# .NET 6.0.13 - January 10, 2023

The .NET 6.0.13, [.NET SDK 6.0.113](6.0.113.md), and [.NET SDK 6.0.308](6.0.308.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.405
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```


Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes
.NET 6.0.13 release carries security fixes.

# Microsoft Security Advisory CVE-2023-21538 | .NET Denial of Service Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists in .NET 6.0 where a malicious client could cause a stack overflow which may result in a denial of service attack when an attacker sends an invalid request to an exposed endpoint.

### Additional fixes in this release

* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.13+is%3Aclosed+label%3Aservicing-approved+)
* [SDK](https://github.com/dotnet/sdk/issues?q=milestone%3A6.0.13+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8090](https://github.com/dotnet/core/issues/8090) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.13.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.13-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.13-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/january-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Ref| 6.0.13
Microsoft.WindowsDesktop.App.Runtime.win-arm64| 6.0.13
Microsoft.WindowsDesktop.App.Runtime.win-x86| 6.0.13
Microsoft.WindowsDesktop.App.Runtime.win-x64| 6.0.13
Microsoft.NETCore.App.Host.linux-x64| 6.0.13
Microsoft.NETCore.App.Crossgen2.win-arm64| 6.0.13
Microsoft.NETCore.App.Crossgen2.linux-x64| 6.0.13
Microsoft.NETCore.App.Host.linux-arm| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64| 6.0.13
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64| 6.0.13
Microsoft.NET.Runtime.iOS.Sample.Mono| 6.0.13
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64| 6.0.13
Microsoft.NETCore.App.Crossgen2.win-x86| 6.0.13
Microsoft.NETCore.App.Crossgen2.win-x64| 6.0.13
Microsoft.NETCore.App.Host.linux-musl-x64| 6.0.13
Microsoft.NETCore.App.Host.win-x64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm| 6.0.13
Microsoft.NETCore.App.Runtime.linux-musl-arm| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.android-x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64| 6.0.13
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86| 6.0.13
Microsoft.NETCore.App.Composite| 6.0.13
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64| 6.0.13
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86| 6.0.13
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100| 6.0.13
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64| 6.0.13
Microsoft.NETCore.App.Crossgen2.linux-musl-arm| 6.0.13
Microsoft.NETCore.App.Crossgen2.osx-arm64| 6.0.13
Microsoft.NETCore.App.Crossgen2.win-arm| 6.0.13
Microsoft.NETCore.App.Host.linux-musl-arm64| 6.0.13
Microsoft.NETCore.App.Host.win-arm| 6.0.13
Microsoft.NETCore.App.Host.win-x86| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86| 6.0.13
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.browser-wasm| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.linux-x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.android-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.linux-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.win-x64| 6.0.13
Microsoft.NETCore.App.Runtime.osx-arm64| 6.0.13
Microsoft.NET.Runtime.Android.Sample.Mono| 6.0.13
Microsoft.NET.Runtime.MonoAOTCompiler.Task| 6.0.13
Microsoft.NET.Runtime.MonoTargets.Sdk| 6.0.13
Microsoft.NET.Runtime.wasm.Sample.Mono| 6.0.13
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64| 6.0.13
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64| 6.0.13
Microsoft.NETCore.App.Crossgen2.linux-musl-x64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.linux-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.android-arm| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.ios-arm| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.linux-arm| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.osx-x64| 6.0.13
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.win-x86| 6.0.13
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86| 6.0.13
Microsoft.NETCore.App.Runtime.win-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.win-x86| 6.0.13
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.13
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.13
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 6.0.13
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.13
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.13
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.13
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.13
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.win-arm| 6.0.13
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.13
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.13
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 6.0.13
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.13
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.13
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 6.0.13
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64| 6.0.13
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64| 6.0.13
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86| 6.0.13
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64| 6.0.13
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300| 6.0.13
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86| 6.0.13
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400| 6.0.13
Microsoft.NETCore.App.Crossgen2.linux-arm64| 6.0.13
Microsoft.NETCore.App.Host.osx-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86| 6.0.13
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86| 6.0.13
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 6.0.13
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.13
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.13
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.13
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.13
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 6.0.13
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.13
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 6.0.13
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.13
runtime.osx-arm64.Microsoft.NETCore.DotNetHost| 6.0.13
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.13
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 6.0.13
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.13
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86| 6.0.13
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86| 6.0.13
Microsoft.Windows.Compatibility| 6.0.2
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost| 6.0.13
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost| 6.0.13
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.13
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 6.0.13
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 6.0.13
Microsoft.NETCore.DotNetHostResolver| 6.0.13
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 6.0.13
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 6.0.13
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86| 6.0.13
Microsoft.NETCore.App.Crossgen2.osx-x64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm| 6.0.13
Microsoft.NETCore.App.Host.win-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.android-x86| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.linux-x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.osx-arm64| 6.0.13
Microsoft.NETCore.DotNetAppHost| 6.0.13
Microsoft.NETCore.DotNetHost| 6.0.13
Microsoft.NETCore.DotNetHostPolicy| 6.0.13
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 6.0.13
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.13
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.13
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64| 6.0.13
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64| 6.0.13
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64| 6.0.13
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86| 6.0.13
Microsoft.NET.Runtime.WebAssembly.Sdk| 6.0.13
Microsoft.NETCore.App.Crossgen2.linux-arm| 6.0.13
Microsoft.NETCore.App.Host.linux-arm64| 6.0.13
Microsoft.NETCore.App.Host.osx-x64| 6.0.13
Microsoft.NETCore.App.Host.linux-musl-arm| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64| 6.0.13
Microsoft.NETCore.App.Ref| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.linux-arm| 6.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.linux-musl-x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.ios-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.osx-x64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86| 6.0.13
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86| 6.0.13
Microsoft.NETCore.App.Runtime.win-x64| 6.0.13
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 6.0.13
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 6.0.13
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.13
runtime.win-arm.Microsoft.NETCore.DotNetHost| 6.0.13
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.13
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.13
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.13
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.13
runtime.win-x64.Microsoft.NETCore.DotNetHost| 6.0.13
runtime.win-x86.Microsoft.NETCore.DotNetHost| 6.0.13
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 6.0.13
Microsoft.AspNetCore.App.Runtime.win-x64| 6.0.13
AspNetCoreRuntime.6.0.x64| 6.0.13
AspNetCoreRuntime.6.0.x86| 6.0.13
Microsoft.AspNetCore.Owin| 6.0.13
Microsoft.AspNetCore.Razor.Language| 6.0.13
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 6.0.13
Microsoft.AspNetCore.SignalR.Client.Core| 6.0.13
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 6.0.13
Microsoft.AspNetCore.SignalR.Specification.Tests| 6.0.13
Microsoft.AspNetCore.TestHost| 6.0.13
Microsoft.AspNetCore.SpaProxy| 6.0.13
Microsoft.AspNetCore.SpaServices.Extensions| 6.0.13
Microsoft.Authentication.WebAssembly.Msal| 6.0.13
Microsoft.Extensions.ApiDescription.Server| 6.0.13
Microsoft.dotnet-openapi| 6.0.13
Microsoft.CodeAnalysis.Razor| 6.0.13
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0| 6.0.13
Microsoft.Extensions.Caching.SqlServer| 6.0.13
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 6.0.13
Microsoft.Extensions.Identity.Core| 6.0.13
Microsoft.Extensions.Identity.Stores| 6.0.13
Microsoft.Extensions.Localization| 6.0.13
Microsoft.Extensions.Localization.Abstractions| 6.0.13
Microsoft.Extensions.Logging.AzureAppServices| 6.0.13
Microsoft.Extensions.ObjectPool| 6.0.13
Microsoft.AspNetCore.App.Runtime.win-arm64| 6.0.13
Microsoft.AspNetCore.App.Runtime.win-x86| 6.0.13
Microsoft.AspNetCore.Authentication.AzureAD.UI| 6.0.13
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 6.0.13
Microsoft.AspNetCore.Components.WebAssembly.Server| 6.0.13
Microsoft.AspNetCore.DataProtection.Abstractions| 6.0.13
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 6.0.13
Microsoft.AspNetCore.DataProtection.Extensions| 6.0.13
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 6.0.13
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 6.0.13
Microsoft.AspNetCore.HeaderPropagation| 6.0.13
Microsoft.AspNetCore.Identity.UI| 6.0.13
Microsoft.AspNetCore.Hosting.WindowsServices| 6.0.13
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 6.0.13
Microsoft.AspNetCore.JsonPatch| 6.0.13
Microsoft.AspNetCore.Metadata| 6.0.13
Microsoft.AspNetCore.MiddlewareAnalysis| 6.0.13
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 6.0.13
Microsoft.AspNetCore.Mvc.Razor.Extensions| 6.0.13
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 6.0.13
Microsoft.AspNetCore.Mvc.Testing| 6.0.13
Microsoft.Extensions.Features| 6.0.13
Microsoft.JSInterop.WebAssembly| 6.0.13
Microsoft.AspNetCore.App.Ref| 6.0.13
Microsoft.AspNetCore.AzureAppServicesIntegration| 6.0.13
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 6.0.13
Microsoft.AspNetCore.Components.Analyzers| 6.0.13
Microsoft.AspNetCore.Components.Authorization| 6.0.13
Microsoft.AspNetCore.Components.Web| 6.0.13
Microsoft.AspNetCore.Components.WebAssembly.DevServer| 6.0.13
Microsoft.AspNetCore.Components.Forms| 6.0.13
Microsoft.AspNetCore.Connections.Abstractions| 6.0.13
Microsoft.Extensions.Http.Polly| 6.0.13
Microsoft.Extensions.FileProviders.Embedded| 6.0.13
Microsoft.Extensions.WebEncoders| 6.0.13
Microsoft.AspNetCore.App.Runtime.linux-arm| 6.0.13
Microsoft.AspNetCore.App.Runtime.linux-musl-arm| 6.0.13
Microsoft.AspNetCore.App.Runtime.linux-arm64| 6.0.13
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 6.0.13
Microsoft.AspNetCore.App.Runtime.osx-x64| 6.0.13
dotnet-sql-cache| 6.0.13
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 6.0.13
Microsoft.AspNetCore.Components.WebAssembly| 6.0.13
Microsoft.AspNetCore.Components.WebView| 6.0.13
Microsoft.AspNetCore.ConcurrencyLimiter| 6.0.13
Microsoft.AspNetCore.Cryptography.Internal| 6.0.13
Microsoft.AspNetCore.Cryptography.KeyDerivation| 6.0.13
Microsoft.AspNetCore.DataProtection| 6.0.13
Microsoft.AspNetCore.Http.Connections.Common| 6.0.13
Microsoft.AspNetCore.SignalR.Common| 6.0.13
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 6.0.13
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 6.0.13
Microsoft.DotNet.Web.Client.ItemTemplates| 6.0.13
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 6.0.13
Microsoft.AspNetCore.App.Runtime.osx-arm64| 6.0.13
Microsoft.AspNetCore.Authentication.Google| 6.0.13
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 6.0.13
Microsoft.AspNetCore.Authentication.Facebook| 6.0.13
Microsoft.AspNetCore.Authentication.Certificate| 6.0.13
Microsoft.AspNetCore.Authentication.JwtBearer| 6.0.13
Microsoft.AspNetCore.Authentication.Negotiate| 6.0.13
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 6.0.13
Microsoft.AspNetCore.Authentication.OpenIdConnect| 6.0.13
Microsoft.AspNetCore.Authentication.Twitter| 6.0.13
Microsoft.AspNetCore.Authentication.WsFederation| 6.0.13
Microsoft.AspNetCore.Authorization| 6.0.13
Microsoft.AspNetCore.Components| 6.0.13
Microsoft.AspNetCore.Components.WebAssembly.Authentication| 6.0.13
Microsoft.AspNetCore.Http.Connections.Client| 6.0.13
Microsoft.AspNetCore.SignalR.Client| 6.0.13
Microsoft.AspNetCore.SignalR.Protocols.Json| 6.0.13
Microsoft.Extensions.ApiDescription.Client| 6.0.13
Microsoft.DotNet.Web.ItemTemplates.6.0| 6.0.13
Microsoft.DotNet.Web.ProjectTemplates.6.0| 6.0.13
Microsoft.Extensions.Configuration.KeyPerFile| 6.0.13
Microsoft.Extensions.Caching.StackExchangeRedis| 6.0.13
Microsoft.Extensions.Diagnostics.HealthChecks| 6.0.13
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 6.0.13
Microsoft.JSInterop| 6.0.13
Microsoft.AspNetCore.App.Runtime.linux-x64| 6.0.13
Microsoft.AspNetCore.App.Runtime.win-arm| 6.0.13
Microsoft.TemplateEngine.IDE| 6.0.113
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.113
Microsoft.TemplateEngine.Abstractions| 6.0.113
Microsoft.TemplateEngine.Core.Contracts| 6.0.113
Microsoft.TemplateEngine.Edge| 6.0.113
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.113
Microsoft.DotNet.Common.ItemTemplates| 6.0.113
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.113
Microsoft.TemplateEngine.Core| 6.0.113
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.113
Microsoft.TemplateEngine.Utils| 6.0.113
Microsoft.TemplateSearch.Common| 6.0.113
Microsoft.DotNet.Compatibility| 1.0.0-servicing.22601.32
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64| 6.0.13
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64| 6.0.13
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64| 6.0.13
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64| 6.0.13
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64| 6.0.13
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64| 6.0.13
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100| 6.0.13
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64| 6.0.13
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64| 6.0.13
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64| 6.0.13
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64| 6.0.13
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64| 6.0.13
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400| 6.0.13
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86| 6.0.13
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64| 6.0.13
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64| 6.0.13
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64| 6.0.13
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64| 6.0.13
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86| 6.0.13
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64| 6.0.13
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64| 6.0.13
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64| 6.0.13
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64| 6.0.13
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300| 6.0.13
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86| 6.0.13
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64| 6.0.13
Microsoft.EntityFrameworkCore.Proxies| 6.0.13
Microsoft.EntityFrameworkCore.Relational| 6.0.13
dotnet-ef| 6.0.13
Microsoft.EntityFrameworkCore| 6.0.13
Microsoft.EntityFrameworkCore.Abstractions| 6.0.13
Microsoft.EntityFrameworkCore.Analyzers| 6.0.13
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests| 6.0.13
Microsoft.EntityFrameworkCore.Cosmos| 6.0.13
Microsoft.EntityFrameworkCore.Design| 6.0.13
Microsoft.EntityFrameworkCore.InMemory| 6.0.13
Microsoft.EntityFrameworkCore.Specification.Tests| 6.0.13
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 6.0.13
Microsoft.EntityFrameworkCore.SqlServer| 6.0.13
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 6.0.13
Microsoft.EntityFrameworkCore.Tools| 6.0.13
Microsoft.Data.Sqlite| 6.0.13
Microsoft.Data.Sqlite.Core| 6.0.13
Microsoft.EntityFrameworkCore.Sqlite| 6.0.13
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 6.0.13
Microsoft.EntityFrameworkCore.Sqlite.Core| 6.0.13
Microsoft.DotNet.Common.ItemTemplates| 6.0.308
Microsoft.TemplateEngine.Core.Contracts| 6.0.308
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.308
Microsoft.TemplateEngine.Abstractions| 6.0.308
Microsoft.TemplateEngine.Core| 6.0.308
Microsoft.TemplateEngine.Edge| 6.0.308
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.308
Microsoft.TemplateEngine.IDE| 6.0.308
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.308
Microsoft.TemplateEngine.Utils| 6.0.308
Microsoft.TemplateSearch.Common| 6.0.308
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.308
FSharp.Compiler.Service| 41.0.5
FSharp.Core| 6.0.5
Microsoft.DotNet.Common.ItemTemplates| 6.0.405
Microsoft.DotNet.Common.ProjectTemplates.1.x| 6.0.405
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.405
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.405
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.405
Microsoft.TemplateEngine.Core| 6.0.405
Microsoft.TemplateEngine.Core.Contracts| 6.0.405
Microsoft.TemplateEngine.Edge| 6.0.405
Microsoft.TemplateEngine.Utils| 6.0.405
Microsoft.TemplateSearch.Common| 6.0.405
Microsoft.DotNet.Common.ProjectTemplates.5.0| 6.0.405
Microsoft.TemplateEngine.Abstractions| 6.0.405
Microsoft.TemplateEngine.IDE| 6.0.405
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.405
Microsoft.DotNet.Common.ProjectTemplates.2.0| 6.0.405
Microsoft.DotNet.Common.ProjectTemplates.2.1| 6.0.405
Microsoft.DotNet.Common.ProjectTemplates.2.2| 6.0.405
Microsoft.DotNet.Common.ProjectTemplates.3.1| 6.0.405
Microsoft.DotNet.Common.ProjectTemplates.3.0| 6.0.405
FSharp.Compiler.Service| 41.0.7
FSharp.Core| 6.0.7


[//]: # ( Runtime 6.0.13)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b5194dc8-0296-4684-8ae7-41f894caed85/f0acb98d32a010f1532d8aad9029e1d3/dotnet-runtime-6.0.13-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/79baf344-68fd-4fdf-a279-8b32116514f2/3f91babc487289f63c6f423da0a397ad/dotnet-runtime-6.0.13-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c241e3d4-2cd4-4ff0-b9db-b1cc4aaa31c1/a36ce788abcb1a438d5204f50c7c8c34/dotnet-runtime-6.0.13-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aba4d6b6-7027-46d9-92ef-8b0d891f1b6f/ae5a76d2a2b4b02dbd42265f04428239/dotnet-runtime-6.0.13-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/506d542d-06bc-44f1-b754-e1b3774f631e/14491ff933bb48a4c4eb85911da3f1af/dotnet-runtime-6.0.13-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2d8697ac-0b1f-4dc8-8c1a-3748763d5c54/c493efee79b0c36c4bc8d3c5039f27c7/dotnet-runtime-6.0.13-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/aa3b3150-80cb-4d30-87f8-dc36fa1dcf26/8ec9ff6836828175f1a6a60aefd4e63b/dotnet-runtime-6.0.13-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/98cb1adf-c95b-4ac1-82b7-54c6ffd7c669/617b0dbf1ff662e78a6eb49b5423f304/dotnet-runtime-6.0.13-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/2ef12357-499b-4a5b-a488-da45a5f310e6/fbe35c354bfb50934a976fc91c6d8d81/dotnet-runtime-6.0.13-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/398dc2ef-017b-4e97-8d05-cde933894da9/bce7bf77230301570a1af839a4ce09e7/dotnet-runtime-6.0.13-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/5fe173ea-4c58-4a8d-b8e5-5c7ea7c59011/a1936e1239e59dc4df58a1bc3db527c3/dotnet-runtime-6.0.13-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/4b252ca7-0fc2-49c3-957b-c084ccfe04c5/4ba30ee9e5839f077e57e45a297664ca/dotnet-runtime-6.0.13-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/436bce6a-f3e7-448e-9279-d58f1e39ab8a/9f5c7ed377294cc8e028e900540632d5/dotnet-runtime-6.0.13-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5c9a3954-70a7-4ade-843f-ffecb51996ea/e85304f2ba104049340513e9d15fd0cb/dotnet-runtime-6.0.13-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5f095cbb-af6c-4d20-909d-87db53879370/d4c6f380a9a68fc853bd891189f3c975/dotnet-runtime-6.0.13-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1aaf78bc-f42e-4ea8-a2a7-8480e2e5d601/a49a833bcae82e5865b2f23f650d125b/dotnet-runtime-6.0.13-win-x86.zip

[//]: # ( WindowsDesktop 6.0.13)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/1740d5f2-61e3-43ab-b0c7-89a44d18f5b5/ca9d3cd1ece3b4ae5517492086ce4a6f/windowsdesktop-runtime-6.0.13-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/8f570679-93ee-45a1-a265-f44e96309b3d/8fe8879315d1f8d83648a1fb78b8ae7c/windowsdesktop-runtime-6.0.13-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4c5e26cf-2512-4518-9480-aac8679b0d08/523f1967fd98b0cf4f9501855d1aa063/windowsdesktop-runtime-6.0.13-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4335e6f1-48ba-4fa8-a1a9-1a1b6dd8f7c9/415e65d170d97e4d352cdb83c2d7993f/windowsdesktop-runtime-6.0.13-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d37ab8e6-095b-4f42-bea5-f519b3c62b68/3b87e1c571a3fc49607acc821d3f107a/windowsdesktop-runtime-6.0.13-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/f2aebdc0-4da9-46f6-8593-b5d9a3f7962e/f1b68049ddbd23ec79e93d7d1b8a65d7/windowsdesktop-runtime-6.0.13-win-x86.zip

[//]: # ( ASP 6.0.13)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8685fc94-b18a-4012-bda7-9ecc28e9d4a8/569d9a735ae79b4ce67393dfd96c3d90/aspnetcore-runtime-6.0.13-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b675e6e9-652b-42a6-a9eb-2813b90b41e0/88ba0bd190041c1db8a681bef7376ab7/aspnetcore-runtime-6.0.13-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1a4b2dca-6856-4ddc-9066-262ed7f6ee33/2f9ab563cf9b5585b8a253614b8fd5e7/aspnetcore-runtime-6.0.13-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0af87f1c-e40b-4ffa-9777-f41954b93b30/b8f69a4b86c11b15c61be15ccb4e209f/aspnetcore-runtime-6.0.13-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2eb8bb1c-0b38-46a7-ab53-9aed04141f50/7ded7f4e01cf4ff6a3beda5818b7bec8/aspnetcore-runtime-6.0.13-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a2234b85-9050-4f90-9fc1-695a428167ee/8d5c3cf8f557e14c7c43965b7cef9c41/aspnetcore-runtime-6.0.13-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e687d28e-8121-4099-b505-f52cd856f718/1089325f2ab576f007e246ceb174e276/aspnetcore-runtime-6.0.13-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6f9bcb00-fa3c-44d8-8f9a-e4a256f20e81/bb989e5cc189e4b51585b4b78024a060/aspnetcore-runtime-6.0.13-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/12d3e2cb-09ed-41c9-bad0-fb75bf42bf95/1e238b410f86ef37799e4d92cb0b4d2e/aspnetcore-runtime-6.0.13-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ef825766-9885-4123-890e-3679352eda71/d58566678c1bcd9aa95327bcff043ccb/aspnetcore-runtime-6.0.13-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b6212cb4-5df9-4781-87e7-83c7f9d617dd/b2ec3f7ed302ea4928e47299ec0d9946/aspnetcore-runtime-6.0.13-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/afd28696-e178-4952-bd38-4525af28a220/8366e1fcdb706c5b0572aecbde579681/aspnetcore-runtime-6.0.13-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/07a63d6d-e971-4765-921a-2a47f2dd87d6/03b202899682957e0bc0531a5cbb4c97/aspnetcore-runtime-6.0.13-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/0cb3c095-c4f4-4d55-929b-3b4888a7b5f1/4156664d6bfcb46b63916a8cd43f8305/dotnet-hosting-6.0.13-win.exe

[//]: # ( SDK 6.0.405)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0cd0c511-c215-48d4-a2a6-e2c94b208605/56b7da0b2c8240ec30001df55d1891d8/dotnet-sdk-6.0.405-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c05dfb39-64d7-42cb-8caa-d669c0509c9b/d498099b33fd336d01e28c38515cb21d/dotnet-sdk-6.0.405-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/29682aff-7321-4034-9833-29f3ea435759/cf2fd8a078d3a6c106a1254cc2887ad3/dotnet-sdk-6.0.405-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/207a3484-7524-4963-9c4e-dacf20ba3a66/4a3bc869dc7a93753022752aa5782989/dotnet-sdk-6.0.405-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d74b9eb9-d60c-4b0d-8d53-f30a6e22b917/ef06d32d3b5206786eac8011798568aa/dotnet-sdk-6.0.405-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c7f21771-9b09-4c81-883b-90dff8760c1e/fe992d38a94cc6f301c0236db3920c0a/dotnet-sdk-6.0.405-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ee832565-1555-453e-8efc-5ea49e2e68d1/57de20cb37dedd138921ec4ea6c6c882/dotnet-sdk-6.0.405-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9ef6ade4-4d92-4243-9e26-748a7c75c490/ef308e5e0bad95bc604fff5c5defd42a/dotnet-sdk-6.0.405-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/8a0c7611-7ca1-49d7-a889-e6514fc29dd0/08927286063140ccdf88eafe0e3bd2fb/dotnet-sdk-6.0.405-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3c785c12-6a6b-493c-929a-9a3f3dc568ad/6290551f01f9cc31039e70771d05aeec/dotnet-sdk-6.0.405-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a54c7206-f5c0-4c2e-b267-633fc5fcc369/19da59625a98087473189df669ec2134/dotnet-sdk-6.0.405-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/d7a87f78-c9bc-4c12-a76c-5792e4904ccb/0b7a9a696929d1d20257d8cd1e70fdc1/dotnet-sdk-6.0.405-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/01dfbf9b-d2d1-4bd2-acb1-51d998c4812e/cf4fd6732540a78b4f44cbd9a285ce80/dotnet-sdk-6.0.405-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/402ad1ea-e4a5-4582-8d74-1c2efd5907e6/2c8eb49494a3598b892681cab23be8ba/dotnet-sdk-6.0.405-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5eacdd37-c806-41fd-8062-ce918137dd96/15f5164a86b4830f2669036cf1e2dafa/dotnet-sdk-6.0.405-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d7f74d30-fcbf-477a-a11b-d2ea372593c3/ce98c98b94fa9bfaba7ca4d3fb24e968/dotnet-sdk-6.0.405-win-x86.zip


