# .NET 6.0.14 - February 14, 2023

The .NET 6.0.14, [.NET SDK 6.0.114](6.0.114.md), and [.NET SDK 6.0.309](6.0.309.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.406
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```


Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes
.NET 6.0.14 release carries security fixes.

# Microsoft Security Advisory CVE-2023-21808 | .NET Remote Code Execution Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in how .NET reads debugging symbols, where reading a malicious symbols file may result in remote code execution.

### Additional fixes in this release

* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.14+is%3Aclosed+label%3Aservicing-approved+)
* [ASPNET](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A6.0.14+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8191](https://github.com/dotnet/core/issues/8191) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.14.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.14-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.14-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/february-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x64| 6.0.14
Microsoft.WindowsDesktop.App.Ref| 6.0.14
Microsoft.WindowsDesktop.App.Runtime.win-x86| 6.0.14
Microsoft.WindowsDesktop.App.Runtime.win-arm64| 6.0.14
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Host.win-arm64| 6.0.14
Microsoft.NETCore.App.Ref| 6.0.14
Microsoft.NETCore.App.Crossgen2.linux-musl-x64| 6.0.14
Microsoft.NETCore.App.Crossgen2.win-x86| 6.0.14
Microsoft.NETCore.App.Crossgen2.win-x64| 6.0.14
Microsoft.NETCore.App.Host.win-arm| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64| 6.0.14
Microsoft.NETCore.DotNetHostResolver| 6.0.14
Microsoft.Windows.Compatibility| 6.0.3
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.14
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.14
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 6.0.14
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.14
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost| 6.0.14
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost| 6.0.14
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.14
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 6.0.14
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86| 6.0.14
Microsoft.NET.Runtime.MonoTargets.Sdk| 6.0.14
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Crossgen2.osx-arm64| 6.0.14
Microsoft.NETCore.App.Crossgen2.linux-x64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.linux-arm| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64| 6.0.14
runtime.win-arm.Microsoft.NETCore.DotNetHost| 6.0.14
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.14
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 6.0.14
System.DirectoryServices| 6.0.1
Microsoft.NETCore.App.Host.osx-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.android-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.browser-wasm| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.ios-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.osx-x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.osx-x64| 6.0.14
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 6.0.14
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.14
runtime.osx-arm64.Microsoft.NETCore.DotNetHost| 6.0.14
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 6.0.14
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 6.0.14
runtime.win-x64.Microsoft.NETCore.DotNetHost| 6.0.14
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 6.0.14
runtime.win-x86.Microsoft.NETCore.DotNetHost| 6.0.14
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 6.0.14
System.Security.Cryptography.Pkcs| 6.0.2
Microsoft.NETCore.App.Composite| 6.0.14
Microsoft.NET.Runtime.MonoAOTCompiler.Task| 6.0.14
Microsoft.NET.Runtime.iOS.Sample.Mono| 6.0.14
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86| 6.0.14
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64| 6.0.14
Microsoft.NET.Runtime.wasm.Sample.Mono| 6.0.14
Microsoft.NET.Runtime.WebAssembly.Sdk| 6.0.14
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64| 6.0.14
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64| 6.0.14
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64| 6.0.14
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86| 6.0.14
Microsoft.NETCore.App.Crossgen2.osx-x64| 6.0.14
Microsoft.NETCore.App.Host.linux-arm| 6.0.14
Microsoft.NETCore.App.Host.linux-musl-arm| 6.0.14
Microsoft.NETCore.App.Host.linux-musl-arm64| 6.0.14
Microsoft.NETCore.App.Host.linux-x64| 6.0.14
Microsoft.NETCore.App.Host.osx-x64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm| 6.0.14
Microsoft.NETCore.App.Runtime.linux-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.linux-x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.android-x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.android-x86| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.osx-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64| 6.0.14
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64| 6.0.14
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 6.0.14
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.14
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.14
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.14
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.14
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.14
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64| 6.0.14
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64| 6.0.14
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86| 6.0.14
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400| 6.0.14
Microsoft.NETCore.App.Crossgen2.linux-musl-arm| 6.0.14
Microsoft.NETCore.App.Host.linux-musl-x64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm| 6.0.14
Microsoft.NETCore.App.Host.win-x64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.android-arm| 6.0.14
Microsoft.NETCore.App.Runtime.linux-arm| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.win-x86| 6.0.14
Microsoft.NETCore.App.Runtime.osx-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.win-arm| 6.0.14
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.win-x64| 6.0.14
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.14
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 6.0.14
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.14
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 6.0.14
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 6.0.14
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.14
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.14
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.14
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300| 6.0.14
Microsoft.NETCore.App.Crossgen2.linux-arm| 6.0.14
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64| 6.0.14
Microsoft.NETCore.App.Crossgen2.linux-arm64| 6.0.14
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64| 6.0.14
Microsoft.NETCore.App.Crossgen2.win-arm| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.linux-musl-x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.linux-x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64| 6.0.14
Microsoft.NETCore.DotNetAppHost| 6.0.14
Microsoft.NETCore.DotNetHostPolicy| 6.0.14
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 6.0.14
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.14
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 6.0.14
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.14
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.14
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 6.0.14
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.14
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.14
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.14
Microsoft.NET.Runtime.Android.Sample.Mono| 6.0.14
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86| 6.0.14
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100| 6.0.14
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64| 6.0.14
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86| 6.0.14
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64| 6.0.14
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Crossgen2.win-arm64| 6.0.14
Microsoft.NETCore.App.Host.linux-arm64| 6.0.14
Microsoft.NETCore.App.Host.win-x86| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.linux-musl-arm| 6.0.14
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.ios-arm| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.linux-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.Mono.win-x64| 6.0.14
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64| 6.0.14
Microsoft.NETCore.App.Runtime.win-arm64| 6.0.14
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86| 6.0.14
Microsoft.NETCore.App.Runtime.win-x86| 6.0.14
Microsoft.NETCore.DotNetHost| 6.0.14
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 6.0.14
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.14
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.14
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.14
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.14
Microsoft.AspNetCore.ConcurrencyLimiter| 6.0.14
Microsoft.AspNetCore.Identity.UI| 6.0.14
Microsoft.AspNetCore.Hosting.WindowsServices| 6.0.14
Microsoft.AspNetCore.Http.Connections.Common| 6.0.14
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 6.0.14
Microsoft.AspNetCore.MiddlewareAnalysis| 6.0.14
Microsoft.AspNetCore.Metadata| 6.0.14
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 6.0.14
Microsoft.AspNetCore.Mvc.Razor.Extensions| 6.0.14
Microsoft.AspNetCore.Razor.Language| 6.0.14
Microsoft.dotnet-openapi| 6.0.14
Microsoft.Authentication.WebAssembly.Msal| 6.0.14
Microsoft.Extensions.ApiDescription.Server| 6.0.14
Microsoft.DotNet.Web.ItemTemplates.6.0| 6.0.14
Microsoft.Extensions.Diagnostics.HealthChecks| 6.0.14
Microsoft.Extensions.Configuration.KeyPerFile| 6.0.14
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 6.0.14
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 6.0.14
Microsoft.AspNetCore.Authentication.Certificate| 6.0.14
Microsoft.AspNetCore.Authentication.Facebook| 6.0.14
Microsoft.AspNetCore.Authentication.Google| 6.0.14
Microsoft.AspNetCore.Authentication.JwtBearer| 6.0.14
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 6.0.14
Microsoft.AspNetCore.Authentication.Negotiate| 6.0.14
Microsoft.AspNetCore.Authentication.OpenIdConnect| 6.0.14
Microsoft.AspNetCore.Authentication.Twitter| 6.0.14
Microsoft.AspNetCore.Components.WebAssembly.Server| 6.0.14
Microsoft.AspNetCore.DataProtection.Extensions| 6.0.14
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 6.0.14
Microsoft.AspNetCore.HeaderPropagation| 6.0.14
Microsoft.AspNetCore.Http.Connections.Client| 6.0.14
Microsoft.DotNet.Web.Client.ItemTemplates| 6.0.14
Microsoft.DotNet.Web.ProjectTemplates.6.0| 6.0.14
Microsoft.Extensions.Caching.StackExchangeRedis| 6.0.14
Microsoft.JSInterop.WebAssembly| 6.0.14
Microsoft.AspNetCore.App.Runtime.linux-musl-arm| 6.0.14
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 6.0.14
AspNetCoreRuntime.6.0.x64| 6.0.14
Microsoft.AspNetCore.App.Runtime.osx-arm64| 6.0.14
dotnet-sql-cache| 6.0.14
Microsoft.AspNetCore.App.Runtime.win-x64| 6.0.14
Microsoft.CodeAnalysis.Razor| 6.0.14
Microsoft.Extensions.Caching.SqlServer| 6.0.14
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0| 6.0.14
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 6.0.14
Microsoft.Extensions.Features| 6.0.14
Microsoft.Extensions.FileProviders.Embedded| 6.0.14
Microsoft.JSInterop| 6.0.14
Microsoft.AspNetCore.App.Runtime.osx-x64| 6.0.14
Microsoft.AspNetCore.App.Runtime.linux-x64| 6.0.14
Microsoft.AspNetCore.App.Runtime.win-arm64| 6.0.14
AspNetCoreRuntime.6.0.x86| 6.0.14
Microsoft.AspNetCore.App.Runtime.win-x86| 6.0.14
Microsoft.AspNetCore.App.Ref| 6.0.14
Microsoft.AspNetCore.JsonPatch| 6.0.14
Microsoft.AspNetCore.Mvc.Testing| 6.0.14
Microsoft.AspNetCore.Owin| 6.0.14
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 6.0.14
Microsoft.AspNetCore.SignalR.Client| 6.0.14
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 6.0.14
Microsoft.AspNetCore.SignalR.Client.Core| 6.0.14
Microsoft.AspNetCore.SignalR.Common| 6.0.14
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 6.0.14
Microsoft.AspNetCore.SignalR.Protocols.Json| 6.0.14
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 6.0.14
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 6.0.14
Microsoft.AspNetCore.SignalR.Specification.Tests| 6.0.14
Microsoft.AspNetCore.SpaServices.Extensions| 6.0.14
Microsoft.AspNetCore.SpaProxy| 6.0.14
Microsoft.AspNetCore.TestHost| 6.0.14
Microsoft.Extensions.ApiDescription.Client| 6.0.14
Microsoft.Extensions.Identity.Core| 6.0.14
Microsoft.Extensions.Http.Polly| 6.0.14
Microsoft.Extensions.Identity.Stores| 6.0.14
Microsoft.Extensions.Localization| 6.0.14
Microsoft.Extensions.Logging.AzureAppServices| 6.0.14
Microsoft.Extensions.Localization.Abstractions| 6.0.14
Microsoft.Extensions.ObjectPool| 6.0.14
Microsoft.Extensions.WebEncoders| 6.0.14
Microsoft.AspNetCore.App.Runtime.win-arm| 6.0.14
Microsoft.AspNetCore.Authentication.WsFederation| 6.0.14
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 6.0.14
Microsoft.AspNetCore.Authorization| 6.0.14
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 6.0.14
Microsoft.AspNetCore.AzureAppServicesIntegration| 6.0.14
Microsoft.AspNetCore.Components.WebAssembly.Authentication| 6.0.14
Microsoft.AspNetCore.Components| 6.0.14
Microsoft.AspNetCore.Components.Analyzers| 6.0.14
Microsoft.AspNetCore.Connections.Abstractions| 6.0.14
Microsoft.AspNetCore.App.Runtime.linux-arm| 6.0.14
Microsoft.AspNetCore.App.Runtime.linux-arm64| 6.0.14
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 6.0.14
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 6.0.14
Microsoft.AspNetCore.Authentication.AzureAD.UI| 6.0.14
Microsoft.AspNetCore.Components.Authorization| 6.0.14
Microsoft.AspNetCore.Components.Forms| 6.0.14
Microsoft.AspNetCore.Components.Web| 6.0.14
Microsoft.AspNetCore.Components.WebAssembly| 6.0.14
Microsoft.AspNetCore.Components.WebView| 6.0.14
Microsoft.AspNetCore.Components.WebAssembly.DevServer| 6.0.14
Microsoft.AspNetCore.Cryptography.Internal| 6.0.14
Microsoft.AspNetCore.Cryptography.KeyDerivation| 6.0.14
Microsoft.AspNetCore.DataProtection| 6.0.14
Microsoft.AspNetCore.DataProtection.Abstractions| 6.0.14
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 6.0.14
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 6.0.14
Microsoft.TemplateEngine.Abstractions| 6.0.114
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.114
Microsoft.TemplateEngine.Core| 6.0.114
Microsoft.TemplateEngine.IDE| 6.0.114
Microsoft.TemplateEngine.Edge| 6.0.114
Microsoft.TemplateEngine.Core.Contracts| 6.0.114
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.114
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.114
Microsoft.TemplateSearch.Common| 6.0.114
Microsoft.TemplateEngine.Utils| 6.0.114
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.114
Microsoft.DotNet.Common.ItemTemplates| 6.0.114
Microsoft.DotNet.Compatibility| 1.0.0-servicing.23074.26
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64| 6.0.14
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64| 6.0.14
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64| 6.0.14
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86| 6.0.14
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300| 6.0.14
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64| 6.0.14
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64| 6.0.14
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64| 6.0.14
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64| 6.0.14
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64| 6.0.14
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86| 6.0.14
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64| 6.0.14
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64| 6.0.14
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64| 6.0.14
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64| 6.0.14
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64| 6.0.14
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64| 6.0.14
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100| 6.0.14
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64| 6.0.14
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64| 6.0.14
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64| 6.0.14
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64| 6.0.14
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86| 6.0.14
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400| 6.0.14
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64| 6.0.14
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64| 6.0.14
Microsoft.Data.Sqlite| 6.0.14
Microsoft.EntityFrameworkCore.Specification.Tests| 6.0.14
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 6.0.14
Microsoft.EntityFrameworkCore.Sqlite| 6.0.14
Microsoft.EntityFrameworkCore.SqlServer| 6.0.14
dotnet-ef| 6.0.14
Microsoft.EntityFrameworkCore.Analyzers| 6.0.14
Microsoft.EntityFrameworkCore.Abstractions| 6.0.14
Microsoft.Data.Sqlite.Core| 6.0.14
Microsoft.EntityFrameworkCore| 6.0.14
Microsoft.EntityFrameworkCore.Cosmos| 6.0.14
Microsoft.EntityFrameworkCore.Proxies| 6.0.14
Microsoft.EntityFrameworkCore.Relational| 6.0.14
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 6.0.14
Microsoft.EntityFrameworkCore.Sqlite.Core| 6.0.14
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 6.0.14
Microsoft.EntityFrameworkCore.Design| 6.0.14
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests| 6.0.14
Microsoft.EntityFrameworkCore.InMemory| 6.0.14
Microsoft.EntityFrameworkCore.Tools| 6.0.14
Microsoft.TemplateEngine.IDE| 6.0.309
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.309
Microsoft.TemplateSearch.Common| 6.0.309
Microsoft.TemplateEngine.Core.Contracts| 6.0.309
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.309
Microsoft.TemplateEngine.Abstractions| 6.0.309
Microsoft.TemplateEngine.Edge| 6.0.309
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.309
Microsoft.TemplateEngine.Utils| 6.0.309
Microsoft.TemplateEngine.Core| 6.0.309
Microsoft.DotNet.Common.ItemTemplates| 6.0.309
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.309
FSharp.Core| 6.0.5
FSharp.Compiler.Service| 41.0.5
Microsoft.DotNet.Common.ProjectTemplates.2.2| 6.0.406
Microsoft.DotNet.Common.ProjectTemplates.1.x| 6.0.406
Microsoft.DotNet.Common.ProjectTemplates.2.0| 6.0.406
Microsoft.DotNet.Common.ProjectTemplates.2.1| 6.0.406
Microsoft.DotNet.Common.ProjectTemplates.3.0| 6.0.406
Microsoft.DotNet.Common.ProjectTemplates.3.1| 6.0.406
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.406
Microsoft.TemplateEngine.Abstractions| 6.0.406
Microsoft.DotNet.Common.ProjectTemplates.5.0| 6.0.406
Microsoft.TemplateEngine.Core| 6.0.406
Microsoft.TemplateEngine.Core.Contracts| 6.0.406
Microsoft.DotNet.Common.ItemTemplates| 6.0.406
Microsoft.TemplateEngine.Edge| 6.0.406
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.406
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.406
Microsoft.TemplateEngine.Utils| 6.0.406
Microsoft.TemplateSearch.Common| 6.0.406
Microsoft.TemplateEngine.IDE| 6.0.406
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.406
FSharp.Compiler.Service| 41.0.7
FSharp.Core| 6.0.7


[//]: # ( Runtime 6.0.14)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f108cccf-0925-4ec3-bb6e-914fd14afc15/e7c38086f49e4f4378774069b6dce9fe/dotnet-runtime-6.0.14-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/52cef887-8713-4085-a8e1-57e18d9a8c2c/85f217a96356c6cb3553883585f44625/dotnet-runtime-6.0.14-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/77231727-4255-426a-87e9-2ae32faf8dd8/c0a0162b90ec0b2a7011d5606630afcd/dotnet-runtime-6.0.14-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8aa2abd2-c3e5-41b9-93cc-15cd199145da/f762256769da1dd4d389cce8e433e27f/dotnet-runtime-6.0.14-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a416558d-5d08-4e50-b24d-54b5e72260cb/51c1e141a1f9f084437c50270b79baef/dotnet-runtime-6.0.14-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bdd6ca22-dd29-4b4d-a9bf-535a04151a39/cd4e2e686ea044729cfa8eab80ba12a9/dotnet-runtime-6.0.14-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/8ac1e071-ea83-452a-83b6-4fe482ed9a51/03a567b5236ea7b11be0b3f901d876b2/dotnet-runtime-6.0.14-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d88d581c-66c4-494d-8bea-922886d27a95/9617e9b18e88e1b02fab40c566b480bd/dotnet-runtime-6.0.14-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/9ccb72c6-1ec5-43e3-884a-3af4a625149f/e29c06718dd33cae7efeb4cb817e620d/dotnet-runtime-6.0.14-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c25fd07e-9ebe-4bef-b53e-8fab7e3cfe0d/87dcc85e499fe8ec272819734822412d/dotnet-runtime-6.0.14-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/affde4e0-2933-4982-a410-8ee5e3ebd954/8013d4d3f8de2e090dacacbbf9094cde/dotnet-runtime-6.0.14-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/89b9c572-17d6-47de-87fd-2641f3232d48/3aa6f206df9f6002c0ca73e78902ce34/dotnet-runtime-6.0.14-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/cdd7a605-be77-47fe-a8ac-d982c8e5d692/c8abed93d34b110b4f3d3254e56de254/dotnet-runtime-6.0.14-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c40ed64b-5501-4096-9b51-4b41e0fc26d1/86f7e0cbd77df3ab48db9a6c43b70c75/dotnet-runtime-6.0.14-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/36ba8cdf-e5c2-4ab8-96e7-e7133f0517dd/e63c28b38f8896298544263469e9f285/dotnet-runtime-6.0.14-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/34101dc8-fcee-4458-aa78-cd888cefd8aa/6bc30a5199bfd75da51bdfa23a17239e/dotnet-runtime-6.0.14-win-x86.zip

[//]: # ( WindowsDesktop 6.0.14)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/55813168-b54b-456f-91df-e0aace414af9/770cd0e0d68e6757cd56c0fd14dbf5f7/windowsdesktop-runtime-6.0.14-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/10a889ac-b978-402d-bb4d-85847e881d02/2f4f2d099819b82275f289fad7a1beee/windowsdesktop-runtime-6.0.14-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/035efed3-6386-4e1d-bcbc-384a20ebf47e/abfbea2303e0ce9cb15d430314e5858f/windowsdesktop-runtime-6.0.14-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e5631431-f761-449b-8b5c-7c72e1734b2e/4e058f3236704fc77045b0d44e0ff2f6/windowsdesktop-runtime-6.0.14-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e66c97f8-3ca5-4cbc-aaf8-77079b21f41f/3ce8574df28f49d85091b1af758eccb7/windowsdesktop-runtime-6.0.14-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/864767b1-74e4-429e-af08-b493880f6b29/d6be6fe52135de4c7d88a8b98955a4c2/windowsdesktop-runtime-6.0.14-win-x86.zip

[//]: # ( ASP 6.0.14)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4fac9144-1998-4d99-8000-6f8c8a19e9a3/3d722a6e310cf82c898f91138971be5b/aspnetcore-runtime-6.0.14-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/10762208-8896-423a-b7f3-5084c7548ce7/620af5c42e5a4087478890294dbe39fb/aspnetcore-runtime-6.0.14-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/88f2261f-462f-4a3e-9c75-b624630c85fe/971ac2be0cd3b951a5fa382ecfd52273/aspnetcore-runtime-6.0.14-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4fcfdff9-dc1e-4e24-b791-53567eee30ab/0e0ae255b4fb9fd3294128cb9d20d533/aspnetcore-runtime-6.0.14-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f67fc9ad-89b8-4cdb-9a57-f8edd4f476e8/a5e8d5aa74a3abf3f504552571e58544/aspnetcore-runtime-6.0.14-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/092f7e69-2e23-40b3-8f36-628d25ac7109/4995e4e141b26ea049163af84592222c/aspnetcore-runtime-6.0.14-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e5afea43-c8ce-4876-8dad-efb09033baab/2b49d236aa076a9934381d9f7db88738/aspnetcore-runtime-6.0.14-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/80906b59-d713-4d5f-ae1b-32823ff1aa0b/6ac94e7a5652c33595f393d4941c57d1/aspnetcore-runtime-6.0.14-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/18902588-5c3a-40f5-917f-c6aad61af2b4/69f4743586281fd51bb9c0db282f6759/aspnetcore-runtime-6.0.14-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/95355fd2-12e2-4a03-b7ef-deff884e040b/a1070d778070557ef3a49eeaac524670/aspnetcore-runtime-6.0.14-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/35bc5004-3fa9-414d-b262-5826325e1d6c/b67fe9bb5331ec19c8ac63d7c073d54f/aspnetcore-runtime-6.0.14-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f7e263ac-64e0-41a6-b6b3-eca6a8ff193b/e8ca4e4568fccaf82d8081ddb9a3e18f/aspnetcore-runtime-6.0.14-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c9a46a47-1193-4ca5-9f77-d9f72d369f8d/56ccbe471ea26c98dd302a57f34104bb/aspnetcore-runtime-6.0.14-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/321a2352-a7aa-492a-bd0d-491a963de7cc/6d17be7b07b8bc22db898db0ff37a5cc/dotnet-hosting-6.0.14-win.exe

[//]: # ( SDK 6.0.406)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/57c99686-6bce-48c7-b69c-91e0be60165c/69e812835ab62d1f1773a71ee943d9a7/dotnet-sdk-6.0.406-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0a569135-1e0d-4273-ab56-f732a11f6199/6fb7eb4813c1cc1a7354cb665d2389c3/dotnet-sdk-6.0.406-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4949d491-b2e5-4dfd-be0d-c5aaaa8b1fe6/98011530a876a7d097e85ea2d073b331/dotnet-sdk-6.0.406-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bc401bd9-55c5-4d6a-9a19-e3f28d5fd676/a6fac969c48d477246e5431894039bf8/dotnet-sdk-6.0.406-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/78f718d3-3419-4ac3-84b0-4ded4f653c65/efd4add8348bc3306dbddd42564341f8/dotnet-sdk-6.0.406-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/265a56e6-bb98-4b17-948b-bf9884ee3bb3/e2a2587b9a964d155763b706dffaeb8b/dotnet-sdk-6.0.406-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a88e8808-bb19-4722-9101-a46814aa2118/17af8da06a520d9435038768fde4d085/dotnet-sdk-6.0.406-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bd1b3132-b61a-47cf-bacc-130e31003021/002152a1050fbc9eb723bd741453c9d9/dotnet-sdk-6.0.406-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/85962c99-0139-47f0-aa4c-b566b809b6a1/2008bf2ed757e67f382fe92c0fcca583/dotnet-sdk-6.0.406-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/61c6fa00-1ebb-4faf-aaf8-30d39ca5c38e/e3d1785f5805093bcb6d778448d3611d/dotnet-sdk-6.0.406-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/f206c2cc-a062-4e26-90ae-7647450de9e1/c4e5b1e0a32613215d998f2bdef12a9c/dotnet-sdk-6.0.406-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/15f64841-7ce2-4508-8227-fcf393a4e14c/32218eb343103113b183f30801c43b94/dotnet-sdk-6.0.406-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4a725ea4-cd2c-4383-9b63-263156d5f042/d973777b32563272b85617105a06d272/dotnet-sdk-6.0.406-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f16f4f87-539e-45c5-9955-50faebec8952/ecf58d052d15372aa01f389b79782c39/dotnet-sdk-6.0.406-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/cacc3503-733e-4ffb-8eab-920f78ea6fc8/3d5603c46de0317eccf75d136749e57b/dotnet-sdk-6.0.406-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6437c23c-1d87-4a42-b807-05c93f66e9e3/ebb3ac00e7d8c22438414b6a9af9aaf6/dotnet-sdk-6.0.406-win-x86.zip
