# .NET 6.0.15 - March 14, 2023

The .NET 6.0.15, [.NET SDK 6.0.115](6.0.115.md), and [.NET SDK 6.0.310](6.0.310.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.407
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```


Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

### Additional fixes in this release

* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.15+is%3Aclosed+label%3Aservicing-approved+)
* [ASPNET](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A6.0.15+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8285](https://github.com/dotnet/core/issues/8285) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.15.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.15-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.15-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/february-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.15
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.15
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.15
Microsoft.WindowsDesktop.App.Ref | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.15
Microsoft.NETCore.App.Host.win-arm | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.15
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.15
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.15
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.15
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.15
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.15
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.15
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.15
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.15
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64 | 6.0.15
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.15
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.15
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.15
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.15
Microsoft.NETCore.App.Host.win-arm64 | 6.0.15
Microsoft.NETCore.App.Ref | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.15
Microsoft.NETCore.DotNetHostPolicy | 6.0.15
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.15
Microsoft.NETCore.Platforms | 6.0.8
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.15
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.15
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.15
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.15
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.15
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.15
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.15
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.15
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.15
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.15
System.Diagnostics.DiagnosticSource | 6.0.1
System.Net.Http.Json | 6.0.1
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.15
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.15
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.15
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Composite | 6.0.15
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.15
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.15
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.15
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.15
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.15
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.15
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.15
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.15
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.15
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.15
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.15
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.15
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.15
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.15
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.15
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.15
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.15
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.15
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.15
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.15
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.15
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86 | 6.0.15
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.15
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Runtime.win-arm | 6.0.15
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.15
Microsoft.NETCore.DotNetHostResolver | 6.0.15
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.15
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.15
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.15
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.15
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.15
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.15
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.15
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.15
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.15
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.15
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.15
Microsoft.NETCore.DotNetHost | 6.0.15
Microsoft.NETCore.DotNetAppHost | 6.0.15
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.15
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.15
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.15
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.15
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.15
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64 | 6.0.15
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300 | 6.0.15
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400 | 6.0.15
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.15
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.15
Microsoft.NETCore.App.Host.win-x86 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.15
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.15
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.15
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.15
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.15
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.15
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.15
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.15
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.15
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.15
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.15
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.15
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.15
Microsoft.NETCore.App.Host.linux-arm | 6.0.15
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.15
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.15
Microsoft.NETCore.App.Host.linux-x64 | 6.0.15
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.15
Microsoft.NETCore.App.Host.osx-x64 | 6.0.15
Microsoft.NETCore.App.Host.win-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.15
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.15
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.15
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.15
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.15
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.15
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.15
Microsoft.AspNetCore.SignalR.Client | 6.0.15
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.15
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.15
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.15
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.15
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.15
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.15
Microsoft.AspNetCore.TestHost | 6.0.15
Microsoft.Extensions.WebEncoders | 6.0.15
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.15
AspNetCoreRuntime.6.0.x64 | 6.0.15
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.15
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.15
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.15
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.15
Microsoft.AspNetCore.Components.Analyzers | 6.0.15
Microsoft.AspNetCore.Components.Forms | 6.0.15
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.15
Microsoft.AspNetCore.DataProtection | 6.0.15
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.15
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.15
Microsoft.AspNetCore.Identity.UI | 6.0.15
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.15
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.15
Microsoft.AspNetCore.Metadata | 6.0.15
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.15
Microsoft.AspNetCore.Mvc.Testing | 6.0.15
Microsoft.AspNetCore.Owin | 6.0.15
Microsoft.Extensions.ApiDescription.Server | 6.0.15
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.15
Microsoft.Extensions.ApiDescription.Client | 6.0.15
Microsoft.Extensions.Caching.SqlServer | 6.0.15
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.15
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.15
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.15
Microsoft.Extensions.Features | 6.0.15
Microsoft.Extensions.FileProviders.Embedded | 6.0.15
Microsoft.Extensions.Identity.Core | 6.0.15
Microsoft.Extensions.Http.Polly | 6.0.15
Microsoft.JSInterop | 6.0.15
Microsoft.JSInterop.WebAssembly | 6.0.15
dotnet-sql-cache | 6.0.15
Microsoft.AspNetCore.Authentication.Google | 6.0.15
Microsoft.AspNetCore.Authentication.Facebook | 6.0.15
Microsoft.AspNetCore.Authentication.Certificate | 6.0.15
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.15
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.15
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.15
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.15
Microsoft.AspNetCore.Authentication.Twitter | 6.0.15
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.15
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.15
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.15
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.15
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.15
Microsoft.Extensions.Identity.Stores | 6.0.15
Microsoft.Extensions.Localization | 6.0.15
Microsoft.Extensions.Localization.Abstractions | 6.0.15
Microsoft.Extensions.Logging.AzureAppServices | 6.0.15
Microsoft.Extensions.ObjectPool | 6.0.15
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.15
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.15
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.15
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.15
AspNetCoreRuntime.6.0.x86 | 6.0.15
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.15
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.15
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.15
Microsoft.AspNetCore.Components.Authorization | 6.0.15
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.15
Microsoft.AspNetCore.Components.WebView | 6.0.15
Microsoft.AspNetCore.Components.WebAssembly | 6.0.15
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.15
Microsoft.AspNetCore.Connections.Abstractions | 6.0.15
Microsoft.AspNetCore.Cryptography.Internal | 6.0.15
Microsoft.AspNetCore.Http.Connections.Client | 6.0.15
Microsoft.AspNetCore.HeaderPropagation | 6.0.15
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.15
Microsoft.AspNetCore.Razor.Language | 6.0.15
Microsoft.AspNetCore.SignalR.Common | 6.0.15
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.15
Microsoft.Authentication.WebAssembly.Msal | 6.0.15
Microsoft.CodeAnalysis.Razor | 6.0.15
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.15
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.15
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.15
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.15
Microsoft.AspNetCore.App.Ref | 6.0.15
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.15
Microsoft.AspNetCore.Authorization | 6.0.15
Microsoft.AspNetCore.Components | 6.0.15
Microsoft.AspNetCore.Components.Web | 6.0.15
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.15
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.15
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.15
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.15
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.15
Microsoft.AspNetCore.Http.Connections.Common | 6.0.15
Microsoft.AspNetCore.JsonPatch | 6.0.15
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.15
Microsoft.AspNetCore.SpaProxy | 6.0.15
Microsoft.dotnet-openapi | 6.0.15
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.15
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.15
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.115
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.115
Microsoft.TemplateSearch.Common | 6.0.115
Microsoft.DotNet.Common.ItemTemplates | 6.0.115
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.115
Microsoft.TemplateEngine.Abstractions | 6.0.115
Microsoft.TemplateEngine.IDE | 6.0.115
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.115
Microsoft.TemplateEngine.Utils | 6.0.115
Microsoft.TemplateEngine.Core | 6.0.115
Microsoft.TemplateEngine.Edge | 6.0.115
Microsoft.TemplateEngine.Core.Contracts | 6.0.115
Microsoft.DotNet.Compatibility | 1.0.0-servicing.23126.1
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.15
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.15
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64 | 6.0.15
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.15
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.15
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.15
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64 | 6.0.15
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.15
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64 | 6.0.15
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64 | 6.0.15
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64 | 6.0.15
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.15
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.15
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64 | 6.0.15
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.15
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.15
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300 | 6.0.15
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.15
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64 | 6.0.15
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.15
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.15
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.15
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400 | 6.0.15
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86 | 6.0.15
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.15
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86 | 6.0.15
Microsoft.EntityFrameworkCore.InMemory | 6.0.15
Microsoft.EntityFrameworkCore.Relational | 6.0.15
Microsoft.EntityFrameworkCore.Proxies | 6.0.15
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.15
Microsoft.EntityFrameworkCore.SqlServer | 6.0.15
Microsoft.EntityFrameworkCore.Tools | 6.0.15
Microsoft.Data.Sqlite | 6.0.15
Microsoft.EntityFrameworkCore.Abstractions | 6.0.15
Microsoft.EntityFrameworkCore.Cosmos | 6.0.15
Microsoft.EntityFrameworkCore.Design | 6.0.15
Microsoft.EntityFrameworkCore.Analyzers | 6.0.15
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.15
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.15
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.15
Microsoft.EntityFrameworkCore | 6.0.15
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.15
Microsoft.EntityFrameworkCore.Sqlite | 6.0.15
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.15
dotnet-ef | 6.0.15
Microsoft.Data.Sqlite.Core | 6.0.15
Microsoft.DotNet.Common.ItemTemplates | 6.0.310
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.310
Microsoft.TemplateEngine.Core | 6.0.310
Microsoft.TemplateEngine.Edge | 6.0.310
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.310
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.310
Microsoft.TemplateSearch.Common | 6.0.310
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.310
Microsoft.TemplateEngine.Abstractions | 6.0.310
Microsoft.TemplateEngine.Core.Contracts | 6.0.310
Microsoft.TemplateEngine.IDE | 6.0.310
Microsoft.TemplateEngine.Utils | 6.0.310
FSharp.Compiler.Service | 41.0.5
FSharp.Core | 6.0.5
FSharp.Core | 6.0.7
FSharp.Compiler.Service | 41.0.7

[//]: # ( Runtime 6.0.15)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dcfe990c-46fa-4222-946c-e5b9523f94db/20c3e626f66ef7d10678e43ab7fba46a/dotnet-runtime-6.0.15-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2151a562-4991-4496-afac-12ae22e4710d/90644d83484758da592719d9946ca1b8/dotnet-runtime-6.0.15-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e35ae1de-bbd7-424d-baf8-e5328d7bff05/b9bf227728fa13bf140b4fe36609a919/dotnet-runtime-6.0.15-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6076b46e-6d5a-410d-93a1-05314698f906/3453979632a67b64d9f24e88112c9154/dotnet-runtime-6.0.15-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5597f305-2de2-4bbe-8f6c-7f1170e4abb3/b90e355ffdc2851dfa5ac68fc0ba5cb9/dotnet-runtime-6.0.15-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a8db1a39-3418-4bd3-871e-5d13509ee724/2fac3893cffd4948c67dc3a2ef96a99d/dotnet-runtime-6.0.15-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/bfbe0103-d86e-4207-b51c-d02d1827225d/190012c955a7726bebd7c0a5f90ffc35/dotnet-runtime-6.0.15-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b809e06f-b836-45d4-b080-06b263579478/4690f65020f04e6579085df1aad7421d/dotnet-runtime-6.0.15-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/efcd27bd-2226-4a5c-9d2e-5926a570e487/6e1d87f63a3bd0490118682da4eb37c1/dotnet-runtime-6.0.15-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/002ce092-a45c-4c52-baae-067879173e64/a6b706f9b30cb74210ce87ca651b3f4b/dotnet-runtime-6.0.15-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/74453a1d-cd7a-4fb7-90a9-40fc56b7324c/f7511ec1107310ca104dec62f86717af/dotnet-runtime-6.0.15-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/85949133-3f73-485a-bcaa-e220677dde01/e23cfab074837c3d98a1737c1869dc74/dotnet-runtime-6.0.15-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0f609431-fc27-4d13-a6b3-15db9153836a/4c7704d6a26f6099e0ff94cb5a853206/dotnet-runtime-6.0.15-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/17309c0b-8c70-467b-9f95-a4f7ee8bd095/e6ccec507628a50cd81caef510b6fe76/dotnet-runtime-6.0.15-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/46f6ac54-6f22-4c0b-92c2-9cc6a427c08f/a00a86f9652ea609e40b337e3553c1e6/dotnet-runtime-6.0.15-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/377bab71-54b5-4e7b-97d8-e928c11603a4/cc846098d8717af452796601fc426fd8/dotnet-runtime-6.0.15-win-x86.zip

[//]: # ( WindowsDesktop 6.0.15)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/ed661b4a-6784-4b40-8872-c7df46d2fc4d/22ee24e9434437b66f1d5431504c049b/windowsdesktop-runtime-6.0.15-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/25666b72-9496-4c15-95ec-952e7a053104/6c0a54f5239cbb35b28d427e271dc8f2/windowsdesktop-runtime-6.0.15-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/513d13b7-b456-45af-828b-b7b7981ff462/edf44a743b78f8b54a2cec97ce888346/windowsdesktop-runtime-6.0.15-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2a6abed9-fe1e-41e5-8351-eaebe0ee5751/40676900544cfe8e12806ecd756c87a2/windowsdesktop-runtime-6.0.15-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c7294693-5754-4bb0-b4a4-bcb63d4ef661/dd21bbae18ee17a1f8cb004bd1a7d365/windowsdesktop-runtime-6.0.15-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a0eefc49-b808-467c-8e01-17a371ba26f1/a4b79ddf4910b9e3d5d127e2236fc4bb/windowsdesktop-runtime-6.0.15-win-x86.zip

[//]: # ( ASP 6.0.15)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c7eade0f-81ff-4587-a58e-647702814ec4/1b8c56efc82990ee986d8dd52a9a09ab/aspnetcore-runtime-6.0.15-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0d9619a1-af06-40c6-9816-46d08c9e42d6/744ecc09a1058822dc08ae17a3dc9c77/aspnetcore-runtime-6.0.15-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/810c6593-da6d-4f45-9b44-0d2773921363/a7802f15b43c2367180a43d1c361edbc/aspnetcore-runtime-6.0.15-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b571004b-d5ff-47eb-a830-1db7285a40a0/34fbf4b46c625eec823bf570ab130b88/aspnetcore-runtime-6.0.15-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dbd4c83d-99e9-40a5-a6c2-df95b921cf38/0b841f3708f58b04cca7e83955c40de6/aspnetcore-runtime-6.0.15-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4518a0d8-9a6b-4836-ada9-096afa24efd0/ad0d8ccefb6b6a36dc108417b74775cb/aspnetcore-runtime-6.0.15-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8c038a1c-2c5a-4223-b863-3c7ace6b96f0/92b7538b884350b055a22c7877775fa1/aspnetcore-runtime-6.0.15-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/183c7035-79ba-4438-a96f-39cebae901c7/14358a3d95afb3af618abea80a8106db/aspnetcore-runtime-6.0.15-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/09efcd1b-5c31-474c-a8e6-4a660d8d4c3e/f10d916bcbaeb695766d2d423e0e9e34/aspnetcore-runtime-6.0.15-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/28431bba-e071-4e98-86a9-aa7e0c9050fc/0677f2fd79faee65f5d48260b9f303e5/aspnetcore-runtime-6.0.15-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/236f1c8f-4d0a-408e-8c78-3b96c884dfe1/705265df9e07e998178826a0871ca452/aspnetcore-runtime-6.0.15-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4b99db58-969b-401d-a239-86ba1c92e6b8/2c17255b0091fa3210ec4cfb7bfe89ed/aspnetcore-runtime-6.0.15-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2415950c-fcc3-4a5c-b0dd-f81f35a5db6e/9e0483851b6d40ae2d39718d3985004e/aspnetcore-runtime-6.0.15-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/e38901ef-e9ac-4331-a6aa-f2aec3b1754b/6d695fa51a4960393edaf725ce970a86/dotnet-hosting-6.0.15-win.exe

[//]: # ( SDK 6.0.407)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7325ec17-70e8-479d-b8b6-fcbab8d6a053/8abb075436b62424378cbee076c895f5/dotnet-sdk-6.0.407-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/72d1f83c-ad2c-4c9b-88b1-15196f411b9d/a0b863cabea9ac0fe7b92dc70c8d4ef0/dotnet-sdk-6.0.407-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eb7a60fe-51ab-49f7-a045-bf45ee4c441a/afc50596a0e6b0ca436558cf9904f423/dotnet-sdk-6.0.407-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ed74f213-93a3-4844-b4e6-a9764730fa4a/8d0819dba2d8670b4511b8f5bf49a350/dotnet-sdk-6.0.407-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8a52ba86-bd79-4551-90ee-cf219c2f45c1/cb92fd411a83c312c4622f4f375e3b14/dotnet-sdk-6.0.407-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/868b2f38-62ca-4fd8-93ea-e640cf4d2c5b/1e615b6044c0cf99806b8f6e19c97e03/dotnet-sdk-6.0.407-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e953e1ca-4e28-4e40-b3de-c0bfce0596f1/43ec5885784a56be964baaf67b4a4742/dotnet-sdk-6.0.407-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a23756f7-af64-424e-824f-35fd816a5144/0c7789d67cef2037efba35649d643004/dotnet-sdk-6.0.407-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/91b09d38-854f-4888-ae10-b337b8c42045/3207fd5f87fcc22959311e588e531947/dotnet-sdk-6.0.407-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3309662c-cf75-4bae-9317-b0441971084a/91c1112b15c070c03a0d5e6f61434fc7/dotnet-sdk-6.0.407-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/ef7f0961-bb98-4d11-8cb2-9697a9cf55f0/ff7adb80e8d1fa056f5d51616a4fdcd1/dotnet-sdk-6.0.407-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/78fa4003-53e1-492e-93d3-685ccf826f2b/6eddeb3f325a2d501f578168f09d5123/dotnet-sdk-6.0.407-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/38dca5f5-f10f-49fb-b07f-a42dd123ea30/335bb4811c9636b3a4687757f9234db9/dotnet-sdk-6.0.407-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/bfb61a9e-7931-4d37-926e-ccfb73b5d910/7bb8a55f3dab0fe28f7e7bf2f9c41aeb/dotnet-sdk-6.0.407-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3f294688-ec3f-4b85-ba46-ca13bd42979b/97c526c92203e8c13e5beb3172523594/dotnet-sdk-6.0.407-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/44ed8ff3-23b9-4cfc-8acd-c4e5ff5c7794/43cf919892c01b2e4b3a26e2da32f34a/dotnet-sdk-6.0.407-win-x86.zip

[//]: # ( SDK 6.0.310)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f5a1fdd9-8299-413e-b707-7bf5bb11c4f8/dec707f0b78e9f1da4305fe588f2eb1f/dotnet-sdk-6.0.310-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/91343c9e-97ff-4b8e-b411-b56a3c237ecd/9b1ff40787e03e94a0ec517eb0ec4d5d/dotnet-sdk-6.0.310-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/160b9f5e-ce30-43c8-bb9b-41fd11e202e0/8c1e67ed39348c42655401b34e78545c/dotnet-sdk-6.0.310-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/12f8d3d8-b184-43bb-bb9e-1f936f726846/8458991219e0057bb856e649074eaf8b/dotnet-sdk-6.0.310-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2fb79c44-2d17-47d9-92ab-2c0b59e45edc/d83fe196b32dc312a3872fe6136d3633/dotnet-sdk-6.0.310-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/71fb7efe-9bc5-44f3-8674-42f66066c482/62d1c73537189c51e3b42473ef3d5eba/dotnet-sdk-6.0.310-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/58ac76e4-d58c-46c4-ac6e-b99c7e496914/3b9683573613d51e6e9ca0ff8f6f32eb/dotnet-sdk-6.0.310-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d506b3c6-5ba1-41c4-8c44-5eefa6095ad0/a95ac6a119735937f196b2b81d2351d3/dotnet-sdk-6.0.310-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/bcc9caeb-6816-4cb5-915c-da4d1eda76e2/1aabc521750b622b4c543d955b92b9c4/dotnet-sdk-6.0.310-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cbd1bf47-d02d-4a0d-81a0-eba2e9e053b3/1492f5bba7eed4cbbc36e2c91045317a/dotnet-sdk-6.0.310-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/be164729-5304-4023-acbc-acc6a1df74fc/e1acdfdfa8663bd0bcd76015af1022c7/dotnet-sdk-6.0.310-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/532a22d1-ae35-49a6-8052-61cf324bb581/4bbaf512a3569f777c4a1e4f60a7fc3e/dotnet-sdk-6.0.310-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/21dc6731-7a33-4f32-9856-a464329cc90f/b53debb329f5aa178cbf987b003013a9/dotnet-sdk-6.0.310-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7260d9d1-f241-434f-b5fa-86bd74fe8f9c/c4c57471d2fcc01887be9bae0158e388/dotnet-sdk-6.0.310-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/156dcb1e-a3f4-4189-a8fc-b73417657ffa/9ae9d146ba05376fc40afac9ce632785/dotnet-sdk-6.0.310-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c9d2ce6d-5aeb-49ad-a3ed-596abb938076/b76cd06070e6b8113e86166206fb27c6/dotnet-sdk-6.0.310-win-x86.zip

[//]: # ( SDK 6.0.115)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/57b378a8-e17f-4240-a20c-b6e9ee70dce0/2646af466664b371c8124238eda909a1/dotnet-sdk-6.0.115-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/988384bf-2a89-4510-a765-ffd9bf04431a/09c640d3969d9d0403139686135dbbdd/dotnet-sdk-6.0.115-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4fea192c-7cdb-415c-bd04-dc1ee5c1226a/6d554912256d5dac55789844c026045b/dotnet-sdk-6.0.115-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bd9cf87c-6052-4585-a292-28d162590a60/f0c5c8094530c507f0a5745877a098e6/dotnet-sdk-6.0.115-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/89287d1b-dee1-4a4a-8283-b69bd7f56465/b3090c73b22186ea0e34908aad190f33/dotnet-sdk-6.0.115-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0985211d-e1ed-4a73-ba42-38642706ec20/29f1d9e253c996765245a39013b4d2c3/dotnet-sdk-6.0.115-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/84bee0ec-58e3-431b-ac10-5f0d1662ac6a/06212bf1a1499733f081d8bbb7ef619a/dotnet-sdk-6.0.115-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a1839bb9-9370-4ddb-a23c-c4c6648ecf4f/9390e176419b63f2157b543582cd4fe6/dotnet-sdk-6.0.115-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/99d2c9b9-1bd7-440e-a17f-1228f05c3c29/68c067ce39503a1e2d427b622ca6a41d/dotnet-sdk-6.0.115-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0734033e-225b-46ea-8b64-38b2bb965c6f/0adc30d2760a58785bd5f60ae087ab05/dotnet-sdk-6.0.115-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/ba6a249e-7494-47cb-a61c-4fd731ea9894/58d9bf6b6e28fa2f4f55e610b31e8b32/dotnet-sdk-6.0.115-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/b2a444c1-c405-4779-9434-98195d71b509/c7fa03144a230b0e841e4169c483e1eb/dotnet-sdk-6.0.115-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/61ee63df-d33b-4601-932d-72a34740b0c1/e2d943bf1e380a99a2718a127fb146ef/dotnet-sdk-6.0.115-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e890fcb5-a41f-44d6-bd51-1565380875c4/2fec92faccc145425861086da086f342/dotnet-sdk-6.0.115-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/38967177-5af4-4a4e-abc1-260cf333c297/2e9153efe6d568580bb39beb2ac40600/dotnet-sdk-6.0.115-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/74f5b524-19cd-4a9d-9439-d114dfc42419/e93ca2aafaec97c90468ab79a596af57/dotnet-sdk-6.0.115-win-x86.zip
