# .NET 6.0.16 - April 11, 2023

The .NET 6.0.16, [.NET SDK 6.0.116](6.0.116.md), and [.NET SDK 6.0.311](6.0.311.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.408
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

.NET 6.0.16 release carries security fixes.

# Microsoft Security Advisory CVE-2023-28260: .NET Remote Code Execution Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET running on Windows where a runtime DLL can be loaded from an unexpected location, resulting in remote code execution.

### Additional fixes in this release

* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.16+is%3Aclosed+label%3Aservicing-approved+)
* [WPF](https://github.com/dotnet/wpf/issues?q=milestone%3A6.0.16+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8383](https://github.com/dotnet/core/issues/8383) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.16.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.16-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.16-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/february-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.16
Microsoft.WindowsDesktop.App.Ref | 6.0.16
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.16
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.16
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.16
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.16
Microsoft.NETCore.DotNetHostResolver | 6.0.16
Microsoft.NETCore.Platforms | 6.0.9
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.16
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.16
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.16
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.16
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.16
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.16
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.16
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.16
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.16
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.16
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.16
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.16
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.16
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.16
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.16
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.16
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.16
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.16
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.16
Microsoft.Windows.Compatibility | 6.0.4
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.16
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.16
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.16
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.16
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.16
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.16
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.16
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.16
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.16
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.16
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.16
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.16
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.16
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.16
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Composite | 6.0.16
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.16
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.16
Microsoft.NETCore.App.Host.win-x64 | 6.0.16
Microsoft.NETCore.App.Host.win-x86 | 6.0.16
Microsoft.NETCore.App.Ref | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.16
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.16
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.win-arm | 6.0.16
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.16
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.16
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.16
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.16
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.16
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.16
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.16
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.16
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.16
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.16
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.16
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.16
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.16
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.16
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.16
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.16
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.16
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.16
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64 | 6.0.16
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.16
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.16
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.16
Microsoft.NETCore.App.Host.linux-arm | 6.0.16
Microsoft.NETCore.App.Host.win-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.16
Microsoft.NETCore.DotNetHost | 6.0.16
Microsoft.NETCore.DotNetHostPolicy | 6.0.16
Microsoft.NETCore.DotNetAppHost | 6.0.16
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.16
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.16
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.16
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.16
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.16
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.16
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.16
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.16
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300 | 6.0.16
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.16
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.16
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.16
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.16
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.16
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.16
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.16
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.16
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.16
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86 | 6.0.16
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64 | 6.0.16
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400 | 6.0.16
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.16
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.16
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.16
Microsoft.NETCore.App.Host.linux-x64 | 6.0.16
Microsoft.NETCore.App.Host.osx-x64 | 6.0.16
Microsoft.NETCore.App.Host.win-arm | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.16
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.16
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.16
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.16
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.16
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.16
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.16
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.16
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.16
System.Management | 6.0.1
Microsoft.AspNetCore.Authentication.Certificate | 6.0.16
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.16
Microsoft.AspNetCore.Authentication.Google | 6.0.16
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.16
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.16
Microsoft.AspNetCore.Authentication.Twitter | 6.0.16
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.16
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.16
Microsoft.AspNetCore.Authorization | 6.0.16
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.16
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.16
Microsoft.AspNetCore.HeaderPropagation | 6.0.16
Microsoft.AspNetCore.Metadata | 6.0.16
Microsoft.AspNetCore.Mvc.Testing | 6.0.16
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.16
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.16
Microsoft.AspNetCore.Razor.Language | 6.0.16
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.16
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.16
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.16
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.16
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.16
Microsoft.AspNetCore.App.Ref | 6.0.16
Microsoft.AspNetCore.Authentication.Facebook | 6.0.16
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.16
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.16
Microsoft.AspNetCore.Components.Authorization | 6.0.16
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.16
Microsoft.AspNetCore.SignalR.Common | 6.0.16
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.16
Microsoft.Authentication.WebAssembly.Msal | 6.0.16
Microsoft.JSInterop | 6.0.16
Microsoft.JSInterop.WebAssembly | 6.0.16
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.16
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.16
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.16
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.16
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.16
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.16
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.16
Microsoft.AspNetCore.Components.WebAssembly | 6.0.16
Microsoft.AspNetCore.Components.WebView | 6.0.16
Microsoft.AspNetCore.Connections.Abstractions | 6.0.16
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.16
Microsoft.AspNetCore.DataProtection | 6.0.16
Microsoft.AspNetCore.Cryptography.Internal | 6.0.16
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.16
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.16
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.16
Microsoft.AspNetCore.TestHost | 6.0.16
Microsoft.Extensions.ApiDescription.Server | 6.0.16
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.16
Microsoft.Extensions.ApiDescription.Client | 6.0.16
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.16
Microsoft.AspNetCore.Owin | 6.0.16
Microsoft.AspNetCore.SignalR.Client | 6.0.16
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.16
Microsoft.CodeAnalysis.Razor | 6.0.16
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.16
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.16
Microsoft.Extensions.Logging.AzureAppServices | 6.0.16
Microsoft.Extensions.WebEncoders | 6.0.16
Microsoft.Extensions.ObjectPool | 6.0.16
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.16
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.16
dotnet-sql-cache | 6.0.16
AspNetCoreRuntime.6.0.x86 | 6.0.16
AspNetCoreRuntime.6.0.x64 | 6.0.16
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.16
Microsoft.AspNetCore.Components.Analyzers | 6.0.16
Microsoft.AspNetCore.Components | 6.0.16
Microsoft.AspNetCore.Components.Forms | 6.0.16
Microsoft.AspNetCore.Components.Web | 6.0.16
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.16
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.16
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.16
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.16
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.16
Microsoft.AspNetCore.Identity.UI | 6.0.16
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.16
Microsoft.AspNetCore.Http.Connections.Client | 6.0.16
Microsoft.AspNetCore.Http.Connections.Common | 6.0.16
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.16
Microsoft.AspNetCore.JsonPatch | 6.0.16
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.16
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.16
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.16
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.16
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.16
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.16
Microsoft.AspNetCore.SpaProxy | 6.0.16
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.16
Microsoft.dotnet-openapi | 6.0.16
Microsoft.Extensions.Caching.SqlServer | 6.0.16
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.16
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.16
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.16
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.16
Microsoft.Extensions.Features | 6.0.16
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.16
Microsoft.Extensions.Identity.Core | 6.0.16
Microsoft.Extensions.FileProviders.Embedded | 6.0.16
Microsoft.Extensions.Http.Polly | 6.0.16
Microsoft.Extensions.Localization | 6.0.16
Microsoft.Extensions.Identity.Stores | 6.0.16
Microsoft.Extensions.Localization.Abstractions | 6.0.16
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.116
Microsoft.TemplateSearch.Common | 6.0.116
Microsoft.TemplateEngine.Utils | 6.0.116
Microsoft.TemplateEngine.Core.Contracts | 6.0.116
Microsoft.TemplateEngine.Edge | 6.0.116
Microsoft.TemplateEngine.IDE | 6.0.116
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.116
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.116
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.116
Microsoft.DotNet.Common.ItemTemplates | 6.0.116
Microsoft.TemplateEngine.Abstractions | 6.0.116
Microsoft.TemplateEngine.Core | 6.0.116
Microsoft.DotNet.Compatibility | 1.0.0-servicing.23177.14
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.16
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.16
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.16
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.16
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64 | 6.0.16
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86 | 6.0.16
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.16
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.16
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.16
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.16
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.16
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300 | 6.0.16
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64 | 6.0.16
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400 | 6.0.16
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.16
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64 | 6.0.16
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64 | 6.0.16
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.16
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.16
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64 | 6.0.16
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.16
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86 | 6.0.16
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64 | 6.0.16
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.16
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64 | 6.0.16
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.16
dotnet-ef | 6.0.16
Microsoft.EntityFrameworkCore.Tools | 6.0.16
Microsoft.EntityFrameworkCore | 6.0.16
Microsoft.Data.Sqlite.Core | 6.0.16
Microsoft.EntityFrameworkCore.Analyzers | 6.0.16
Microsoft.EntityFrameworkCore.Abstractions | 6.0.16
Microsoft.EntityFrameworkCore.Cosmos | 6.0.16
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.16
Microsoft.EntityFrameworkCore.Design | 6.0.16
Microsoft.EntityFrameworkCore.InMemory | 6.0.16
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.16
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.16
Microsoft.EntityFrameworkCore.Proxies | 6.0.16
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.16
Microsoft.EntityFrameworkCore.Sqlite | 6.0.16
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.16
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.16
Microsoft.Data.Sqlite | 6.0.16
Microsoft.EntityFrameworkCore.Relational | 6.0.16
Microsoft.EntityFrameworkCore.SqlServer | 6.0.16
Microsoft.DotNet.Common.ItemTemplates | 6.0.311
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.311
Microsoft.TemplateEngine.Abstractions | 6.0.311
Microsoft.TemplateEngine.Core.Contracts | 6.0.311
Microsoft.TemplateEngine.Edge | 6.0.311
Microsoft.TemplateEngine.IDE | 6.0.311
Microsoft.TemplateEngine.Utils | 6.0.311
Microsoft.TemplateSearch.Common | 6.0.311
Microsoft.TemplateEngine.Core | 6.0.311
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.311
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.311
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.311
FSharp.Compiler.Service | 41.0.5
FSharp.Core | 6.0.5
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.408
Microsoft.TemplateEngine.Utils | 6.0.408
Microsoft.TemplateSearch.Common | 6.0.408
Microsoft.DotNet.Common.ItemTemplates. | 6.0.408
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.408
Microsoft.DotNet.Common.ProjectTemplates.1.x |  6.0.408
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.408
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.408
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.408
Microsoft.TemplateEngine.Abstractions | 6.0.408
Microsoft.TemplateEngine.Core | 6.0.408
Microsoft.TemplateEngine.Core.Contracts | 6.0.408
Microsoft.TemplateEngine.IDE | 6.0.408
Microsoft.TemplateEngine.Edge | 6.0.408
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.408
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.408
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.408
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.408
FSharp.Core | 6.0.7
FSharp.Compiler.Service | 41.0.7

[//]: # ( Runtime 6.0.16)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7039aeff-2d14-46b3-a560-e5af5591d6c6/3cb3a4aae10e161413fda1100007551a/dotnet-runtime-6.0.16-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e7866e12-a380-4994-9c56-1bd3a1e0a546/22a5e54cb4e637c5aac7ec6dcab0d739/dotnet-runtime-6.0.16-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/77e84978-dd35-484f-a61d-088d9e6797b6/9383790626c84b8f0cb21c6256ec39e7/dotnet-runtime-6.0.16-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1527c68d-b4d3-484f-8b03-2fac8059cc22/d92d3b107c5f4247f42662715665790f/dotnet-runtime-6.0.16-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/594f2293-b2d4-4ed4-b9ab-59cb2941b2de/80e8f041723a08526a3a94ccbf026abe/dotnet-runtime-6.0.16-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/45395f1b-8928-41c5-9585-f01d949b2afb/0911c4025fffc0f51c3ab535695c6ca6/dotnet-runtime-6.0.16-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/46bc499c-d5a9-4fb7-8329-1ae1e36b5e4e/07ea51ee4ea1d10230832304ee0ac8c8/dotnet-runtime-6.0.16-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/757be454-09b0-4991-a2bc-90c06267fbde/2ea450db713598c9cdb46a6d9bd56156/dotnet-runtime-6.0.16-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ca62f657-0cc3-44be-b7d5-0a9bbd6b0ddd/5f362447c26eb162a36670f345e3349d/dotnet-runtime-6.0.16-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/24cc772f-0358-40c5-a41a-4c1434a9e9b8/f91c66d80be3a91f632f7eae102fd64f/dotnet-runtime-6.0.16-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/91b97f3d-7783-4be3-ada2-6f1d4b299088/8d98117ad78ad15945f28a4e4bd0f79d/dotnet-runtime-6.0.16-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/2d4158c5-2c5a-483f-a0ee-32832dcc5468/cb14d5419b4b9eb2145a0b5fa5c12d3d/dotnet-runtime-6.0.16-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/456fdf02-f100-4664-916d-fd46c192efea/619bbd8426537632b7598b4c7c467cf1/dotnet-runtime-6.0.16-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e492f874-2dc9-4b6c-b30b-7d18ab522310/cd4889d33b3c45fbda5918b510404d2a/dotnet-runtime-6.0.16-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/78caa28b-2982-43ed-8b9c-20e3369f0795/c771e9fd12a67068436115cf295740f7/dotnet-runtime-6.0.16-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/18a60899-5997-461a-a656-dc2bfed134dd/9460561daa0955d796342c5ac88ee26b/dotnet-runtime-6.0.16-win-x86.zip

[//]: # ( WindowsDesktop 6.0.16)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/7a490e4e-5a43-4e3e-8311-028e1a5436cb/d2b0bd46d8202676bb8c9f4c97f8ec58/windowsdesktop-runtime-6.0.16-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/890774e2-7be2-4e8d-acd5-c32d4643a64d/9169706a433b9763874646cfefeddc53/windowsdesktop-runtime-6.0.16-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/85473c45-8d91-48cb-ab41-86ec7abc1000/83cd0c82f0cde9a566bae4245ea5a65b/windowsdesktop-runtime-6.0.16-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/53713a98-b62a-4457-9139-14fc18715aaf/716e4d20995f127e413b4b49eec736fb/windowsdesktop-runtime-6.0.16-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ea0e40d2-e326-453b-8cac-2719cbbefeca/b26458b139a500d3067ec25987030497/windowsdesktop-runtime-6.0.16-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/611a2b62-90e6-4c3b-9499-f22b453045a2/2cdb0dc2cbde813e30979c10c9c8c6a6/windowsdesktop-runtime-6.0.16-win-x86.zip

[//]: # ( ASP 6.0.16)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4054a868-d2c9-4e04-84ea-d78b6b77c8cb/f69efb40d4cc84fa5f792d0bb821eea8/aspnetcore-runtime-6.0.16-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5fe35f73-59e4-462e-b7aa-98b5b8782051/74a27e03d896663a9483eb72bc59b275/aspnetcore-runtime-6.0.16-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/86eb22f1-0f85-44e7-a3a0-6e98962af095/19b79091c241cb0bd19460a09c54b43b/aspnetcore-runtime-6.0.16-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/575b2a83-e143-409f-bb71-bbc07b0c89c5/7fd2c84dc6a06b8344a03fe87b0d6fd1/aspnetcore-runtime-6.0.16-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aef4689c-0fda-42b1-abb2-4cbd524efa48/087182f77a3b8b7ec4b29e6c40948af2/aspnetcore-runtime-6.0.16-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/877a2d48-74ed-484b-85a1-605078f5e718/752ce1e38b76ffb5ebfc2ee1772307bf/aspnetcore-runtime-6.0.16-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9209cddf-bdad-425a-8b04-682a7ead5e12/93c46a477e0d4ff411d78546638f6a54/aspnetcore-runtime-6.0.16-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3e30ee2d-da08-49fc-8877-712fd63b0b84/1390326bfaf1e6fcd922fcbc4efc6293/aspnetcore-runtime-6.0.16-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/46db4832-313b-4d38-8e04-2bf7850d2f87/7c0536e55f708d0f8b5d303f82af3f8a/aspnetcore-runtime-6.0.16-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/97eb0863-ef19-4f74-ac83-5ab594acb830/593ea1cd7b879bea4f75ab638c34de22/aspnetcore-runtime-6.0.16-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/579135b3-8d18-4267-9f05-819f31931eb8/a03bcc68c2247d44649cfdde685694b7/aspnetcore-runtime-6.0.16-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a4f38d1f-1d4d-41f0-8937-fcdd3fc692a2/64133ed947181f97400234cdd7e76c4f/aspnetcore-runtime-6.0.16-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7a8350d6-6a71-4fb4-a4e5-d9c2049b131b/cd6f32423fe9a43812c18ca493964e35/aspnetcore-runtime-6.0.16-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/7ab0bc25-5b00-42c3-b7cc-bb8e08f05135/91528a790a28c1f0fe39845decf40e10/dotnet-hosting-6.0.16-win.exe

[//]: # ( SDK 6.0.408)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ddd2d69f-65ef-4cb2-b34f-468c582d3092/f5572b4b10386c9defc75a813836c3f3/dotnet-sdk-6.0.408-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9c4bff1b-9f35-44a3-95a3-d17224810b08/0f7426d4ce82cd5b55ed1b6f07877d5e/dotnet-sdk-6.0.408-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d51cc812-92f2-4d1d-b24f-fa62413ef680/a40265fed749899bb01cd49944acbd6a/dotnet-sdk-6.0.408-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf0904f1-081b-40c3-809a-71738768474e/4b07da9d9f2036baa2a458847782256c/dotnet-sdk-6.0.408-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c8f36f9f-c7b3-4e10-9145-f4c201c71985/8c8270f66f7b25b1b3367281a2c9f646/dotnet-sdk-6.0.408-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dd7d2255-c9c1-4c6f-b8ad-6e853d6bb574/c8e1b5f47bf17b317a84487491915178/dotnet-sdk-6.0.408-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/d314a89e-8bfa-4b7d-876b-9df41ec12a53/37ebf6170857ab5da80a02d4ec8a3364/dotnet-sdk-6.0.408-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/21503502-8d12-4a18-9d93-ec0f7ee7b9cb/3df619d8ac623a16a79755e73fdf4d0d/dotnet-sdk-6.0.408-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4909fc6d-8655-437d-b436-74fc180d12e6/24de71d15ed7bcf02ff8f96fff6a2f54/dotnet-sdk-6.0.408-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/048c81a0-ee14-4b14-8572-d192651d12d1/060be74876613256c50ea75ed623970a/dotnet-sdk-6.0.408-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/4a7ae9d1-fb98-4e1d-a2d7-3d9903973312/b9f80d6eaa94f7b04cb45241ec515ff6/dotnet-sdk-6.0.408-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/64300040-4f70-4567-aaa7-4fd1b9eca339/c74eb35d5eaa393845b0e5836ef0e040/dotnet-sdk-6.0.408-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/df42b901-8ce2-4131-941a-b3fa094ff3d8/556da65f7a2f6164bf3df932e030898a/dotnet-sdk-6.0.408-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ca13c6f1-3107-4cf8-991c-f70edc1c1139/a9f90579d827514af05c3463bed63c22/dotnet-sdk-6.0.408-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/43e1af49-c5e0-4df8-b4c1-aab805e823bc/9b215244f10ee4606e28fcdb0f63ebd1/dotnet-sdk-6.0.408-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e8bf9b59-bec4-49d3-a043-154e3d5b830e/a48c12e1d295c6a3cf708eb2ef0b7136/dotnet-sdk-6.0.408-win-x86.zip
