# .NET 6.0.18 - June 13, 2023

The .NET 6.0.18, [.NET SDK 6.0.118](6.0.118.md), and [.NET SDK 6.0.313](6.0.313.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.410
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

.NET 6.0.18 release carries security fixes.

[CVE-2023-24895 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-24895)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in how WPF for .NET handles certain XAML Frame elements which may result in remote code execution.

[CVE-2023-24897 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-24897)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in how .NET reads debugging symbols, where reading a malicious symbols file may result in remote code execution.

[CVE-2023-24936 - .NET Elevation of Privilege Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-24936)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET when deserializing a DataSet or DataTable from XML which may result in elevation of privileges.

[CVE-2023-29331 -  .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-29331)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET when processing X.509 certificates that may result in Denial of Service.

[CVE-2023-29337 -  NuGet Client Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-29337)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET and NuGet on Linux. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in nuget where a potential race condition that can lead to a symlink attack

[CVE-2023-33126 -  .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-33126)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET during crash and stack trace scenarios that could lead to loading arbitrary binaries.

[CVE-2023-33128 -  .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-33128)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET source generator for P/Invokes that can lead to generated code freeing uninitialized memory and crashing.

[CVE-2023-33135 -  .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-33135)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in the .NET SDK during tool restore which can lead to an elevation of privilege.

### Additional fixes in this release

* [ASPNET](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A6.0.18+is%3Aclosed+label%3Aservicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.18+is%3Aclosed+label%3Aservicing-approved+)
* [Winforms](https://github.com/dotnet/winforms/issues?q=milestone%3A6.0.18+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8539](https://github.com/dotnet/core/issues/8539) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.18.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.18-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.18-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/June-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.18
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.18
Microsoft.WindowsDesktop.App.Ref | 6.0.18
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.18
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.18
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.18
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.18
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.18
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.18
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.18
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.18
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64 | 6.0.18
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64 | 6.0.18
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400 | 6.0.18
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.18
Microsoft.NETCore.App.Host.win-x64 | 6.0.18
Microsoft.NETCore.App.Host.win-x86 | 6.0.18
Microsoft.NETCore.App.Ref | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.18
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.18
Microsoft.Extensions.Hosting.WindowsServices | 6.0.2
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.18
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.18
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.18
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300 | 6.0.18
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.18
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.18
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.18
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.18
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.18
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.18
Microsoft.NETCore.DotNetHostPolicy | 6.0.18
Microsoft.NETCore.DotNetAppHost | 6.0.18
Microsoft.NETCore.DotNetHostResolver | 6.0.18
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.18
System.Management | 6.0.2
System.Security.Cryptography.Pkcs | 6.0.3
System.Text.Json | 6.0.8
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.18
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.18
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.win-arm | 6.0.18
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.18
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.18
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.18
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.18
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.18
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.18
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.18
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.18
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.18
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.18
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.18
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.18
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.18
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.18
Microsoft.Extensions.Logging.Abstractions | 6.0.4
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.18
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.18
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Composite | 6.0.18
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.18
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.18
Microsoft.NETCore.App.Host.linux-arm | 6.0.18
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.18
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.18
Microsoft.NETCore.App.Host.osx-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.18
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.18
Microsoft.NETCore.Platforms | 6.0.10
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.18
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.18
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.18
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.18
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.18
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.18
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.18
System.DirectoryServices.Protocols | 6.0.2
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.18
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.18
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.18
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.18
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.18
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.18
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.18
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.18
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.18
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.18
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.18
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.18
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.18
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.18
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.18
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.18
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.18
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.18
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.18
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.18
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.18
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.18
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.18
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.18
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.18
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.18
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.18
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.18
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.18
Microsoft.NETCore.App.Host.linux-x64 | 6.0.18
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.18
Microsoft.NETCore.App.Host.win-arm | 6.0.18
Microsoft.NETCore.App.Host.win-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.18
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.18
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.18
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.18
Microsoft.NETCore.DotNetHost | 6.0.18
Microsoft.Windows.Compatibility | 6.0.6
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.18
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.18
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.18
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.18
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.18
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.18
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.18
System.ServiceProcess.ServiceController | 6.0.1
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.18
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.18
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.18
Microsoft.AspNetCore.Components | 6.0.18
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.18
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.18
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.18
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.18
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.18
Microsoft.Extensions.Features | 6.0.18
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.18
AspNetCoreRuntime.6.0.x86 | 6.0.18
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.18
Microsoft.AspNetCore.Authentication.Facebook | 6.0.18
Microsoft.AspNetCore.Authentication.Google | 6.0.18
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.18
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.18
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.18
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.18
Microsoft.AspNetCore.Authentication.Twitter | 6.0.18
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.18
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.18
Microsoft.AspNetCore.Authorization | 6.0.18
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.18
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.18
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.18
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.18
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.18
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.18
Microsoft.AspNetCore.Http.Connections.Client | 6.0.18
Microsoft.AspNetCore.Identity.UI | 6.0.18
Microsoft.AspNetCore.Http.Connections.Common | 6.0.18
Microsoft.CodeAnalysis.Razor | 6.0.18
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.18
Microsoft.Extensions.Caching.SqlServer | 6.0.18
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.18
Microsoft.Extensions.FileProviders.Embedded | 6.0.18
Microsoft.Extensions.Http.Polly | 6.0.18
Microsoft.Extensions.Identity.Core | 6.0.18
Microsoft.Extensions.Localization.Abstractions | 6.0.18
Microsoft.Extensions.Logging.AzureAppServices | 6.0.18
Microsoft.JSInterop | 6.0.18
Microsoft.JSInterop.WebAssembly | 6.0.18
AspNetCoreRuntime.6.0.x64 | 6.0.18
dotnet-sql-cache | 6.0.18
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.18
Microsoft.AspNetCore.App.Ref | 6.0.18
Microsoft.AspNetCore.Components.Authorization | 6.0.18
Microsoft.AspNetCore.SignalR.Client | 6.0.18
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.18
Microsoft.AspNetCore.SignalR.Common | 6.0.18
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.18
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.18
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.18
Microsoft.Extensions.Identity.Stores | 6.0.18
Microsoft.Extensions.Localization | 6.0.18
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.18
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.18
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.18
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.18
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.18
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.18
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.18
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.18
Microsoft.AspNetCore.Authentication.Certificate | 6.0.18
Microsoft.AspNetCore.Components.Analyzers | 6.0.18
Microsoft.AspNetCore.Components.WebView | 6.0.18
Microsoft.AspNetCore.Components.Web | 6.0.18
Microsoft.AspNetCore.Components.WebAssembly | 6.0.18
Microsoft.AspNetCore.Connections.Abstractions | 6.0.18
Microsoft.AspNetCore.Cryptography.Internal | 6.0.18
Microsoft.AspNetCore.DataProtection | 6.0.18
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.18
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.18
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.18
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.18
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.18
Microsoft.AspNetCore.Components.Forms | 6.0.18
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.18
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.18
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.18
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.18
Microsoft.AspNetCore.HeaderPropagation | 6.0.18
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.18
Microsoft.AspNetCore.JsonPatch | 6.0.18
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.18
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.18
Microsoft.AspNetCore.Metadata | 6.0.18
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.18
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.18
Microsoft.AspNetCore.Owin | 6.0.18
Microsoft.AspNetCore.Mvc.Testing | 6.0.18
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.18
Microsoft.AspNetCore.Razor.Language | 6.0.18
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.18
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.18
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.18
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.18
Microsoft.AspNetCore.SpaProxy | 6.0.18
Microsoft.Authentication.WebAssembly.Msal | 6.0.18
Microsoft.dotnet-openapi | 6.0.18
Microsoft.AspNetCore.TestHost | 6.0.18
Microsoft.Extensions.ApiDescription.Server | 6.0.18
Microsoft.Extensions.ApiDescription.Client | 6.0.18
Microsoft.Extensions.ObjectPool | 6.0.18
Microsoft.Extensions.WebEncoders | 6.0.18
Microsoft.DotNet.Common.ItemTemplates | 6.0.118
Microsoft.TemplateEngine.Core | 6.0.118
Microsoft.TemplateEngine.Core.Contracts | 6.0.118
Microsoft.TemplateEngine.Edge | 6.0.118
Microsoft.TemplateEngine.IDE | 6.0.118
Microsoft.TemplateEngine.Utils | 6.0.118
Microsoft.TemplateSearch.Common | 6.0.118
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.118
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.118
Microsoft.TemplateEngine.Abstractions | 6.0.118
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.118
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.118
Microsoft.DotNet.Compatibility | 1.0.0-servicing.23272.29
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.18
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64 | 6.0.18
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.18
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.18
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.18
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64 | 6.0.18
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64 | 6.0.18
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.18
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.18
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64 | 6.0.18
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.18
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.18
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.18
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300 | 6.0.18
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64 | 6.0.18
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64 | 6.0.18
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.18
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.18
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400 | 6.0.18
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.18
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.18
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64 | 6.0.18
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.18
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86 | 6.0.18
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.18
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86 | 6.0.18
Microsoft.EntityFrameworkCore | 6.0.18
Microsoft.Data.Sqlite.Core | 6.0.18
Microsoft.Data.Sqlite | 6.0.18
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.18
Microsoft.EntityFrameworkCore.Proxies | 6.0.18
Microsoft.EntityFrameworkCore.Sqlite | 6.0.18
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.18
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.18
Microsoft.EntityFrameworkCore.SqlServer | 6.0.18
Microsoft.EntityFrameworkCore.Abstractions | 6.0.18
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.18
Microsoft.EntityFrameworkCore.Cosmos | 6.0.18
Microsoft.EntityFrameworkCore.Design | 6.0.18
Microsoft.EntityFrameworkCore.InMemory | 6.0.18
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.18
dotnet-ef | 6.0.18
Microsoft.EntityFrameworkCore.Analyzers | 6.0.18
Microsoft.EntityFrameworkCore.Relational | 6.0.18
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.18
Microsoft.EntityFrameworkCore.Tools | 6.0.18
Microsoft.TemplateEngine.Utils | 6.0.313
Microsoft.DotNet.Common.ItemTemplates | 6.0.313
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.313
Microsoft.TemplateEngine.Core | 6.0.313
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.313
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.313
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.313
Microsoft.TemplateSearch.Common | 6.0.313
Microsoft.TemplateEngine.Edge | 6.0.313
Microsoft.TemplateEngine.Abstractions | 6.0.313
Microsoft.TemplateEngine.IDE | 6.0.313
Microsoft.TemplateEngine.Core.Contracts | 6.0.313
FSharp.Compiler.Service | 41.0.5
FSharp.Core | 6.0.5
Microsoft.TemplateSearch.Common | 6.0.410
Microsoft.DotNet.Common.ItemTemplates | 6.0.410
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.410
Microsoft.TemplateEngine.Utils | 6.0.410
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.410
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.410
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.410
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.410
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.410
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.410
Microsoft.TemplateEngine.Edge | 6.0.410
Microsoft.TemplateEngine.IDE | 6.0.410
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.410
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.410
Microsoft.TemplateEngine.Abstractions | 6.0.410
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.410
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.410
Microsoft.TemplateEngine.Core.Contracts | 6.0.410
Microsoft.TemplateEngine.Core | 6.0.410
FSharp.Core | 6.0.7
FSharp.Compiler.Service | 41.0.7

[//]: # ( Runtime 6.0.18)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7853dcac-adfa-4cf4-8131-ee38c0962267/8bff8be2972a7894fd699a5bbc92b467/dotnet-runtime-6.0.18-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/29fb12f4-03c2-450c-99d4-6c94fb47a6b2/18e308e40e503f02696f00b719ce581a/dotnet-runtime-6.0.18-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/53dac94e-b298-4c7d-8da6-adbbea68ba15/5517499fd1f7e3794f5a7fb4ec2d336d/dotnet-runtime-6.0.18-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/826c48f5-19e4-4cf1-9ec3-cecf010f8ae5/616bc0ac995e4214c36df79c49def5d9/dotnet-runtime-6.0.18-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/60b89d76-b036-484f-a160-527562454fa8/d29669379e59f39ff00a7897919c9719/dotnet-runtime-6.0.18-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/53fce0ba-88f8-44e0-8174-16fb7d6f1a33/7e4ee56d0aa754deed6cf4db31dd9e25/dotnet-runtime-6.0.18-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0377fbff-2f19-439a-8947-737efae3402a/8c6dd93cabe570b85e6b2979a7cd0d44/dotnet-runtime-6.0.18-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9dc8fb0b-74d4-4c1e-8eea-b4cf02151db9/e5e72a0e4773f5542d3bedc735736774/dotnet-runtime-6.0.18-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/03315605-5bd7-4346-a583-ee251c2d4b96/96bb4b600ce86f901245c8254460acd1/dotnet-runtime-6.0.18-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8b68e217-8a0a-4398-9559-7767c973b26c/e322082fa4280a2b1f0904d74750aeec/dotnet-runtime-6.0.18-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/52743981-ced5-4b6a-a9eb-0bbb685769e6/0f23882914cc08efd6be25a641989896/dotnet-runtime-6.0.18-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/55ebe9fd-3fa9-4802-a1c0-2aa4497d3baf/d19833722c0dcab83fc93a4af35c711a/dotnet-runtime-6.0.18-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e389c6ec-73bf-4f2f-aa8b-03caf20c8a9b/83b1073742b86a6359a0e633a9ea9d82/dotnet-runtime-6.0.18-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1cd79758-b33c-4a04-a126-8f302fbdcd66/d99a42150aca8a8489a0b1110d3c2e4b/dotnet-runtime-6.0.18-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b6b9602e-ea2f-4dee-9f0e-03811b085a7c/f68e10f69c30fb281c1a107c58ef91e9/dotnet-runtime-6.0.18-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/22a5c610-00d3-4b21-8f55-8c9f8f4e07c6/ff67c714571eb58d0d0ff4512bb05716/dotnet-runtime-6.0.18-win-x86.zip

[//]: # ( WindowsDesktop 6.0.18)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/efc902e6-6c71-42d2-b9d7-ad7c1d104d52/2f88aed465962b5f495c98536d6371c5/windowsdesktop-runtime-6.0.18-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/dd5799ce-7f57-4c2e-ab46-9916167e91de/6f30e82c094e3de7617fbb46bce4a681/windowsdesktop-runtime-6.0.18-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f76bace5-6cf4-41d8-ab54-fb7a3766b673/1cbc047d4547dfa9ecd59d5a71402186/windowsdesktop-runtime-6.0.18-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5e93b647-ae04-4e7e-8819-2b0677d4f7b0/bf2be615dc2f178e8805e6d52413ae57/windowsdesktop-runtime-6.0.18-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/68574b0b-3242-46f1-a406-9ef9aeeec3e5/d45d732e846f306889f41579104b1a33/windowsdesktop-runtime-6.0.18-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/728f90d8-95f4-41bb-84d1-d5c4ebe9c67a/45dfdbcf9280d5a1299f05b2fc584018/windowsdesktop-runtime-6.0.18-win-x86.zip

[//]: # ( ASP 6.0.18)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7b10cc0d-3627-4d1b-8307-630c05fb30be/06e4498eeb854db5a723b46114377fce/aspnetcore-runtime-6.0.18-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f60912b4-b50d-4d85-b3aa-3b69504a426b/190ebc4012cd4da240e4d5247b484b15/aspnetcore-runtime-6.0.18-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/76c14a83-3d22-4a36-819e-61e3c9c05bee/5b72d62559f070fab09515a6d672bdd4/aspnetcore-runtime-6.0.18-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/574d6e0c-8e4d-429b-9b09-8bff55af7b1f/14efa83c2fccdf38ba8a88b20fb98a9e/aspnetcore-runtime-6.0.18-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/78cd6f86-a970-450c-bfa4-6b84dd378b36/10b533b65feaa6e44c8efe1220897d56/aspnetcore-runtime-6.0.18-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/503c4325-104f-41e0-8dc6-1a8b55e0651a/3dcd8a5d03d3a04bb4111296b12cd11d/aspnetcore-runtime-6.0.18-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8727a27f-8715-4651-89d9-dd8f431928fa/4f11488f22cbe8a052991b00ba2a99df/aspnetcore-runtime-6.0.18-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/29f05258-1233-44dd-8810-89401619064b/9e3ab81867221289c6ef76216fcc0a70/aspnetcore-runtime-6.0.18-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/3515f0f4-8d87-48f6-91c8-be197546538c/29e872aa4f8d62c8cb6e91296bcdb2ad/aspnetcore-runtime-6.0.18-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a0a0d5c2-92d4-4781-a503-e957d63c5111/25ee550f61810fb292873ffdfc3e500a/aspnetcore-runtime-6.0.18-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/59b58bb4-041a-460f-98ad-f32ffa77fc5b/b3a40257a3d137f76ba686947766fd26/aspnetcore-runtime-6.0.18-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4f0f6018-2f1e-4855-a4a4-57084f720bc6/45e06449f5ac52ec8c62618ae3dda669/aspnetcore-runtime-6.0.18-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8c533084-472b-4865-b2b5-a1d48e150e6e/3380a17237106fd3a9f2c3942aa9b9f0/aspnetcore-runtime-6.0.18-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/b84943df-6c61-4af8-91fc-a3981cd04eb8/69663d1ee22625a25d9f528b9dde0225/dotnet-hosting-6.0.18-win.exe

[//]: # ( SDK 6.0.410)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5e96f312-9963-4aae-98c5-38bb1cf3020d/9c5fa4d735eb7af674a365821525b503/dotnet-sdk-6.0.410-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf758689-351e-4857-8e9d-b2f155577bcf/759401b27c3c68d3ae344d2112bf9057/dotnet-sdk-6.0.410-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/175b0448-039e-4332-bee4-4dd3abd4494f/97249f56661919a1c1bc08d09de58311/dotnet-sdk-6.0.410-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c90417bb-3bde-41e0-a741-7ab560ebac63/b959ab2ae1cff165dd6a8ca1f621db4d/dotnet-sdk-6.0.410-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a29518af-5294-4a54-9648-0089b1162a2a/efc56f0d5cac270defc8dd5ed0ad4b21/dotnet-sdk-6.0.410-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ac5809b0-7930-4ae9-9005-58f2fd7912f3/4cf0cb18d22a162b33149b1f28a8e045/dotnet-sdk-6.0.410-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/983c585a-6e22-458f-8632-f0f97b687ca8/8250a113e906e443c904e9cf72f118b9/dotnet-sdk-6.0.410-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c9f8cecc-df92-4720-bb4f-273c55762b68/7abd1ebeb6241949dae538dc72532190/dotnet-sdk-6.0.410-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a3e893be-f18b-4e66-82e8-7c8ed885656d/3418460dc778e8e496b578b93d7df141/dotnet-sdk-6.0.410-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/190b69f8-f50a-4d68-bd44-8bfc5271265a/a29b1769b5e5d73366cb34ba3bccf9d9/dotnet-sdk-6.0.410-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/ed9ab89a-e404-4fad-9dfe-038d65799714/71ba990c8b470cfb81e4d3547af1c0b9/dotnet-sdk-6.0.410-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/6846300a-60e5-4c26-9aef-e3f63420f7e4/a4f9be0661afd3c63c35ed365ba7da22/dotnet-sdk-6.0.410-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7c048383-52b1-47cb-91d1-acfaf1a3fcc9/ea510c0bfa44f33cc3ddea79090a51e1/dotnet-sdk-6.0.410-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/735f204c-3a63-464b-931a-a0439c9067a0/14389038ec984246ab803ae99cf22fbf/dotnet-sdk-6.0.410-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3ad1511b-0fe6-4805-bcd9-b4bb5272774b/d5f1281e453949dd2a0b60a603665c51/dotnet-sdk-6.0.410-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/34bd7427-8eb9-467d-8140-3f7e06884fcb/c0406e2e8a530abad4fd33c57ec2eac2/dotnet-sdk-6.0.410-win-x86.zip
