# .NET 6.0.19 - June 22, 2023

The .NET 6.0.19, [.NET SDK 6.0.119](6.0.119.md), and [.NET SDK 6.0.314](6.0.314.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.411
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

.NET 6.0.19 release carries non-security fixes.

## .NET June OOB Updates

### Background
The NET 6.0.18 and 7.0.7 updates update added constraints to PFX certificate loading to fix a DoS vulnerability (CVE-2023-29331). We created a specific exception message with an FWlink to a known issue KB https://support.microsoft.com/kb/5025823 to describe these behavioral changes.

Some customer reports during the week of June 13, 2023, reveal that .NET 6.0.18 and 7.0.7 may fail to import PKCS12 blobs whose private keys are protected by a null password. Callers may non-deterministically observe a `CryptographicException` being thrown by the `X509Certificate` constructor on those runtimes. This regression was unintentional and a fix is being offered for affected applications.

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8570](https://github.com/dotnet/core/issues/8570) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.19.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.19-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.19-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/June-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.19
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.19
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.19
Microsoft.WindowsDesktop.App.Ref | 6.0.19
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.19
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.19
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.19
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.19
Microsoft.NETCore.App.Composite | 6.0.19
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.19
Microsoft.NETCore.App.Host.osx-x64 | 6.0.19
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.19
Microsoft.NETCore.App.Host.linux-x64 | 6.0.19
Microsoft.NETCore.App.Host.win-arm64 | 6.0.19
Microsoft.NETCore.App.Host.win-x64 | 6.0.19
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.19
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400 | 6.0.19
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.19
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.19
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.19
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.19
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.19
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.19
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.19
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.19
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.19
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Runtime.win-arm | 6.0.19
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.19
Microsoft.NETCore.DotNetHost | 6.0.19
Microsoft.NETCore.DotNetHostPolicy | 6.0.19
Microsoft.NETCore.DotNetHostResolver | 6.0.19
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.19
Microsoft.Windows.Compatibility | 6.0.7
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.19
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.19
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.19
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.19
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.19
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.19
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.19
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.19
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.19
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.19
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.19
Microsoft.NETCore.App.Host.win-arm | 6.0.19
Microsoft.NETCore.App.Ref | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.19
Microsoft.NETCore.DotNetAppHost | 6.0.19
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.19
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.19
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.19
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.19
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.19
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.19
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.19
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.19
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.19
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300 | 6.0.19
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64 | 6.0.19
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.19
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.19
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.19
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.19
Microsoft.NETCore.App.Host.win-x86 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.19
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.19
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.19
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.19
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.19
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.19
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.19
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.19
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.19
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.19
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.19
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.19
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.19
System.Security.Cryptography.Pkcs | 6.0.4
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.19
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.19
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.19
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64 | 6.0.19
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Host.linux-arm | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.19
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.19
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.19
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.19
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.19
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.19
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.19
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.19
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.19
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.19
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.19
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.19
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.19
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.19
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.19
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.19
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.19
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.19
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.19
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.19
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.19
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.19
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.19
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.19
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.19
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.19
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.19
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.19
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.19
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.19
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.19
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.19
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.19
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.19
Microsoft.AspNetCore.Components.WebAssembly | 6.0.19
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.19
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.19
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.19
Microsoft.CodeAnalysis.Razor | 6.0.19
Microsoft.Extensions.ApiDescription.Client | 6.0.19
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.19
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.19
Microsoft.Extensions.Caching.SqlServer | 6.0.19
Microsoft.Extensions.Identity.Stores | 6.0.19
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.19
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.19
AspNetCoreRuntime.6.0.x64 | 6.0.19
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.19
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.19
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.19
AspNetCoreRuntime.6.0.x86 | 6.0.19
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.19
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.19
Microsoft.AspNetCore.App.Ref | 6.0.19
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.19
Microsoft.AspNetCore.Authentication.Twitter | 6.0.19
Microsoft.AspNetCore.Authorization | 6.0.19
Microsoft.AspNetCore.Components | 6.0.19
Microsoft.AspNetCore.Identity.UI | 6.0.19
Microsoft.AspNetCore.HeaderPropagation | 6.0.19
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.19
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.19
Microsoft.AspNetCore.Mvc.Testing | 6.0.19
Microsoft.AspNetCore.Owin | 6.0.19
Microsoft.AspNetCore.Razor.Language | 6.0.19
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.19
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.19
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.19
Microsoft.AspNetCore.SpaProxy | 6.0.19
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.19
Microsoft.Extensions.ApiDescription.Server | 6.0.19
Microsoft.dotnet-openapi | 6.0.19
Microsoft.AspNetCore.TestHost | 6.0.19
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.19
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.19
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.19
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.19
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.19
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.19
Microsoft.Extensions.FileProviders.Embedded | 6.0.19
Microsoft.Extensions.Http.Polly | 6.0.19
Microsoft.Extensions.Identity.Core | 6.0.19
Microsoft.Extensions.Localization | 6.0.19
Microsoft.Extensions.Localization.Abstractions | 6.0.19
Microsoft.Extensions.Logging.AzureAppServices | 6.0.19
Microsoft.Extensions.ObjectPool | 6.0.19
Microsoft.Extensions.WebEncoders | 6.0.19
Microsoft.Extensions.Features | 6.0.19
Microsoft.AspNetCore.Authentication.Certificate | 6.0.19
Microsoft.AspNetCore.Authentication.Google | 6.0.19
Microsoft.AspNetCore.Authentication.Facebook | 6.0.19
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.19
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.19
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.19
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.19
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.19
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.19
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.19
Microsoft.AspNetCore.SignalR.Client | 6.0.19
Microsoft.AspNetCore.SignalR.Common | 6.0.19
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.19
Microsoft.Authentication.WebAssembly.Msal | 6.0.19
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.19
Microsoft.JSInterop | 6.0.19
Microsoft.JSInterop.WebAssembly | 6.0.19
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.19
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.19
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.19
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.19
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.19
dotnet-sql-cache | 6.0.19
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.19
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.19
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.19
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.19
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.19
Microsoft.AspNetCore.Components.Authorization | 6.0.19
Microsoft.AspNetCore.Components.Analyzers | 6.0.19
Microsoft.AspNetCore.Components.Forms | 6.0.19
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.19
Microsoft.AspNetCore.Components.Web | 6.0.19
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.19
Microsoft.AspNetCore.Components.WebView | 6.0.19
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.19
Microsoft.AspNetCore.Cryptography.Internal | 6.0.19
Microsoft.AspNetCore.Connections.Abstractions | 6.0.19
Microsoft.AspNetCore.DataProtection | 6.0.19
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.19
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.19
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.19
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.19
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.19
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.19
Microsoft.AspNetCore.Http.Connections.Client | 6.0.19
Microsoft.AspNetCore.Http.Connections.Common | 6.0.19
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.19
Microsoft.AspNetCore.JsonPatch | 6.0.19
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.19
Microsoft.AspNetCore.Metadata | 6.0.19
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.119
Microsoft.TemplateEngine.Core | 6.0.119
Microsoft.TemplateEngine.Core.Contracts | 6.0.119
Microsoft.TemplateEngine.Edge | 6.0.119
Microsoft.TemplateEngine.IDE | 6.0.119
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.119
Microsoft.TemplateEngine.Utils | 6.0.119
Microsoft.TemplateSearch.Common | 6.0.119
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.119
Microsoft.DotNet.Common.ItemTemplates | 6.0.119
Microsoft.TemplateEngine.Abstractions | 6.0.119
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.119
Microsoft.DotNet.Compatibility | 1.0.0-servicing.23318.12
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.19
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64 | 6.0.19
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.19
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.19
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.19
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.19
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.19
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.19
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.19
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300 | 6.0.19
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.19
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86 | 6.0.19
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64 | 6.0.19
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400 | 6.0.19
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64 | 6.0.19
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64 | 6.0.19
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.19
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.19
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.19
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.19
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64 | 6.0.19
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64 | 6.0.19
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86 | 6.0.19
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.19
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.19
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64 | 6.0.19
Microsoft.Data.Sqlite.Core | 6.0.19
Microsoft.Data.Sqlite | 6.0.19
Microsoft.EntityFrameworkCore.Abstractions | 6.0.19
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.19
Microsoft.EntityFrameworkCore.Analyzers | 6.0.19
Microsoft.EntityFrameworkCore.Cosmos | 6.0.19
Microsoft.EntityFrameworkCore.Design | 6.0.19
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.19
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.19
Microsoft.EntityFrameworkCore.SqlServer | 6.0.19
Microsoft.EntityFrameworkCore.Sqlite | 6.0.19
Microsoft.EntityFrameworkCore.Tools | 6.0.19
Microsoft.EntityFrameworkCore | 6.0.19
Microsoft.EntityFrameworkCore.Relational | 6.0.19
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.19
Microsoft.EntityFrameworkCore.Proxies | 6.0.19
dotnet-ef | 6.0.19
Microsoft.EntityFrameworkCore.InMemory | 6.0.19
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.19
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.19
Microsoft.TemplateEngine.Edge | 6.0.314
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.314
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.314
Microsoft.TemplateEngine.Abstractions | 6.0.314
Microsoft.TemplateEngine.Core.Contracts | 6.0.314
Microsoft.TemplateEngine.Core | 6.0.314
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.314
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.314
Microsoft.TemplateEngine.IDE | 6.0.314
Microsoft.TemplateSearch.Common | 6.0.314
Microsoft.DotNet.Common.ItemTemplates | 6.0.314
Microsoft.TemplateEngine.Utils | 6.0.314
FSharp.Compiler.Service | 41.0.5
FSharp.Core | 6.0.5
Microsoft.TemplateEngine.Utils | 6.0.411
Microsoft.DotNet.Common.ItemTemplates | 6.0.411
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.411
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.411
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.411
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.411
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.411
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.411
Microsoft.TemplateEngine.Abstractions | 6.0.411
Microsoft.TemplateEngine.Core.Contracts | 6.0.411
Microsoft.TemplateEngine.Core | 6.0.411
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.411
Microsoft.TemplateSearch.Common | 6.0.411
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.411
Microsoft.TemplateEngine.Edge | 6.0.411
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.411
Microsoft.TemplateEngine.IDE | 6.0.411
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.411
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.411
FSharp.Core | 6.0.7
FSharp.Compiler.Service | 41.0.7

[//]: # ( Runtime 6.0.19)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9dc8a595-02f9-4b64-8cae-64e0ffe796b1/72a09d9ffa2c262d3c25869d58139c50/dotnet-runtime-6.0.19-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5428b024-2cca-483c-b103-429b04611e0c/8db2a6abdd0abbb00714d700e8acccd8/dotnet-runtime-6.0.19-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4631c3dc-6d9a-4bf8-9330-daa3b4d27c61/0767424e61f009bb732c5393aff8e68c/dotnet-runtime-6.0.19-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7f428c2d-da2f-4e9e-b31d-01ecdb4d5b3d/b89c587ad37ae0e7c0c0dd7824864a30/dotnet-runtime-6.0.19-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4780d634-1f74-4b40-8e3d-b96a1a9d5d53/24e802749d95e554853f2faf108a1a2e/dotnet-runtime-6.0.19-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/59b2fb63-9075-4ee8-9120-d6d048226aa0/fe92c70fec406174fa2585c9b668900b/dotnet-runtime-6.0.19-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/8cd3fd9e-2c74-4315-b4e3-0906a03d7a5c/2c46a2a3a2329d1bfd79cbb70bbdc745/dotnet-runtime-6.0.19-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9e22fdfd-02df-4b83-ae80-933ab45da241/678caea6e30c0c4673f398cd42288f2f/dotnet-runtime-6.0.19-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a2b0f1f9-40e3-44e1-b6b9-540c6ad255ec/e4653ed21ab749761efba07725d8f75a/dotnet-runtime-6.0.19-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a9559a9f-3e72-4fde-bc55-b5fd2260ad5f/f501dba0830e7cfdbf73c7d9780abaac/dotnet-runtime-6.0.19-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/88bca6d6-e24d-4364-b4ac-7f4e4455f316/bdf7bdc5a28a186c6c60fdcf8c427bc2/dotnet-runtime-6.0.19-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/d755fd4f-76b5-4d1e-81f2-e8c9ebd17ca4/2937ddb3d0cdf26e8848ef06fae5e2fc/dotnet-runtime-6.0.19-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7bb7f85b-9bf0-4c6f-b3e4-a3832720f162/73e280cfd7f686c34748e0bf98d879c7/dotnet-runtime-6.0.19-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/58015aef-fae1-4dbc-9fb4-7c235788dad1/04539902bbd6cdffcefe562468475621/dotnet-runtime-6.0.19-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6b04af90-1760-4f04-93bc-548cc03f1d4b/1479bfb3a68bd45bdce774e18449fe6c/dotnet-runtime-6.0.19-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/3147c711-9d16-4bf0-9f67-e34df5290fba/8645ee7ba2a607e7f286c933414d651e/dotnet-runtime-6.0.19-win-x86.zip

[//]: # ( WindowsDesktop 6.0.19)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/84d9dca1-78f0-4f4f-b9ff-313beaf5873d/43b7293b597cbb02d112709810766a50/windowsdesktop-runtime-6.0.19-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/40e3c6f8-1743-4577-a561-2639b81ef98e/64a7cc22c13620c9291562330871a3ac/windowsdesktop-runtime-6.0.19-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/30841ca9-5538-40c3-9022-d1ba1e69f6e8/aa94715bc3d74ee0b2e27de757ef0cdb/windowsdesktop-runtime-6.0.19-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9de1b638-6a4c-48b6-ac5d-13571defc5fd/9361bcd30e8935f89fbe629574a932e5/windowsdesktop-runtime-6.0.19-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1a0e6cd8-4c5b-4a25-8da6-6985792c5cad/aea270b977828772087496b7b073f383/windowsdesktop-runtime-6.0.19-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e70f3c3a-6bd7-44a4-999e-1fd46483c930/8640bc06ad2d699672bc56d070c248e9/windowsdesktop-runtime-6.0.19-win-x86.zip

[//]: # ( ASP 6.0.19)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f33d9dc8-1f77-48dc-89f5-8f691038d629/90926d8575953228ee5271530e08b595/aspnetcore-runtime-6.0.19-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/86b5e7ea-d316-4b44-a543-95cbfeafadd9/7e7b8ed4c007d9290c2099b5bcd144af/aspnetcore-runtime-6.0.19-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f77f31ba-21d4-4046-82ba-e1a11a61a544/646f48aea6c74b7b5d1f01b4467df073/aspnetcore-runtime-6.0.19-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c5141d1f-21ea-44ee-a145-8d9100b8fdba/a2a249684271a9b06a34a6bf5bf17c92/aspnetcore-runtime-6.0.19-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2849b6c4-9083-4642-897b-3be1e801b2b7/618b0bad6d79c1d355b8146243b320fe/aspnetcore-runtime-6.0.19-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fb0913f6-79a8-40b6-b604-bda42b60d0c2/eb98e78d3d75c16326a54cd0277b5406/aspnetcore-runtime-6.0.19-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/af7c7c1e-4bcc-494e-b454-fcca9577426f/53d486a54766bc79208f72bb60beda29/aspnetcore-runtime-6.0.19-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ff5fcf0c-64a2-4b7c-a406-06ac6e0369ec/7edc4ca9309235eb554cfd580aa6ca37/aspnetcore-runtime-6.0.19-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/11e186bf-c8ad-460d-92d9-d8dacb5196dc/92b79b009fadcebb4c4190cacf51ca87/aspnetcore-runtime-6.0.19-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1cda6855-cc0d-44fa-9f02-250d306b4216/6ca1bcf300507edfa2036f91c1545b11/aspnetcore-runtime-6.0.19-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/89d0c41b-b6af-4ac7-8317-7cac46228b43/64d3662e38107f573c1283c976ddaaed/aspnetcore-runtime-6.0.19-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/599e1299-1f44-480e-be40-2dd660cb3fe2/83075b238d26aac63519fad9b01002c8/aspnetcore-runtime-6.0.19-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c19b7e9b-9a7d-4018-88c1-672850bbc02c/71d8d9621113e8c12dadf8d9c4f1382c/aspnetcore-runtime-6.0.19-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/6e855d0c-464a-4ade-b92f-2ba604e68897/cb3b140bdf36b5bc16efc49787028cb8/dotnet-hosting-6.0.19-win.exe

[//]: # ( SDK 6.0.411)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/32a4d76d-a2c5-47c6-9c22-e40a3ab28e2c/4f196ad02122b385e8f66e24a16cca38/dotnet-sdk-6.0.411-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/43eb599e-df6d-4303-b266-b96a9f77a8ca/a5c595017960d21f6d7b89530bff173f/dotnet-sdk-6.0.411-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a1e22c51-eb87-4b62-9ba4-cc8eedf05432/45f0fb7629b03b06b5b9199aba33056a/dotnet-sdk-6.0.411-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/97808ded-2577-4239-ad78-4b6251a1ad3f/a97e053ef9296fac819101c8daf02094/dotnet-sdk-6.0.411-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ae0697cd-a49f-4c07-9ce2-71f38449e242/7b887886ad2da43b450de6b71f0f9720/dotnet-sdk-6.0.411-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1f26cd3a-af60-4140-9cab-b661cfe0a1ed/4d533d26ef5d55fa17f23c207f6d3330/dotnet-sdk-6.0.411-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1b86cb38-768d-47af-a9c0-7bc78e1cae84/d45528a6916f85bfcde29d2794139087/dotnet-sdk-6.0.411-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5288044c-41cd-43f1-af79-9aa29f6e5a10/aaf4fa836481a4ff3a0f9bf79c4ffffc/dotnet-sdk-6.0.411-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a91e812a-f286-4b1b-b050-f9612c4f5ec9/dd24f826e0c99945066987df1f7ec790/dotnet-sdk-6.0.411-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d53a8cc3-7c70-4374-8072-5ddd6a75ff5b/0b64e3ca7c14755bd4d806ca235a2760/dotnet-sdk-6.0.411-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/14cbfa6a-f2ed-494f-bd94-32b382d8d562/058bcbe9cb559341f8598fe2b19dd2b4/dotnet-sdk-6.0.411-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/67ddd8f3-5a64-433d-8194-eb50fca0e1a6/e635545de1ec4875546aa744de78264c/dotnet-sdk-6.0.411-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/56785524-dcd2-425a-8a95-3c2ee607b22f/e32ce2d12821f85c7d5e9cdee5ff5264/dotnet-sdk-6.0.411-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/61f44f70-0f5a-4b89-ae95-b26c80567917/abac586ea20fb485702ea496fe83b9ee/dotnet-sdk-6.0.411-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/259a783a-5531-4e18-9bdd-fbd3868cda0a/b3ab7e7fa20e59f4794f2ec7f26dcf2d/dotnet-sdk-6.0.411-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/17c848fb-cea9-484f-9ec2-9dda8e304f01/3b485289d5da6d714e8094bec3cc3cb7/dotnet-sdk-6.0.411-win-x86.zip

