# .NET 6.0.20 - July 11, 2023

The .NET 6.0.20, [.NET SDK 6.0.120](6.0.120.md), and [.NET SDK 6.0.315](6.0.315.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.412
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```
The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

.NET 6.0.20 release carries security fixes.

[CVE-2023-33127 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-33127)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET applications where the diagnostic server can be exploited to achieve cross-session/cross-user elevation of privilege (EoP) and code execution.

[CVE-2023-33170 - .NET Security Feature Bypass Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-33170)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core 2.1 and above. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exist in ASP.NET  Core applications where account lockout maximum failed attempts may not be immediately updated, allowing an attacker to try more passwords.

### Additional fixes in this release

* [EFCore](https://github.com/dotnet/efcore/issues?q=milestone%3A6.0.20+is%3Aclosed+label%3Aservicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.20+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8611](https://github.com/dotnet/core/issues/8611) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.20.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.20-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.20-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/July-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
packages\Microsoft.WindowsDesktop.App.Ref | 6.0.20
packages\Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.20
packages\Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.20
packages\Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.20
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.20
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.20
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.20
Microsoft.NETCore.App.Composite | 6.0.20
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.20
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.20
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.20
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.20
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.20
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.20
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.20
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.20
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300 | 6.0.20
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64 | 6.0.20
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86 | 6.0.20
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.20
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.20
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.20
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.20
Microsoft.NETCore.App.Host.osx-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.20
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.20
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.20
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.20
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.20
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.20
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.20
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.20
Microsoft.NETCore.App.Host.linux-arm | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.20
Microsoft.NETCore.DotNetHost | 6.0.20
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.20
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.20
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.20
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.20
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.20
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.20
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.20
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.20
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.20
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.20
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.20
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.20
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.20
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.20
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.20
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.20
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.20
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.20
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.20
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86 | 6.0.20
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.20
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.20
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.20
Microsoft.NETCore.App.Host.win-arm | 6.0.20
Microsoft.NETCore.App.Host.win-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.20
Microsoft.NETCore.DotNetHostPolicy | 6.0.20
Microsoft.NETCore.DotNetAppHost | 6.0.20
Microsoft.NETCore.DotNetHostResolver | 6.0.20
Microsoft.NETCore.Platforms | 6.0.11
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.20
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.20
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.20
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.20
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.20
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.20
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.20
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.20
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.20
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.20
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.20
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.20
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.20
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400 | 6.0.20
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.win-arm | 6.0.20
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.20
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.20
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.20
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.20
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.20
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.20
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.20
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.20
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.20
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.20
Microsoft.NETCore.App.Host.win-x86 | 6.0.20
Microsoft.NETCore.App.Host.win-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.20
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.20
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.20
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.20
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64 | 6.0.20
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.20
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.20
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.20
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.20
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.20
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.20
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.20
Microsoft.NETCore.App.Host.linux-x64 | 6.0.20
Microsoft.NETCore.App.Ref | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.20
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.20
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.20
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.20
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.20
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.20
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.20
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.20
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.20
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.20
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.20
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.20
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.20
Microsoft.Extensions.Features | 6.0.20
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.20
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.20
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.20
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.20
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.20
Microsoft.AspNetCore.Components.WebAssembly | 6.0.20
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.20
Microsoft.AspNetCore.Http.Connections.Client | 6.0.20
Microsoft.AspNetCore.JsonPatch | 6.0.20
Microsoft.AspNetCore.Http.Connections.Common | 6.0.20
Microsoft.AspNetCore.Identity.UI | 6.0.20
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.20
Microsoft.AspNetCore.Razor.Language | 6.0.20
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.20
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.20
Microsoft.AspNetCore.SignalR.Client | 6.0.20
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.20
Microsoft.AspNetCore.SignalR.Common | 6.0.20
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.20
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.20
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.20
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.20
Microsoft.dotnet-openapi | 6.0.20
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.20
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.20
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.20
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.20
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.20
Microsoft.AspNetCore.Authentication.Twitter | 6.0.20
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.20
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.20
Microsoft.AspNetCore.Authorization | 6.0.20
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.20
Microsoft.AspNetCore.Components.Web | 6.0.20
Microsoft.AspNetCore.Components.WebView | 6.0.20
Microsoft.AspNetCore.DataProtection | 6.0.20
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.20
Microsoft.AspNetCore.Mvc.Testing | 6.0.20
Microsoft.AspNetCore.TestHost | 6.0.20
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.20
Microsoft.AspNetCore.SpaProxy | 6.0.20
Microsoft.Authentication.WebAssembly.Msal | 6.0.20
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.20
Microsoft.CodeAnalysis.Razor | 6.0.20
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.20
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.20
AspNetCoreRuntime.6.0.x64 | 6.0.20
AspNetCoreRuntime.6.0.x86 | 6.0.20
dotnet-sql-cache | 6.0.20
Microsoft.AspNetCore.App.Ref | 6.0.20
Microsoft.AspNetCore.Components | 6.0.20
Microsoft.AspNetCore.Components.Analyzers | 6.0.20
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.20
Microsoft.AspNetCore.Metadata | 6.0.20
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.20
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.20
Microsoft.Extensions.Caching.SqlServer | 6.0.20
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.20
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.20
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.20
Microsoft.Extensions.Identity.Stores | 6.0.20
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.20
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.20
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.20
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.20
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.20
Microsoft.AspNetCore.Owin | 6.0.20
Microsoft.Extensions.ApiDescription.Client | 6.0.20
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.20
Microsoft.Extensions.ApiDescription.Server | 6.0.20
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.20
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.20
Microsoft.Extensions.FileProviders.Embedded | 6.0.20
Microsoft.Extensions.Http.Polly | 6.0.20
Microsoft.Extensions.Identity.Core | 6.0.20
Microsoft.Extensions.Localization | 6.0.20
Microsoft.Extensions.Logging.AzureAppServices | 6.0.20
Microsoft.Extensions.WebEncoders | 6.0.20
Microsoft.Extensions.Localization.Abstractions | 6.0.20
Microsoft.Extensions.ObjectPool | 6.0.20
Microsoft.JSInterop.WebAssembly | 6.0.20
Microsoft.JSInterop | 6.0.20
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.20
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.20
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.20
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.20
Microsoft.AspNetCore.Authentication.Facebook | 6.0.20
Microsoft.AspNetCore.Authentication.Google | 6.0.20
Microsoft.AspNetCore.Authentication.Certificate | 6.0.20
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.20
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.20
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.20
Microsoft.AspNetCore.Components.Forms | 6.0.20
Microsoft.AspNetCore.Components.Authorization | 6.0.20
Microsoft.AspNetCore.Connections.Abstractions | 6.0.20
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.20
Microsoft.AspNetCore.Cryptography.Internal | 6.0.20
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.20
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.20
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.20
Microsoft.AspNetCore.HeaderPropagation | 6.0.20
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.20
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.20
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.20
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.20
Microsoft.DotNet.Common.ItemTemplates | 6.0.120
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.120
Microsoft.TemplateEngine.Abstractions | 6.0.120
Microsoft.TemplateEngine.Core.Contracts | 6.0.120
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.120
Microsoft.TemplateSearch.Common | 6.0.120
Microsoft.TemplateEngine.Utils | 6.0.120
Microsoft.TemplateEngine.Core | 6.0.120
Microsoft.TemplateEngine.Edge | 6.0.120
Microsoft.TemplateEngine.IDE | 6.0.120
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.120
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.120
Microsoft.DotNet.Compatibility | 1.0.0-servicing.23322.14
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.20
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.20
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.20
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300 | 6.0.20
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.20
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.20
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64 | 6.0.20
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64 | 6.0.20
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64 | 6.0.20
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400 | 6.0.20
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64 | 6.0.20
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64 | 6.0.20
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.20
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.20
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.20
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.20
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64 | 6.0.20
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.20
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.20
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.20
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.20
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64 | 6.0.20
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.20
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.20
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86 | 6.0.20
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86 | 6.0.20
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.20
Microsoft.Data.Sqlite.Core | 6.0.20
Microsoft.EntityFrameworkCore.InMemory | 6.0.20
Microsoft.EntityFrameworkCore.Proxies | 6.0.20
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.20
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.20
Microsoft.EntityFrameworkCore.SqlServer | 6.0.20
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.20
dotnet-ef | 6.0.20
Microsoft.Data.Sqlite | 6.0.20
Microsoft.EntityFrameworkCore | 6.0.20
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.20
Microsoft.EntityFrameworkCore.Abstractions | 6.0.20
Microsoft.EntityFrameworkCore.Analyzers | 6.0.20
Microsoft.EntityFrameworkCore.Cosmos | 6.0.20
Microsoft.EntityFrameworkCore.Relational | 6.0.20
Microsoft.EntityFrameworkCore.Design | 6.0.20
Microsoft.EntityFrameworkCore.Sqlite | 6.0.20
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.20
Microsoft.EntityFrameworkCore.Tools | 6.0.20
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.315
Microsoft.TemplateSearch.Common | 6.0.315
Microsoft.TemplateEngine.Edge | 6.0.315
Microsoft.TemplateEngine.Core.Contracts | 6.0.315
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.315
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.315
Microsoft.DotNet.Common.ItemTemplates | 6.0.315
Microsoft.TemplateEngine.Abstractions | 6.0.315
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.315
Microsoft.TemplateEngine.Core | 6.0.315
Microsoft.TemplateEngine.IDE | 6.0.315
Microsoft.TemplateEngine.Utils | 6.0.315
FSharp.Compiler.Service | 41.0.5
FSharp.Core | 6.0.5
Microsoft.DotNet.Common.ItemTemplates | 6.0.412
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.412
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.412
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.412
Microsoft.TemplateEngine.Abstractions | 6.0.412
Microsoft.TemplateEngine.Edge | 6.0.412
Microsoft.TemplateEngine.Core.Contracts | 6.0.412
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.412
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.412
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.412
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.412
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.412
Microsoft.TemplateEngine.IDE | 6.0.412
Microsoft.TemplateEngine.Core | 6.0.412
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.412
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.412
Microsoft.TemplateEngine.Utils | 6.0.412
Microsoft.TemplateSearch.Common | 6.0.412
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.412
FSharp.Core | 6.0.7
FSharp.Compiler.Service | 41.0.7

[//]: # ( Runtime 6.0.20)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0969e51f-a427-491f-a194-327592601377/d7975ce1a8c8d3c3e1d50c99227b9fd1/dotnet-runtime-6.0.20-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f45ea605-cd0d-446b-9d79-b9c033c10c11/ba7fd32581bb5f448abdd317d8d55b3f/dotnet-runtime-6.0.20-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/27f8d6e0-f914-4b4b-844b-f04b5710e83d/87015a89639c9d65896dacd8cd54c6c5/dotnet-runtime-6.0.20-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6f39ee6d-cd45-454c-9642-7e562c088b22/2e7a920d2d93c0a618acdc61e2019fe9/dotnet-runtime-6.0.20-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1298fce2-9eb9-43a1-a8b8-16716f54d062/cb830a1fdc245f4d1a8a4016f437f843/dotnet-runtime-6.0.20-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/26b4797f-d3f2-40c7-8f4a-91120ab87469/4677c3c4e3ee7919836c3a5336e04509/dotnet-runtime-6.0.20-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/bc001e67-c521-4d22-bf6a-a05c866c3bde/b8b87876c5266e61d92262a7818b18cb/dotnet-runtime-6.0.20-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0f3ecdea-c85c-423b-ab55-d97061a3d9f0/b01dd205c4d6ffdb6266e4540c82621d/dotnet-runtime-6.0.20-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/b0d747b0-f61b-4c1b-809e-b96c8fbd21d9/8ee735c0d9d48aaf4a79051160a5b63b/dotnet-runtime-6.0.20-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/810c2cf6-c3a3-4f35-91f4-facf1ac24ef1/3ecedc1a0888b571d272c0dd64080c52/dotnet-runtime-6.0.20-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/cf704719-c2f5-480d-bcad-48596cce50db/00be44eab331d583b4492dd2ea788a80/dotnet-runtime-6.0.20-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/a7d20a71-ecc1-4339-9ff9-2a538a38cd90/1323492919ce7c2d3cf3d68136225b0e/dotnet-runtime-6.0.20-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3cfb6d2a-afbe-4ae7-8e5b-776f350654cc/6e8d858a60fe15381f3c84d8ca66c4a7/dotnet-runtime-6.0.20-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1fdea1ea-6999-4280-b94f-38b29f68e2cf/5ce361abf248f0ad7ddc5b894e8beaca/dotnet-runtime-6.0.20-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3be5ee3a-c171-4cd2-ab98-00ca5c11eb8c/6fd31294b0c6c670ab5c060592935203/dotnet-runtime-6.0.20-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/47d8f9b0-610f-42fe-81a8-08b8fa6fca52/b25b09249ac09dcbb46b6ee0b06628f4/dotnet-runtime-6.0.20-win-x86.zip

[//]: # ( WindowsDesktop 6.0.20)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/bb9cff90-608d-4799-909e-94f49191b402/25b6295aeecb86fd35fffb95c1e0066e/windowsdesktop-runtime-6.0.20-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/a53f8949-6b49-4067-bc86-6b4753a3b9f3/e2294b71b5eb961da1ec9adb67c415ab/windowsdesktop-runtime-6.0.20-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1146f414-17c7-4184-8b10-1addfa5315e4/39db5573efb029130add485566320d74/windowsdesktop-runtime-6.0.20-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9dd54fc4-359d-4929-9d84-4001b870485b/9e8b44f975c8739a3c8598bda6a47de3/windowsdesktop-runtime-6.0.20-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0413b619-3eb2-4178-a78e-8d1aafab1a01/5247f08ea3c13849b68074a2142fbf31/windowsdesktop-runtime-6.0.20-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/56095624-2cc2-4375-960e-5106d57786ae/4697b3f287fd4297544134b3edf22288/windowsdesktop-runtime-6.0.20-win-x86.zip

[//]: # ( ASP 6.0.20)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/872ccb13-fbc4-4d75-9d8f-be3fec5581ef/add2199206c438835b7b48a6d061b023/aspnetcore-runtime-6.0.20-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a8a1a993-ddd9-4bcd-8386-d9defcf0fd29/4b471f72c8253fa1462ea923d0fe39a2/aspnetcore-runtime-6.0.20-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aff3fb91-f43b-42a0-b840-95cbeb09f447/f1a576406bab6d90f27d30b3d1d51304/aspnetcore-runtime-6.0.20-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a9bf2919-71fc-41cf-9492-375ad018a04f/de882ba860a274e9d672f917eeb8f30d/aspnetcore-runtime-6.0.20-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/642377be-d296-46b8-a68e-74c37575574b/f7eb534ca07abd78d8b3d5c4763c3f6d/aspnetcore-runtime-6.0.20-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/972dc929-4c16-4456-a7c8-64014f80678d/a3b62252f98a0d7e0c0a9a01ede18776/aspnetcore-runtime-6.0.20-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/14d8afd0-2635-4f3c-96fa-63edccafe16f/317d19d4f625bdae211d428ab880a331/aspnetcore-runtime-6.0.20-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5fe2084e-1538-4193-9eb6-54b0f8470574/258915bac675b1dea6aa0b5435f64981/aspnetcore-runtime-6.0.20-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/329d4eeb-aeae-4165-b491-afa59fd0e017/6faf6564e1a78f5339ef9600a75099c9/aspnetcore-runtime-6.0.20-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/be9f67fd-60af-45b1-9bca-a7bcc0e86e7e/6a750f7d7432937b3999bb4c5325062a/aspnetcore-runtime-6.0.20-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7a434041-8de3-47c8-a079-c2213f95841d/eb5e4e77fd86e17c8c08ed23315b8c70/aspnetcore-runtime-6.0.20-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0e37c76c-53b4-4eea-8f5c-6ad2f8d5fe3c/88a8620329ced1aee271992a5b56d236/aspnetcore-runtime-6.0.20-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8bff0136-121a-4bf8-8058-762992c71cc5/60b6e01a744035eeb057a72a467e0614/aspnetcore-runtime-6.0.20-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/d7124775-38c9-460f-a269-7bc131b3dfbf/7f60bcc6030e408cf11a935d5451ffa4/dotnet-hosting-6.0.20-win.exe

[//]: # ( SDK 6.0.412)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/041e8f1c-fae7-4422-9c6c-8f73f74fbbcf/26de71e5d316ce9939a0194ff36a10ba/dotnet-sdk-6.0.412-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/daff8399-d60f-4bde-97bb-c6e350c03e90/5eeb0b21bf1ad11b5f5a7b4ac217c381/dotnet-sdk-6.0.412-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/159728f5-f77d-4027-86a5-f0bd8a2b5ed4/5ec1a238ec73e29c2ebd75658e88d042/dotnet-sdk-6.0.412-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf99b046-6491-456f-b417-0b1b6f0df0e0/460769396dfeb81b03b0e2d046310944/dotnet-sdk-6.0.412-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/404fc2f9-6d4d-4fcf-b5ac-aba01776308e/7e9e87f3708e2fb713c00a5ab1d77dd4/dotnet-sdk-6.0.412-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/62181759-93ce-4512-8de1-92de74a6ba3f/f83ea41c3161f301d3584598f9c31801/dotnet-sdk-6.0.412-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/298ca4ac-bcb3-4be3-9cb2-b3e57021ff66/b3fa8311e2c3ef1401885c15a492a8c0/dotnet-sdk-6.0.412-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6a6555e3-06ff-4124-aad5-497a2940398b/47bda2f1324f867ae0da2099c5702769/dotnet-sdk-6.0.412-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/29422c7c-896f-489e-ae47-d8a343b105c2/123a90e25f0260d92ec192877c5bc7cf/dotnet-sdk-6.0.412-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/094020b2-7fcd-45aa-a122-42ad85b25d15/969de8f0d024a5bee5260271e097519b/dotnet-sdk-6.0.412-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/fb61446b-04be-446b-adac-e1ce3a53766a/14044dbc5cf509a05977c6c9d75e84e1/dotnet-sdk-6.0.412-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/9bbf1d58-ff39-456b-8a27-9b43287d1a55/c6a0aa81a9438addb61d6ecc050de09b/dotnet-sdk-6.0.412-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6a7d9254-d184-41a1-91fc-00ed876297a9/9db88f1a5fe2375b8c389d7087db132e/dotnet-sdk-6.0.412-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/28be1206-08c5-44bb-ab3d-6775bc03b392/2146d7b8060998ea83d381ee80471557/dotnet-sdk-6.0.412-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c6059f30-8b89-4d02-b35d-d958d5d16bfc/67df66037514582077e7eaade76a841e/dotnet-sdk-6.0.412-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a0a7adc0-f71c-4fa6-8df0-144b544a53d4/7cf9770698f23238bc8b9e40688d490e/dotnet-sdk-6.0.412-win-x86.zip
