# .NET 6.0.21 - August 08, 2023

The .NET 6.0.21, [.NET SDK 6.0.121](6.0.121.md), and [.NET SDK 6.0.316](6.0.316.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.413
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```
The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

.NET 6.0.21 release carries security fixes.

[CVE-2023-35390 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-35390)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists when some dotnet commands are used in directories with weaker permissions which can result in remote code execution.

[CVE-2023-38180 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-38180)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core 2.1, .NET 6.0, and .NET 7.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Kestrel where, on detecting a potentially malicious client, Kestrel will sometimes fail to disconnect it, resulting in denial of service.

[CVE-2023-35391 - .NET Information Disclosure Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-35391)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET core 2.1, .NET 6.0 and, .NET 7.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in ASP.NET Core 2.1, .NET 6.0 and, .NET 7.0 applications using SignalR when redis backplane use might result in information disclosure.

### Additional fixes in this release

* [EFCore](https://github.com/dotnet/efcore/issues?q=milestone%3A6.0.21+is%3Aclosed+label%3Aservicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.21+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8673](https://github.com/dotnet/core/issues/8673) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.21.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.21-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.21-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/July-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Ref | 6.0.21
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.21
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.21
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.21
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.21
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.21
Microsoft.NETCore.App.Composite | 6.0.21
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.21
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.21
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.21
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.21
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.21
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300 | 6.0.21
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.21
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.21
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.21
Microsoft.NETCore.App.Host.linux-arm | 6.0.21
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.21
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.21
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.21
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.21
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.21
Microsoft.NETCore.App.Host.linux-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.21
Microsoft.NETCore.App.Host.win-x86 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.21
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.21
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.21
Microsoft.NETCore.App.Runtime.win-arm | 6.0.21
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.21
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.21
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.21
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.21
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.21
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.21
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.21
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64 | 6.0.21
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64 | 6.0.21
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86 | 6.0.21
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400 | 6.0.21
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86 | 6.0.21
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.21
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.21
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.21
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.21
Microsoft.NETCore.App.Host.osx-x64 | 6.0.21
Microsoft.NETCore.App.Host.win-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.21
Microsoft.NETCore.DotNetHost | 6.0.21
Microsoft.NETCore.DotNetHostPolicy | 6.0.21
Microsoft.NETCore.DotNetAppHost | 6.0.21
Microsoft.NETCore.DotNetHostResolver | 6.0.21
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.21
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.21
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.21
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.21
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.21
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.21
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.21
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.21
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.21
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.21
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.21
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.21
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.21
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.21
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.21
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.21
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.21
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.21
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.21
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.21
Microsoft.NETCore.App.Ref | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.21
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.21
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.21
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.21
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.21
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.21
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.21
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.21
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.21
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.21
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.21
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.21
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.21
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.21
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.21
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.21
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.21
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.21
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.21
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.21
Microsoft.NETCore.App.Host.win-arm | 6.0.21
Microsoft.NETCore.App.Host.win-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.21
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.21
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.21
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.21
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.21
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.21
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.21
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.21
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.21
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.21
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.21
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.21
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.21
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.21
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.21
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.21
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.21
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.21
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.21
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.21
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.21
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.21
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.21
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.21
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.21
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.21
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.21
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.21
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.21
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.21
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.21
AspNetCoreRuntime.6.0.x86 | 6.0.21
Microsoft.AspNetCore.App.Ref | 6.0.21
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.21
Microsoft.AspNetCore.Authentication.Google | 6.0.21
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.21
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.21
Microsoft.AspNetCore.Authorization | 6.0.21
Microsoft.AspNetCore.Components.Authorization | 6.0.21
Microsoft.AspNetCore.Identity.UI | 6.0.21
Microsoft.AspNetCore.HeaderPropagation | 6.0.21
Microsoft.AspNetCore.Http.Connections.Client | 6.0.21
Microsoft.AspNetCore.Razor.Language | 6.0.21
Microsoft.AspNetCore.SignalR.Client | 6.0.21
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.21
Microsoft.AspNetCore.SignalR.Common | 6.0.21
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.21
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.21
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.21
Microsoft.Extensions.ApiDescription.Server | 6.0.21
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.21
Microsoft.Extensions.Caching.SqlServer | 6.0.21
Microsoft.AspNetCore.Authentication.Facebook | 6.0.21
Microsoft.AspNetCore.Authentication.Certificate | 6.0.21
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.21
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.21
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.21
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.21
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.21
Microsoft.AspNetCore.Authentication.Twitter | 6.0.21
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.21
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.21
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.21
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.21
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.21
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.21
Microsoft.AspNetCore.Components | 6.0.21
Microsoft.AspNetCore.Components.Analyzers | 6.0.21
Microsoft.AspNetCore.Components.Forms | 6.0.21
Microsoft.AspNetCore.Components.Web | 6.0.21
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.21
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.21
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.21
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.21
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.21
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.21
Microsoft.AspNetCore.Http.Connections.Common | 6.0.21
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.21
Microsoft.AspNetCore.JsonPatch | 6.0.21
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.21
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.21
Microsoft.AspNetCore.Metadata | 6.0.21
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.21
Microsoft.AspNetCore.Mvc.Testing | 6.0.21
Microsoft.AspNetCore.TestHost | 6.0.21
Microsoft.dotnet-openapi | 6.0.21
Microsoft.Extensions.Identity.Stores | 6.0.21
Microsoft.Extensions.Logging.AzureAppServices | 6.0.21
Microsoft.Extensions.Localization | 6.0.21
Microsoft.Extensions.Localization.Abstractions | 6.0.21
Microsoft.Extensions.ObjectPool | 6.0.21
Microsoft.JSInterop | 6.0.21
Microsoft.JSInterop.WebAssembly | 6.0.21
Microsoft.AspNetCore.Connections.Abstractions | 6.0.21
Microsoft.AspNetCore.DataProtection | 6.0.21
Microsoft.AspNetCore.Cryptography.Internal | 6.0.21
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.21
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.21
Microsoft.CodeAnalysis.Razor | 6.0.21
Microsoft.Extensions.ApiDescription.Client | 6.0.21
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.21
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.21
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.21
Microsoft.Extensions.FileProviders.Embedded | 6.0.21
Microsoft.Extensions.Identity.Core | 6.0.21
Microsoft.Extensions.WebEncoders | 6.0.21
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.21
Microsoft.AspNetCore.Components.WebView | 6.0.21
Microsoft.AspNetCore.Components.WebAssembly | 6.0.21
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.21
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.21
Microsoft.AspNetCore.Owin | 6.0.21
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.21
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.21
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.21
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.21
Microsoft.AspNetCore.SpaProxy | 6.0.21
Microsoft.Authentication.WebAssembly.Msal | 6.0.21
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.21
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.21
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.21
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.21
Microsoft.Extensions.Http.Polly | 6.0.21
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.21
Microsoft.Extensions.Features | 6.0.21
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.21
dotnet-sql-cache | 6.0.21
AspNetCoreRuntime.6.0.x64 | 6.0.21
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.21
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.21
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.21
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.121
Microsoft.TemplateEngine.Core.Contracts | 6.0.121
Microsoft.TemplateEngine.Edge | 6.0.121
Microsoft.TemplateEngine.IDE | 6.0.121
Microsoft.DotNet.Common.ItemTemplates | 6.0.121
Microsoft.TemplateEngine.Abstractions | 6.0.121
Microsoft.TemplateEngine.Core | 6.0.121
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.121
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.121
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.121
Microsoft.TemplateEngine.Utils | 6.0.121
Microsoft.TemplateSearch.Common | 6.0.121
Microsoft.DotNet.Compatibility | 1.0.0-servicing.23367.13
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.21
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.21
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.21
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64 | 6.0.21
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.21
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300 | 6.0.21
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.21
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64 | 6.0.21
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.21
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64 | 6.0.21
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.21
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.21
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.21
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.21
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64 | 6.0.21
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.21
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86 | 6.0.21
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64 | 6.0.21
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64 | 6.0.21
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.21
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.21
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.21
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.21
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64 | 6.0.21
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400 | 6.0.21
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86 | 6.0.21
Microsoft.Data.Sqlite | 6.0.21
Microsoft.Data.Sqlite.Core | 6.0.21
Microsoft.EntityFrameworkCore.Abstractions | 6.0.21
Microsoft.EntityFrameworkCore.Analyzers | 6.0.21
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.21
Microsoft.EntityFrameworkCore.Cosmos | 6.0.21
Microsoft.EntityFrameworkCore.InMemory | 6.0.21
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.21
Microsoft.EntityFrameworkCore.Sqlite | 6.0.21
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.21
Microsoft.EntityFrameworkCore.SqlServer | 6.0.21
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.21
Microsoft.EntityFrameworkCore.Tools | 6.0.21
dotnet-ef | 6.0.21
Microsoft.EntityFrameworkCore | 6.0.21
Microsoft.EntityFrameworkCore.Design | 6.0.21
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.21
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.21
Microsoft.EntityFrameworkCore.Proxies | 6.0.21
Microsoft.EntityFrameworkCore.Relational | 6.0.21
Microsoft.TemplateEngine.Utils | 6.0.316
Microsoft.TemplateSearch.Common | 6.0.316
Microsoft.DotNet.Common.ItemTemplates | 6.0.316
Microsoft.TemplateEngine.Abstractions | 6.0.316
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.316
Microsoft.TemplateEngine.Core | 6.0.316
Microsoft.TemplateEngine.Edge | 6.0.316
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.316
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.316
Microsoft.TemplateEngine.Core.Contracts | 6.0.316
Microsoft.TemplateEngine.IDE | 6.0.316
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.316
FSharp.Core | 6.0.5
FSharp.Compiler.Service | 41.0.5
Microsoft.DotNet.Common.ItemTemplates | 6.0.413
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.413
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.413
Microsoft.TemplateEngine.Abstractions | 6.0.413
Microsoft.TemplateSearch.Common | 6.0.413
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.413
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.413
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.413
Microsoft.TemplateEngine.Core | 6.0.413
Microsoft.TemplateEngine.Edge | 6.0.413
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.413
Microsoft.TemplateEngine.Utils | 6.0.413
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.413
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.413
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.413
Microsoft.TemplateEngine.Core.Contracts | 6.0.413
Microsoft.TemplateEngine.IDE | 6.0.413
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.413
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.413
FSharp.Compiler.Service | 41.0.7
FSharp.Core | 6.0.7


[//]: # ( Runtime 6.0.21)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/624d59fc-74c1-4be6-a68d-458511083f62/be357754b5989a735b809b477848ddb4/dotnet-runtime-6.0.21-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/934fe9da-efb0-47e4-8db2-4d2153c7fe0c/e382d2a3169ac6a8288f09c9077868c3/dotnet-runtime-6.0.21-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a6facbdc-75a6-441a-8e1b-6a660dc73a2e/cb184b42c018ab76191e88194d2a0442/dotnet-runtime-6.0.21-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/92eb2535-0e96-4be1-9d90-65fa91584d3f/50d64fb4b990be50735e51c1830936f0/dotnet-runtime-6.0.21-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/71215001-2059-4b1c-9135-0646f73d6d45/b703f08a074d62f5a1d0e9e97ae3d8fe/dotnet-runtime-6.0.21-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/25fc0412-b2ff-4868-9920-c087b8a75c55/a95292a725fc37c909c4432c74ecdb43/dotnet-runtime-6.0.21-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/8a1c31d9-1b2d-4309-b83f-5e57307a3fc4/d85f0282898f1e78fa0399940c8987dd/dotnet-runtime-6.0.21-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4c3bd8fc-abdb-458d-a675-aac97584babb/35b8a258af87daac35bab7db1af0ff9b/dotnet-runtime-6.0.21-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7d078084-d24a-47c8-ba99-11b8d6f9ee3f/eaac4ff3f4a2feca41e1649a47de195c/dotnet-runtime-6.0.21-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/af927c74-8c04-4aac-9597-3b56902a812a/47139a25bbc5e58b24fff42f6af0da7c/dotnet-runtime-6.0.21-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/f7d2a496-d05f-4eb0-a80d-83753ec790b0/0ef4e2f02ec68346af7ae1c686ea3fc5/dotnet-runtime-6.0.21-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/1fb38c6a-6735-4337-ad02-b232c7058032/b970fd0b3b1fb2822c5c46fa85f4b2ee/dotnet-runtime-6.0.21-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/31949bf4-c9ef-4e57-9da2-d798ab8b8bbf/fb7a481d9381bb740223629422a006e0/dotnet-runtime-6.0.21-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d8c23e2d-3942-4fb0-8497-04b9f3d9dd8d/46f2d0088b249ca0f5e3b21e710cab97/dotnet-runtime-6.0.21-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/10f934c5-07f3-4360-aef8-6bbca6f089f9/9d6f5247f2ef12ef3caccd600e23fe05/dotnet-runtime-6.0.21-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4fbf0e99-19cd-4abe-ba81-a1dab0684777/2127b2301ab374f22b116886437f8ee0/dotnet-runtime-6.0.21-win-x86.zip

[//]: # ( WindowsDesktop 6.0.21)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/d8396415-37e0-4445-b9aa-42e4b26b704e/a48269d7b01d818695e0413b34b724b1/windowsdesktop-runtime-6.0.21-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/bb7cf67e-2e97-4d5e-9453-0c1549c6f990/c4e1de15114915d52ca9e0dbb747ee7b/windowsdesktop-runtime-6.0.21-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/06239090-ba0c-46e2-ad3e-6491b877f481/c5e4ab5e344eb3bdc3630e7b5bc29cd7/windowsdesktop-runtime-6.0.21-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a5c8a7f9-142c-485f-b804-340eecd863df/2665fa050607d1fcebe00b3ffe8cc933/windowsdesktop-runtime-6.0.21-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/edd094be-cc44-4af5-b6ce-d9e0c9bf47eb/f2e1c95e07a9cc1436e9f47a61dabc4e/windowsdesktop-runtime-6.0.21-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6166d784-c419-4853-96f8-4715c51a43b8/b7b99968b55979f5e1e94956d2df839b/windowsdesktop-runtime-6.0.21-win-x86.zip

[//]: # ( ASP 6.0.21)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d184fca4-527b-46aa-ad71-9fdf7c010262/dc0eb0bd54951de8c1eacaab795ecf24/aspnetcore-runtime-6.0.21-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1f8d7d02-581b-42f8-b74a-bf523099ab5c/29da812824f1a8cdfbe452aa5bc0ebc3/aspnetcore-runtime-6.0.21-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eda7f451-8507-46c3-9f79-40bfac434b4e/b230ebc0b91483c6e5b7550d31fce51d/aspnetcore-runtime-6.0.21-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/88f80738-e37f-466c-8d8d-11115ef23d3f/2037b2b6416b8d81dd4f3ab9b7a8de90/aspnetcore-runtime-6.0.21-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/517e08c1-09f1-4bf9-af05-8723bfa3d41f/2a533a6ec6d24dd1a8abb6fc0d3b102a/aspnetcore-runtime-6.0.21-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/56d44b17-03c2-4d9e-bdbc-a598ca34fc01/8fcc1e19dfd3c86b09beb68460db6e85/aspnetcore-runtime-6.0.21-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a6bf9946-7321-452d-8dfb-120ea0911a6a/9d77b20bb6802d0e8a4cdeda58fddaee/aspnetcore-runtime-6.0.21-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4eece21f-af5c-4bdd-8e5b-5e300f0cbc6d/5290c217803341cb2a51628e8ea0dd9e/aspnetcore-runtime-6.0.21-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/76002558-acc4-490b-ac03-3cb9010eea7d/9295a3fb144fab2f3a499772917abfa0/aspnetcore-runtime-6.0.21-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e9d6a662-9f62-48b2-b7c2-5c94ee34afb1/b4b09a0dc605d4d51495abab6cfcf717/aspnetcore-runtime-6.0.21-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/94fd2c9b-5ee9-4086-8baf-cbc3b01fb641/22db23334d892f84b01f0725c510fbee/aspnetcore-runtime-6.0.21-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/fadbbcba-f49c-4c1b-b801-6c93566e1ca7/26594e6303cae1364f23928e2d63889a/aspnetcore-runtime-6.0.21-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/dfae4456-6985-45ab-8eb7-15169ef86e36/11f0abdcafad9995513056d8f7c776ca/aspnetcore-runtime-6.0.21-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/b50f2f63-23ed-4c96-9b38-71d319107d1b/26f8c79415eccaef1f2e0614e10cd701/dotnet-hosting-6.0.21-win.exe

[//]: # ( SDK 6.0.413)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/11682594-fb2f-4a01-861c-cc76935003f6/9138dabf011a0c07bc306443dedee687/dotnet-sdk-6.0.413-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/82132239-803b-4800-971e-ded613cc280a/67d0025a0a54566657c3e6dfeb90253e/dotnet-sdk-6.0.413-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dd5add99-8d35-48f0-9e67-3f5c7b61da8f/9196b17aea5018ab286fe8e1dc777c08/dotnet-sdk-6.0.413-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6bb03864-cb2f-41f5-b0a2-621f9fb29be2/1e4f599c69a231ceff5abe30e887778a/dotnet-sdk-6.0.413-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/66b8d73b-a371-4208-97f7-80b2dc55dfac/9cc37d50e7f83a0782b80ce8fbb8d935/dotnet-sdk-6.0.413-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8eed69b0-0f3a-4d43-a47d-37dd67ece54d/0f2a9e86ff24fbd7bbc129b2c18851fe/dotnet-sdk-6.0.413-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/d95d315f-8088-440b-88db-1e84398f6167/0a450912f02c207430bcc4bc9aaeefc1/dotnet-sdk-6.0.413-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6152c11b-e65d-4b60-8fc0-3c506a6199d2/c9f1ce3f1fc5bc6fa758fac505845232/dotnet-sdk-6.0.413-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f8ef7ef6-04f0-4d7f-a39d-127d7cf099a9/021922f4a6860bcd8257df91a53cb5d0/dotnet-sdk-6.0.413-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/398d17e1-bdee-419a-b50e-e0a1841c8a3c/2e8177e8c2c46af1f34094369f2219be/dotnet-sdk-6.0.413-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/65921ee8-7be8-42f7-8902-900c98acd5e0/818423a2eb96f680225390e706e9994e/dotnet-sdk-6.0.413-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/e8fea835-8884-434c-9a77-9d8b71c94f7e/f8a325aafd1e71024930a6d7a41440f2/dotnet-sdk-6.0.413-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/8d1443fd-a5e1-438d-8cb8-6ccb9849a54a/4f89f2b74a9c272789dfac8658a87673/dotnet-sdk-6.0.413-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3d28b406-bdbd-423e-a173-015215ae83d5/abf5701bb34a153e073409858758eea1/dotnet-sdk-6.0.413-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/fbf3c93d-757e-46fe-ad9c-90105d48a3e8/0fd732e33dd3f18e2c5c269bfd94e505/dotnet-sdk-6.0.413-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1db37c35-fbb6-4dce-9029-338598cad8ec/20f18f4efb360653746d396cc0d3e1ea/dotnet-sdk-6.0.413-win-x86.zip
