# .NET 6.0.22 - September 12, 2023

The .NET 6.0.22, [.NET SDK 6.0.122](6.0.122.md), and [.NET SDK 6.0.317](6.0.317.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.414
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```
The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

.NET 6.0.22 release carries security fixes.

**Note:** The vulnerabilities [CVE-2023-36792]( https://www.cve.org/CVERecord?id=CVE-2023-36792), [CVE-2023-36793]( https://www.cve.org/CVERecord?id=CVE-2023-36793), [CVE-2023-36792]( https://www.cve.org/CVERecord?id=CVE-2023-36794), [CVE-2023-36796]( https://www.cve.org/CVERecord?id=CVE-2023-36796) are all resolved by a single patch. Get this update to resolve all of them.

[CVE-2023-36792 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36792)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36793 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36793)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36794 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36794)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36796 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36796)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36799 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36799)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET where reading a maliciously crafted X.509 certificate may result in Denial of Service. This issue only affects Linux systems.


### Additional fixes in this release

* [SDK](https://github.com/dotnet/sdk/issues?q=milestone%3A6.0.22+is%3Aclosed+label%3Aservicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.22+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8758](https://github.com/dotnet/core/issues/8758) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.22.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.22-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.22-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/September-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.22
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.22
Microsoft.WindowsDesktop.App.Ref | 6.0.22
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.22
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.22
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.22
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.22
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.22
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.22
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.22
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.22
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.22
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.22
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.22
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.22
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.22
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.22
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.22
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300 | 6.0.22
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.22
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.22
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.22
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.22
Microsoft.NETCore.App.Composite | 6.0.22
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.22
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.22
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64 | 6.0.22
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86 | 6.0.22
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64 | 6.0.22
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400 | 6.0.22
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.22
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.22
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.22
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.22
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.22
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.22
Microsoft.NETCore.App.Host.linux-arm | 6.0.22
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.22
Microsoft.NETCore.App.Host.osx-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.22
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.22
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.22
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.22
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.22
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.22
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.22
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.22
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.22
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.22
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.22
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.22
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.22
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.22
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.22
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.22
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.22
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.22
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.22
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.22
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.22
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.22
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.22
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.22
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.22
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.22
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.22
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.22
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.22
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.22
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.22
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.22
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.22
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.22
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.22
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.22
Microsoft.NETCore.App.Host.win-arm64 | 6.0.22
Microsoft.NETCore.App.Host.win-x86 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.22
Microsoft.NETCore.App.Runtime.win-arm | 6.0.22
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.22
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.22
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.22
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.22
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.22
Microsoft.NETCore.App.Host.linux-x64 | 6.0.22
Microsoft.NETCore.App.Host.win-arm | 6.0.22
Microsoft.NETCore.App.Host.win-x64 | 6.0.22
Microsoft.NETCore.App.Ref | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.22
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.22
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.22
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.22
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.22
Microsoft.NETCore.DotNetHostResolver | 6.0.22
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.22
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.22
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.22
Microsoft.NETCore.DotNetAppHost | 6.0.22
Microsoft.NETCore.DotNetHostPolicy | 6.0.22
Microsoft.NETCore.DotNetHost | 6.0.22
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.22
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.22
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.22
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.22
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.22
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.22
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.22
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.22
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.22
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.22
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.22
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.22
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.22
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.22
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.22
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.22
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.22
AspNetCoreRuntime.6.0.x86 | 6.0.22
Microsoft.AspNetCore.App.Ref | 6.0.22
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.22
Microsoft.AspNetCore.Authentication.Twitter | 6.0.22
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.22
Microsoft.AspNetCore.Authorization | 6.0.22
Microsoft.AspNetCore.Components.Authorization | 6.0.22
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.22
Microsoft.AspNetCore.Components.Forms | 6.0.22
Microsoft.AspNetCore.Components.WebView | 6.0.22
Microsoft.AspNetCore.Connections.Abstractions | 6.0.22
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.22
Microsoft.AspNetCore.DataProtection | 6.0.22
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.22
Microsoft.AspNetCore.Metadata | 6.0.22
Microsoft.AspNetCore.Owin | 6.0.22
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.22
Microsoft.Authentication.WebAssembly.Msal | 6.0.22
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.22
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.22
Microsoft.Extensions.Localization.Abstractions | 6.0.22
Microsoft.Extensions.Logging.AzureAppServices | 6.0.22
dotnet-sql-cache | 6.0.22
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.22
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.22
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.22
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.22
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.22
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.22
Microsoft.AspNetCore.Components | 6.0.22
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.22
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.22
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.22
Microsoft.AspNetCore.Razor.Language | 6.0.22
Microsoft.AspNetCore.SignalR.Client | 6.0.22
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.22
Microsoft.AspNetCore.SignalR.Common | 6.0.22
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.22
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.22
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.22
Microsoft.CodeAnalysis.Razor | 6.0.22
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.22
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.22
Microsoft.Extensions.Http.Polly | 6.0.22
Microsoft.Extensions.Localization | 6.0.22
Microsoft.Extensions.WebEncoders | 6.0.22
Microsoft.AspNetCore.Components.Analyzers | 6.0.22
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.22
Microsoft.AspNetCore.HeaderPropagation | 6.0.22
Microsoft.AspNetCore.Http.Connections.Common | 6.0.22
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.22
Microsoft.AspNetCore.JsonPatch | 6.0.22
Microsoft.AspNetCore.Identity.UI | 6.0.22
Microsoft.Extensions.ApiDescription.Server | 6.0.22
Microsoft.dotnet-openapi | 6.0.22
Microsoft.Extensions.ApiDescription.Client | 6.0.22
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.22
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.22
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.22
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.22
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.22
AspNetCoreRuntime.6.0.x64 | 6.0.22
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.22
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.22
Microsoft.AspNetCore.Authentication.Certificate | 6.0.22
Microsoft.AspNetCore.Authentication.Google | 6.0.22
Microsoft.AspNetCore.Authentication.Facebook | 6.0.22
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.22
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.22
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.22
Microsoft.AspNetCore.Components.Web | 6.0.22
Microsoft.AspNetCore.Components.WebAssembly | 6.0.22
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.22
Microsoft.AspNetCore.Cryptography.Internal | 6.0.22
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.22
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.22
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.22
Microsoft.AspNetCore.Http.Connections.Client | 6.0.22
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.22
Microsoft.AspNetCore.Mvc.Testing | 6.0.22
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.22
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.22
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.22
Microsoft.AspNetCore.TestHost | 6.0.22
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.22
Microsoft.AspNetCore.SpaProxy | 6.0.22
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.22
Microsoft.Extensions.Caching.SqlServer | 6.0.22
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.22
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.22
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.22
Microsoft.Extensions.Features | 6.0.22
Microsoft.Extensions.Identity.Core | 6.0.22
Microsoft.Extensions.FileProviders.Embedded | 6.0.22
Microsoft.Extensions.Identity.Stores | 6.0.22
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.22
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.22
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.22
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.22
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.22
Microsoft.Extensions.ObjectPool | 6.0.22
Microsoft.JSInterop | 6.0.22
Microsoft.JSInterop.WebAssembly | 6.0.22
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.414
Microsoft.TemplateEngine.Core.Contracts | 6.0.414
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.414
Microsoft.TemplateEngine.Core | 6.0.414
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.414
Microsoft.DotNet.Common.ItemTemplates | 6.0.414
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.414
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.414
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.414
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.414
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.414
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.414
Microsoft.TemplateEngine.Abstractions | 6.0.414
Microsoft.TemplateEngine.Edge | 6.0.414
Microsoft.TemplateEngine.IDE | 6.0.414
Microsoft.TemplateEngine.Utils | 6.0.414
Microsoft.TemplateSearch.Common | 6.0.414
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.414
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.414
FSharp.Core | 6.0.7
FSharp.Compiler.Service | 41.0.7
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.22
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.22
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.22
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64 | 6.0.22
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.22
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.22
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.22
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.22
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300 | 6.0.22
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.22
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64 | 6.0.22
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64 | 6.0.22
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64 | 6.0.22
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64 | 6.0.22
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.22
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86 | 6.0.22
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86 | 6.0.22
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400 | 6.0.22
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.22
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64 | 6.0.22
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.22
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.22
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64 | 6.0.22
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.22
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.22
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.22
Microsoft.EntityFrameworkCore | 6.0.22
Microsoft.Data.Sqlite | 6.0.22
dotnet-ef | 6.0.22
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.22
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.22
Microsoft.EntityFrameworkCore.Proxies | 6.0.22
Microsoft.EntityFrameworkCore.Design | 6.0.22
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.22
Microsoft.EntityFrameworkCore.Analyzers | 6.0.22
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.22
Microsoft.EntityFrameworkCore.Sqlite | 6.0.22
Microsoft.EntityFrameworkCore.Cosmos | 6.0.22
Microsoft.EntityFrameworkCore.Abstractions | 6.0.22
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.22
Microsoft.EntityFrameworkCore.Tools | 6.0.22
Microsoft.Data.Sqlite.Core | 6.0.22
Microsoft.EntityFrameworkCore.InMemory | 6.0.22
Microsoft.EntityFrameworkCore.Relational | 6.0.22
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.22
Microsoft.EntityFrameworkCore.SqlServer | 6.0.22
Microsoft.TemplateEngine.Abstractions | 6.0.317
Microsoft.DotNet.Common.ItemTemplates | 6.0.317
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.317
Microsoft.TemplateEngine.Core | 6.0.317
Microsoft.TemplateEngine.IDE | 6.0.317
Microsoft.TemplateEngine.Core.Contracts | 6.0.317
Microsoft.TemplateEngine.Edge | 6.0.317
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.317
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.317
Microsoft.TemplateEngine.Utils | 6.0.317
Microsoft.TemplateSearch.Common | 6.0.317
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.317
FSharp.Compiler.Service | 41.0.5
FSharp.Core | 6.0.5
Microsoft.DotNet.Common.ItemTemplates | 6.0.122
Microsoft.TemplateEngine.Core.Contracts | 6.0.122
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.122
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.122
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.122
Microsoft.TemplateEngine.Core | 6.0.122
Microsoft.TemplateEngine.Edge | 6.0.122
Microsoft.TemplateEngine.IDE | 6.0.122
Microsoft.TemplateEngine.Utils | 6.0.122
Microsoft.TemplateSearch.Common | 6.0.122
Microsoft.TemplateEngine.Abstractions | 6.0.122
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.122
Microsoft.DotNet.Compatibility | 1.0.0-servicing.23425.21

[//]: # ( Runtime 6.0.22)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4b96a170-6a14-412a-a222-0c4994e88138/7e0f12214e87d9aa27831272cda5642b/dotnet-runtime-6.0.22-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1cd7db66-695f-48d8-9e79-d61df9774345/4c363363f91445c542e8a997e3568ac4/dotnet-runtime-6.0.22-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3f623867-1cd6-4743-b71e-dede0a762342/58d2552517b891101c37fec0056c1760/dotnet-runtime-6.0.22-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/77dd9ff5-f657-455c-be35-c7bd296f2cec/c12fb0f5d83cd20e6126bc50b6127835/dotnet-runtime-6.0.22-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/142a943f-d1fb-4b22-93c3-a170077fe759/291000206c5907a4cb8a25ef5f09d8b1/dotnet-runtime-6.0.22-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f812da49-53de-4f59-93d2-742a61229149/35ff2eb90bf2583d21ad25146c291fe4/dotnet-runtime-6.0.22-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c11bd531-45d7-4788-977a-4bfb55d89e3e/3b62a6d0dfe4900aae09d166665aa4c5/dotnet-runtime-6.0.22-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/48cddb0a-2a08-4d83-b571-00772a73d05e/5489b285d12781a983a0f17f26973369/dotnet-runtime-6.0.22-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/46d95672-b4c5-4c42-8710-773a86c2024e/3898cc9d40e03604f29ecab0155c1958/dotnet-runtime-6.0.22-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b1dc97bc-8a17-4211-831f-8dd2c01399ce/9972b4153b37a16773b13ea0dcd12268/dotnet-runtime-6.0.22-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/dcde8b51-ea6b-45eb-8619-c30901443ee0/4def35061c7e50fb7df8a0460adae8f7/dotnet-runtime-6.0.22-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/07f9079c-d0b4-41ac-a59f-88b3d305a055/0271dc503c8e1ebbf84b879d8cb9e4de/dotnet-runtime-6.0.22-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4b347c5f-a013-4894-ba0e-1474aad69ad5/fe6700c305d8904efd266435cdc641e4/dotnet-runtime-6.0.22-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5f15b355-d73a-47c3-96a6-e7ea2a54ef32/8d7a131b7e4ea660ebf6d502ee9fefeb/dotnet-runtime-6.0.22-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1c759a1f-96f6-4013-81a7-11a4cb95988c/a906c37b7c77b5f524f77a51e1ef84c9/dotnet-runtime-6.0.22-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/66c09d73-21e7-4416-af70-77896b887251/6a90bb01b857e353b9dae7838e3481d0/dotnet-runtime-6.0.22-win-x86.zip

[//]: # ( WindowsDesktop 6.0.22)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/5c1ee666-7d88-4463-afd4-87f608035d97/f3e97d4cb56dd7060d69f83a3e7c36ad/windowsdesktop-runtime-6.0.22-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/d734e93d-3728-4af6-a89c-70820a349fb5/0c19682817df9828fc9475c9b9f35912/windowsdesktop-runtime-6.0.22-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/66a7c4c6-8401-4799-864f-9afddf5a7733/4052f458f0266e25ab1b9c7959ca245f/windowsdesktop-runtime-6.0.22-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/fd28a1bc-4c84-4081-ba0e-10632afcab3f/a6cead7247f403aa16acf9713502df9c/windowsdesktop-runtime-6.0.22-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4842d8ed-dae1-462b-a1c6-f08fcf568aa1/2a4ede4188528a10d003ee797a211568/windowsdesktop-runtime-6.0.22-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/58e78fe4-3c5d-4c4b-b01c-96c65ef525db/9a8cda6e8ab6a1c671200577cd3f11e3/windowsdesktop-runtime-6.0.22-win-x86.zip

[//]: # ( ASP 6.0.22)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/994282df-ceee-45e9-890a-cd979a7ae186/f54f388f61b7a2a57b39d166f9936966/aspnetcore-runtime-6.0.22-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/000ddf12-2c8b-4d97-9b3d-f76c8fef461e/c2dfb5a82b7952cb272c0f5dbeb7fcb1/aspnetcore-runtime-6.0.22-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/72bfd2b0-0b64-48a5-bf1c-7ba2e6fc7356/c723b4ff7cee67d564233afcb453d239/aspnetcore-runtime-6.0.22-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cbf6abe5-a8a2-4b9b-b496-9eedb2ea93ec/7725c16a88d3192a92234e3eda4012a7/aspnetcore-runtime-6.0.22-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/32759672-4bfd-43a3-9d72-d586ec78ec5c/2551da06feb8677759abd86816d1d188/aspnetcore-runtime-6.0.22-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a936856b-96f0-4525-8f74-b96b792c3664/2da9be398c92985d3f95c3336361d1ba/aspnetcore-runtime-6.0.22-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4f2055fb-f5f2-4953-8341-4c56ae1f2893/52d66998e9326c7172d77a706e752861/aspnetcore-runtime-6.0.22-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/447de6fd-79ad-4a1d-a7ea-48f57a8e1280/27c1a55772876bf109b7c2caa5038d9d/aspnetcore-runtime-6.0.22-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/6d029f28-f82f-4440-adeb-bab04a7ef429/45c91bd9cb9d933ef11c68b57bd4d0f6/aspnetcore-runtime-6.0.22-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a0946814-10e0-4546-92e9-b74c88ebe45a/1da48715b74940956f3362b714c2457f/aspnetcore-runtime-6.0.22-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/152fb6ef-71d1-41c1-8910-f9225c5e3af5/b14a8f41e5def4d1306328a9cfdf5c16/aspnetcore-runtime-6.0.22-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/aec975a2-16e3-4654-ad07-db9925012ca2/6a087cfaad1f8064933274fab65b7cd7/aspnetcore-runtime-6.0.22-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/f374b922-689a-453b-b64b-927a5f0e6e97/0262a024556a31cb8947e87bab919009/aspnetcore-runtime-6.0.22-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/6127ac20-be25-437d-ab6a-e90415f3d547/f572f0b58361ccff32a961ad4446bb24/dotnet-hosting-6.0.22-win.exe

[//]: # ( SDK 6.0.414)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/05e4b609-84ad-45fb-b6d8-314befed2398/f39d5341d71966a6f29dd562180f7f00/dotnet-sdk-6.0.414-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a2afb4da-478b-4ffa-aeeb-a37a313d6fc8/0897a8456d42f306519de9a15b1e14ef/dotnet-sdk-6.0.414-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7ba77d67-e3ca-4d97-b2f5-d1ce907baf93/9438ce851ab25d281689fadc2af4febf/dotnet-sdk-6.0.414-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/daf4e30c-de53-494b-868a-dd262cde3595/94ef233706af73948785eb913758931e/dotnet-sdk-6.0.414-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/da3e4284-66b3-44a4-a094-9cf2d3f238db/bfb2d81e48d9eee2552de8b630837abb/dotnet-sdk-6.0.414-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d97d1625-d7ed-444c-a7e9-e7b469842960/d8b97220d0d79119e3026da2b956854e/dotnet-sdk-6.0.414-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/6936c1ed-530d-4b1d-898e-1f27e5109c5a/a8f73f24b9103d0a64ca42f1462b0954/dotnet-sdk-6.0.414-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/72bd5609-d0bd-4fb5-a563-6f426038a7d9/01507b650934aab36c340284d0819ba3/dotnet-sdk-6.0.414-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1de3975a-e76b-4524-9584-b01d2c8db33e/4a05072624690d3b0167493cbb3d7757/dotnet-sdk-6.0.414-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/25ec70da-5c05-4d55-9f1c-fe103417da1d/afcf8ecac02c9e8a927c128c9a72ec1f/dotnet-sdk-6.0.414-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c58838b8-93cb-45bb-b8c5-3177039051fd/cd07d9b67c9a8abc9aa78a1329b52260/dotnet-sdk-6.0.414-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f30157af-c3e4-4a1a-8668-a96c9a4fb8bf/e9a6d55be6224ac35f79c7c1d81fa844/dotnet-sdk-6.0.414-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1344d6ee-3e0e-43e7-ad65-61ce8bcce2de/1339c0073340fedfdd28dd9bfb9a5fb6/dotnet-sdk-6.0.414-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c226e396-07e9-4ce6-a6d2-96c867db596c/84a7aaf08f4c038d0f142c516d529bcc/dotnet-sdk-6.0.414-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/56151f40-04dc-4df9-9e24-a6f69a2510fc/92c7e5b7a977b0919d90a1ad9e416660/dotnet-sdk-6.0.414-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8eb6d21a-a3f7-41a2-b708-28f7f136dd2e/1195d9e071fc01df2adb5d612f6126bb/dotnet-sdk-6.0.414-win-x86.zip
