# .NET 6.0.23 - October 10, 2023

The .NET 6.0.23, [.NET SDK 6.0.123](6.0.123.md), and [.NET SDK 6.0.318](6.0.318.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.415
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```
The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

.NET 6.0.23 release carries security fixes.

[CVE-2023-44487 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-44487)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 8.0 RC1, .NET 7.0 ,and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A vulnerability exists in the ASP.NET  Core Kestrel web server where a malicious client may flood the server with specially crafted HTTP/2 requests, causing denial of service.

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8827](https://github.com/dotnet/core/issues/8827) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.23.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.23-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.23-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/October-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.23
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.23
Microsoft.WindowsDesktop.App.Ref | 6.0.23
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.23
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.23
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.23
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.23
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.23
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.23
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.23
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.23
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64 | 6.0.23
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.23
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.23
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.23
Microsoft.NETCore.App.Host.osx-x64 | 6.0.23
Microsoft.NETCore.App.Host.win-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.23
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.23
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.23
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.23
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.23
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.23
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.23
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.23
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.23
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.23
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.23
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.23
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.23
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.23
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.23
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.23
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300 | 6.0.23
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.23
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.23
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.23
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.23
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.23
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.23
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.23
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.23
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.23
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Composite | 6.0.23
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86 | 6.0.23
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.23
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.23
Microsoft.NETCore.App.Host.win-arm | 6.0.23
Microsoft.NETCore.App.Ref | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.23
Microsoft.NETCore.DotNetHostResolver | 6.0.23
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.23
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.23
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.23
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.23
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.23
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.23
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.23
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.23
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.23
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.23
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.23
Microsoft.NETCore.App.Host.linux-arm | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.23
Microsoft.NETCore.App.Host.linux-x64 | 6.0.23
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.23
Microsoft.NETCore.App.Host.win-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.23
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.23
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.win-arm | 6.0.23
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.23
Microsoft.NETCore.DotNetHost | 6.0.23
Microsoft.NETCore.DotNetHostPolicy | 6.0.23
Microsoft.NETCore.DotNetAppHost | 6.0.23
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.23
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.23
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.23
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.23
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.23
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.23
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.23
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.23
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.23
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.23
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.23
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.23
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.23
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.23
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.23
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.23
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.23
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.23
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.23
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400 | 6.0.23
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.23
Microsoft.NETCore.App.Host.win-x86 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.23
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.23
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.23
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.23
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.23
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.23
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.23
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.23
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.23
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.23
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.23
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.23
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.23
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.23
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.23
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.23
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.23
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.23
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.23
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.23
Microsoft.AspNetCore.Metadata | 6.0.23
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.23
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.23
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.23
Microsoft.AspNetCore.SpaProxy | 6.0.23
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.23
Microsoft.AspNetCore.TestHost | 6.0.23
Microsoft.Extensions.ApiDescription.Server | 6.0.23
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.23
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.23
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.23
Microsoft.AspNetCore.Components | 6.0.23
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.23
Microsoft.AspNetCore.Components.Analyzers | 6.0.23
Microsoft.AspNetCore.Components.Authorization | 6.0.23
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.23
Microsoft.AspNetCore.Components.Forms | 6.0.23
Microsoft.AspNetCore.Components.Web | 6.0.23
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.23
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.23
Microsoft.AspNetCore.DataProtection | 6.0.23
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.23
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.23
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.23
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.23
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.23
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.23
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.23
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.23
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.23
dotnet-sql-cache | 6.0.23
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.23
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.23
Microsoft.AspNetCore.Authentication.Certificate | 6.0.23
Microsoft.AspNetCore.Authentication.Facebook | 6.0.23
Microsoft.AspNetCore.Authentication.Google | 6.0.23
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.23
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.23
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.23
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.23
Microsoft.AspNetCore.Components.WebView | 6.0.23
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.23
Microsoft.AspNetCore.Connections.Abstractions | 6.0.23
Microsoft.AspNetCore.Cryptography.Internal | 6.0.23
Microsoft.AspNetCore.Http.Connections.Client | 6.0.23
Microsoft.AspNetCore.HeaderPropagation | 6.0.23
Microsoft.AspNetCore.Http.Connections.Common | 6.0.23
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.23
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.23
Microsoft.AspNetCore.JsonPatch | 6.0.23
Microsoft.AspNetCore.Identity.UI | 6.0.23
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.23
Microsoft.AspNetCore.Mvc.Testing | 6.0.23
Microsoft.AspNetCore.Owin | 6.0.23
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.23
Microsoft.AspNetCore.SignalR.Client | 6.0.23
Microsoft.AspNetCore.SignalR.Common | 6.0.23
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.23
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.23
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.23
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.23
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.23
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.23
Microsoft.Extensions.Caching.SqlServer | 6.0.23
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.23
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.23
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.23
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.23
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.23
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.23
Microsoft.AspNetCore.App.Ref | 6.0.23
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.23
Microsoft.AspNetCore.Authentication.Twitter | 6.0.23
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.23
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.23
Microsoft.AspNetCore.Authorization | 6.0.23
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.23
Microsoft.Authentication.WebAssembly.Msal | 6.0.23
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.23
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.23
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.23
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.23
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.23
Microsoft.Extensions.Features | 6.0.23
Microsoft.Extensions.Identity.Core | 6.0.23
Microsoft.Extensions.FileProviders.Embedded | 6.0.23
Microsoft.Extensions.Http.Polly | 6.0.23
Microsoft.Extensions.Identity.Stores | 6.0.23
Microsoft.Extensions.Logging.AzureAppServices | 6.0.23
Microsoft.Extensions.Localization.Abstractions | 6.0.23
Microsoft.Extensions.Localization | 6.0.23
Microsoft.Extensions.ObjectPool | 6.0.23
Microsoft.Extensions.WebEncoders | 6.0.23
Microsoft.JSInterop | 6.0.23
Microsoft.JSInterop.WebAssembly | 6.0.23
AspNetCoreRuntime.6.0.x86 | 6.0.23
AspNetCoreRuntime.6.0.x64 | 6.0.23
Microsoft.AspNetCore.Components.WebAssembly | 6.0.23
Microsoft.AspNetCore.Razor.Language | 6.0.23
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.23
Microsoft.dotnet-openapi | 6.0.23
Microsoft.CodeAnalysis.Razor | 6.0.23
Microsoft.Extensions.ApiDescription.Client | 6.0.23
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.23
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.23
Microsoft.DotNet.Common.ItemTemplates | 6.0.123
Microsoft.TemplateEngine.IDE | 6.0.123
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.123
Microsoft.TemplateEngine.Abstractions | 6.0.123
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.123
Microsoft.TemplateEngine.Core.Contracts | 6.0.123
Microsoft.TemplateEngine.Core | 6.0.123
Microsoft.TemplateEngine.Edge | 6.0.123
Microsoft.TemplateEngine.Utils | 6.0.123
Microsoft.TemplateSearch.Common | 6.0.123
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.123
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.123
Microsoft.DotNet.Compatibility | 1.0.0-servicing.23480.40
Microsoft.Data.Sqlite.Core | 6.0.23
Microsoft.EntityFrameworkCore.Abstractions | 6.0.23
Microsoft.EntityFrameworkCore | 6.0.23
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.23
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.23
Microsoft.EntityFrameworkCore.Relational | 6.0.23
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.23
Microsoft.EntityFrameworkCore.SqlServer | 6.0.23
Microsoft.EntityFrameworkCore.Sqlite | 6.0.23
Microsoft.EntityFrameworkCore.Tools | 6.0.23
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.23
dotnet-ef | 6.0.23
Microsoft.Data.Sqlite | 6.0.23
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.23
Microsoft.EntityFrameworkCore.Cosmos | 6.0.23
Microsoft.EntityFrameworkCore.Proxies | 6.0.23
Microsoft.EntityFrameworkCore.Analyzers | 6.0.23
Microsoft.EntityFrameworkCore.Design | 6.0.23
Microsoft.EntityFrameworkCore.InMemory | 6.0.23
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.23
Microsoft.TemplateEngine.Abstractions | 6.0.318
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.318
Microsoft.TemplateEngine.Core | 6.0.318
Microsoft.TemplateEngine.Core.Contracts | 6.0.318
Microsoft.TemplateEngine.Edge | 6.0.318
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.318
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.318
Microsoft.DotNet.Common.ItemTemplates | 6.0.318
Microsoft.TemplateEngine.IDE | 6.0.318
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.318
Microsoft.TemplateEngine.Utils | 6.0.318
Microsoft.TemplateSearch.Common | 6.0.318
FSharp.Core | 6.0.5
FSharp.Compiler.Service | 41.0.5
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.415
Microsoft.DotNet.Common.ItemTemplates | 6.0.415
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.415
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.415
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.415
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.415
Microsoft.TemplateSearch.Common | 6.0.415
Microsoft.TemplateEngine.Utils | 6.0.415
Microsoft.TemplateEngine.Edge | 6.0.415
Microsoft.TemplateEngine.IDE | 6.0.415
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.415
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.415
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.415
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.415
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.415
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.415
Microsoft.TemplateEngine.Abstractions | 6.0.415
Microsoft.TemplateEngine.Core | 6.0.415
Microsoft.TemplateEngine.Core.Contracts | 6.0.415
FSharp.Compiler.Service | 41.0.7
FSharp.Core | 6.0.7

[//]: # ( Runtime 6.0.23)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e14a0dcb-5458-410d-8d0e-2488ae14e047/915ed2d0e103f073487d2ea000dd2f68/dotnet-runtime-6.0.23-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/66d729cf-1303-44dd-9f14-5859282cc780/e67f72282c5ef0e75dc698f93324460c/dotnet-runtime-6.0.23-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4e70d935-e3a0-4e78-9336-d36a3fe3fef3/0c36f78eb6792cbd19a7004cd80fef2b/dotnet-runtime-6.0.23-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/76e02f7a-1c0a-48e4-b642-0d25f9473fdc/cb426b5daeff6c4c8292193cf90b43d8/dotnet-runtime-6.0.23-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f0b9d33e-a1a5-43aa-b980-6cdbadaa58d6/8208989039c030c0d41c2c08425f4918/dotnet-runtime-6.0.23-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7475b540-969a-4979-ad06-ca4a312f24e1/9fc47fc894869efaf968d47d3235f554/dotnet-runtime-6.0.23-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/b500e83e-82d6-42ba-b2fc-26657ce7e6b2/f9dadcad404221e14b574acc432c17fc/dotnet-runtime-6.0.23-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a8600e65-bbf6-41cc-84ac-e4c5d8d73eae/47975544e7950aaa47561fde22d147ea/dotnet-runtime-6.0.23-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e48b91ad-85cd-4454-aec4-527b67099780/472f45b97a30a1acebd2b70738397312/dotnet-runtime-6.0.23-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a9675800-40b8-4f51-984f-f9931ddcd15f/341376f06f5c176556a82b7c7c59bb26/dotnet-runtime-6.0.23-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c9a9f47c-b231-4155-a8cb-7432dce65476/97a20f1eee423ce07b544d127d6739d3/dotnet-runtime-6.0.23-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0b88918e-1245-4126-b27b-8b55e9f1f376/240fd4eb5e289242e44fe8ba01db29bd/dotnet-runtime-6.0.23-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0e41930c-8e2d-4fb0-9b50-3a011bbc5338/a5f8b21867caacf4e97bf560eb304f7f/dotnet-runtime-6.0.23-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9f10af63-f5e5-437f-931c-dc15fcbe9f4c/2a58f59009b50e5f13a46b3d308c6d63/dotnet-runtime-6.0.23-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e1f87d42-e036-4a5e-a61d-1df3a5f12c5d/f2f9d74bccf880943dabbccd98fd610f/dotnet-runtime-6.0.23-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/14ef2fd9-4895-4fd4-b1ac-9a3e01da30eb/05a3833407df2f7749a59946b614c4ec/dotnet-runtime-6.0.23-win-x86.zip

[//]: # ( WindowsDesktop 6.0.23)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c1bf9010-5b41-4457-bcad-bc2503767a57/2fea652e66c03acf51dcc62b98e5e9df/windowsdesktop-runtime-6.0.23-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/3dc261a4-e7e4-4f49-aeea-b72764d05db2/177e524fe8ad1441dccba14320d47367/windowsdesktop-runtime-6.0.23-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/83d32568-c5a2-4117-9591-437051785f41/e75171da01b1fa5c796660dc4b96beed/windowsdesktop-runtime-6.0.23-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b0224b3a-7905-48c1-b7f9-677ef92bdbed/10cbd8aaa9d6bb59e7e665096bf17716/windowsdesktop-runtime-6.0.23-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c40fd151-a0f3-42a4-a081-cade6ad66bf8/3e6c8d60725eaa25ef1302a82fb1235b/windowsdesktop-runtime-6.0.23-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/05e60dc3-39b6-4e9c-b6ff-04a212db8f09/fa006e572d0ec6f43e37f729794f46c6/windowsdesktop-runtime-6.0.23-win-x86.zip

[//]: # ( ASP 6.0.23)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/07b545c0-a68b-4f26-8b8f-38050a8c2f86/a6abe31d891483c58f8145a152696570/aspnetcore-runtime-6.0.23-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6d4850c5-4c75-4bbd-b5c7-33f9b9945d8e/8b1a5434084cd1b7e590dafa43586149/aspnetcore-runtime-6.0.23-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/58d856fa-9744-421c-93e9-17ed17949bcd/cb0814eade88b9e2a07943ffafac96ad/aspnetcore-runtime-6.0.23-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/caf0ed15-fbc7-4944-b2aa-2e909cf64d0c/c962809ffa7bf12011683a9cb301a94e/aspnetcore-runtime-6.0.23-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f0746d4d-6a01-49aa-a0a1-2c782be753a0/bed31d0d2c4ca78c75fe0852ae60507d/aspnetcore-runtime-6.0.23-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/40fe5762-4d1d-4630-a943-32ebfe660c39/bba3d2c93794aa406a2402652b23d953/aspnetcore-runtime-6.0.23-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/88e21502-48f6-4c50-b238-d25b090a9fdc/6a44ec6cbbde487b9d380c601992e73c/aspnetcore-runtime-6.0.23-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/02deac39-8c5a-450f-92e5-678a1bfab895/1c99ce9a82ec4facff6fee560e0ceb2d/aspnetcore-runtime-6.0.23-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/129e4f85-c885-46e7-bb14-5a5d66dc401a/4e11cdb9f6a120adb025fdff4e61bed7/aspnetcore-runtime-6.0.23-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5dda0222-f938-4c6f-abb8-31dbf6e73540/71d708e5c3579ab96f998c0e7323c0cc/aspnetcore-runtime-6.0.23-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/beef4774-ff5c-48bd-8db9-4bc5b6404875/8182f768c7fb56921647b8826378614b/aspnetcore-runtime-6.0.23-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6970ad95-e962-4ec9-b2e1-c8bd9f530346/e82487275052013684dfdd3780460a17/aspnetcore-runtime-6.0.23-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/3d96e1de-5411-4d84-be62-aa986f1276a7/d16cccd97758d05f13062045fd1330a7/aspnetcore-runtime-6.0.23-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/34343c71-eb52-4537-b2b9-f25bc8b6c894/c6a39b3b387ad3f9662cd77c220902f5/dotnet-hosting-6.0.23-win.exe

[//]: # ( SDK 6.0.415)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8a8f78e6-47c3-44c5-8161-2ed9cd395ad0/5e8a3d7557a913d88ebb320e61cda754/dotnet-sdk-6.0.415-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/df31fc1b-3db2-48c3-81f1-dade77100315/3cdb20ce781adcc51fd6058ebe32a8c9/dotnet-sdk-6.0.415-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5f57e119-dba4-41f2-8b31-e3d89623addd/41319b700003f7e6de010a668f428ce1/dotnet-sdk-6.0.415-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cdbfe5ac-c546-4bc3-9418-ee0b621bdfe2/ccbcf26d7f55daaf8a5f0d950062ac50/dotnet-sdk-6.0.415-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e71a441a-8ce5-4bf3-be2e-e0ff2ff66fc9/5144a14a22a7f51a6f18e95827765819/dotnet-sdk-6.0.415-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/62a75533-4a7d-47e3-9863-4ab5eea04ea8/d802c8f82a8c2b5f276f68b87c682b70/dotnet-sdk-6.0.415-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/db68b8a6-fd16-4a90-ad4c-9f349335785a/ad03eae1b78be886c0f15a49cc54d999/dotnet-sdk-6.0.415-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/771d37cf-3247-4d94-be22-b4c379164b7c/e654c1d75c5093bced25412452329a93/dotnet-sdk-6.0.415-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/df136a69-ab21-4938-ae40-785862f52445/e220acaad09b018a0b0b622710694367/dotnet-sdk-6.0.415-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d5060b22-1d6d-4372-9ae1-6240fad6925c/74040d3b0c729b6c780b526978b29446/dotnet-sdk-6.0.415-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/ad43ff75-1e52-4ac8-ba16-f243e63c3077/5b832eb2bd8d98e422257d8ddb9364b7/dotnet-sdk-6.0.415-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/88583dbc-a214-437e-801e-ca34746a148e/5bf5593e7b7789a49a812ecd2f2da2d1/dotnet-sdk-6.0.415-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9b3cbb1c-3368-4a5a-a899-b1c6ec5c0c3e/cb4de75dd805113129a7f903d125e4b0/dotnet-sdk-6.0.415-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/38487782-aa7b-40a8-9de4-18e93344d21b/6fdd1c8b3b4e673f8ba7f2d97283984b/dotnet-sdk-6.0.415-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9c0f0376-7a5a-4f9d-917b-1aefd18f6144/4af6a2f485d800c1121a27b6c7f2a0df/dotnet-sdk-6.0.415-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/85995085-ed0a-43d6-94b3-92e328f869b2/f53f00f428f3912244dc3ff3b44234e3/dotnet-sdk-6.0.415-win-x86.zip
