# .NET 6.0.24 - October 24, 2023

Microsoft is releasing an update to our October 10, 2023 security release. The .NET 6.0.23 updates inadvertently missed (were not cumulative of) the security fixes in our previous September 12, 2023 update. The new .NET 6.0.24 update is cumulative of both September and October security fixes.

The .NET 6.0.24, [.NET SDK 6.0.124](6.0.124.md), and [.NET SDK 6.0.319](6.0.319.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.416
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```
The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

* [.NET 6.0 Blog][dotnet-blog]

.NET 6.0.24 release carries security fixes.

**Note:** The vulnerabilities [CVE-2023-36792]( https://www.cve.org/CVERecord?id=CVE-2023-36792), [CVE-2023-36793]( https://www.cve.org/CVERecord?id=CVE-2023-36793), [CVE-2023-36794]( https://www.cve.org/CVERecord?id=CVE-2023-36794), [CVE-2023-36796]( https://www.cve.org/CVERecord?id=CVE-2023-36796) are all resolved by a single patch. Get this update to resolve all of them.

[CVE-2023-36792 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36792)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36793 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36793)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36794 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36794)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36796 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36796)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36799 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36799)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET where reading a maliciously crafted X.509 certificate may result in Denial of Service. This issue only affects Linux systems.

[CVE-2023-44487 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-44487)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 8.0 RC1, .NET 7.0 ,and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A vulnerability exists in the ASP.NET  Core Kestrel web server where a malicious client may flood the server with specially crafted HTTP/2 requests, causing denial of service.

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8856](https://github.com/dotnet/core/issues/8856) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.24.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.24-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.24-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/October-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.24
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.24
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.24
Microsoft.WindowsDesktop.App.Ref | 6.0.24
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Host.win-x86 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.24
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.24
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.24
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.24
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.24
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.24
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.24
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.24
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.24
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.24
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.24
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.24
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.24
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64 | 6.0.24
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.24
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.24
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.24
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.24
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.24
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.24
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.24
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.24
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.24
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.24
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.24
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.24
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.24
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.24
Microsoft.NETCore.App.Composite | 6.0.24
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.24
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.24
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.24
Microsoft.NETCore.App.Host.linux-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.24
Microsoft.NETCore.DotNetHost | 6.0.24
Microsoft.NETCore.DotNetAppHost | 6.0.24
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.24
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.24
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.24
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.24
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.24
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64 | 6.0.24
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.24
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.24
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.24
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.24
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.24
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.24
Microsoft.NETCore.App.Host.win-arm | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.24
Microsoft.NETCore.App.Host.win-arm64 | 6.0.24
Microsoft.NETCore.App.Ref | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.24
Microsoft.NETCore.DotNetHostPolicy | 6.0.24
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.24
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.24
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.24
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.24
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.24
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.24
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.24
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.24
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.24
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.24
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300 | 6.0.24
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.24
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.24
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.24
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.24
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64 | 6.0.24
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400 | 6.0.24
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.24
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.24
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.24
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.24
Microsoft.NETCore.DotNetHostResolver | 6.0.24
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.24
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.24
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.24
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.24
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.24
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.24
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.24
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.24
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.24
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.24
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.24
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Host.linux-arm | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.24
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.win-arm | 6.0.24
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.24
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.24
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.24
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.24
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.24
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.24
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.24
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.24
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.24
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.24
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.24
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.24
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.24
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.24
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.24
Microsoft.NETCore.App.Host.osx-x64 | 6.0.24
Microsoft.NETCore.App.Host.win-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.24
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.24
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.24
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.24
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.24
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.24
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.24
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.24
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.24
Microsoft.AspNetCore.JsonPatch | 6.0.24
Microsoft.AspNetCore.Metadata | 6.0.24
Microsoft.AspNetCore.Mvc.Testing | 6.0.24
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.24
Microsoft.AspNetCore.Owin | 6.0.24
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.24
Microsoft.AspNetCore.SignalR.Client | 6.0.24
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.24
Microsoft.AspNetCore.SpaProxy | 6.0.24
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.24
Microsoft.AspNetCore.TestHost | 6.0.24
Microsoft.CodeAnalysis.Razor | 6.0.24
Microsoft.Extensions.ApiDescription.Client | 6.0.24
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.24
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.24
Microsoft.Extensions.Caching.SqlServer | 6.0.24
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.24
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.24
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.24
Microsoft.Extensions.Features | 6.0.24
Microsoft.Extensions.FileProviders.Embedded | 6.0.24
Microsoft.Extensions.Http.Polly | 6.0.24
Microsoft.Extensions.Identity.Core | 6.0.24
Microsoft.Extensions.Localization | 6.0.24
Microsoft.Extensions.Localization.Abstractions | 6.0.24
Microsoft.Extensions.Logging.AzureAppServices | 6.0.24
Microsoft.Extensions.ObjectPool | 6.0.24
Microsoft.JSInterop | 6.0.24
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.24
AspNetCoreRuntime.6.0.x86 | 6.0.24
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.24
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.24
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.24
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.24
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.24
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.24
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.24
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.24
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.24
AspNetCoreRuntime.6.0.x64 | 6.0.24
dotnet-sql-cache | 6.0.24
Microsoft.AspNetCore.Components.Forms | 6.0.24
Microsoft.AspNetCore.Components.Analyzers | 6.0.24
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.24
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.24
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.24
Microsoft.AspNetCore.Http.Connections.Common | 6.0.24
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.24
Microsoft.AspNetCore.Razor.Language | 6.0.24
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.24
Microsoft.Extensions.Identity.Stores | 6.0.24
Microsoft.JSInterop.WebAssembly | 6.0.24
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.24
Microsoft.AspNetCore.Authentication.Certificate | 6.0.24
Microsoft.AspNetCore.Authentication.Google | 6.0.24
Microsoft.AspNetCore.Authentication.Facebook | 6.0.24
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.24
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.24
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.24
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.24
Microsoft.AspNetCore.Authorization | 6.0.24
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.24
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.24
Microsoft.AspNetCore.App.Ref | 6.0.24
Microsoft.AspNetCore.Authentication.Twitter | 6.0.24
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.24
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.24
Microsoft.AspNetCore.Components | 6.0.24
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.24
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.24
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.24
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.24
Microsoft.AspNetCore.SignalR.Common | 6.0.24
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.24
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.24
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.24
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.24
Microsoft.Authentication.WebAssembly.Msal | 6.0.24
Microsoft.dotnet-openapi | 6.0.24
Microsoft.Extensions.ApiDescription.Server | 6.0.24
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.24
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.24
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.24
Microsoft.Extensions.WebEncoders | 6.0.24
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.24
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.24
Microsoft.AspNetCore.Components.Authorization | 6.0.24
Microsoft.AspNetCore.Components.Web | 6.0.24
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.24
Microsoft.AspNetCore.Components.WebAssembly | 6.0.24
Microsoft.AspNetCore.Components.WebView | 6.0.24
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.24
Microsoft.AspNetCore.Connections.Abstractions | 6.0.24
Microsoft.AspNetCore.Cryptography.Internal | 6.0.24
Microsoft.AspNetCore.DataProtection | 6.0.24
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.24
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.24
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.24
Microsoft.AspNetCore.HeaderPropagation | 6.0.24
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.24
Microsoft.AspNetCore.Identity.UI | 6.0.24
Microsoft.AspNetCore.Http.Connections.Client | 6.0.24
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.24
Microsoft.DotNet.Common.ItemTemplates | 6.0.124
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.124
Microsoft.TemplateEngine.Core.Contracts | 6.0.124
Microsoft.TemplateEngine.Edge | 6.0.124
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.124
Microsoft.TemplateEngine.Abstractions | 6.0.124
Microsoft.TemplateEngine.Core | 6.0.124
Microsoft.TemplateEngine.IDE | 6.0.124
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.124
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.124
Microsoft.TemplateEngine.Utils | 6.0.124
Microsoft.TemplateSearch.Common | 6.0.124
Microsoft.DotNet.Compatibility | 1.0.0-servicing.23518.85
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86 | 6.0.24
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64 | 6.0.24
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.24
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300 | 6.0.24
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.24
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.24
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.24
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.24
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64 | 6.0.24
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.24
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.24
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.24
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64 | 6.0.24
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64 | 6.0.24
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.24
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.24
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.24
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64 | 6.0.24
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.24
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.24
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.24
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400 | 6.0.24
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64 | 6.0.24
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.24
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86 | 6.0.24
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64 | 6.0.24
Microsoft.EntityFrameworkCore.Analyzers | 6.0.24
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.24
Microsoft.EntityFrameworkCore.Design | 6.0.24
Microsoft.EntityFrameworkCore.InMemory | 6.0.24
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.24
Microsoft.EntityFrameworkCore.Relational | 6.0.24
Microsoft.EntityFrameworkCore.Tools | 6.0.24
dotnet-ef | 6.0.24
Microsoft.Data.Sqlite | 6.0.24
Microsoft.EntityFrameworkCore.Cosmos | 6.0.24
Microsoft.EntityFrameworkCore.Abstractions | 6.0.24
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.24
Microsoft.EntityFrameworkCore.Proxies | 6.0.24
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.24
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.24
Microsoft.EntityFrameworkCore.Sqlite | 6.0.24
Microsoft.EntityFrameworkCore.SqlServer | 6.0.24
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.24
Microsoft.EntityFrameworkCore | 6.0.24
Microsoft.Data.Sqlite.Core | 6.0.24
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.319
Microsoft.TemplateSearch.Common | 6.0.319
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.319
Microsoft.TemplateEngine.Utils | 6.0.319
Microsoft.DotNet.Common.ItemTemplates | 6.0.319
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.319
Microsoft.TemplateEngine.Abstractions | 6.0.319
Microsoft.TemplateEngine.Core | 6.0.319
Microsoft.TemplateEngine.Core.Contracts | 6.0.319
Microsoft.TemplateEngine.Edge | 6.0.319
Microsoft.TemplateEngine.IDE | 6.0.319
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.319
FSharp.Compiler.Service | 41.0.5
FSharp.Core | 6.0.5
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.416
Microsoft.TemplateEngine.Core | 6.0.416
Microsoft.TemplateEngine.Core.Contracts | 6.0.416
Microsoft.TemplateEngine.Edge | 6.0.416
Microsoft.TemplateEngine.IDE | 6.0.416
Microsoft.TemplateEngine.Utils | 6.0.416
Microsoft.TemplateSearch.Common | 6.0.416
Microsoft.DotNet.Common.ItemTemplates | 6.0.416
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.416
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.416
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.416
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.416
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.416
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.416
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.416
Microsoft.TemplateEngine.Abstractions | 6.0.416
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.416
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.416
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.416
FSharp.Compiler.Service | 41.0.7
FSharp.Core | 6.0.7

[//]: # ( Runtime 6.0.24)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/68e18009-afb1-4f94-948e-e07f6d8886d1/3e440f9c63cb4733528fa052d37254e8/dotnet-runtime-6.0.24-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8292f37d-c0b7-4371-b307-990c488ffce0/95142913864b1f8cf45d3bc432a8c193/dotnet-runtime-6.0.24-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/706891e2-9c53-4b3d-8290-96bd6ae28224/c240eb2faf8a7939e0540b98a71581f3/dotnet-runtime-6.0.24-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8cd016b4-abeb-48db-a7d0-0128be0b5905/ca97fddbcbfdc096b4ef1fb4ac0de43f/dotnet-runtime-6.0.24-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8ae5406a-3be4-41d4-b49d-f54667c95631/2c9697240d38608e15cf715abe0e2343/dotnet-runtime-6.0.24-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/872b4f32-dd0d-49e5-bca3-2b27314286a7/e72d2be582895b7053912deb45a4677d/dotnet-runtime-6.0.24-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4d78d106-3423-428c-b7be-79af4f938f14/4d1a4cc0a650de19be6870da2c53b66f/dotnet-runtime-6.0.24-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/87743def-9e7c-4157-8ca5-d818496e41ff/97ab6a39043f45d7701f91c422a663f4/dotnet-runtime-6.0.24-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/48041645-2706-4bc6-bcaf-8a21b4ed3536/d1fefeadf2d4a693c70fb30d6fff98b6/dotnet-runtime-6.0.24-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3adf2172-7ded-4053-bc86-b5236b1a3830/80038eb1ea0019995c76660f18e9a290/dotnet-runtime-6.0.24-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/435e9aec-1096-4424-941f-0f077855139d/9d653b2b0a90150f843e77114a04ba47/dotnet-runtime-6.0.24-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/3e813b04-b20e-42da-9641-c11d985546b5/ed674be2536cf472370c2fc1febb4ceb/dotnet-runtime-6.0.24-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/62bf9f50-dcd9-4e4c-ac02-4d355efb914d/a56b37b98cb07899cd8c44fa7d50dff3/dotnet-runtime-6.0.24-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/96c98d76-1d86-4395-863b-70c59930ad0f/30ff5527a4ea14df6891c556dab657e8/dotnet-runtime-6.0.24-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c002ad47-2da2-4d0f-b32b-07c60935dbad/b505f2e042b6598b483fa314b010e889/dotnet-runtime-6.0.24-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7f9e4329-81b1-4f70-93e2-0f25b1b2839b/fb64fee3c2054e1720083dcf6c64f8f6/dotnet-runtime-6.0.24-win-x86.zip

[//]: # ( WindowsDesktop 6.0.24)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/e06f3708-2216-451a-a99a-48ce5eb8e556/daa5aca45f8fd818e9584331ca0cab82/windowsdesktop-runtime-6.0.24-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/d6050938-4e9c-4ca5-8566-61c63bd9e6fa/b0818ea2d0b0ccf87b7f88ad6b056e91/windowsdesktop-runtime-6.0.24-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/dde9eb7e-8ea8-494a-9b04-5db26c7740e2/43d5050cfa63b7323749c7e56fedd3ac/windowsdesktop-runtime-6.0.24-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/66400a95-9a99-4744-8138-7d121b0760bb/30a49089649167cd6a040a08f18f91bd/windowsdesktop-runtime-6.0.24-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e55fa3d8-9a76-498a-aaaa-7dca44c7be3a/5ec98543746ddf2df96264ab015caa0b/windowsdesktop-runtime-6.0.24-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/f8afc2b5-866c-4264-94b7-f779a9a8c308/d405c0919fc069da144da09e6accebe6/windowsdesktop-runtime-6.0.24-win-x86.zip

[//]: # ( ASP 6.0.24)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9c00fe25-e1e0-4390-9061-77d07e95356f/09886ffeaed522c3fa8803e879ce070c/aspnetcore-runtime-6.0.24-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d562ba2b-8e2c-48e5-9853-f8616a9cb4e4/f4e251ba67b718083c28017e3b0c6349/aspnetcore-runtime-6.0.24-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/314e5429-c299-441d-9b59-eec5a119e6a0/185165c26e7dea000ab1405c79b209c3/aspnetcore-runtime-6.0.24-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/01fc7f48-9a0a-4c02-88a1-1796c4d357cf/c79005e23e25d569aa5784133ca7271d/aspnetcore-runtime-6.0.24-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3865aa48-18a8-4c6b-8603-04ce4902624e/9bc0206d5a699c7818637ef56f5642e9/aspnetcore-runtime-6.0.24-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8f5a65c0-9bc8-497d-9ce2-4658c461dc55/b6c01c3cd060552d987501ba6bbde09f/aspnetcore-runtime-6.0.24-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/516e1a2a-0256-48d9-8212-c95a6c9d93de/6abbcc369ef1d3e03e6e28f0438ee295/aspnetcore-runtime-6.0.24-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cf267621-f2f5-47d8-90b4-e8a4555de21b/aa82da20c081e6359b1ffbc8261b5c73/aspnetcore-runtime-6.0.24-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/6f16b964-4971-4959-8a3f-75d04860d126/b1f3326dad38c5e992b020a253ccabd8/aspnetcore-runtime-6.0.24-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d38606f9-0adb-4df8-a0da-d49297c76846/a8796f1fb5e54735a4c8061359e3b9ed/aspnetcore-runtime-6.0.24-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d1b763b4-b4b1-4091-b2a5-3e8c292b57f8/871b6186164c7a83ef6823336639f846/aspnetcore-runtime-6.0.24-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f59f7502-4360-41bb-9f25-5af0491d3a8c/43781f10e4a25862684b56b5f3ebde46/aspnetcore-runtime-6.0.24-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/17e4c027-13a7-42ca-acdf-6b9fa3db730e/331681e7d8db4ccaa8770ca6a087066c/aspnetcore-runtime-6.0.24-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/2d151460-8311-4452-9a2e-dfb1447f2e9b/15c599ea357a0e4dc333d28b351f1c6c/dotnet-hosting-6.0.24-win.exe

[//]: # ( SDK 6.0.416)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2c8da3b8-66b9-4906-ba3c-cb536f5c46eb/b5c8900abce86499ce826798eb2fbef7/dotnet-sdk-6.0.416-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a56a7895-ec29-44fe-9fbf-3ea6a1bedd3d/47393de218098a0d63e9629b008abf07/dotnet-sdk-6.0.416-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9bd330eb-5bc6-43be-892c-79d5017a652b/65923c0e17ad2f98e340e5cba06be114/dotnet-sdk-6.0.416-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9a97f365-d320-40b9-9db7-a88b99e325f7/a9f94468149ca8ef16ef66af873fde5a/dotnet-sdk-6.0.416-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2dae5995-80c3-4420-9844-c44c6caf2f3e/7cf8f910373f165f84e715b1146aa84e/dotnet-sdk-6.0.416-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/675f1077-ab10-40cf-ac18-d146a14ea18a/522055f875b0a2474dacfa25729d3231/dotnet-sdk-6.0.416-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/94bf06c0-dcb8-45e6-bbce-c1a96f958e16/bd16f41a64771021877b52dccbba0161/dotnet-sdk-6.0.416-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ac99e470-ab07-4f1f-901a-3d14c9dd909d/a2a51c3f12ba268e22166cdeca54cc65/dotnet-sdk-6.0.416-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3b305e51-67fb-47cf-a916-700e62148324/1b71cd10822a3a1805008e212157a178/dotnet-sdk-6.0.416-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fd03f404-c806-4eae-9bda-0d002437c227/314b39bd905ad559bf38421d8184f0b1/dotnet-sdk-6.0.416-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/afaa9ecd-7997-42c1-a40b-91b72552dc57/93eaa9439ba54cbb05e632593c8a092c/dotnet-sdk-6.0.416-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/6be187bf-beca-4097-be7b-a45e70a87010/6a4b358d5a95c7da4d0fd0dba6a222d1/dotnet-sdk-6.0.416-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/bf047319-5b65-4630-b0f1-e7a8a7d40724/6c98f5732611a6ded7a9e62dc7bb2be1/dotnet-sdk-6.0.416-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e5f3c5bd-fb2d-4070-9893-fa3e852c5545/49dc01b583c1007561a3e51f898abe77/dotnet-sdk-6.0.416-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f3f85cd7-bee2-43ce-b0c7-edf5dcffa375/2ae120e6e5cfc484b3668509fba50270/dotnet-sdk-6.0.416-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1ca0fde6-1ff2-461c-8b35-dfb343b76e52/e27640bb1a9af2f6add4c1749caa4da1/dotnet-sdk-6.0.416-win-x86.zip
