# .NET 6.0.25 -November 14, 2023

The .NET 6.0.25, [.NET SDK 6.0.125](6.0.125.md), and [.NET SDK 6.0.320](6.0.320.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.417
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```
The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 6.0 Blog][dotnet-blog]

.NET 6.0.25 release carries security fixes.


[CVE-2023-36049 - .NET Elevation of Privilege Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36049)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 7.0 and .NET 8.0 RC2. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

An elevation of privilege vulnerability exists in .NET where untrusted URIs provided to System.Net.WebRequest.Create can be used to inject arbitrary commands to backend FTP servers.

[CVE-2023-36558 - .NET Security Feature Bypass Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36558)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core 6.0, ASP.NET Core 7.0 and, ASP.NET Core 8.0 RC2. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A security feature bypass vulnerability exists in ASP.NET where an unauthenticated user is able to bypass validation on Blazor server forms which could trigger unintended actions.


## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8910](https://github.com/dotnet/core/issues/8910) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.25.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.25-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.25-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/November-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.25
Microsoft.WindowsDesktop.App.Ref | 6.0.25
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.25
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.25
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.25
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.25
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.25
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.25
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.25
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.25
Microsoft.NETCore.App.Host.win-arm | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.25
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.25
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.25
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.25
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.25
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.25
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.25
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.25
Microsoft.NETCore.App.Host.osx-x64 | 6.0.25
Microsoft.NETCore.App.Host.win-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.25
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.25
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.25
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.25
Microsoft.NETCore.App.Host.linux-arm | 6.0.25
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.25
Microsoft.NETCore.App.Host.linux-x64 | 6.0.25
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.25
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.25
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.25
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.25
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.25
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.25
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.25
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.25
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.25
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.25
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.25
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.25
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.25
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.25
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.25
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64 | 6.0.25
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300 | 6.0.25
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86 | 6.0.25
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400 | 6.0.25
Microsoft.NETCore.App.Host.win-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.25
Microsoft.NETCore.App.Ref | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.25
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.25
Microsoft.NETCore.DotNetAppHost | 6.0.25
Microsoft.NETCore.DotNetHostPolicy | 6.0.25
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.25
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.25
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.25
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.25
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.25
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.25
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.25
System.Text.Json | 6.0.9
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.25
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.25
Microsoft.NETCore.App.Runtime.win-arm | 6.0.25
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.25
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.25
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.25
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.25
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.25
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.25
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.25
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.25
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.25
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.25
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.25
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.25
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.25
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.25
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.25
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.25
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.25
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.25
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.25
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.25
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.25
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.25
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Composite | 6.0.25
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.25
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64 | 6.0.25
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.25
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64 | 6.0.25
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.25
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.25
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.25
Microsoft.NETCore.App.Host.win-x86 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.25
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.25
Microsoft.NETCore.DotNetHost | 6.0.25
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.25
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.25
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.25
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.25
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.25
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.25
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.25
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.25
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.25
Microsoft.NETCore.DotNetHostResolver | 6.0.25
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.25
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.25
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.25
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.25
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.25
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.25
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.25
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.25
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.25
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.25
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.25
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.25
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.25
Microsoft.AspNetCore.Authorization | 6.0.25
Microsoft.AspNetCore.Authentication.Twitter | 6.0.25
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.25
Microsoft.AspNetCore.Components | 6.0.25
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.25
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.25
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.25
Microsoft.AspNetCore.Components.Web | 6.0.25
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.25
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.25
Microsoft.AspNetCore.Cryptography.Internal | 6.0.25
Microsoft.AspNetCore.Connections.Abstractions | 6.0.25
Microsoft.AspNetCore.DataProtection | 6.0.25
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.25
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.25
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.25
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.25
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.25
Microsoft.AspNetCore.HeaderPropagation | 6.0.25
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.25
Microsoft.AspNetCore.Identity.UI | 6.0.25
Microsoft.AspNetCore.Http.Connections.Client | 6.0.25
Microsoft.AspNetCore.Http.Connections.Common | 6.0.25
Microsoft.AspNetCore.JsonPatch | 6.0.25
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.25
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.25
Microsoft.AspNetCore.Mvc.Testing | 6.0.25
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.25
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.25
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.25
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.25
AspNetCoreRuntime.6.0.x64 | 6.0.25
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.25
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.25
Microsoft.Extensions.ApiDescription.Server | 6.0.25
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.25
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.25
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.25
Microsoft.Extensions.Features | 6.0.25
Microsoft.Extensions.FileProviders.Embedded | 6.0.25
Microsoft.Extensions.Identity.Core | 6.0.25
Microsoft.Extensions.Http.Polly | 6.0.25
Microsoft.Extensions.Identity.Stores | 6.0.25
Microsoft.Extensions.Localization | 6.0.25
Microsoft.Extensions.Localization.Abstractions | 6.0.25
Microsoft.Extensions.Logging.AzureAppServices | 6.0.25
Microsoft.Extensions.ObjectPool | 6.0.25
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.25
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.25
dotnet-sql-cache | 6.0.25
Microsoft.AspNetCore.Owin | 6.0.25
Microsoft.AspNetCore.Razor.Language | 6.0.25
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.25
Microsoft.AspNetCore.SignalR.Common | 6.0.25
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.25
Microsoft.CodeAnalysis.Razor | 6.0.25
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.25
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.25
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.25
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.25
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.25
Microsoft.AspNetCore.Authentication.Certificate | 6.0.25
Microsoft.AspNetCore.Authentication.Google | 6.0.25
Microsoft.AspNetCore.Authentication.Facebook | 6.0.25
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.25
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.25
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.25
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.25
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.25
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.25
Microsoft.AspNetCore.Components.Analyzers | 6.0.25
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.25
Microsoft.Extensions.WebEncoders | 6.0.25
Microsoft.JSInterop | 6.0.25
Microsoft.JSInterop.WebAssembly | 6.0.25
AspNetCoreRuntime.6.0.x86 | 6.0.25
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.25
Microsoft.AspNetCore.App.Ref | 6.0.25
Microsoft.AspNetCore.Components.Authorization | 6.0.25
Microsoft.AspNetCore.Components.Forms | 6.0.25
Microsoft.AspNetCore.Components.WebAssembly | 6.0.25
Microsoft.AspNetCore.Components.WebView | 6.0.25
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.25
Microsoft.AspNetCore.Metadata | 6.0.25
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.25
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.25
Microsoft.AspNetCore.SignalR.Client | 6.0.25
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.25
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.25
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.25
Microsoft.AspNetCore.SpaProxy | 6.0.25
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.25
Microsoft.AspNetCore.TestHost | 6.0.25
Microsoft.Authentication.WebAssembly.Msal | 6.0.25
Microsoft.dotnet-openapi | 6.0.25
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.25
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.25
Microsoft.Extensions.ApiDescription.Client | 6.0.25
Microsoft.Extensions.Caching.SqlServer | 6.0.25
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.25
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.25
Microsoft.DotNet.Common.ItemTemplates | 6.0.417
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.417
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.417
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.417
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.417
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.417
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.417
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.417
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.417
Microsoft.TemplateEngine.Core | 6.0.417
Microsoft.TemplateEngine.IDE | 6.0.417
Microsoft.TemplateEngine.Abstractions | 6.0.417
Microsoft.TemplateEngine.Core.Contracts | 6.0.417
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.417
Microsoft.TemplateEngine.Edge | 6.0.417
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.417
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.417
Microsoft.TemplateEngine.Utils | 6.0.417
Microsoft.TemplateSearch.Common | 6.0.417
FSharp.Compiler.Service | 41.0.7
FSharp.Core | 6.0.7
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.25
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.25
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64 | 6.0.25
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.25
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.25
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.25
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.25
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64 | 6.0.25
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.25
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86 | 6.0.25
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.25
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.25
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.25
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64 | 6.0.25
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64 | 6.0.25
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400 | 6.0.25
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64 | 6.0.25
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64 | 6.0.25
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86 | 6.0.25
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.25
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.25
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.25
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.25
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64 | 6.0.25
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.25
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300 | 6.0.25
dotnet-ef | 6.0.25
Microsoft.EntityFrameworkCore | 6.0.25
Microsoft.EntityFrameworkCore.Abstractions | 6.0.25
Microsoft.EntityFrameworkCore.Cosmos | 6.0.25
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.25
Microsoft.EntityFrameworkCore.Analyzers | 6.0.25
Microsoft.EntityFrameworkCore.Proxies | 6.0.25
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.25
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.25
Microsoft.EntityFrameworkCore.SqlServer | 6.0.25
Microsoft.EntityFrameworkCore.Sqlite | 6.0.25
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.25
Microsoft.EntityFrameworkCore.Tools | 6.0.25
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.25
Microsoft.Data.Sqlite.Core | 6.0.25
Microsoft.Data.Sqlite | 6.0.25
Microsoft.EntityFrameworkCore.Relational | 6.0.25
Microsoft.EntityFrameworkCore.Design | 6.0.25
Microsoft.EntityFrameworkCore.InMemory | 6.0.25
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.25
Microsoft.TemplateEngine.Abstractions | 6.0.125
Microsoft.TemplateEngine.Core | 6.0.125
Microsoft.TemplateEngine.IDE | 6.0.125
Microsoft.TemplateEngine.Utils | 6.0.125
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.125
Microsoft.TemplateSearch.Common | 6.0.125
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.125
Microsoft.DotNet.Common.ItemTemplates | 6.0.125
Microsoft.TemplateEngine.Core.Contracts | 6.0.125
Microsoft.TemplateEngine.Edge | 6.0.125
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.125
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.125
Microsoft.DotNet.Compatibility | 1.0.0-servicing.23523.37
Microsoft.TemplateEngine.Utils | 6.0.320
Microsoft.TemplateEngine.Edge | 6.0.320
Microsoft.TemplateEngine.IDE | 6.0.320
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.320
Microsoft.DotNet.Common.ItemTemplates | 6.0.320
Microsoft.TemplateEngine.Abstractions | 6.0.320
Microsoft.TemplateEngine.Core.Contracts | 6.0.320
Microsoft.TemplateEngine.Core | 6.0.320
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.320
Microsoft.TemplateSearch.Common | 6.0.320
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.320
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.320
FSharp.Compiler.Service | 41.0.5
FSharp.Core | 6.0.5

[//]: # ( Runtime 6.0.25)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bcc7110a-a76f-405c-a563-be1658136d7d/770dbe55fd315be7254166747a96e21f/dotnet-runtime-6.0.25-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c5ebe66a-1815-4cdf-a099-af89dbf370b8/8162d0068512e14f69325d18ce10acb3/dotnet-runtime-6.0.25-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/485f2b5d-be74-4731-ae40-59ea5a890f38/e5d7cee2bf37e72081bcd855c44ca3bb/dotnet-runtime-6.0.25-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/914eb79c-36f6-45c3-9213-ace71f41188c/30764f52a6baf659a495d753ae889ca0/dotnet-runtime-6.0.25-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bffc3e31-f40e-4dbd-ad02-37efa3f1a4a7/3d8d26b93cb8f78330b8a781fea4aa0b/dotnet-runtime-6.0.25-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0e8de3f9-7fda-46b7-9337-a3709c8e385d/bc29c53eb79fda25abb0fb9be60c6a22/dotnet-runtime-6.0.25-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1d0efabd-953a-44db-9e8e-5516d9c3f7cd/e4d405c3cd216ae471fb22c139b5c153/dotnet-runtime-6.0.25-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5bb1393b-ffe1-4961-8d42-7272611a0399/6cb74b96d854a95fe4d42c62d359427c/dotnet-runtime-6.0.25-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f66ae4da-025f-49bb-b0b9-25e427e6a788/6472b834c6780084eff11fd798308380/dotnet-runtime-6.0.25-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bb33d6bf-748c-47b0-8077-962fef12afc8/8a0fbc979b8bded0b4538d08e8f92916/dotnet-runtime-6.0.25-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/029addec-0abe-4761-b1b0-f9ef8b8680c3/c1b9fe178e0eb08a2c38cd3e00202226/dotnet-runtime-6.0.25-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/98dc8b8f-0a00-4adc-a7d7-469ccb6aba9c/c5defc235ab8e73716a4dbcc46e4526c/dotnet-runtime-6.0.25-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/955c1f8b-93d8-4c32-9380-6dd18f69a135/44efbec986e7d078395ba9e45cf0e607/dotnet-runtime-6.0.25-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d0eb988c-2e83-491c-b6f9-1af4c4d113af/43656032bb9e515d85818c87ba91ba86/dotnet-runtime-6.0.25-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/af5234d4-8cf2-4f95-895a-cc9c5ce9f904/0bfee492f05b560030716ee066dce3fb/dotnet-runtime-6.0.25-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b6ae306f-17f7-442c-a202-54803b12485d/b37005edf0d03214fa67436d140a7813/dotnet-runtime-6.0.25-win-x86.zip

[//]: # ( WindowsDesktop 6.0.25)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b87f26d1-3e82-4df1-983a-42300f6830ec/24feae0309a1c6cd0fc8c10a20f3bdce/windowsdesktop-runtime-6.0.25-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/1eb613c0-6c2d-4fa0-ad9c-38b6e540b6a7/a0e0354e8d72ee904d20ee4e9610733e/windowsdesktop-runtime-6.0.25-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/52d6ef78-d4ec-4713-9e01-eb8e77276381/e58f307cda1df61e930209b13ecb47a4/windowsdesktop-runtime-6.0.25-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5a48ce29-1f12-46f0-b41e-0fb1bcd31e17/a08bbffdd131b3cb71a9d34f98f20a9b/windowsdesktop-runtime-6.0.25-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/33eced41-f212-46df-bb2f-12d4b891e667/f55a4581dd72a971f21e9562816c7430/windowsdesktop-runtime-6.0.25-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9211773c-3f7a-470b-9e8e-9e6fd2596327/80982bbfe8f600b6687a44b2a67df075/windowsdesktop-runtime-6.0.25-win-x86.zip

[//]: # ( ASP 6.0.25)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/88cf902b-08e0-4329-b2cf-7d0ab104d97d/287edc7e830d810424d62f6efc5c577a/aspnetcore-runtime-6.0.25-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8f085f4e-ce83-494f-add1-7e6d4e04f90e/398b661de84bda4d74b5c04fa709eadb/aspnetcore-runtime-6.0.25-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a99de040-6c21-4777-a3b5-82b6c79b541d/86293126c8ba97985fd4aefb6e7916d1/aspnetcore-runtime-6.0.25-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/265ec8c4-ee67-4139-bf6d-d511c26fcfe9/decead6225b9f9b28d556f655a4c3d97/aspnetcore-runtime-6.0.25-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8b0e3dbe-e970-4e8c-b4fd-db5245c8c021/c523986a6d8b880e5bac1a11a87c88a8/aspnetcore-runtime-6.0.25-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0cf64d28-dec3-4553-b38d-8f526e6f64b0/0bf8e79d48da8cb4913bc1c969653e9a/aspnetcore-runtime-6.0.25-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fab54ac5-5712-4c94-b9a7-68e18533b8ee/8197e36c3a2522e233e4d66c3a7b098b/aspnetcore-runtime-6.0.25-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eb5d3ec0-10d3-4ed4-986a-9b350f200d7c/e59374e45f5f1be3c111f53c7e2ebb32/aspnetcore-runtime-6.0.25-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/baa266e8-e19f-40e5-99b7-4200d61e831b/d6ff0858da413afbee6d9974912b1ac1/aspnetcore-runtime-6.0.25-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/dc41dbfc-0cb2-453b-8e13-b96df87ec639/80632cb579c5dd86842224b9e6304221/aspnetcore-runtime-6.0.25-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4153c9e0-4ac6-4bdd-aaf3-717f2d553514/42166423785c7b0ce406f6ddd4eea521/aspnetcore-runtime-6.0.25-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/25974def-24fd-4155-af11-7bf477cc1c7f/21f5291090d9d4040ad8522bbdf00cc6/aspnetcore-runtime-6.0.25-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/3277a575-e25f-470b-8c07-148e557af3b9/7a54737c606ad446e2389d4c8234633b/aspnetcore-runtime-6.0.25-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/1fd87564-6bdb-4123-90dd-26488ec868c9/6c68988c310805bdcbb07b704fbe3e9d/dotnet-hosting-6.0.25-win.exe

[//]: # ( SDK 6.0.417)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a72dea03-21fd-48c6-bf0c-78e621b60514/e0b8f186730fce858eb1bffc83c9e41c/dotnet-sdk-6.0.417-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/03972b46-ddcd-4529-b8e0-df5c1264cd98/285a1f545020e3ddc47d15cf95ca7a33/dotnet-sdk-6.0.417-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/37dc096f-4efe-4bc6-8045-cc3a53a131e2/cdd7d98a70619e5cd347075912934f92/dotnet-sdk-6.0.417-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c568be55-76ca-4c8f-9dca-44ae658e43d2/478dad8a73eefcf8becd54f8645a0e19/dotnet-sdk-6.0.417-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1d40d62c-fe35-485e-9d69-106841119ae0/ea71178f19edb282afe9ad1d64ad2e15/dotnet-sdk-6.0.417-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1cac4d08-3025-4c00-972d-5c7ea446d1d7/a83bc5cbedf8b90495802ccfedaeb2e6/dotnet-sdk-6.0.417-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/47808287-f432-4d37-8ca3-d7aca6b12e8b/9ae7559421a9c44ba334e996701f6b8a/dotnet-sdk-6.0.417-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f82f1323-a530-4dcd-9488-c73443f35198/e59be6f142903e5d562143b1ae8f2155/dotnet-sdk-6.0.417-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c5479676-0268-4f47-84bb-10fdf00b8baf/f74ac823e3bcb54beed5a0fb4a5813d2/dotnet-sdk-6.0.417-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c271e475-c02a-4c95-a3d2-d276ede0ba74/8eee5d06d92ed4ae73083aa55b1270a8/dotnet-sdk-6.0.417-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/e75544b9-d9ca-4499-bf9d-841af4a07453/c0e6fcfb163ac910be085896ef1cbb60/dotnet-sdk-6.0.417-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0b4d9110-d2ad-4438-81b9-f713652ef883/4dd728f44509797acb09e48c4887faa2/dotnet-sdk-6.0.417-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/81531ad6-afa9-4b61-9d05-6a76dce81123/2885d26c1a58f37176fd7859f8cc80f1/dotnet-sdk-6.0.417-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9fdcd0fd-467c-43ee-b118-1f163533e8f1/f1031bccbf9327fc69f4bf5826d557f3/dotnet-sdk-6.0.417-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/99c8b10d-f835-4aab-b952-81617a50d21c/413f3d0fe256a9551f4e5204021dfb14/dotnet-sdk-6.0.417-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9e5c8dcc-db95-4292-9f71-5ea766ca2428/35ae59d27e8b025b567258c5843b9099/dotnet-sdk-6.0.417-win-x86.zip
