# .NET 6.0.26 - January 09, 2024

The .NET 6.0.26, [.NET SDK 6.0.126](6.0.126.md), and [.NET SDK 6.0.321](6.0.321.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.418
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```
The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 6.0 Blog][dotnet-blog]

.NET 6.0.26 release carries security fixes.


[CVE-2024-0056 - Microsoft.Data.SqlClient and System.Data.SqlClient SQL Data provider Information Disclosure Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-0056)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET's System.Data.SqlClient and Microsoft.Data.SqlClient NuGet Packages. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A vulnerability exists in the Microsoft.Data.SqlClient and System.Data.SqlClient SQL Data provider where an attackercan perform an AiTM (adversary-in-the-middle) attack between the SQL client and the SQL server. This may allow the attacker to steal authentication credentials intended for the database server, even if the connection is established over an encrypted channel like TLS.

[CVE-2024-0057- .NET Security Feature bypass Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36049)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 7.0 and .NET 8.0 . This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A security feature bypass vulnerability exists when Microsoft .NET Framework-based applications use X.509 chain building APIs but do not completely validate the X.509 certificate due to a logic flaw. An attacker could present an arbitrary untrusted certificate with malformed signatures, triggering a bug in the framework. The framework will correctly report that X.509 chain building failed, but it will return an incorrect reason code for the failure. Applications which utilize this reason code to make their own chain building trust decisions may inadvertently treat this scenario as a successful chain build. This could allow an adversary to subvert the app's typical authentication logic.

[CVE-2024-21319 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-21319)

Microsoft is releasing this security advisory to provide information about a vulnerability in the ASP.NET Core project templates. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A Denial of Service vulnerability exists in ASP.NET Core project templates which utilize JWT-based authentication tokens. This vulnerability allows an unauthenticated client to consume arbitrarily large amounts of server memory, potentially triggering an out-of-memory condition on the server and making the server no longer able to respond to legitimate requests.

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9052](https://github.com/dotnet/core/issues/9052) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.26.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.26-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.26-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/January-2024-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.26
Microsoft.WindowsDesktop.App.Ref | 6.0.26
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.26
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.26
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.26
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.26
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.26
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.26
Microsoft.NETCore.App.Composite | 6.0.26
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.26
Microsoft.NETCore.App.Host.linux-arm | 6.0.26
Microsoft.NETCore.App.Ref | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.26
Microsoft.NETCore.DotNetHostResolver | 6.0.26
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.26
Microsoft.NETCore.App.Host.linux-x64 | 6.0.26
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.26
Microsoft.NETCore.App.Host.win-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.26
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.26
Microsoft.NETCore.DotNetHost | 6.0.26
Microsoft.NETCore.DotNetHostPolicy | 6.0.26
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.26
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.26
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.26
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.26
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.26
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.26
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.26
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.26
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.26
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.26
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.26
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.26
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.26
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64 | 6.0.26
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300 | 6.0.26
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400 | 6.0.26
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86 | 6.0.26
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.26
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.26
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.26
Microsoft.NETCore.App.Host.win-x86 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.26
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.26
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.26
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.26
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.26
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.26
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.26
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.26
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.26
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.26
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.26
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.26
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.26
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.26
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.26
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.26
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.26
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.26
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.26
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.26
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.26
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.26
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.26
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.26
Microsoft.NETCore.App.Host.win-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.26
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.26
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.26
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.26
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.26
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86 | 6.0.26
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.26
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.26
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.26
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.26
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.26
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.26
Microsoft.NETCore.DotNetAppHost | 6.0.26
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.26
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.26
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.26
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.26
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.26
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.26
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.26
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.26
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.26
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.26
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.26
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.26
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.26
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.26
Microsoft.NETCore.App.Host.osx-x64 | 6.0.26
Microsoft.NETCore.App.Host.win-arm | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.26
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.win-arm | 6.0.26
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.26
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.26
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.26
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.26
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.26
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.26
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.26
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.26
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.26
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.26
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.26
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.26
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.26
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.26
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.26
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.26
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.26
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.26
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.26
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.26
AspNetCoreRuntime.6.0.x64 | 6.0.26
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.26
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.26
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.26
Microsoft.AspNetCore.Razor.Language | 6.0.26
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.26
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.26
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.26
Microsoft.AspNetCore.TestHost | 6.0.26
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.26
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.26
AspNetCoreRuntime.6.0.x86 | 6.0.26
Microsoft.AspNetCore.Authentication.Certificate | 6.0.26
Microsoft.AspNetCore.Authentication.Facebook | 6.0.26
Microsoft.AspNetCore.Authentication.Google | 6.0.26
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.26
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.26
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.26
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.26
Microsoft.AspNetCore.Authentication.Twitter | 6.0.26
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.26
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.26
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.26
Microsoft.AspNetCore.DataProtection | 6.0.26
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.26
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.26
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.26
Microsoft.AspNetCore.SpaProxy | 6.0.26
Microsoft.Extensions.ApiDescription.Server | 6.0.26
Microsoft.dotnet-openapi | 6.0.26
Microsoft.Authentication.WebAssembly.Msal | 6.0.26
Microsoft.Extensions.ApiDescription.Client | 6.0.26
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.26
Microsoft.Extensions.Caching.SqlServer | 6.0.26
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.26
Microsoft.Extensions.WebEncoders | 6.0.26
Microsoft.JSInterop.WebAssembly | 6.0.26
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.26
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.26
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.26
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.26
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.26
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.26
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.26
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.26
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.26
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.26
Microsoft.AspNetCore.Components.Authorization | 6.0.26
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.26
Microsoft.AspNetCore.Connections.Abstractions | 6.0.26
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.26
Microsoft.AspNetCore.Cryptography.Internal | 6.0.26
Microsoft.AspNetCore.Http.Connections.Client | 6.0.26
Microsoft.AspNetCore.HeaderPropagation | 6.0.26
Microsoft.AspNetCore.Identity.UI | 6.0.26
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.26
Microsoft.AspNetCore.Http.Connections.Common | 6.0.26
Microsoft.AspNetCore.JsonPatch | 6.0.26
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.26
Microsoft.AspNetCore.SignalR.Client | 6.0.26
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.26
Microsoft.AspNetCore.SignalR.Common | 6.0.26
Microsoft.CodeAnalysis.Razor | 6.0.26
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.26
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.26
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.26
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.26
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.26
Microsoft.Extensions.Features | 6.0.26
Microsoft.JSInterop | 6.0.26
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.26
dotnet-sql-cache | 6.0.26
Microsoft.AspNetCore.App.Ref | 6.0.26
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.26
Microsoft.AspNetCore.Authorization | 6.0.26
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.26
Microsoft.AspNetCore.Components | 6.0.26
Microsoft.AspNetCore.Components.Analyzers | 6.0.26
Microsoft.AspNetCore.Components.Forms | 6.0.26
Microsoft.AspNetCore.Components.Web | 6.0.26
Microsoft.AspNetCore.Components.WebAssembly | 6.0.26
Microsoft.AspNetCore.Components.WebView | 6.0.26
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.26
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.26
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.26
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.26
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.26
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.26
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.26
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.26
Microsoft.AspNetCore.Metadata | 6.0.26
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.26
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.26
Microsoft.AspNetCore.Mvc.Testing | 6.0.26
Microsoft.AspNetCore.Owin | 6.0.26
Microsoft.Extensions.Identity.Core | 6.0.26
Microsoft.Extensions.FileProviders.Embedded | 6.0.26
Microsoft.Extensions.Http.Polly | 6.0.26
Microsoft.Extensions.Identity.Stores | 6.0.26
Microsoft.Extensions.Localization.Abstractions | 6.0.26
Microsoft.Extensions.Localization | 6.0.26
Microsoft.Extensions.Logging.AzureAppServices | 6.0.26
Microsoft.Extensions.ObjectPool | 6.0.26
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.321
Microsoft.TemplateEngine.IDE | 6.0.321
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.321
Microsoft.TemplateEngine.Edge | 6.0.321
Microsoft.TemplateEngine.Core | 6.0.321
Microsoft.TemplateEngine.Core.Contracts | 6.0.321
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.321
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.321
Microsoft.DotNet.Common.ItemTemplates | 6.0.321
Microsoft.TemplateEngine.Abstractions | 6.0.321
Microsoft.TemplateEngine.Utils | 6.0.321
Microsoft.TemplateSearch.Common | 6.0.321
FSharp.Compiler.Service | 41.0.5
FSharp.Core | 6.0.5
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.26
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.26
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.26
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.26
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.26
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300 | 6.0.26
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64 | 6.0.26
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.26
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.26
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64 | 6.0.26
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.26
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.26
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64 | 6.0.26
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.26
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64 | 6.0.26
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64 | 6.0.26
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.26
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86 | 6.0.26
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.26
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.26
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86 | 6.0.26
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64 | 6.0.26
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64 | 6.0.26
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.26
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.26
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400 | 6.0.26
Microsoft.Data.Sqlite | 6.0.26
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.26
Microsoft.EntityFrameworkCore.Sqlite | 6.0.26
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.26
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.26
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.26
Microsoft.EntityFrameworkCore.Tools | 6.0.26
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.26
Microsoft.EntityFrameworkCore.Relational | 6.0.26
dotnet-ef | 6.0.26
Microsoft.EntityFrameworkCore.Cosmos | 6.0.26
Microsoft.EntityFrameworkCore.Abstractions | 6.0.26
Microsoft.Data.Sqlite.Core | 6.0.26
Microsoft.EntityFrameworkCore | 6.0.26
Microsoft.EntityFrameworkCore.Analyzers | 6.0.26
Microsoft.EntityFrameworkCore.Design | 6.0.26
Microsoft.EntityFrameworkCore.Proxies | 6.0.26
Microsoft.EntityFrameworkCore.InMemory | 6.0.26
Microsoft.EntityFrameworkCore.SqlServer | 6.0.26
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.26
Microsoft.TemplateEngine.Abstractions | 6.0.418
Microsoft.TemplateEngine.Core.Contracts | 6.0.418
Microsoft.TemplateEngine.Edge | 6.0.418
Microsoft.TemplateEngine.IDE | 6.0.418
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.418
Microsoft.DotNet.Common.ItemTemplates | 6.0.418
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.418
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.418
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.418
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.418
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.418
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.418
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.418
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.418
Microsoft.TemplateEngine.Core | 6.0.418
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.418
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.418
Microsoft.TemplateEngine.Utils | 6.0.418
Microsoft.TemplateSearch.Common | 6.0.418
FSharp.Core | 6.0.7
FSharp.Compiler.Service | 41.0.7
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.126
Microsoft.TemplateEngine.Utils | 6.0.126
Microsoft.TemplateSearch.Common | 6.0.126
Microsoft.DotNet.Common.ItemTemplates | 6.0.126
Microsoft.TemplateEngine.Core | 6.0.126
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.126
Microsoft.TemplateEngine.Abstractions | 6.0.126
Microsoft.TemplateEngine.Core.Contracts | 6.0.126
Microsoft.TemplateEngine.IDE | 6.0.126
Microsoft.TemplateEngine.Edge | 6.0.126
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.126
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.126
Microsoft.DotNet.Compatibility | 1.0.0-servicing.23605.37

[//]: # ( Runtime 6.0.26)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c6398027-c209-42e3-900c-22b4f32d2cde/437e26f725761e4cf50b8ceba8a7a454/dotnet-runtime-6.0.26-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/226d8ab0-8daf-47b1-80cb-a9b68badb28b/a4425bebee91775ce41a50aca80e09c1/dotnet-runtime-6.0.26-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/80749fa2-4c42-4b7a-82d3-f02df3215bdc/f93db5b5ab7b5919b22a3010ad38104d/dotnet-runtime-6.0.26-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ad122bf5-aa69-46db-9ecd-33cdc2cfde39/418cb2e7c2b6ab619c06bd757321651e/dotnet-runtime-6.0.26-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/43ab2539-eb8a-477c-b97f-6b4eac1b4dc4/b0f10fdaca435d6f3d7fdb11cb499d03/dotnet-runtime-6.0.26-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1873e7f3-aa12-4189-8d6d-db0fb859211e/b36e8f8a6ceb63bc3cfac875c7bb63d0/dotnet-runtime-6.0.26-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/359b63fb-ccc4-424e-8b66-c55a38b26282/f5e656f57fbfdc5dd3eba07cfcc3184a/dotnet-runtime-6.0.26-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d76c6416-5a6d-42c0-99b0-a4bb0021426b/84ef0457a893dbf0d565a532fa9dd805/dotnet-runtime-6.0.26-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c702eda6-452f-47a6-bf78-1894c0af34dd/6f3585ce50b92e812aed66f27c95f310/dotnet-runtime-6.0.26-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/51703c07-2cf0-415f-abbd-5d4bf2ffd56a/fc952db2ecb119fa2d58828d1046f974/dotnet-runtime-6.0.26-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a919d290-d7b9-495a-8b89-9826735ed2c3/47f467fc4e46200553392532cd869acc/dotnet-runtime-6.0.26-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/3c3aeda5-33aa-4df6-ab78-936aa2d721de/3a3f7b22402dfa03634aa757d4b1714f/dotnet-runtime-6.0.26-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7d3cdd04-9db8-41db-bc86-4af63f9edd4a/8899ff776eed41b3f5376bfc09913c36/dotnet-runtime-6.0.26-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/62025cf7-35ad-4be2-a3dd-fc865f038c65/bfa6ccaa29f57797ca518c7110624209/dotnet-runtime-6.0.26-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b9e43719-f3ce-4b04-9012-db2761d86407/a726c1eac3b8c2086a067406dae91bfa/dotnet-runtime-6.0.26-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/db577d7b-2b22-482e-a1ba-b9b3e0ea92ca/186b7a3bbf919b3449bf31e2cc35e000/dotnet-runtime-6.0.26-win-x86.zip

[//]: # ( WindowsDesktop 6.0.26)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/1f071ba6-9c5d-4b94-9c77-b21b626daa98/947231a2e1151ddc7dfd4ed50a8815a8/windowsdesktop-runtime-6.0.26-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/7c729a5b-30e3-475e-b449-ec1b14ccd633/cdb326c447af7268431c42eda73f7d64/windowsdesktop-runtime-6.0.26-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3136e217-e5b7-4899-9b7e-aa52ecb8b108/d74134edaa75e3300f8692660b9fb7b5/windowsdesktop-runtime-6.0.26-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f033dac5-3326-4ef7-a492-4a39bb5f10ec/ae8eeb93ede7a6fa0ce158fb4e9fb077/windowsdesktop-runtime-6.0.26-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d6835aa3-6ec4-47ec-a5a5-9052ed310e4f/c1171996e95717bf532475f4546e479c/windowsdesktop-runtime-6.0.26-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6df04511-4d7e-4525-ab95-1ecdc145e6fc/223cf72dd45fb9effbdb47192a8cc730/windowsdesktop-runtime-6.0.26-win-x86.zip

[//]: # ( ASP 6.0.26)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1d42ac0-cd0c-4188-b260-1667a7443534/f0d1a0b4b88432f1c8d31b467d8548f0/aspnetcore-runtime-6.0.26-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cfc40e77-a6de-481f-812d-6867289e2d8b/eeedeebccc412fd01110d8b59050754d/aspnetcore-runtime-6.0.26-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/43311ea0-98a0-4bb7-8c71-ae3ca1773597/3e4d007ad8e8d85b1b9d18a8f6753548/aspnetcore-runtime-6.0.26-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e0861e57-ef72-4ec0-b019-80eb7dc7c585/cee537a2a13d774ee8bc2ec458dbb087/aspnetcore-runtime-6.0.26-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2611b613-ca44-465d-8ca6-8a8b1dbea477/e277ab58a0c26bb2ac7fa3df4505a810/aspnetcore-runtime-6.0.26-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b63daa46-51f4-480e-ad03-ef2c5a6a2885/ae059763456991305109bf98b3a67640/aspnetcore-runtime-6.0.26-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e5181497-c33a-4341-a5a6-57eb21f39d33/85b574ef2b884f084b604d1869d72c02/aspnetcore-runtime-6.0.26-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/19e27b0b-cd99-4b84-bc7a-05eda52bd77f/a85cbbb13b629b75b2026bb8c6238e6e/aspnetcore-runtime-6.0.26-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/19aee804-2e3f-468f-950d-f82253d43320/c8865861d1c773556e24a1206ee1760a/aspnetcore-runtime-6.0.26-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/504867be-8cc2-4982-a4a6-5d3596835347/1868f16e22e6c13795d397fead4b9545/aspnetcore-runtime-6.0.26-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0f7eb7e4-55e4-42f6-9cc3-eb70d04d9eab/5f4fae21258debd63b597738605466d5/aspnetcore-runtime-6.0.26-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a9326bbe-0d19-4980-af79-58095f22e956/fade24808fb03539ace50016367f3350/aspnetcore-runtime-6.0.26-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a347a3f7-9579-4d5a-821b-b00a2314aeaf/53cb343a4c59934663ec02fca623f1a5/aspnetcore-runtime-6.0.26-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/16e13e4d-a240-4102-a460-3f4448afe1c3/3d832f15255d62bee8bc86fed40084ef/dotnet-hosting-6.0.26-win.exe

[//]: # ( SDK 6.0.418)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2088d482-4a99-4dfd-96d8-01438439f088/31d073266c6d390c7082d01492c87ec2/dotnet-sdk-6.0.418-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/487a62cc-de86-4648-bcf4-18a02b0f4ccc/669d92e679215646badef80782d32bff/dotnet-sdk-6.0.418-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b1456738-0c9d-4f6c-8b7e-d9b1f5ffaeff/f2c683552a9c4a42a74f7e263fce30d9/dotnet-sdk-6.0.418-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d2604a0d-b881-48a6-b6ee-ff87b7ea823b/695e61cc3e2e239e3f4226c322f690c0/dotnet-sdk-6.0.418-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/39d4fd37-6c87-4e48-9160-be46903a8048/6d5ba12bd99f5875e127eea8e972e219/dotnet-sdk-6.0.418-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/01292c7c-a1ec-4957-90fc-3f6a2a1e5edc/025e84c4d9bd4aeb003d4f07b42e9159/dotnet-sdk-6.0.418-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/40173cfc-efa9-47e4-83d9-806839c7be01/4242d0be35aec95d7c1e395520edbf38/dotnet-sdk-6.0.418-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/20977215-ff63-458a-ba19-43e93456b76e/bd58619144624cc66ac451d9c3bd5f5a/dotnet-sdk-6.0.418-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ba81dbfc-1340-403a-b5c0-4fb36702e9d7/b001ed59b2abe972a5cb9238f2a873b1/dotnet-sdk-6.0.418-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0cce8cdf-fcdf-453e-9346-96abbe76ba6e/79047571e41085ddbef25c25540b40a8/dotnet-sdk-6.0.418-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/14902549-0414-40d0-8584-44eecb84da59/a75f21ba2b33eb381a637e03725e0eed/dotnet-sdk-6.0.418-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/cd17618c-a475-408b-8429-1efdb4255844/83a3b7dac08d00dd0a284337f97202b8/dotnet-sdk-6.0.418-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9b8baa92-04f4-4b1a-8ccd-aa6bf31592bc/3a25c73326e060e04c119264ba58d0d5/dotnet-sdk-6.0.418-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a33e6436-92cf-4659-9dfd-8ccbfde6255e/39f2eb8d138db0053747e1e530b56475/dotnet-sdk-6.0.418-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1e096f07-42cb-4a18-9bf2-164657d4b451/e8473d0791e95b881ef27b9f75d92edb/dotnet-sdk-6.0.418-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1ed63007-e2d9-4a20-bb66-c68ee3acfaf9/bac28130e56fd9216d9ca7475c0e89b3/dotnet-sdk-6.0.418-win-x86.zip
