# .NET 6.0.27 - February 13, 2024

The .NET 6.0.27, [.NET SDK 6.0.127](6.0.127.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.419
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```
The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 6.0 Blog][dotnet-blog]

.NET 6.0.27 release carries security fixes.

[CVE-2024-21386 | .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-21386)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET 6.0, ASP.NET 7.0 and, ASP.NET 8.0. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A vulnerability exists in ASP.NET applications using SignalR where a malicious client can result in a denial-of-service.

[CVE-2024-21404 | .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-21404)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 7.0 and .NET 8.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial-of-service vulnerability exists in .NET with OpenSSL support when parsing X509 certificates.

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9163](https://github.com/dotnet/core/issues/9163) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.27.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.27-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.27-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/February-2024-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.27
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.27
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.27
Microsoft.WindowsDesktop.App.Ref | 6.0.27
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.27
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.27
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.27
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.27
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.27
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.27
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.27
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.27
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.27
Microsoft.NETCore.App.Host.win-arm | 6.0.27
Microsoft.NETCore.App.Host.win-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.27
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.27
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.27
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.27
Microsoft.NETCore.App.Host.linux-x64 | 6.0.27
Microsoft.NETCore.App.Host.win-x86 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Composite | 6.0.27
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.27
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.27
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400 | 6.0.27
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64 | 6.0.27
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.27
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.27
Microsoft.NETCore.App.Host.linux-arm | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.27
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.27
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.27
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.27
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.27
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.27
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.27
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.27
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.27
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.27
Microsoft.NETCore.App.Host.osx-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.win-arm | 6.0.27
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.27
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.27
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.27
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.27
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.27
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.27
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.27
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.27
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.27
Microsoft.NETCore.App.Ref | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.27
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.27
Microsoft.NETCore.DotNetHostPolicy | 6.0.27
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.27
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.27
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.27
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.27
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Host.win-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.27
Microsoft.NETCore.DotNetHost | 6.0.27
Microsoft.NETCore.DotNetAppHost | 6.0.27
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.27
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.27
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.27
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.27
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.27
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.27
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.27
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.27
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.27
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.27
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.27
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.27
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.27
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.27
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.27
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.27
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.27
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.27
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.27
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.27
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.27
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.27
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.27
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.27
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.27
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.27
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.27
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.27
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.27
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300 | 6.0.27
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64 | 6.0.27
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86 | 6.0.27
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.27
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.27
Microsoft.NETCore.DotNetHostResolver | 6.0.27
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.27
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.27
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.27
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.27
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.27
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.27
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.27
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.27
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.27
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.27
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.27
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.27
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.27
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.27
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.27
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.27
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.27
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.27
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.27
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.27
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.27
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.27
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.27
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.27
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.27
dotnet-sql-cache | 6.0.27
AspNetCoreRuntime.6.0.x86 | 6.0.27
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.27
Microsoft.AspNetCore.App.Ref | 6.0.27
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.27
Microsoft.AspNetCore.Authentication.Certificate | 6.0.27
Microsoft.AspNetCore.Authentication.Facebook | 6.0.27
Microsoft.AspNetCore.Components.Authorization | 6.0.27
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.27
Microsoft.AspNetCore.Components.Analyzers | 6.0.27
Microsoft.AspNetCore.Components.Forms | 6.0.27
Microsoft.AspNetCore.Components.Web | 6.0.27
Microsoft.AspNetCore.Components.WebAssembly | 6.0.27
Microsoft.AspNetCore.Connections.Abstractions | 6.0.27
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.27
Microsoft.AspNetCore.DataProtection | 6.0.27
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.27
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.27
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.27
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.27
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.27
Microsoft.Extensions.Caching.SqlServer | 6.0.27
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.27
Microsoft.Extensions.Localization.Abstractions | 6.0.27
Microsoft.Extensions.Identity.Stores | 6.0.27
Microsoft.Extensions.WebEncoders | 6.0.27
Microsoft.JSInterop | 6.0.27
Microsoft.JSInterop.WebAssembly | 6.0.27
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.27
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.27
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.27
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.27
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.27
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.27
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.27
Microsoft.AspNetCore.Identity.UI | 6.0.27
Microsoft.AspNetCore.Http.Connections.Client | 6.0.27
Microsoft.AspNetCore.Metadata | 6.0.27
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.27
Microsoft.AspNetCore.SignalR.Client | 6.0.27
Microsoft.AspNetCore.SignalR.Common | 6.0.27
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.27
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.27
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.27
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.27
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.27
Microsoft.AspNetCore.Http.Connections.Common | 6.0.27
Microsoft.AspNetCore.JsonPatch | 6.0.27
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.27
Microsoft.AspNetCore.Mvc.Testing | 6.0.27
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.27
Microsoft.AspNetCore.Owin | 6.0.27
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.27
Microsoft.AspNetCore.Razor.Language | 6.0.27
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.27
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.27
Microsoft.Extensions.Logging.AzureAppServices | 6.0.27
Microsoft.Extensions.ObjectPool | 6.0.27
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.27
AspNetCoreRuntime.6.0.x64 | 6.0.27
Microsoft.AspNetCore.Authentication.Google | 6.0.27
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.27
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.27
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.27
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.27
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.27
Microsoft.AspNetCore.Authentication.Twitter | 6.0.27
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.27
Microsoft.AspNetCore.Authorization | 6.0.27
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.27
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.27
Microsoft.AspNetCore.Components.WebView | 6.0.27
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.27
Microsoft.AspNetCore.Cryptography.Internal | 6.0.27
Microsoft.AspNetCore.HeaderPropagation | 6.0.27
Microsoft.CodeAnalysis.Razor | 6.0.27
Microsoft.Extensions.ApiDescription.Client | 6.0.27
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.27
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.27
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.27
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.27
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.27
Microsoft.Extensions.FileProviders.Embedded | 6.0.27
Microsoft.Extensions.Http.Polly | 6.0.27
Microsoft.Extensions.Features | 6.0.27
Microsoft.Extensions.Identity.Core | 6.0.27
Microsoft.Extensions.Localization | 6.0.27
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.27
Microsoft.AspNetCore.Components | 6.0.27
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.27
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.27
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.27
Microsoft.AspNetCore.TestHost | 6.0.27
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.27
Microsoft.AspNetCore.SpaProxy | 6.0.27
Microsoft.Authentication.WebAssembly.Msal | 6.0.27
Microsoft.dotnet-openapi | 6.0.27
Microsoft.Extensions.ApiDescription.Server | 6.0.27
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.27
Microsoft.DotNet.Common.ItemTemplates | 6.0.127
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.127
Microsoft.TemplateEngine.Edge | 6.0.127
Microsoft.TemplateEngine.IDE | 6.0.127
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.127
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.127
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.127
Microsoft.TemplateEngine.Utils | 6.0.127
Microsoft.TemplateSearch.Common | 6.0.127
Microsoft.TemplateEngine.Abstractions | 6.0.127
Microsoft.TemplateEngine.Core | 6.0.127
Microsoft.TemplateEngine.Core.Contracts | 6.0.127
Microsoft.DotNet.Compatibility.1.0.0-servicing.24070.10
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.27
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.27
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.27
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64 | 6.0.27
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.27
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.27
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.27
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.27
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.27
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64 | 6.0.27
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300 | 6.0.27
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86 | 6.0.27
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.27
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.27
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64 | 6.0.27
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64 | 6.0.27
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400 | 6.0.27
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86 | 6.0.27
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64 | 6.0.27
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64 | 6.0.27
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.27
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.27
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.27
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.27
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.27
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64 | 6.0.27
dotnet-ef | 6.0.27
Microsoft.EntityFrameworkCore | 6.0.27
Microsoft.Data.Sqlite.Core | 6.0.27
Microsoft.Data.Sqlite | 6.0.27
Microsoft.EntityFrameworkCore.Abstractions | 6.0.27
Microsoft.EntityFrameworkCore.Cosmos | 6.0.27
Microsoft.EntityFrameworkCore.Analyzers | 6.0.27
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.27
Microsoft.EntityFrameworkCore.Design | 6.0.27
Microsoft.EntityFrameworkCore.InMemory | 6.0.27
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.27
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.27
Microsoft.EntityFrameworkCore.Proxies | 6.0.27
Microsoft.EntityFrameworkCore.Sqlite | 6.0.27
Microsoft.EntityFrameworkCore.SqlServer | 6.0.27
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.27
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.27
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.27
Microsoft.EntityFrameworkCore.Tools | 6.0.27
Microsoft.EntityFrameworkCore.Relational | 6.0.27
Microsoft.DotNet.Common.ItemTemplates | 6.0.419
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.419
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.419
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.419
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.419
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.419
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.419
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.419
Microsoft.TemplateEngine.Abstractions | 6.0.419
Microsoft.TemplateEngine.Core.Contracts | 6.0.419
Microsoft.TemplateEngine.IDE | 6.0.419
Microsoft.TemplateEngine.Edge | 6.0.419
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.419
Microsoft.TemplateEngine.Core | 6.0.419
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.419
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.419
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.419
Microsoft.TemplateEngine.Utils | 6.0.419
Microsoft.TemplateSearch.Common | 6.0.419
FSharp.Core | 6.0.7
FSharp.Compiler.Service | 41.0.7

[//]: # ( Runtime 6.0.27)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8c35f4b3-32a9-41a7-8690-659051788610/49969180f86f9deb6af2cd55ef59005a/dotnet-runtime-6.0.27-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/559c4240-f5e3-4d3a-a361-99c07c7cad11/a00adbf8edb12c3646ebf57bce84d1c6/dotnet-runtime-6.0.27-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3ebc6223-96e5-49dc-9359-2cba6963bed0/0c07476fa184fd61b0af6def41166a2d/dotnet-runtime-6.0.27-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e3592f87-5832-4af4-98f7-85caf820b618/7159e1cecd35294be1cf02b20ac486e1/dotnet-runtime-6.0.27-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fa6af42b-36e5-4de2-b57a-21f7a9e6d558/0e6435339b808b132d0e812ceb6457c3/dotnet-runtime-6.0.27-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b4f214ee-a287-4640-991c-de80de4111d9/2672dee679fc3627949e8efdfff71e6d/dotnet-runtime-6.0.27-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/8a27acfa-4a99-4dbf-9780-9bf76550d254/4f608beae37f2860403b1714d96eaad6/dotnet-runtime-6.0.27-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ac022bcb-1ccc-4e7d-8b96-6d0379bec761/3ac011081768ec18387dee520e42c540/dotnet-runtime-6.0.27-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c534069c-5286-4755-a7a1-0e227154778e/5c5182246f716ec759eb4106daa1a4b6/dotnet-runtime-6.0.27-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/54b2f9c4-2c1a-4fdf-9054-f295d3ae24f2/bafc4747c493d32bbeab6a5dc3cef4a5/dotnet-runtime-6.0.27-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a59ec05b-ce0b-4e7e-b3e8-657f722ed041/e91b7395313babef6773f45e3987bf9b/dotnet-runtime-6.0.27-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/42a7a61b-650a-43fe-8bc0-20d694ead001/1f3aefb5c3a0a32d116685d27821addd/dotnet-runtime-6.0.27-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d57db805-d384-4ddb-b4a0-a9b4f7b37400/6e762dcde412cceafa16725e393663ab/dotnet-runtime-6.0.27-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f9c69d2a-258e-4943-b909-37b6f0865559/fc3989ac356c3b5216ded488c50b5304/dotnet-runtime-6.0.27-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/777e48e1-24a5-4aa5-b380-9c715f8542c2/4c7fd363a2c93c7c4ab77f6a75ca50a7/dotnet-runtime-6.0.27-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/84577830-4b37-4b7c-be2c-9cd14eadc50e/688f58a0bb556bede6a27dd2d555a316/dotnet-runtime-6.0.27-win-x86.zip

[//]: # ( WindowsDesktop 6.0.27)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/4ea37d90-c794-4059-a84e-27f6df349c1c/46d11b15e35b1ea4e36faaed3568766f/windowsdesktop-runtime-6.0.27-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f56749ce-aa62-4a08-9933-deca924e7d74/86f8ed6898689ed48d5191f2ad0bc71c/windowsdesktop-runtime-6.0.27-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3ef3cd0c-8c7f-4146-bd8d-589d748b997e/3477d059f8fe5cceb5166b367d7995c6/windowsdesktop-runtime-6.0.27-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/109538ea-fd30-4081-b523-681beec3b058/4f988f23937e5f6e70e0cf17b456ae0b/windowsdesktop-runtime-6.0.27-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a9669480-f3e0-42a6-b381-108950dfe290/b54d6613c0fa2839c41d61478926ccb9/windowsdesktop-runtime-6.0.27-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/549ac739-30af-488a-850a-536bd96825b6/c3893d3a827d7a4c1e5e9ea1971c3041/windowsdesktop-runtime-6.0.27-win-x86.zip

[//]: # ( ASP 6.0.27)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d339df74-9573-4ca1-9835-61a829e3fcf4/6937d0f4650f3622dbcdbe8a1717f212/aspnetcore-runtime-6.0.27-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6be3e44e-1306-422b-845c-9313589bbeb0/d76f133799f6b2c8e3ea7dc9d92b7a03/aspnetcore-runtime-6.0.27-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/69914cf9-9e19-4408-b3b2-c96fe09d2393/ca3a991f899c772e7604ef160cef9bab/aspnetcore-runtime-6.0.27-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8bbde0db-0484-4041-8a6d-c3aaee72c8ff/eecc3feb6188d28c38498e1ec267d768/aspnetcore-runtime-6.0.27-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8a13027e-f8fe-4f1b-a7e5-1a75725485f7/94dd9fe1074bd49fc2708e41e9fe071e/aspnetcore-runtime-6.0.27-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d3e6b8a2-f7de-441e-a3af-c18b7584034b/9f15be4d095b7bbb751222b4d68a17e3/aspnetcore-runtime-6.0.27-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7127ff28-48c8-4f40-bd34-be86a2098a67/afad61df9e45650c995b92dd10d2167c/aspnetcore-runtime-6.0.27-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9c3628c1-8221-48e4-aff1-a3eb23bc42f0/4c6717fec81aa31dbc290af683087304/aspnetcore-runtime-6.0.27-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/bdff621d-a96e-4879-8dd0-f297427fbad4/f609ad2836cdb47858447104bea1bdf5/aspnetcore-runtime-6.0.27-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/856b04b7-f893-4fb1-9205-052413fde70f/09996e15acebe136113a3aa77b28fe5e/aspnetcore-runtime-6.0.27-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/64bf3c18-3785-4413-967d-412ae2ccfcc1/bdc8c69011982fa81c72a58e81a1df17/aspnetcore-runtime-6.0.27-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/57d7ee45-b642-4f3d-8843-36fd275d7280/f99c16e25049cb16c9997c8b75de630f/aspnetcore-runtime-6.0.27-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e26c59a7-56be-4a43-8a8f-a45980917bf1/4eff47f9af189d6c151cacc713e390a3/aspnetcore-runtime-6.0.27-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/04389c24-12a9-4e0e-8498-31989f30bb22/141aef28265938153eefad0f2398a73b/dotnet-hosting-6.0.27-win.exe

[//]: # ( SDK 6.0.419)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/badd7c97-634f-410d-9397-995524372595/3d773584b9017d27433c1fe793d9696f/dotnet-sdk-6.0.419-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3b18aefa-0e14-4193-a167-35e1de4cfe46/acf2b230ae3ecfbc4d5f4c20cbf97b2d/dotnet-sdk-6.0.419-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6876bff7-b557-49c0-a30a-5beb0c7774a6/057afb27a068f2e7ae911893c5a1d0b2/dotnet-sdk-6.0.419-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cc52116e-50a3-466c-9ec8-30934e60fa95/5a6a3401cc326ce4069a79ee21701e7c/dotnet-sdk-6.0.419-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d0734139-d379-4126-aba8-4ff0862ef519/4ff75e52b185eab48784a610a1ed6f2e/dotnet-sdk-6.0.419-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8828b97b-7bfd-4b1b-a646-e55bddc0d7ad/e2f7d168ad273e78fbae72ffb6d215d3/dotnet-sdk-6.0.419-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/9be72207-eade-45b0-92a9-d48725770f61/8890ebc6575287d598c7139f90cdc2ca/dotnet-sdk-6.0.419-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c4bdba21-86ac-4c0b-8d65-c26459e115ee/8fcb7e012eda317486ad00d095cddba4/dotnet-sdk-6.0.419-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/bede9a7c-0980-45a2-b9fd-3477827dfb1e/9c132e3a5ea9d26840f015a957ee1248/dotnet-sdk-6.0.419-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f9e10850-734b-4267-8fd4-27a8e0f83cb9/1ac81544781feb8717c584d991f831c3/dotnet-sdk-6.0.419-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/2fcb1098-8331-4ada-8369-98fd7cde03a6/27c33a1f6dda1924ac95e61e7a2ecae2/dotnet-sdk-6.0.419-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/78d9c039-65f0-4ab9-82fb-4c1081ba3840/50db731747ac0a40473ee681c8947365/dotnet-sdk-6.0.419-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/37d12f81-b83d-43d8-91be-7c547a2abfe2/4f6bed6c672458dafd805b007509d9ad/dotnet-sdk-6.0.419-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5216ba35-4818-4ccc-bfea-423167b2c2e0/e879920a65ee5b5dc13d884d823b8469/dotnet-sdk-6.0.419-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1acbc347-e426-49fa-9efc-2ad9a7658d17/f75e1585e8319141b84d3e0e3fe38354/dotnet-sdk-6.0.419-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d42c5b77-0c94-458e-a7d1-0b3ce28641be/d1aa90d107d598739a57ebd3d1dc6127/dotnet-sdk-6.0.419-win-x86.zip
