# .NET 6.0.28 - March 12, 2024

The .NET 6.0.28, [.NET SDK 6.0.128](6.0.128.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.420
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```
The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 6.0 Blog][dotnet-blog]

.NET 6.0.28 release carries non security fixes.


## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9214](https://github.com/dotnet/core/issues/9214) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.28.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.28-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.28-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/March-2024-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Ref | 6.0.28
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.28
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.28
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.28
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.28
Microsoft.NETCore.App.Host.osx-x64 | 6.0.28
Microsoft.NETCore.App.Host.win-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.28
Microsoft.NETCore.DotNetHost | 6.0.28
Microsoft.NETCore.DotNetHostResolver | 6.0.28
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.28
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.28
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.28
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.28
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.28
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.28
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.28
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.28
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.28
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.28
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300 | 6.0.28
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64 | 6.0.28
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.28
Microsoft.NETCore.App.Host.linux-arm | 6.0.28
Microsoft.NETCore.App.Host.linux-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.win-arm | 6.0.28
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.28
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.28
Microsoft.NETCore.DotNetAppHost | 6.0.28
Microsoft.Windows.Compatibility.6.0.8
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.28
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.28
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.28
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.28
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.28
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.28
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.28
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.28
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.28
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.28
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.28
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.28
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.28
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.28
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.28
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.28
Microsoft.NETCore.App.Ref | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.28
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.28
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.28
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.28
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.28
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.28
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.28
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.28
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.28
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.28
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.28
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.28
Microsoft.NETCore.App.Composite | 6.0.28
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.28
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.28
Microsoft.NETCore.App.Host.win-x86 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.28
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.28
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.28
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.28
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.28
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.28
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.28
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.28
Microsoft.NETCore.App.Host.win-arm | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.28
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.28
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.28
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.28
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.28
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.28
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.28
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64 | 6.0.28
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400 | 6.0.28
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64 | 6.0.28
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.28
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.28
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.28
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.28
Microsoft.NETCore.DotNetHostPolicy | 6.0.28
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.28
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.28
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.28
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.28
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.28
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.28
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.28
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.28
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.28
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.28
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.28
Microsoft.NETCore.App.Host.win-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.28
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.28
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.28
Microsoft.NETCore.Platforms | 6.0.12
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.28
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.28
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.28
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.28
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.28
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.28
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.28
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.28
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.28
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.28
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.28
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.28
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.28
Microsoft.AspNetCore.Components | 6.0.28
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.28
Microsoft.AspNetCore.Components.WebView | 6.0.28
Microsoft.AspNetCore.Connections.Abstractions | 6.0.28
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.28
Microsoft.AspNetCore.Cryptography.Internal | 6.0.28
Microsoft.AspNetCore.DataProtection | 6.0.28
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.28
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.28
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.28
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.28
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.28
Microsoft.AspNetCore.Http.Connections.Common | 6.0.28
Microsoft.AspNetCore.HeaderPropagation | 6.0.28
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.28
Microsoft.AspNetCore.SignalR.Client | 6.0.28
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.28
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.28
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.28
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.28
Microsoft.Extensions.Localization | 6.0.28
Microsoft.Extensions.Logging.AzureAppServices | 6.0.28
Microsoft.Extensions.Localization.Abstractions | 6.0.28
Microsoft.Extensions.ObjectPool | 6.0.28
Microsoft.Extensions.WebEncoders | 6.0.28
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.28
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.28
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.28
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.28
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.28
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.28
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.28
AspNetCoreRuntime.6.0.x64 | 6.0.28
AspNetCoreRuntime.6.0.x86 | 6.0.28
Microsoft.AspNetCore.App.Ref | 6.0.28
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.28
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.28
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.28
Microsoft.AspNetCore.Authentication.Twitter | 6.0.28
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.28
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.28
Microsoft.AspNetCore.Authorization | 6.0.28
Microsoft.AspNetCore.Components.Analyzers | 6.0.28
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.28
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.28
Microsoft.AspNetCore.Owin | 6.0.28
Microsoft.AspNetCore.SignalR.Common | 6.0.28
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.28
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.28
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.28
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.28
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.28
Microsoft.Extensions.Caching.SqlServer | 6.0.28
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.28
Microsoft.Extensions.Identity.Core | 6.0.28
Microsoft.AspNetCore.Components.Web | 6.0.28
Microsoft.AspNetCore.Components.WebAssembly | 6.0.28
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.28
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.28
Microsoft.AspNetCore.Http.Connections.Client | 6.0.28
Microsoft.AspNetCore.Identity.UI | 6.0.28
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.28
Microsoft.AspNetCore.SpaProxy | 6.0.28
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.28
Microsoft.AspNetCore.TestHost | 6.0.28
Microsoft.Authentication.WebAssembly.Msal | 6.0.28
Microsoft.CodeAnalysis.Razor | 6.0.28
Microsoft.dotnet-openapi | 6.0.28
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.28
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.28
Microsoft.Extensions.Identity.Stores | 6.0.28
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.28
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.28
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.28
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.28
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.28
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.28
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.28
Microsoft.AspNetCore.Components.Forms | 6.0.28
Microsoft.AspNetCore.JsonPatch | 6.0.28
Microsoft.AspNetCore.Metadata | 6.0.28
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.28
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.28
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.28
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.28
Microsoft.AspNetCore.Mvc.Testing | 6.0.28
Microsoft.AspNetCore.Razor.Language | 6.0.28
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.28
Microsoft.Extensions.ApiDescription.Server | 6.0.28
Microsoft.Extensions.ApiDescription.Client | 6.0.28
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.28
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.28
Microsoft.Extensions.Features | 6.0.28
Microsoft.Extensions.FileProviders.Embedded | 6.0.28
Microsoft.Extensions.Http.Polly | 6.0.28
Microsoft.JSInterop | 6.0.28
Microsoft.JSInterop.WebAssembly | 6.0.28
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.28
dotnet-sql-cache | 6.0.28
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.28
Microsoft.AspNetCore.Authentication.Certificate | 6.0.28
Microsoft.AspNetCore.Authentication.Facebook | 6.0.28
Microsoft.AspNetCore.Authentication.Google | 6.0.28
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.28
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.28
Microsoft.AspNetCore.Components.Authorization | 6.0.28
Microsoft.TemplateEngine.IDE | 6.0.128
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.128
Microsoft.TemplateEngine.Utils | 6.0.128
Microsoft.TemplateEngine.Abstractions | 6.0.128
Microsoft.TemplateEngine.Core | 6.0.128
Microsoft.TemplateEngine.Core.Contracts | 6.0.128
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.128
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.128
Microsoft.TemplateSearch.Common | 6.0.128
Microsoft.DotNet.Common.ItemTemplates | 6.0.128
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.128
Microsoft.TemplateEngine.Edge | 6.0.128
Microsoft.DotNet.Compatibility | 1.0.0-servicing.24120.32
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.28
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64 | 6.0.28
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.28
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.28
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.28
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.28
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300 | 6.0.28
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64 | 6.0.28
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64 | 6.0.28
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400 | 6.0.28
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.28
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.28
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.28
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86 | 6.0.28
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.28
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64 | 6.0.28
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64 | 6.0.28
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.28
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64 | 6.0.28
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.28
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.28
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.28
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64 | 6.0.28
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.28
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.28
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86 | 6.0.28
dotnet-ef | 6.0.28
Microsoft.EntityFrameworkCore.Abstractions | 6.0.28
Microsoft.EntityFrameworkCore.Analyzers | 6.0.28
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.28
Microsoft.EntityFrameworkCore.Cosmos | 6.0.28
Microsoft.EntityFrameworkCore.Design | 6.0.28
Microsoft.EntityFrameworkCore.InMemory | 6.0.28
Microsoft.EntityFrameworkCore.Tools | 6.0.28
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.28
Microsoft.EntityFrameworkCore.Relational | 6.0.28
Microsoft.EntityFrameworkCore.Sqlite | 6.0.28
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.28
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.28
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.28
Microsoft.EntityFrameworkCore.SqlServer | 6.0.28
Microsoft.Data.Sqlite | 6.0.28
Microsoft.Data.Sqlite.Core | 6.0.28
Microsoft.EntityFrameworkCore | 6.0.28
Microsoft.EntityFrameworkCore.Proxies | 6.0.28
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.28
Microsoft.DotNet.Common.ItemTemplates | 6.0.420
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.420
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.420
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.420
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.420
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.420
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.420
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.420
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.420
Microsoft.TemplateEngine.Utils | 6.0.420
Microsoft.TemplateSearch.Common | 6.0.420
Microsoft.TemplateEngine.Core | 6.0.420
Microsoft.TemplateEngine.IDE | 6.0.420
Microsoft.TemplateEngine.Core.Contracts | 6.0.420
Microsoft.TemplateEngine.Abstractions | 6.0.420
Microsoft.TemplateEngine.Edge | 6.0.420
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.420
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.420
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.420
FSharp.Compiler.Service | 41.0.7
FSharp.Core | 6.0.7

[//]: # ( Runtime 6.0.28)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/71bb1bf6-dd86-4fe4-970c-9a9940bd1dcc/74cf5cc1c0a7e6c2c450e1c9e117b025/dotnet-runtime-6.0.28-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/05be959a-e55f-471c-ab03-75be0ac4fff2/65b05e51362a7a73621d17c718b8c5ae/dotnet-runtime-6.0.28-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bab2a313-b180-49cd-becc-3cda3bcc28df/e0df4ca21d73a32dc4aeb13082b1a068/dotnet-runtime-6.0.28-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/85324441-0d10-42fe-9463-4b2668eb4781/a1d495eaf6d815f8137c8690a3ed49df/dotnet-runtime-6.0.28-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e960795d-7dc6-40e6-8a3c-a8def247f17d/4d6ce411567c7709e816e16f2c47ab9a/dotnet-runtime-6.0.28-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7299a5aa-2992-4ba8-80ba-4aab1d009fc5/4ed058593c95649e1ef63567829d99d6/dotnet-runtime-6.0.28-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/6bdf3655-2e22-493c-b414-df0557b828de/a9b37b1aae9b4025da820fa796e272d2/dotnet-runtime-6.0.28-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3093e11f-975b-4c5f-ae9d-197149efb629/ceb685df67884156ea052c95d3b3d466/dotnet-runtime-6.0.28-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f9f7aec9-ee4d-49f2-92fc-7f8dc4e89975/ac76ce333c8c3f677a67cd2f4ea668a8/dotnet-runtime-6.0.28-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d04355db-6489-4205-8ad8-f42ca21c1c21/193b2519cd202d9cd8129e62dcf9ec1f/dotnet-runtime-6.0.28-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/df9a97a8-a535-4564-8132-f56cf1e57874/dccc2f9bb9391c2b15fe5944468f80d7/dotnet-runtime-6.0.28-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/7e465889-3fa8-4ce5-9501-8a79ddc38352/cf7aaaee41ff48f2cf480181529f4fc5/dotnet-runtime-6.0.28-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/fb0630a0-d5e7-43a6-92eb-1e114de80a5b/a43563f0a5c6ca71005d8ffe5de1bd88/dotnet-runtime-6.0.28-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d96457e9-44d0-4f7b-a45a-72471e83622a/7cb90da69ed3d23af308702ab2b9bb17/dotnet-runtime-6.0.28-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/267211b8-f876-4e97-b98c-6014a5c83b50/2c6630fe03f63e581c98302e5ac144fc/dotnet-runtime-6.0.28-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c090f88f-988c-44d6-9a40-a8b9bc5ce5a0/f122abbfed1d3754f1c412c92b73a3f0/dotnet-runtime-6.0.28-win-x86.zip

[//]: # ( WindowsDesktop 6.0.28)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/1c3aa974-fd10-4e3a-afd0-70504981901c/f043466b295d91cb432cfb12187f9317/windowsdesktop-runtime-6.0.28-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/8cae7212-f168-42fe-a850-eb6a43d4906d/754bd95f0de7a40d62618fa4e8f29b8f/windowsdesktop-runtime-6.0.28-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3f02cb28-18d2-41d8-a5e3-411aac7b7e5d/69fb6f7f450993f326ead2575ab783d0/windowsdesktop-runtime-6.0.28-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e649bfc4-2465-4444-9aef-7bb4f37f97f9/0daa90bf1f463c8d4b3ccc085e968b0a/windowsdesktop-runtime-6.0.28-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6e38e5c8-1fad-47d6-8863-bef8a6806148/255e17a4ef55bc157392e713cc7aff82/windowsdesktop-runtime-6.0.28-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/92cd4f2c-bf71-4042-ba71-5ff52c824d99/d327d7840c7dcb6da0750af40889db28/windowsdesktop-runtime-6.0.28-win-x86.zip

[//]: # ( ASP 6.0.28)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2b871c24-a310-4842-9ebf-81c257443f4e/dabf5b3fb20dcaa50818574cbf91712b/aspnetcore-runtime-6.0.28-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9926d390-141c-449b-b66b-92592af1c4d2/affff3fb06b82ef6388f57f1ee5359a3/aspnetcore-runtime-6.0.28-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7945d535-ac85-47a8-aa20-06e1748c9be1/2fa424c7de8b65cdb963ce8b78d97edf/aspnetcore-runtime-6.0.28-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f50ace21-4baa-4e03-95de-eb1d966e193d/be697285e0e7abac4180a86a6c0fe0ab/aspnetcore-runtime-6.0.28-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e05bf464-9601-4d4b-b412-f9d281ad4b78/4f8ae9cc0779607b4df58c223c411334/aspnetcore-runtime-6.0.28-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8e120ccb-35b2-461b-a791-4c439d2371f1/f64e4a1a25fc96ed90c9db839d7044fd/aspnetcore-runtime-6.0.28-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eda70fe7-655e-4753-b185-159a9534f6fc/0cead75a722fddb6341c27da918576d4/aspnetcore-runtime-6.0.28-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/82a75674-ecad-46c9-afb7-4cbdd9e5c464/f6fdcb021c3a7c0a7e7bf844eea1bb66/aspnetcore-runtime-6.0.28-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/1abf1ec0-cd9d-4970-8cc3-c2278909f3b5/d9b8a31101651c3bacb8decc0efa8db9/aspnetcore-runtime-6.0.28-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c7e44967-9522-4567-9f23-d92452cb25d4/89b32234f3dc50b2c1e215439dd98866/aspnetcore-runtime-6.0.28-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/56ba51ff-c29e-460d-bff3-4604f84942fe/df3aea77fa56a76a1325940747f82e99/aspnetcore-runtime-6.0.28-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/43a8bb70-5f8b-4219-95f1-8a3af65ac047/23bc7729e74089ee0edb0bf08f71bb37/aspnetcore-runtime-6.0.28-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c4d7199e-a4ba-476e-a22e-ac3e4ee62314/ed30b26a606fd18c5c6b346890fc6a90/aspnetcore-runtime-6.0.28-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/c9277ae6-1bd2-47d6-aa9f-0409791e4a22/ce685479743a5567f43913362237e320/dotnet-hosting-6.0.28-win.exe

[//]: # ( SDK 6.0.420)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cf62adad-ab62-4941-b474-ed275935e7b2/358b637e181b9a76a9a70a192b951760/dotnet-sdk-6.0.420-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d4704678-77d5-433e-97d3-a72b5a1f3316/b73d2c0c05f3df0c119b68418404a618/dotnet-sdk-6.0.420-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1d53328c-86c5-430b-830c-107a2a841ed5/83ddc0c32cb5b866c9a5fca70fab8942/dotnet-sdk-6.0.420-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/31eab213-91c5-4963-aa6b-8321f55e9f17/ced5291ea886b3dc5d76d6d1ab5dec27/dotnet-sdk-6.0.420-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bcaad2d2-19a9-42f0-8dfc-604cf03ddfde/bd1374c2c4ebc770f4555da947cd1c42/dotnet-sdk-6.0.420-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b521d7d2-108b-43d9-861a-58b2505a125a/0023553690a68328b33bc30a38f151db/dotnet-sdk-6.0.420-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/765a8b03-083e-4ae0-a468-3025f7025d8c/6d90637617f28810ec3abe148a051d3f/dotnet-sdk-6.0.420-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4a4728b7-96e6-48f1-a072-6906205e6a58/de54331936784caded5ecd5d10b0ee81/dotnet-sdk-6.0.420-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0e01a0d5-70de-4872-9e17-ac810a2d0325/b1cdf50516e6a6fc9e413164e93a5934/dotnet-sdk-6.0.420-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fd6f52d7-42fb-47a3-befc-a1458fe3d345/82d7e21a105b02acc768fdbfdcd2cddf/dotnet-sdk-6.0.420-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/7849f6b1-0f74-491b-9483-c621f731909c/75547effeb5839364d5d53441b756aa6/dotnet-sdk-6.0.420-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/ba7d7c8b-cabc-449e-9be6-f3eea1ccc6b5/9254b70dd8643b6fa37e342cb633a9db/dotnet-sdk-6.0.420-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/68ff350e-8b8d-4249-8678-570d5025f8e3/2178c63b5572b6016647525b53aa75b5/dotnet-sdk-6.0.420-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/98372669-0339-4a65-8a48-7f8b6426339a/204e48e8157b031ecb0149a44827863c/dotnet-sdk-6.0.420-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/87974b87-c8d7-4d78-9d86-e4273fee5546/3b3947ce98f7d39f8a7d8987bd6fd8e4/dotnet-sdk-6.0.420-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/51f29b21-f5e5-44c4-b617-190ad248dc52/83fb33c0233d11ab20185132ef201dd7/dotnet-sdk-6.0.420-win-x86.zip
