# .NET 6.0.29 - April 09, 2024

The .NET 6.0.29, [.NET SDK 6.0.129](6.0.129.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.421
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:d

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```
The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 6.0 Blog][dotnet-blog]

.NET 6.0.29 release carries security fixes.

[CVE-2024-21409 | .NET Elevation of Privilege Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-21409)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 7.0 ,and .NET 8.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A use-after-free vulnerability exists in WPF which may result in Elevation of Privilege when viewing untrusted documents.This is a Windows only vulnerability.


## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9263](https://github.com/dotnet/core/issues/9263) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.29.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.29-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.29-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/April-2024-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.29
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.29
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.29
Microsoft.WindowsDesktop.App.Ref | 6.0.29
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.29
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.29
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.29
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.29
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.29
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.29
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.29
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64 | 6.0.29
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86 | 6.0.29
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400 | 6.0.29
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.29
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86 | 6.0.29
Microsoft.NETCore.App.Host.linux-x64 | 6.0.29
Microsoft.NETCore.App.Host.osx-x64 | 6.0.29
Microsoft.NETCore.App.Host.win-arm | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.29
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.win-arm | 6.0.29
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.29
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.29
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.29
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.29
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Composite | 6.0.29
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.29
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.29
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.29
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64 | 6.0.29
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.29
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.29
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.29
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.29
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.29
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.29
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.29
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.29
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.29
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.29
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.29
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.29
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.29
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.29
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.29
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.29
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.29
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.29
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300 | 6.0.29
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.29
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.29
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.29
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.29
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.29
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.29
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.29
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.29
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.29
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.29
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.29
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.29
System.Security.AccessControl | 6.0.1
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.29
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.29
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.29
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.29
Microsoft.NETCore.App.Host.win-arm64 | 6.0.29
Microsoft.NETCore.App.Host.win-x64 | 6.0.29
Microsoft.NETCore.App.Host.win-x86 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.29
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.29
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.29
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.29
Microsoft.NETCore.DotNetAppHost | 6.0.29
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.29
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.29
Microsoft.NETCore.App.Host.linux-arm | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.29
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.29
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.29
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.29
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.29
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.29
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.29
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.29
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.29
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.29
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.29
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.29
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.29
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.29
Microsoft.NETCore.App.Ref | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.29
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.29
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.29
Microsoft.NETCore.DotNetHost | 6.0.29
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.29
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.29
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.29
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.29
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.29
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.29
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.29
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.29
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.29
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.29
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.29
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.29
Microsoft.NETCore.DotNetHostPolicy | 6.0.29
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.29
Microsoft.NETCore.DotNetHostResolver | 6.0.29
Microsoft.NETCore.Platforms | 6.0.13
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.29
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.29
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.29
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.29
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.29
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.29
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.29
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.29
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.29
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.29
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.29
Microsoft.AspNetCore.Authentication.Facebook | 6.0.29
Microsoft.AspNetCore.Authentication.Google | 6.0.29
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.29
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.29
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.29
Microsoft.AspNetCore.Components.Authorization | 6.0.29
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.29
Microsoft.AspNetCore.Connections.Abstractions | 6.0.29
Microsoft.AspNetCore.DataProtection | 6.0.29
Microsoft.AspNetCore.Cryptography.Internal | 6.0.29
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.29
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.29
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.29
Microsoft.AspNetCore.Http.Connections.Client | 6.0.29
Microsoft.AspNetCore.JsonPatch | 6.0.29
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.29
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.29
Microsoft.AspNetCore.Metadata | 6.0.29
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.29
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.29
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.29
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.29
Microsoft.Extensions.Identity.Stores | 6.0.29
Microsoft.Extensions.Localization | 6.0.29
Microsoft.Extensions.Localization.Abstractions | 6.0.29
Microsoft.Extensions.WebEncoders | 6.0.29
Microsoft.Extensions.ObjectPool | 6.0.29
Microsoft.JSInterop | 6.0.29
Microsoft.JSInterop.WebAssembly | 6.0.29
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.29
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.29
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.29
Microsoft.AspNetCore.Authentication.Certificate | 6.0.29
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.29
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.29
Microsoft.AspNetCore.Authorization | 6.0.29
Microsoft.AspNetCore.Components | 6.0.29
Microsoft.AspNetCore.Components.Analyzers | 6.0.29
Microsoft.AspNetCore.Components.Forms | 6.0.29
Microsoft.AspNetCore.Components.Web | 6.0.29
Microsoft.AspNetCore.Components.WebAssembly | 6.0.29
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.29
Microsoft.AspNetCore.SignalR.Common | 6.0.29
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.29
Microsoft.AspNetCore.SignalR.Client | 6.0.29
Microsoft.AspNetCore.SpaProxy | 6.0.29
Microsoft.Authentication.WebAssembly.Msal | 6.0.29
Microsoft.Extensions.ApiDescription.Server | 6.0.29
Microsoft.AspNetCore.TestHost | 6.0.29
Microsoft.dotnet-openapi | 6.0.29
Microsoft.Extensions.Caching.SqlServer | 6.0.29
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.29
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.29
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.29
dotnet-sql-cache | 6.0.29
AspNetCoreRuntime.6.0.x86 | 6.0.29
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.29
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.29
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.29
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.29
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.29
Microsoft.AspNetCore.Authentication.Twitter | 6.0.29
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.29
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.29
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.29
Microsoft.AspNetCore.Components.WebView | 6.0.29
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.29
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.29
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.29
Microsoft.AspNetCore.Identity.UI | 6.0.29
Microsoft.AspNetCore.HeaderPropagation | 6.0.29
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.29
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.29
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.29
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.29
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.29
Microsoft.Extensions.FileProviders.Embedded | 6.0.29
Microsoft.Extensions.Identity.Core | 6.0.29
Microsoft.Extensions.Features | 6.0.29
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.29
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.29
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.29
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.29
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.29
Microsoft.AspNetCore.App.Ref | 6.0.29
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.29
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.29
AspNetCoreRuntime.6.0.x64 | 6.0.29
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.29
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.29
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.29
Microsoft.AspNetCore.Http.Connections.Common | 6.0.29
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.29
Microsoft.AspNetCore.Mvc.Testing | 6.0.29
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.29
Microsoft.AspNetCore.Owin | 6.0.29
Microsoft.AspNetCore.Razor.Language | 6.0.29
Microsoft.CodeAnalysis.Razor | 6.0.29
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.29
Microsoft.Extensions.ApiDescription.Client | 6.0.29
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.29
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.29
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.29
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.29
Microsoft.Extensions.Http.Polly | 6.0.29
Microsoft.Extensions.Logging.AzureAppServices | 6.0.29
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.421
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.421
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.421
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.421
Microsoft.TemplateEngine.Edge | 6.0.421
Microsoft.TemplateEngine.Core | 6.0.421
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.421
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.421
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.421
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.421
Microsoft.TemplateEngine.Abstractions | 6.0.421
Microsoft.TemplateEngine.IDE | 6.0.421
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.421
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.421
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.421
Microsoft.TemplateSearch.Common | 6.0.421
Microsoft.DotNet.Common.ItemTemplates | 6.0.421
Microsoft.TemplateEngine.Core.Contracts | 6.0.421
Microsoft.TemplateEngine.Utils | 6.0.421
FSharp.Core | 6.0.7
FSharp.Compiler.Service | 41.0.7
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.29
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.29
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.29
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64 | 6.0.29
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.29
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.29
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64 | 6.0.29
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64 | 6.0.29
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86 | 6.0.29
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64 | 6.0.29
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64 | 6.0.29
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.29
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.29
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.29
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.29
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.29
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.29
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.29
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86 | 6.0.29
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64 | 6.0.29
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400 | 6.0.29
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64 | 6.0.29
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.29
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.29
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.29
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300 | 6.0.29
Microsoft.Data.Sqlite | 6.0.29
dotnet-ef | 6.0.29
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.29
Microsoft.EntityFrameworkCore | 6.0.29
Microsoft.Data.Sqlite.Core | 6.0.29
Microsoft.EntityFrameworkCore.Proxies | 6.0.29
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.29
Microsoft.EntityFrameworkCore.Design | 6.0.29
Microsoft.EntityFrameworkCore.Sqlite | 6.0.29
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.29
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.29
Microsoft.EntityFrameworkCore.SqlServer | 6.0.29
Microsoft.EntityFrameworkCore.Tools | 6.0.29
Microsoft.EntityFrameworkCore.Cosmos | 6.0.29
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.29
Microsoft.EntityFrameworkCore.Analyzers | 6.0.29
Microsoft.EntityFrameworkCore.Abstractions | 6.0.29
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.29
Microsoft.EntityFrameworkCore.InMemory | 6.0.29
Microsoft.EntityFrameworkCore.Relational | 6.0.29
Microsoft.DotNet.Common.ItemTemplates | 6.0.129
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.129
Microsoft.TemplateEngine.Abstractions | 6.0.129
Microsoft.TemplateEngine.Core | 6.0.129
Microsoft.TemplateEngine.Core.Contracts | 6.0.129
Microsoft.TemplateEngine.Edge | 6.0.129
Microsoft.TemplateEngine.Utils | 6.0.129
Microsoft.TemplateSearch.Common | 6.0.129
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.129
Microsoft.TemplateEngine.IDE | 6.0.129
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.129
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.129
Microsoft.DotNet.Compatibility | 1.0.0-servicing.24172.15

[//]: # ( Runtime 6.0.29)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/09f011b1-5f35-4bd5-85c4-5256fb93e33b/e3927b144f9c7e683057f0065bf2fb74/dotnet-runtime-6.0.29-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/633cbdd7-57e0-4101-9627-9bda4f29dc9d/93ad01d00720363b0c054f5d88d97a62/dotnet-runtime-6.0.29-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c3bed8c4-1549-493f-aabc-1bf81854b61e/8589cf6e9402903bcaf16cd96beb7aa1/dotnet-runtime-6.0.29-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0e27ad1b-43db-4126-855e-cd600dc1fad2/77d1bb08b361dda54da1493e8b1ac0d7/dotnet-runtime-6.0.29-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dbe837bc-4fc9-4183-95b3-b0caa65824f5/9329bcd4d04d36f5b5a9c1ec2bd98f0b/dotnet-runtime-6.0.29-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a066873e-e4f6-4538-a225-4170e2950af2/7e3b369dee3fb19cf193823e158f3b6b/dotnet-runtime-6.0.29-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/99a222a4-b8fb-4d19-a91a-a69aeaf9ba06/fdd439f0dc45cb1357b03a30e2bc8f98/dotnet-runtime-6.0.29-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ca51758e-d614-4a55-97ce-bf60ec381931/c2e6633c67dcf4359666cdaa88f1eeae/dotnet-runtime-6.0.29-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/8583970d-ca62-4053-9b25-01c2d2742062/8a5c9a04863a80655f483d67c3725255/dotnet-runtime-6.0.29-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ed218418-03fc-455b-ba08-6743dd753435/87ce2ccb4bd152e7e9435b891349ec9c/dotnet-runtime-6.0.29-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/58e1339b-27ed-4233-abc4-90e7627c5206/8cc8f028a095612101abaf3572325130/dotnet-runtime-6.0.29-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/4b1112ce-d049-4aa2-8a0e-fe3cd7fa5fd9/2423265745ca326a16ed4291290f84a1/dotnet-runtime-6.0.29-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/97f5bf17-3cc0-44ec-b9f9-3387070d3416/98378e07c1ae918eb3816f9945efe6b5/dotnet-runtime-6.0.29-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/48039340-3c06-4c2a-82cb-415fa8e5d78f/2b07f9b005685f0634f6d215295c1db6/dotnet-runtime-6.0.29-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a7c0ec36-a427-446c-9f30-a77434aa10cc/c599cd7e50eebd716f2e2b8a86c1338f/dotnet-runtime-6.0.29-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1347e1b3-d864-4f6d-a6aa-5a7a1ccd2f65/cfee0a36c05029759843e403897d53c8/dotnet-runtime-6.0.29-win-x86.zip

[//]: # ( WindowsDesktop 6.0.29)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/3f248dec-e035-4688-8ec2-0ee6234148f2/5348de59826f299f21b479e35e38d940/windowsdesktop-runtime-6.0.29-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/651d310d-5ce2-4996-a8e3-c3abee14ce49/37070e6d4e73b317516a7a2e0c82681b/windowsdesktop-runtime-6.0.29-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d0849e66-227d-40f7-8f7b-c3f7dfe51f43/37f8a04ab7ff94db7f20d3c598dc4d74/windowsdesktop-runtime-6.0.29-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7329f189-2aaf-46d6-b181-d530c47ba8a9/d1a252dca5b2396a71b4bdaa035be6e8/windowsdesktop-runtime-6.0.29-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/744eb7f8-57b2-4393-b3c6-a2cd57a2430f/23b8b7cefcb2cf19563f4d00575e58f4/windowsdesktop-runtime-6.0.29-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2a72fdd7-2dd9-4ebc-b108-ab8b52bfe14e/b2b6a47934e607c15b14236014fb6a2d/windowsdesktop-runtime-6.0.29-win-x86.zip

[//]: # ( ASP 6.0.29)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/57510d35-63b1-4535-bf83-e10deb8a3b78/b052a4381befd434cbe8da36ab937ff8/aspnetcore-runtime-6.0.29-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/094fe5d6-0520-4c0a-9edf-b53d269f8b20/8c5e69ed04787815037ae373ffb77466/aspnetcore-runtime-6.0.29-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dbdcfff0-935d-46a7-8522-eaf86ddbfd59/bb61884f6de8c9b771dbe3a37b4ca927/aspnetcore-runtime-6.0.29-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1eab5842-54c5-4899-9eb0-09f95f1d2ab4/f86e4d95a08033b0862f650a7a493112/aspnetcore-runtime-6.0.29-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/edd6d8e2-c2dc-4133-b686-f8900f9c141b/3e1e628ff616d9987d0658b8b1131d3e/aspnetcore-runtime-6.0.29-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/70ddd1ed-776d-41d2-b192-f02436ef3ca6/337d6dd35177408acb9889289a7743a7/aspnetcore-runtime-6.0.29-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cbaf5637-d4ba-41e8-a16f-a66a063a30e2/205c5fd4005a47753549594370bd385d/aspnetcore-runtime-6.0.29-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7b93130d-337d-46b8-8d61-cd702c4f2ae7/e198b8e68a06f1f1f5f46116f9976641/aspnetcore-runtime-6.0.29-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/776ba66f-3b9a-4ff8-8ab0-9f96eab62220/7cdd41e76c81a69c5df76614cfcfbbed/aspnetcore-runtime-6.0.29-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/91214b5b-3197-4b4b-8b18-88bf817d9694/5037417e01ba9482adac4d5a3a0657d7/aspnetcore-runtime-6.0.29-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6d57a434-ee30-42ae-b3c4-cc62cec1423d/116b1d450cd75b2d4da2a3ca29525873/aspnetcore-runtime-6.0.29-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/de3182fe-8475-438d-8c34-82504e3b15b9/7a6475407cbc1c380cda70ead77410e7/aspnetcore-runtime-6.0.29-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7d1cc405-3be7-452d-924f-d80c95e0541f/64998fc9d5c13f869ef862f9f2ad88a8/aspnetcore-runtime-6.0.29-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/b54e1bdd-2525-4414-a93a-27c62b329e47/c34cf7303786e74a20f7125475ffa511/dotnet-hosting-6.0.29-win.exe

[//]: # ( SDK 6.0.421)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/795e39e5-d7ae-4470-ae4a-f561bfb6eeb8/6c8903fe02d13e1d8776ace41e1bf1bb/dotnet-sdk-6.0.421-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/30303304-04ea-4569-9f10-3919b4b3105c/5b689d8357866cc2637a021d16096256/dotnet-sdk-6.0.421-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1be2307b-d369-4b30-8d93-9c58ef1cd05c/94eb69ee673057641a86b75ffc4a2a2e/dotnet-sdk-6.0.421-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8fca5735-10a9-4b48-ad5d-0f6f3c06f418/14b1928f50de99e470bcad0050a2c4f9/dotnet-sdk-6.0.421-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2f455565-db1f-4a92-b543-f21fca2448de/d1906dfe71b2d4eba4cbed50ecd20fab/dotnet-sdk-6.0.421-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/19144d78-6f95-4810-a9f6-3bf86035a244/23f4654fc5352e049b517937f94be839/dotnet-sdk-6.0.421-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ddaffb02-761d-4e21-a1fb-c96849a76428/9b97f4cc8a77e337486d5ffbef86ea1e/dotnet-sdk-6.0.421-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ed341e9a-7848-4036-bf88-00cffa9fe535/52887ced41272bf177a9ef6ac04563a2/dotnet-sdk-6.0.421-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3654f673-8801-454b-8d34-607a33f3ac39/2b642a9d794c3d3c5a4b218d9f5020d7/dotnet-sdk-6.0.421-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/270b615f-5281-4c58-980f-d9f7a08db642/3e874492a9cb0d5b87195c596b46d609/dotnet-sdk-6.0.421-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a1308bb3-7a60-4601-bf6c-23252af47598/55db6d5f38fa89dc388861e39df5522f/dotnet-sdk-6.0.421-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/94270c9d-949b-412a-9a6b-078f8fe2f95d/9dad0f822e025fd3c35175f8bc7e7067/dotnet-sdk-6.0.421-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9cac8293-891f-4f26-a911-4741f9765e48/ff71641bba9df8c745bf2a166cde23e2/dotnet-sdk-6.0.421-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/14804c03-4206-411a-80a5-8e26cd6ddcbc/e4e1e88d75be3a6f5c84ea3d39f60c19/dotnet-sdk-6.0.421-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4aded178-a52a-4fcc-a779-59bb444df048/67924e3556a3a69da09528bd74dca9ef/dotnet-sdk-6.0.421-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0ec741b7-1ba6-43f8-96b9-dcb0c2dd0997/3b00ab34251460fbe7b65048de8faf83/dotnet-sdk-6.0.421-win-x86.zip
