# .NET 6.0.3 - March 8, 2022

The .NET 6.0.3, .NET 6.0.201 SDK and [.NET SDK 6.0.103](6.0.103.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.201
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```


Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Windows SDK Updates

* .NET SDK 6.0.103 and 6.0.201 includes performance improvements to the Windows SDK packages that provide access to Windows Runtime APIs. For more details see the [C#/WinRT 1.5.0 release notes](https://github.com/microsoft/CsWinRT/releases/tag/1.5.0.220207.5).

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes
.NET 6.0.3 release carries security fixes.

# Microsoft Security Advisory CVE-2022-24464 | .NET Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 5.0, and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a Denial of Service vulnerability, which exists in .NET 6.0, .NET 5.0, and .NET Core 3.1 when parsing certain types of http form requests.


# Microsoft Security Advisory CVE-2022-24512 | .NET Remote Code Execution Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 5.0, and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A Remote Code Execution vulnerability exists in .NET 6.0, .NET 5.0, and .NET Core 3.1 where a stack buffer overrun occurs in .NET Double Parse routine.

Release feature and bug lists:

* [ASP.NET](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A6.0.3+is%3Aclosed+label%3AServicing-approved+)
* [WPF](https://github.com/dotnet/wpf/issues?q=milestone%3A6.0.3+is%3Aclosed+label%3Aservicing-approved+)
* [Winforms](https://github.com/dotnet/winforms/issues?q=milestone%3A6.0.3+is%3Aclosed+label%3Aservicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.3+is%3Aclosed+label%3Aservicing-approved+)


## Visual Studio Compatibility

You need [Visual Studio 17.0](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7259](https://github.com/dotnet/core/issues/7259) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.3.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.3-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.3-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/march-2022-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
 Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.3.nupkg
 Microsoft.WindowsDesktop.App.Ref | 6.0.3.nupkg
 Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.3.nupkg
 Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.3.nupkg
 runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.3.nupkg
 runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.3.nupkg
 runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.3.nupkg
 runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.3.nupkg
 runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.3.nupkg
 runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.3.nupkg
 Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Host.osx-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.3.nupkg
 runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.3.nupkg
 runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.3.nupkg
 runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.3.nupkg
 runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.3.nupkg
 runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.3.nupkg
 runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.3.nupkg
 runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.3.nupkg
 Microsoft.NETCore.DotNetHostResolver | 6.0.3.nupkg
 runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.3.nupkg
 runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.3.nupkg
 runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.3.nupkg
 runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.3.nupkg
 runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.3.nupkg
 runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.3.nupkg
 Microsoft.NETCore.App.Host.linux-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.3.nupkg
 runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.3.nupkg
 runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.3.nupkg
 runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.3.nupkg
 Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Host.linux-arm | 6.0.3.nupkg
 Microsoft.NETCore.App.Host.osx-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Host.win-arm | 6.0.3.nupkg
 Microsoft.NETCore.App.Host.win-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.DotNetHostPolicy | 6.0.3.nupkg
 runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.3.nupkg
 runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.3.nupkg
 Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.3.nupkg
 Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Host.win-x86 | 6.0.3.nupkg
 Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.win-arm | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.3.nupkg
 runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.3.nupkg
 runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.3.nupkg
 runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.3.nupkg
 runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.3.nupkg
 runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Ref | 6.0.3.nupkg
 Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.3.nupkg
 Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.3.nupkg
 Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.3.nupkg
 Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.3.nupkg
 Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.3.nupkg
 runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.3.nupkg
 Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.3.nupkg
 Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.3.nupkg
 Microsoft.NETCore.App.Composite | 6.0.3.nupkg
 Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200 | 6.0.3.nupkg
 Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.3.nupkg
 Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.3.nupkg
 runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.3.nupkg
 runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.3.nupkg
 runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.3.nupkg
 runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.Platforms.| 6.0.2.nupkg
 Microsoft.NETCore.DotNetAppHost | 6.0.3.nupkg
 System.Runtime.InteropServices.NFloat.Internal.| 6.0.1.nupkg
 runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.3.nupkg
 Microsoft.Extensions.Configuration.| 6.0.1.nupkg
 Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.3.nupkg
 runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.win-x64 | 6.0.3.nupkg
 runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.3.nupkg
 Microsoft.NETCore.DotNetHost | 6.0.3.nupkg
 runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.3.nupkg
 runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.3.nupkg
 runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.3.nupkg
 Microsoft.NETCore.App.Host.linux-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.3.nupkg
 Microsoft.NETCore.App.Host.win-arm64 | 6.0.3.nupkg
 Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.3.nupkg
 Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.linux-arm | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.3.nupkg
 runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.3.nupkg
 runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.3.nupkg
 runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.3.nupkg
 runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.3.nupkg
 runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.3.nupkg
 runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.win-x86 | 6.0.3.nupkg
 System.Reflection.Metadata.| 6.0.1.nupkg
 Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.3.nupkg
 Microsoft.Extensions.Logging.Abstractions.| 6.0.1.nupkg
 Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.3.nupkg
 Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200.Msi.x64 | 6.0.3.nupkg
 Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200.Msi.x86 | 6.0.3.nupkg
 Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.3.nupkg
 runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.3.nupkg
 runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.3.nupkg
 Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.3.nupkg
 Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.3.nupkg
 dotnet-sql-cache | 6.0.3.nupkg
 Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.3.nupkg
 Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.3.nupkg
 Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.3.nupkg
 Microsoft.AspNetCore.SignalR.Common | 6.0.3.nupkg
 Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.3.nupkg
 Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.3.nupkg
 Microsoft.AspNetCore.Razor.Language | 6.0.3.nupkg
 AspNetCoreRuntime.6.0.x86 | 6.0.3.nupkg
 Microsoft.AspNetCore.Mvc.Testing | 6.0.3.nupkg
 Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.3.nupkg
 Microsoft.AspNetCore.SignalR.Client | 6.0.3.nupkg
 Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.3.nupkg
 Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.3.nupkg
 Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.3.nupkg
 Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.3.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.3.nupkg
 Microsoft.AspNetCore.Authentication.WsFederation | 6.0.3.nupkg
 Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.3.nupkg
 Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.3.nupkg
 Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.3.nupkg
 Microsoft.CodeAnalysis.Razor | 6.0.3.nupkg
 Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.3.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.3.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.3.nupkg
 Microsoft.AspNetCore.Components.Analyzers | 6.0.3.nupkg
 Microsoft.AspNetCore.Components | 6.0.3.nupkg
 Microsoft.Extensions.Logging.AzureAppServices | 6.0.3.nupkg
 Microsoft.Extensions.ApiDescription.Server | 6.0.3.nupkg
 Microsoft.Extensions.Identity.Core | 6.0.3.nupkg
 Microsoft.Extensions.Http.Polly | 6.0.3.nupkg
 Microsoft.Extensions.Features | 6.0.3.nupkg
 Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.3.nupkg
 Microsoft.Extensions.Configuration.KeyPerFile | 6.0.3.nupkg
 Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.3.nupkg
 Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.3.nupkg
 Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.3.nupkg
 Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.3.nupkg
 Microsoft.AspNetCore.JsonPatch | 6.0.3.nupkg
 Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.3.nupkg
 Microsoft.AspNetCore.DataProtection | 6.0.3.nupkg
 Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.3.nupkg
 Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.3.nupkg
 Microsoft.AspNetCore.Cryptography.Internal | 6.0.3.nupkg
 Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.3.nupkg
 Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.3.nupkg
 Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.3.nupkg
 Microsoft.AspNetCore.TestHost | 6.0.3.nupkg
 Microsoft.AspNetCore.SpaProxy | 6.0.3.nupkg
 Microsoft.AspNetCore.SignalR.Client.Core | 6.0.3.nupkg
 AspNetCoreRuntime.6.0.x64 | 6.0.3.nupkg
 Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.3.nupkg
 Microsoft.AspNetCore.App.Ref | 6.0.3.nupkg
 Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.3.nupkg
 Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.3.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.3.nupkg
 Microsoft.Authentication.WebAssembly.Msal | 6.0.3.nupkg
 Microsoft.AspNetCore.Authentication.Negotiate | 6.0.3.nupkg
 Microsoft.AspNetCore.Authentication.Facebook | 6.0.3.nupkg
 Microsoft.dotnet-openapi | 6.0.3.nupkg
 Microsoft.JSInterop | 6.0.3.nupkg
 Microsoft.AspNetCore.Metadata | 6.0.3.nupkg
 Microsoft.AspNetCore.Http.Connections.Client | 6.0.3.nupkg
 Microsoft.AspNetCore.Http.Connections.Common | 6.0.3.nupkg
 Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.3.nupkg
 Microsoft.AspNetCore.HeaderPropagation | 6.0.3.nupkg
 Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.3.nupkg
 Microsoft.AspNetCore.DataProtection.Extensions | 6.0.3.nupkg
 Microsoft.AspNetCore.Connections.Abstractions | 6.0.3.nupkg
 Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.3.nupkg
 Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.3.nupkg
 Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.3.nupkg
 Microsoft.AspNetCore.Components.WebView | 6.0.3.nupkg
 Microsoft.AspNetCore.Owin | 6.0.3.nupkg
 Microsoft.AspNetCore.Components.WebAssembly | 6.0.3.nupkg
 Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.3.nupkg
 Microsoft.AspNetCore.Authentication.Twitter | 6.0.3.nupkg
 Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.3.nupkg
 Microsoft.AspNetCore.Authentication.Google | 6.0.3.nupkg
 Microsoft.Extensions.WebEncoders | 6.0.3.nupkg
 Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.3.nupkg
 Microsoft.AspNetCore.Identity.UI | 6.0.3.nupkg
 Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.3.nupkg
 Microsoft.AspNetCore.SpaServices.Extensions | 6.0.3.nupkg
 Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.3.nupkg
 Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.3.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.3.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.3.nupkg
 Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.3.nupkg
 Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.3.nupkg
 Microsoft.AspNetCore.Components.Web | 6.0.3.nupkg
 Microsoft.AspNetCore.Components.Authorization | 6.0.3.nupkg
 Microsoft.AspNetCore.Components.Forms | 6.0.3.nupkg
 Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.3.nupkg
 Microsoft.AspNetCore.Authentication.Certificate | 6.0.3.nupkg
 Microsoft.AspNetCore.Authorization | 6.0.3.nupkg
 Microsoft.Extensions.Localization.Abstractions | 6.0.3.nupkg
 Microsoft.Extensions.ObjectPool | 6.0.3.nupkg
 Microsoft.Extensions.Localization | 6.0.3.nupkg
 Microsoft.Extensions.Identity.Stores | 6.0.3.nupkg
 Microsoft.Extensions.FileProviders.Embedded | 6.0.3.nupkg
 Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.3.nupkg
 Microsoft.Extensions.Caching.SqlServer | 6.0.3.nupkg
 Microsoft.Extensions.ApiDescription.Client | 6.0.3.nupkg
 Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.3.nupkg
 Microsoft.JSInterop.WebAssembly | 6.0.3.nupkg
 Microsoft.TemplateEngine.Core | 6.0.201.nupkg
 Microsoft.DotNet.Common.ItemTemplates | 6.0.201.nupkg
 Microsoft.TemplateEngine.Core.Contracts | 6.0.201.nupkg
 Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.201.nupkg
 Microsoft.TemplateEngine.TemplateLocalizer | 6.0.201.nupkg
 Microsoft.TemplateSearch.Common | 6.0.201.nupkg
 Microsoft.TemplateEngine.Utils | 6.0.201.nupkg
 Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.201.nupkg
 Microsoft.TemplateEngine.Edge | 6.0.201.nupkg
 Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.201.nupkg
 Microsoft.TemplateEngine.Abstractions | 6.0.201.nupkg
 Microsoft.TemplateEngine.IDE | 6.0.201.nupkg
 Microsoft.DotNet.Compatibility.1.0.0-servicing.22124.17.nupkg
 Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.2.nupkg
 Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.2.nupkg
 Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.2.nupkg
 Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.2.nupkg
 Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.2.nupkg
 Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.2.nupkg
 Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.2.nupkg
 Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.2.nupkg
 Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.2.nupkg
 Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.2.nupkg
 Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.2.nupkg
 Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.2.nupkg
 Microsoft.NET.Workload.Emscripten.Manifest-6.0.200 | 6.0.2.nupkg
 Microsoft.NET.Workload.Emscripten.Manifest-6.0.200.Msi.x86 | 6.0.2.nupkg
 Microsoft.NET.Workload.Emscripten.Manifest-6.0.200.Msi.arm64 | 6.0.2.nupkg
 Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.2.nupkg
 Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.2.nupkg
 Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.2.nupkg
 Microsoft.NET.Workload.Emscripten.Manifest-6.0.200.Msi.x64 | 6.0.2.nupkg
 Microsoft.Data.Sqlite | 6.0.3.nupkg
 Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.3.nupkg
 Microsoft.Data.Sqlite.Core | 6.0.3.nupkg
 Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.3.nupkg
 Microsoft.EntityFrameworkCore | 6.0.3.nupkg
 Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.3.nupkg
 Microsoft.EntityFrameworkCore.Abstractions | 6.0.3.nupkg
 Microsoft.EntityFrameworkCore.Analyzers | 6.0.3.nupkg
 Microsoft.EntityFrameworkCore.InMemory | 6.0.3.nupkg
 Microsoft.EntityFrameworkCore.Design | 6.0.3.nupkg
 Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.3.nupkg
 Microsoft.EntityFrameworkCore.Relational | 6.0.3.nupkg
 Microsoft.EntityFrameworkCore.Tools | 6.0.3.nupkg
 dotnet-ef | 6.0.3.nupkg
 Microsoft.EntityFrameworkCore.Proxies | 6.0.3.nupkg
 Microsoft.EntityFrameworkCore.Sqlite | 6.0.3.nupkg
 Microsoft.EntityFrameworkCore.Cosmos | 6.0.3.nupkg
 Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.3.nupkg
 Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.3.nupkg
 Microsoft.EntityFrameworkCore.SqlServer | 6.0.3.nupkg
 Microsoft.DotNet.Common.ItemTemplates | 6.0.103.nupkg
 Microsoft.TemplateEngine.IDE | 6.0.103.nupkg
 Microsoft.TemplateEngine.Core.Contracts | 6.0.103.nupkg
 Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.103.nupkg
 Microsoft.TemplateEngine.TemplateLocalizer | 6.0.103.nupkg
 Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.103.nupkg
 Microsoft.TemplateEngine.Utils | 6.0.103.nupkg
 Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.103.nupkg
 Microsoft.TemplateEngine.Core | 6.0.103.nupkg
 Microsoft.TemplateEngine.Edge | 6.0.103.nupkg
 Microsoft.TemplateEngine.Abstractions | 6.0.103.nupkg
 Microsoft.TemplateSearch.Common | 6.0.103.nupkg
 Microsoft.DotNet.Compatibility.1.0.0-servicing.22124.18.nupkg




[//]: # ( Runtime 6.0.3)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b9025cf6-8662-4d27-9095-d7aefa15c7b3/b50251688bab4b62bf6b2b20355e8bfc/dotnet-runtime-6.0.3-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/89b5d16e-cb5e-4e6c-90f6-7332e93d20ae/7a0146aa4fc59154a3256c5196a622c7/dotnet-runtime-6.0.3-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c54574f5-c9fa-40f3-b968-5bdfe527d155/2012ef392b4e3d9c52da9bb705a99b11/dotnet-runtime-6.0.3-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d71417a8-4514-4976-a763-0e58deeda7fa/5ddd06f261adcd67eec2ae2a3bfa3c85/dotnet-runtime-6.0.3-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fa71d56a-8002-4f92-a250-66ba40526408/d96248ff8cd695061f45550b3d0a8837/dotnet-runtime-6.0.3-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4e766615-57e6-4b1d-a574-25eeb7a71107/9f95f74c33711e085302ffd644ef86ee/dotnet-runtime-6.0.3-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/fd2bc402-447c-46ec-b400-8db8d19670c3/a79a70e58fa4197f2acacf35237c2c06/dotnet-runtime-6.0.3-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/03047609-269e-4ca6-bf2e-406c496b27e3/3b19ad4d3fbc5d9a92f436db13e9e3d1/dotnet-runtime-6.0.3-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/2a70a8b8-e0e7-4ccc-940b-d73b375b0636/75422fdccd9e762cc0c3176424779181/dotnet-runtime-6.0.3-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1f354e35-ff3f-4de7-b6be-f5001b7c3976/b7c8814ab28a6f00f063440e63903105/dotnet-runtime-6.0.3-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/64212768-e4a7-4150-9f45-87712dd00832/ec91bc1674fc324a88baf1a6488e7c9f/dotnet-runtime-6.0.3-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/d0764d57-d623-44f1-ae06-3dc986b1d9fa/14777382e911ba2cf74915a1f7bf4958/dotnet-runtime-6.0.3-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1ac0b57e-cf64-487f-aecf-d7df0111fd56/2484cbe1ffacceacaa41eab92a6de998/dotnet-runtime-6.0.3-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/cf4207e9-1af7-4eec-8f3b-78880cae7500/1a1bd8eea1a0fb4287b3527bdfa4f757/dotnet-runtime-6.0.3-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/fa2aa002-94d8-4882-960f-066edcbcc187/58f85bc6116d65f5bd296f9512690b50/dotnet-runtime-6.0.3-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d48f3593-c7dc-4f24-a1db-315a7f0cd81a/6c52f8055184a8a2008712052142e0e6/dotnet-runtime-6.0.3-win-x86.zip

[//]: # ( WindowsDesktop 6.0.3)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/2aa0dc08-37a3-41cd-86be-e7179ca88185/7079574462a7b6a7e166dc1fe802abe1/windowsdesktop-runtime-6.0.3-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7f3a766e-9516-4579-aaf2-2b150caa465c/d57665f880cdcce816b278a944092965/windowsdesktop-runtime-6.0.3-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/33dd62b5-7676-483d-836c-e4cb178e3924/0de6894b5fdb6d130eccd57ab5af4cb8/windowsdesktop-runtime-6.0.3-win-x86.exe

[//]: # ( ASP 6.0.3)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7e5fa679-9e48-4748-8d54-578c03d5ce53/70f7cf826885132badd35ed667009fc2/aspnetcore-runtime-6.0.3-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1e7933b2-1202-4aeb-bb70-a6f9cecac61a/b12b5666b3d4cf508f8575581abd4033/aspnetcore-runtime-6.0.3-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d46b13ee-b710-43d7-b818-1eae18800a42/11e3430eed7b76bf38580a777b0b0904/aspnetcore-runtime-6.0.3-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e1ba7b30-de7e-4419-bf78-3bc935064b1b/9662000838cd29c2afa0aa9d46b03dc8/aspnetcore-runtime-6.0.3-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cc2698ef-3460-4f35-9713-eb52f4f4bddd/0dad1d7367d7b4fe53940d69b6fbfd1f/aspnetcore-runtime-6.0.3-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3af854b6-80fb-425a-972f-c7f0d693bf1b/cd458a4feae5a98646ee12a14ab34151/aspnetcore-runtime-6.0.3-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d7cf4456-d9ba-4a31-98e9-4681e1b0d8b8/b9c4cfded00e9940756e62c4486f64c6/aspnetcore-runtime-6.0.3-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2cfe2a02-dd59-4cb7-9788-76c620eaa0ff/dfd0d449289a042be9bc62e4466bf350/aspnetcore-runtime-6.0.3-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/bf79f30d-9ced-4fda-941f-8cc0716b1c61/cfe6ac5149bf86a0267c496a9cc45a86/aspnetcore-runtime-6.0.3-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/10857513-e4fe-41eb-bb13-7ea5c02dcb00/ca75a693efb0b3c5cebf173eb7f98242/aspnetcore-runtime-6.0.3-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a6bebf66-144f-44a3-8b74-425466e3608d/07231c69bfd5c749d48dbea15c50545a/aspnetcore-runtime-6.0.3-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/93ae486b-e23d-4311-af43-bb5201298e80/860ce9bf78843286a69bb2957456cc4c/aspnetcore-runtime-6.0.3-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d9200a02-fb3d-41da-a12a-391d31e4119d/dfbd376744f0e55c38f8809f4d4b4bd6/aspnetcore-runtime-6.0.3-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/41d7c644-140a-40b5-9eb7-071544b79c65/885b7fa698a2d1d3a79ad363613f8ff2/dotnet-hosting-6.0.3-win.exe

[//]: # ( SDK 6.0.201)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eefec3fa-c4c3-454d-bd7d-8fda31d15e5f/62668641ffc94db5fa11187f14a981f8/dotnet-sdk-6.0.201-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/33c6e1e3-e81f-44e8-9de8-91934fba3c94/9105f95a9e37cda6bd0c33651be2b90a/dotnet-sdk-6.0.201-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/09df51a1-5ef7-4db6-90cd-302ae92b7c84/3d000f08ab919f43f61184a3c48b46a8/dotnet-sdk-6.0.201-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0038906f-0d85-41ad-897d-2579359eeb77/78bb1d3b9df9d8017222f0bed5df23ab/dotnet-sdk-6.0.201-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/70fb6022-ef53-473b-bfde-dc8cd6b673ca/2c04303064ed5c5158998c3a0d11fcc1/dotnet-sdk-6.0.201-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c505a449-9ecf-4352-8629-56216f521616/bd6807340faae05b61de340c8bf161e8/dotnet-sdk-6.0.201-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/2e20d654-1371-4c8f-a0dd-e81bac07549e/7b63667ab1941110bf9e684dc66b590d/dotnet-sdk-6.0.201-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/628be5e6-7fc7-42b6-99c9-ea46fbcc3d14/d94bb4198af2d5013c75b1c70751ec8f/dotnet-sdk-6.0.201-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a5e0f5da-6088-451c-a341-b751c0d418c7/9fe3a31273888fe23cbe71cac32fa35c/dotnet-sdk-6.0.201-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cecaa095-3254-4987-b105-6bb9b594a89c/df29881aea827565a96d5e47dc337749/dotnet-sdk-6.0.201-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/8ff80e7e-fe35-45ca-bcfd-476e8d8715b5/92207f5d3df4c8f3992d1e8792971e89/dotnet-sdk-6.0.201-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/bfb98e2a-7535-4f27-bb62-bd9e94e9ec36/6e6a149f56712e6ac949a8b30ea93c70/dotnet-sdk-6.0.201-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1eb43f77-61af-40b0-8a5a-6165724dca60/f12aac6d4a907b4d54f5d41317aae0f7/dotnet-sdk-6.0.201-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5432b207-da43-4524-810c-563f1820d6b4/f5ca8777ecca3fd9dff35ca90502c960/dotnet-sdk-6.0.201-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/191ad5e8-d23e-4a6d-86d2-6295ad15c412/e172fc20532a76f4d60b9a47fd317ae2/dotnet-sdk-6.0.201-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/f3eb10bc-017a-47f8-8acd-ca90efcf8be8/584f28dfcaedcdddf575eb976e687955/dotnet-sdk-6.0.201-win-x86.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/09910ffd-238f-400b-95b4-abf54927f641/d69a4b8fb466b6036fb0d070fcfe01e3/dotnet-sdk-6.0.103-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8b770369-0721-4a3a-9fc8-475ac5f33d10/82d1188b5f1cfe06dc41b5a507a68476/dotnet-sdk-6.0.103-win-x86.zip

