# .NET 6.0.30 - May 14, 2024

The .NET 6.0.30, [.NET SDK 6.0.130](6.0.130.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.422
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:d

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```
The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 6.0 Blog][dotnet-blog]

.NET 6.0.30 release carries non security fixes.

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9309](https://github.com/dotnet/core/issues/9309) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.30.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.30-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.30-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/dotnet-and-dotnet-framework-may-2024-servicing-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.30
Microsoft.WindowsDesktop.App.Ref | 6.0.30
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.30
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.30
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.30
Microsoft.NETCore.App.Host.linux-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.30
Microsoft.NETCore.App.Ref | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.30
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.30
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.30
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.30
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.30
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.30
Microsoft.NETCore.App.Host.win-x64 | 6.0.30
Microsoft.NETCore.App.Host.win-x86 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.30
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.30
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Runtime.win-arm | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.30
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.30
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.30
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.30
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Composite | 6.0.30
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.30
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.30
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.30
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.30
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.30
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.30
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.30
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.30
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.30
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.30
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.30
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.30
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.30
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.30
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.30
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.30
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.30
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.30
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.30
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.30
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.30
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.30
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.30
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.30
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.30
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.30
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.30
Microsoft.NETCore.App.Host.win-arm | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.30
Microsoft.NETCore.DotNetAppHost | 6.0.30
Microsoft.NETCore.DotNetHost | 6.0.30
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.30
Microsoft.NETCore.DotNetHostResolver | 6.0.30
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.30
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.30
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.30
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.30
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.30
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.30
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300 | 6.0.30
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.30
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64 | 6.0.30
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64 | 6.0.30
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86 | 6.0.30
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400 | 6.0.30
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.30
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64 | 6.0.30
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.30
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.30
Microsoft.NETCore.App.Host.linux-arm | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.30
Microsoft.NETCore.DotNetHostPolicy | 6.0.30
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.30
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.30
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.30
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.30
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.30
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.30
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.30
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.30
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.30
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.30
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.30
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.30
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.30
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.30
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.30
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.30
Microsoft.NETCore.App.Host.win-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.30
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.30
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.30
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.30
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.30
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.30
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.30
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.30
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.30
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.30
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.30
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.30
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.30
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.30
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.30
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.30
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.30
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.30
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.30
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.30
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.30
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.30
Microsoft.NETCore.App.Host.osx-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.30
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.30
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.30
Microsoft.AspNetCore.Components.Web | 6.0.30
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.30
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.30
Microsoft.AspNetCore.Components.WebAssembly | 6.0.30
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.30
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.30
Microsoft.Extensions.Logging.AzureAppServices | 6.0.30
Microsoft.Extensions.ObjectPool | 6.0.30
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.30
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.30
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.30
Microsoft.AspNetCore.Components.Authorization | 6.0.30
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.30
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.30
Microsoft.AspNetCore.Components.WebView | 6.0.30
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.30
Microsoft.AspNetCore.Connections.Abstractions | 6.0.30
Microsoft.AspNetCore.DataProtection | 6.0.30
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.30
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.30
Microsoft.AspNetCore.Metadata | 6.0.30
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.30
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.30
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.30
Microsoft.AspNetCore.Mvc.Testing | 6.0.30
Microsoft.AspNetCore.Owin | 6.0.30
dotnet-sql-cache | 6.0.30
AspNetCoreRuntime.6.0.x86 | 6.0.30
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.30
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.30
Microsoft.Extensions.Http.Polly | 6.0.30
Microsoft.Extensions.Identity.Stores | 6.0.30
Microsoft.Extensions.Localization | 6.0.30
Microsoft.Extensions.Localization.Abstractions | 6.0.30
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.30
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.30
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.30
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.30
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.30
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.30
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.30
Microsoft.AspNetCore.Authentication.Certificate | 6.0.30
Microsoft.AspNetCore.Authentication.Facebook | 6.0.30
Microsoft.AspNetCore.Authentication.Google | 6.0.30
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.30
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.30
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.30
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.30
Microsoft.AspNetCore.Authentication.Twitter | 6.0.30
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.30
Microsoft.AspNetCore.Authorization | 6.0.30
Microsoft.AspNetCore.Components | 6.0.30
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.30
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.30
Microsoft.AspNetCore.Cryptography.Internal | 6.0.30
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.30
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.30
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.30
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.30
Microsoft.AspNetCore.HeaderPropagation | 6.0.30
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.30
Microsoft.AspNetCore.Identity.UI | 6.0.30
Microsoft.AspNetCore.Http.Connections.Client | 6.0.30
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.30
Microsoft.AspNetCore.Razor.Language | 6.0.30
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.30
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.30
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.30
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.30
Microsoft.Extensions.ApiDescription.Server | 6.0.30
Microsoft.Authentication.WebAssembly.Msal | 6.0.30
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.30
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.30
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.30
Microsoft.AspNetCore.App.Ref | 6.0.30
Microsoft.AspNetCore.Components.Analyzers | 6.0.30
Microsoft.AspNetCore.Components.Forms | 6.0.30
Microsoft.AspNetCore.Http.Connections.Common | 6.0.30
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.30
Microsoft.AspNetCore.JsonPatch | 6.0.30
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.30
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.30
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.30
Microsoft.AspNetCore.SpaProxy | 6.0.30
Microsoft.AspNetCore.TestHost | 6.0.30
Microsoft.dotnet-openapi | 6.0.30
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.30
Microsoft.Extensions.ApiDescription.Client | 6.0.30
Microsoft.Extensions.Caching.SqlServer | 6.0.30
Microsoft.Extensions.WebEncoders | 6.0.30
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.30
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.30
AspNetCoreRuntime.6.0.x64 | 6.0.30
Microsoft.AspNetCore.SignalR.Client | 6.0.30
Microsoft.AspNetCore.SignalR.Common | 6.0.30
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.30
Microsoft.CodeAnalysis.Razor | 6.0.30
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.30
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.30
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.30
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.30
Microsoft.Extensions.Features | 6.0.30
Microsoft.Extensions.FileProviders.Embedded | 6.0.30
Microsoft.Extensions.Identity.Core | 6.0.30
Microsoft.JSInterop | 6.0.30
Microsoft.JSInterop.WebAssembly | 6.0.30
Microsoft.TemplateEngine.Core | 6.0.130
Microsoft.DotNet.Common.ItemTemplates | 6.0.130
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.130
Microsoft.TemplateEngine.Utils | 6.0.130
Microsoft.TemplateEngine.IDE | 6.0.130
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.130
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.130
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.130
Microsoft.TemplateEngine.Abstractions | 6.0.130
Microsoft.TemplateEngine.Core.Contracts | 6.0.130
Microsoft.TemplateEngine.Edge | 6.0.130
Microsoft.TemplateSearch.Common | 6.0.130
Microsoft.DotNet.Compatibility | 1.0.0-servicing.24229.17
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.30
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.30
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86 | 6.0.30
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64 | 6.0.30
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64 | 6.0.30
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64 | 6.0.30
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300 | 6.0.30
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64 | 6.0.30
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64 | 6.0.30
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.30
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.30
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.30
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400 | 6.0.30
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.30
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.30
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.30
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64 | 6.0.30
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.30
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.30
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86 | 6.0.30
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.30
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.30
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.30
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.30
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.30
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64 | 6.0.30
Microsoft.Data.Sqlite | 6.0.30
Microsoft.EntityFrameworkCore.Analyzers | 6.0.30
Microsoft.EntityFrameworkCore.Design | 6.0.30
Microsoft.EntityFrameworkCore.InMemory | 6.0.30
Microsoft.EntityFrameworkCore.Relational | 6.0.30
Microsoft.EntityFrameworkCore | 6.0.30
Microsoft.EntityFrameworkCore.Cosmos | 6.0.30
Microsoft.EntityFrameworkCore.Proxies | 6.0.30
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.30
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.30
Microsoft.EntityFrameworkCore.Sqlite | 6.0.30
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.30
Microsoft.EntityFrameworkCore.SqlServer | 6.0.30
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.30
Microsoft.EntityFrameworkCore.Tools | 6.0.30
Microsoft.EntityFrameworkCore.Abstractions | 6.0.30
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.30
dotnet-ef | 6.0.30
Microsoft.Data.Sqlite.Core | 6.0.30
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.30
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.422
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.422
Microsoft.TemplateEngine.Core | 6.0.422
Microsoft.TemplateEngine.Core.Contracts | 6.0.422
Microsoft.TemplateEngine.Edge | 6.0.422
Microsoft.DotNet.Common.ItemTemplates | 6.0.422
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.422
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.422
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.422
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.422
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.422
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.422
Microsoft.TemplateEngine.Abstractions | 6.0.422
Microsoft.TemplateEngine.Utils | 6.0.422
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.422
Microsoft.TemplateSearch.Common | 6.0.422
Microsoft.TemplateEngine.IDE | 6.0.422
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.422
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.422
FSharp.Compiler.Service | 41.0.7
FSharp.Core | 6.0.7

[//]: # ( Runtime 6.0.30)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/483f6fe3-77d1-4836-bd77-5e31a692e20b/b17e2cdc16ef6a011b007cd751304ed5/dotnet-runtime-6.0.30-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/27a21bdd-cad5-4f5a-b7a3-86942632a745/3d7aba7c0cfe0c28342a8f83b65e72b9/dotnet-runtime-6.0.30-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f4b42b62-3be8-4d35-9ac4-963dbff46eca/cbdc0f0d8d1f1b1bd2d3e940a90ed32f/dotnet-runtime-6.0.30-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bbacb3d4-59eb-4fa5-8516-433e9026b121/892d304ec8cbedc744e4754ee13eba3b/dotnet-runtime-6.0.30-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e29d4eb6-9ab6-4829-aac7-ad2735fd5315/3f0c147178cd55a76dab707929dd9e44/dotnet-runtime-6.0.30-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a80ab89d-9f64-47b9-bba5-907a4cdaf457/c5714a6e605ef86293a5145d8ea72f39/dotnet-runtime-6.0.30-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/98933696-35c7-4fd8-a064-464b225936bc/d6b3543a85048bfbfeaf573c530ff325/dotnet-runtime-6.0.30-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e78e6379-e47a-4e24-ac6b-1c3182f1d664/b8f47b2f04b15c78ac24a8bc88000131/dotnet-runtime-6.0.30-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ae918557-0104-47ec-852e-8a7d7da28f0c/88cb2064682655ebd9af66b5884415d0/dotnet-runtime-6.0.30-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aee516fe-b6d8-40db-b284-1a287f7cd5ce/c217b7cdbcac883886169b82bcc2b7d8/dotnet-runtime-6.0.30-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c9a26964-93dc-4553-9d8c-476429b8ab97/b3d8a2434beb4a9731f2799712c97de8/dotnet-runtime-6.0.30-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/8f10ef9c-0b38-4ce4-807e-2b5963d9af59/34c51c70fdf020cd0bfc4bbbd34b422c/dotnet-runtime-6.0.30-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4c90e689-0f01-44a5-b9f3-1e3f5719b958/036442fd1c69b528939b5f98b7180f44/dotnet-runtime-6.0.30-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4cbb8ef9-bdab-4c78-a09a-bc44fdd4574f/15fe579eb104fb9c3254540075e423b8/dotnet-runtime-6.0.30-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7be97c08-23b8-4f60-ad04-82bac01ee741/e1631e554c004a83a118cfee672f3ee9/dotnet-runtime-6.0.30-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d67770a3-84d1-49b9-a5ae-93aef0c45ec5/bbb1fa9e139c5be7ba2f747732aa7d76/dotnet-runtime-6.0.30-win-x86.zip

[//]: # ( WindowsDesktop 6.0.30)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/62c0149c-c117-4600-8717-cbdd0f6101aa/00c4f58f028abd47afe3ad9c41c6ca9a/windowsdesktop-runtime-6.0.30-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/d3ad48f5-3eff-40ab-90ae-052da562a692/f0c35f18716ac63e81190b0e84757a99/windowsdesktop-runtime-6.0.30-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b14af665-ca5f-40a5-b0a9-4c7ca9ff1072/dfc3ab88e4dfbcece4fb7ee5246c406b/windowsdesktop-runtime-6.0.30-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e736525d-4d3b-4bcd-a01b-10e8facabfe5/95cc409bf57021fbb6be4ba2809394c5/windowsdesktop-runtime-6.0.30-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/94bd5cf9-0c22-4790-89c6-d1ce4b4fe952/2a01badbae5ec0c3e199f3c2a7ae764f/windowsdesktop-runtime-6.0.30-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/740d0876-4421-4ab5-abb9-db8a59ca9c58/d0f24e78945bd5ae8cb781faad2f8439/windowsdesktop-runtime-6.0.30-win-x86.zip

[//]: # ( ASP 6.0.30)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4e9433f6-d96f-412e-9eea-006657b32057/fcffac6fb601db009bceb8a4c58a9eea/aspnetcore-runtime-6.0.30-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a4c8e994-c595-4698-8cfc-cf3ac166bbbf/9e6b514da011de5191d148d95601a7ec/aspnetcore-runtime-6.0.30-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8629bb1d-d6dd-45b6-8398-0751c82dd7fb/679f6876065ec1bc7120524f3c24e5da/aspnetcore-runtime-6.0.30-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e889b668-b57b-4d65-ad63-27a469f5b014/625a3b54ef81f8dc202caab3835fd7fb/aspnetcore-runtime-6.0.30-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9cef9012-d931-4f34-91b3-e9df5db451d8/4a8854c8dc18438461cf54e05795c7ea/aspnetcore-runtime-6.0.30-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/03d1bc71-2ad1-41b4-aa2f-9e4ef6d5c6ed/29b655655d626c590cb216e0c30bccb3/aspnetcore-runtime-6.0.30-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0a61c065-2196-4a9f-a34a-9517b3ec9336/538e1624926840a66ef6963f57d44aa0/aspnetcore-runtime-6.0.30-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/15ab71c2-9230-4afb-87c5-36328af745ed/b859c077ed4d8c00985a2ee87009b6f1/aspnetcore-runtime-6.0.30-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/fc08d418-ec71-4944-bfab-46fa482cbab7/b5429f709866cc339e87c2c43d155ee1/aspnetcore-runtime-6.0.30-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/df69e0b0-7666-43f2-9a1d-5c239f0a5d70/ecd33d20405bbc0f9caf30983dd255bf/aspnetcore-runtime-6.0.30-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/20424721-b266-4fcc-8862-c7d497001955/567470e03758660466c61485d458ed71/aspnetcore-runtime-6.0.30-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e418b6d7-11ba-4986-a94b-05129eca848d/832c57d83015072a1c1446dee4366ed6/aspnetcore-runtime-6.0.30-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/badc125b-8d4f-425d-9228-a461f973141f/8061de10b426a544de715a5e15411a5a/aspnetcore-runtime-6.0.30-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/41643a5c-1ed5-41c8-abd0-473112282a79/644e14ace834d476fe3fa6797e472c55/dotnet-hosting-6.0.30-win.exe

[//]: # ( SDK 6.0.422)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7e506c78-3762-4743-b441-656f01a0be8b/3929e58819b463e92f29402f89933e36/dotnet-sdk-6.0.422-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9f8f2c2c-e531-4a5d-b7ed-1e7e4b8bbc29/12e87ade15ce29558b40099d6c152b10/dotnet-sdk-6.0.422-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0430126e-df4b-41ee-b093-051d296bf485/247b9749f364a4ce2cc6e1db6daff8b0/dotnet-sdk-6.0.422-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7c818b48-9346-4eb1-8dd1-f1285f65d675/2cf742083041b91fc93339efe3d7200d/dotnet-sdk-6.0.422-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/61decbf0-7544-4979-bf53-77731cacab87/454424446b24f8c801e80e17ae8b9268/dotnet-sdk-6.0.422-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/316ad9ae-22cb-478b-b51e-47667f1e7027/7a13422c0951e9235b7692c610b83442/dotnet-sdk-6.0.422-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/6427e918-a7a3-4c2c-81f3-15f92e61e661/468d9aaaff48719810e170b0ccf679e8/dotnet-sdk-6.0.422-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2f0c0bae-a26c-44c1-bd9e-9fcd42548066/c88dc835e8ac824d992696122c10d959/dotnet-sdk-6.0.422-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ce675d3b-f53e-4638-a758-6c2c1fff25dd/ca400cd93ebb189399599589ad6c352c/dotnet-sdk-6.0.422-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/818b0c97-95cc-4da8-b5af-05f6854c5e89/200ee246643a1d6a0436ad967ae705f1/dotnet-sdk-6.0.422-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/f39e11e0-03bd-4d5b-b5f6-3ae7dce29222/a22b7612e6ffeebde8f662cc0ead90ec/dotnet-sdk-6.0.422-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/09f68839-eb40-4bd5-a356-d5b5d50294c2/cf2a1373e137b30b6e61960ed2f4935c/dotnet-sdk-6.0.422-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/47f095fd-7aa8-4def-82d0-57897cf32202/f063bf11d48ab31bb6f87a6d582a57a8/dotnet-sdk-6.0.422-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/078b7ea9-b26e-4c4e-80eb-3a79be9906d8/a20046f51d2e14c20ac4d5872f29d174/dotnet-sdk-6.0.422-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1c3a9ea6-02ed-4420-84a6-f5b91aa3f2f3/a766b889cb6298b14102c6563d994fbf/dotnet-sdk-6.0.422-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/34a90c0d-cdfb-4a5c-bbb1-bf57919a3afb/e86043cec9beb64de028d5e529023433/dotnet-sdk-6.0.422-win-x86.zip
