# .NET 6.0.31 - May 28, 2024

The .NET 6.0.31, [.NET SDK 6.0.131](6.0.131.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.423
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:d

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```
The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/monitor](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor.md): .NET Monitor
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 6.0 Blog][dotnet-blog]

.NET 6.0.31 release carries the security and non-security fixes.

 ### WiX toolset signed with incorrect certificate

 The .NET 6.0.30 release on May 14, 2024 included updates to the WiX toolset which were incorrectly signed. This caused failures in scenarios on Windows where Code Integrity checks were enabled.

[CVE-2024-20672 | .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-20672)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 8.0, .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET when processing X.509 certificates that may result in Denial of Service. This vulnerabilty only affects macOS.

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9362](https://github.com/dotnet/core/issues/9362) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.31.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.31-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.31-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/dotnet-and-dotnet-framework-may-2024-servicing-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.31
Microsoft.WindowsDesktop.App.Ref | 6.0.31
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.31
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.win-arm | 6.0.31
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.31
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.31
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.31
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.31
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.31
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.31
Microsoft.NETCore.DotNetHost | 6.0.31
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.31
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.31
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.31
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.31
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.31
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.31
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.31
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.31
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.31
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.31
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.31
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.31
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.31
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.31
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.31
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.31
Microsoft.NETCore.App.Host.linux-x64 | 6.0.31
Microsoft.NETCore.App.Host.win-arm | 6.0.31
Microsoft.NETCore.App.Host.win-x86 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.31
Microsoft.NETCore.DotNetHostPolicy | 6.0.31
Microsoft.NETCore.DotNetHostResolver | 6.0.31
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.31
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.31
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.31
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.31
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.31
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.31
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.31
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.31
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.31
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.31
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.31
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.31
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.31
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.31
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.31
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.31
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.31
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.31
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.31
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.31
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.31
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.31
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.31
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.31
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.31
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.31
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.31
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.31
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.31
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.31
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.31
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.31
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.31
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.31
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.31
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.31
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Composite | 6.0.31
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.31
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.31
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.31
Microsoft.NETCore.App.Host.osx-x64 | 6.0.31
Microsoft.NETCore.App.Host.win-arm64 | 6.0.31
Microsoft.NETCore.App.Host.win-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.31
Microsoft.NETCore.App.Ref | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.31
Microsoft.NETCore.DotNetAppHost | 6.0.31
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.31
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.31
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.31
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.31
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.31
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.31
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.31
Microsoft.NETCore.App.Host.linux-arm | 6.0.31
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.31
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.31
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.31
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.31
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.31
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.31
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.31
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.31
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.31
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.31
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.31
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.31
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.31
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.31
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.31
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.31
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.31
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.31
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.31
AspNetCoreRuntime.6.0.x64 | 6.0.31
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.31
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.31
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.31
dotnet-sql-cache | 6.0.31
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.31
Microsoft.dotnet-openapi | 6.0.31
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.31
Microsoft.Extensions.Caching.SqlServer | 6.0.31
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.31
Microsoft.AspNetCore.Components.Authorization | 6.0.31
Microsoft.AspNetCore.Components.WebAssembly | 6.0.31
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.31
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.31
Microsoft.AspNetCore.Components.WebView | 6.0.31
Microsoft.AspNetCore.Connections.Abstractions | 6.0.31
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.31
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.31
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.31
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.31
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.31
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.31
Microsoft.AspNetCore.HeaderPropagation | 6.0.31
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.31
Microsoft.AspNetCore.Http.Connections.Common | 6.0.31
Microsoft.AspNetCore.Identity.UI | 6.0.31
Microsoft.AspNetCore.Http.Connections.Client | 6.0.31
Microsoft.AspNetCore.JsonPatch | 6.0.31
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.31
Microsoft.AspNetCore.Metadata | 6.0.31
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.31
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.31
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.31
Microsoft.AspNetCore.Mvc.Testing | 6.0.31
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.31
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.31
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.31
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.31
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.31
Microsoft.AspNetCore.SpaProxy | 6.0.31
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.31
Microsoft.Extensions.ApiDescription.Server | 6.0.31
Microsoft.Authentication.WebAssembly.Msal | 6.0.31
Microsoft.CodeAnalysis.Razor | 6.0.31
Microsoft.Extensions.ApiDescription.Client | 6.0.31
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.31
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.31
Microsoft.JSInterop | 6.0.31
Microsoft.Extensions.WebEncoders | 6.0.31
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.31
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.31
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.31
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.31
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.31
Microsoft.AspNetCore.Authentication.Facebook | 6.0.31
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.31
Microsoft.AspNetCore.Authentication.Twitter | 6.0.31
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.31
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.31
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.31
Microsoft.AspNetCore.Authorization | 6.0.31
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.31
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.31
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.31
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.31
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.31
Microsoft.AspNetCore.SignalR.Client | 6.0.31
Microsoft.AspNetCore.TestHost | 6.0.31
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.31
Microsoft.AspNetCore.SignalR.Common | 6.0.31
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.31
AspNetCoreRuntime.6.0.x86 | 6.0.31
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.31
Microsoft.AspNetCore.App.Ref | 6.0.31
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.31
Microsoft.AspNetCore.Authentication.Google | 6.0.31
Microsoft.AspNetCore.Authentication.Certificate | 6.0.31
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.31
Microsoft.AspNetCore.Components | 6.0.31
Microsoft.AspNetCore.Components.Analyzers | 6.0.31
Microsoft.AspNetCore.Components.Web | 6.0.31
Microsoft.AspNetCore.Components.Forms | 6.0.31
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.31
Microsoft.AspNetCore.Cryptography.Internal | 6.0.31
Microsoft.AspNetCore.DataProtection | 6.0.31
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.31
Microsoft.AspNetCore.Razor.Language | 6.0.31
Microsoft.AspNetCore.Owin | 6.0.31
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.31
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.31
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.31
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.31
Microsoft.Extensions.Features | 6.0.31
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.31
Microsoft.Extensions.Http.Polly | 6.0.31
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.31
Microsoft.Extensions.Identity.Stores | 6.0.31
Microsoft.Extensions.FileProviders.Embedded | 6.0.31
Microsoft.Extensions.Identity.Core | 6.0.31
Microsoft.Extensions.ObjectPool | 6.0.31
Microsoft.Extensions.Localization | 6.0.31
Microsoft.JSInterop.WebAssembly | 6.0.31
Microsoft.Extensions.Localization.Abstractions | 6.0.31
Microsoft.Extensions.Logging.AzureAppServices | 6.0.31
Microsoft.DotNet.Common.ItemTemplates | 6.0.131
Microsoft.TemplateEngine.Core.Contracts | 6.0.131
Microsoft.TemplateEngine.Edge | 6.0.131
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.131
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.131
Microsoft.TemplateEngine.Utils | 6.0.131
Microsoft.TemplateSearch.Common | 6.0.131
Microsoft.TemplateEngine.Abstractions | 6.0.131
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.131
Microsoft.TemplateEngine.Core | 6.0.131
Microsoft.TemplateEngine.IDE | 6.0.131
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.131
Microsoft.DotNet.Compatibility | 1.0.0-servicing.24270.35
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.31
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64 | 6.0.31
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.31
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.31
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.31
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.31
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64 | 6.0.31
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64 | 6.0.31
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.31
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.31
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.31
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.31
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.31
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.31
Microsoft.Data.Sqlite.Core | 6.0.31
Microsoft.EntityFrameworkCore | 6.0.31
Microsoft.Data.Sqlite | 6.0.31
Microsoft.EntityFrameworkCore.Analyzers | 6.0.31
Microsoft.EntityFrameworkCore.Design | 6.0.31
Microsoft.EntityFrameworkCore.Cosmos | 6.0.31
Microsoft.EntityFrameworkCore.InMemory | 6.0.31
Microsoft.EntityFrameworkCore.Proxies | 6.0.31
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.31
dotnet-ef | 6.0.31
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.31
Microsoft.EntityFrameworkCore.Abstractions | 6.0.31
Microsoft.EntityFrameworkCore.Relational | 6.0.31
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.31
Microsoft.EntityFrameworkCore.Sqlite | 6.0.31
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.31
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.31
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.31
Microsoft.EntityFrameworkCore.SqlServer | 6.0.31
Microsoft.EntityFrameworkCore.Tools | 6.0.31
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.423
Microsoft.TemplateEngine.Edge | 6.0.423
Microsoft.TemplateEngine.Utils | 6.0.423
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.423
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.423
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.423
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.423
Microsoft.TemplateEngine.Abstractions | 6.0.423
Microsoft.TemplateEngine.Core | 6.0.423
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.423
Microsoft.TemplateEngine.Core.Contracts | 6.0.423
Microsoft.TemplateEngine.IDE | 6.0.423
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.423
Microsoft.TemplateSearch.Common | 6.0.423
Microsoft.DotNet.Common.ItemTemplates | 6.0.423
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.423
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.423
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.423
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.423
FSharp.Core | 6.0.7
FSharp.Compiler.Service | 41.0.7



[//]: # ( Runtime 6.0.31)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8a421098-c7f1-49fc-be1d-8cfd2bdbe43f/90870bea5d80cb8eb442da2565df8096/dotnet-runtime-6.0.31-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/34215580-c4c9-49ee-a9a1-e9cb1a25646b/9ac060d3bd7eaf550d11acd60bd2841a/dotnet-runtime-6.0.31-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf518d36-a5bf-4e06-bf16-099d92e03744/22dbd4539da66f6dc11fdac7ab2e4618/dotnet-runtime-6.0.31-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6d83fcdd-5332-46d6-904b-af3fd76f8e0c/07613bcb4461d357d9d08f9f6809cbd1/dotnet-runtime-6.0.31-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1b11db6a-494e-46dd-9dcc-18d16b905f08/2335473df705580a4cebf5f17f99ce60/dotnet-runtime-6.0.31-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d67d6174-70c0-4256-b4f3-1f06cb5e8499/4bb51048eee17bda6b0ab7887c227206/dotnet-runtime-6.0.31-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1d94e81b-82ef-4d84-9245-2d67659ac6e1/8e4206b0f821fb0f11c43f051c62b3c7/dotnet-runtime-6.0.31-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d82928b9-3ce6-4060-bdd5-159afb165b37/002421f6104e66b92b7abb31abe7ffed/dotnet-runtime-6.0.31-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/6a514178-f043-41c4-a95e-02cffdc6343c/0089499e9ac0499d22506f7d4e1aa379/dotnet-runtime-6.0.31-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e06ea94c-e84e-48c3-9bcb-5fc65db7701b/22612902257c79e6483990c0d9bf02b5/dotnet-runtime-6.0.31-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/11fefaa5-bbc3-484c-9445-6aff23ee54d7/19ecf3ee8441f55170ce0bbe001f186e/dotnet-runtime-6.0.31-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/1a511c4f-d19a-4990-a2b9-b62691db856e/1a5e4da29246457dc06847e6aeac9963/dotnet-runtime-6.0.31-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/17089bd5-7875-4a3f-a430-5da3bc2dd57e/33acf480233bfb3fca383fb664fc8981/dotnet-runtime-6.0.31-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0bbe9bbb-ef1e-4f72-8bed-ca418c6d4ee6/4ce04e7d20ffaecd59186a6a917d425c/dotnet-runtime-6.0.31-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4cb113f7-9553-4a2b-9c13-cd4fbd0cea30/02da5b68097af3c33b1b4ee5842f327e/dotnet-runtime-6.0.31-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/64526e36-89a1-4eb2-9fa7-7946a982e303/ad408617b83719dcc6c77cd77c45bced/dotnet-runtime-6.0.31-win-x86.zip

[//]: # ( WindowsDesktop 6.0.31)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/1578f2ab-9de8-4078-8063-a629edfef884/bb9268adab104f9c23e590ca414603e3/windowsdesktop-runtime-6.0.31-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/aa4ee2e3-0512-4b6e-a204-0b7fd174f634/0c90be1dfee331ad77a7714334f87507/windowsdesktop-runtime-6.0.31-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a1da19dc-d781-4981-84e9-ffa0c05e00e9/46f3cd2015c27a0e93d7c102a711577e/windowsdesktop-runtime-6.0.31-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7cd9dc99-338a-4d22-860a-ab254a90cdf6/005d58fce355fc17fbe21c756510aa6b/windowsdesktop-runtime-6.0.31-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b5fbd3de-7a12-43ba-b460-2f938fd802c3/627f6335ef3ba17bd3ef901c790d7575/windowsdesktop-runtime-6.0.31-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d480ae88-fd83-448b-ac25-ce1726c79c0a/56833ac1f585296e44eb2cb5a8937bd5/windowsdesktop-runtime-6.0.31-win-x86.zip

[//]: # ( ASP 6.0.31)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dbcc9954-e476-416b-9411-f65a6d265e67/5a64d97dbae939763192831e828f58d9/aspnetcore-runtime-6.0.31-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/088b0ba5-2eaa-4815-a5c2-3517b99d059c/f6d18014064903be5fa2f654f51f5ce0/aspnetcore-runtime-6.0.31-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/42f7a62d-7557-45fa-b688-075bb5297e38/14a51115ce10a5a60e5c163213ad8b00/aspnetcore-runtime-6.0.31-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/306eae65-34db-4ffb-b193-c1158b711110/f46edc0e21c3b638e29b67e8a0644f1b/aspnetcore-runtime-6.0.31-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2ee2be3f-e46e-46d5-9033-a3c9d54d0c45/28bdb475b102b420ff109e3bc28e517b/aspnetcore-runtime-6.0.31-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c8c7ccb6-b0f8-4448-a542-ed153838cac3/f104b5cc6c11109c0b48e2bb8f5b6cef/aspnetcore-runtime-6.0.31-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/299cb3a7-badd-474f-9906-33d744bd77e7/cfb103fc34184ce82a012c5a1046292a/aspnetcore-runtime-6.0.31-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9b9addf2-5f49-4d1d-8272-bc348c9d93e4/a4dc2cdc0dcf8215a1c7e436a4c854cc/aspnetcore-runtime-6.0.31-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/cdca53f2-d843-4af6-959b-7c3f38d3125a/4458477adcb71d4c9006856b75d8e691/aspnetcore-runtime-6.0.31-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/29b7b141-bb4d-462b-8b55-6a1e4a610add/c38161439a048506b923b47fd50d21cc/aspnetcore-runtime-6.0.31-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8541d0ce-ecff-4f2b-8fe7-d69e296f7817/5a4e4db9162d0264f436660f614782b1/aspnetcore-runtime-6.0.31-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/330eeb02-98bb-44c7-8ebc-4d76a0aaa669/418966ec92d4ef584587769e246155c5/aspnetcore-runtime-6.0.31-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c67869d1-cbb2-474b-8b50-f3ff28f726c5/d0b8c627bad558d3af3706f6f49a36f5/aspnetcore-runtime-6.0.31-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/fee6ce1d-a3c4-4aed-ba11-5cbb9e22e5b1/8b1248f13ca5326850112ad45ccf3527/dotnet-hosting-6.0.31-win.exe

[//]: # ( SDK 6.0.423)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/46083246-216c-4d0c-905f-67f335466a23/505f9e26b85d7dd29d79a7e11da37926/dotnet-sdk-6.0.423-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f60a9d6c-1df8-4b84-af48-1961ed476a38/32f60a0f291dce64fb33a502e69e78bf/dotnet-sdk-6.0.423-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/63816465-f42b-4ea2-a98d-d901df5a83b2/3c651e7a6b7c23938251a2d6e4733ba5/dotnet-sdk-6.0.423-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5f67c6ce-9cd5-4edf-8d2f-0de3d79dbec0/8e9db372229edbf4bde4c1602d921b9f/dotnet-sdk-6.0.423-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c2c6b374-8dd3-47a7-9f88-8968fcecf8d4/9d2417660826791639931413207b0344/dotnet-sdk-6.0.423-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/111a63f5-e1d4-4d07-b8b2-98642b5fcc59/389661b982fa5b83b09a1f50b9da247a/dotnet-sdk-6.0.423-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/8a43cb29-3cfd-41e2-8c80-46ec7ae7192d/3e460e7f35b80aefb18b0d1a90849981/dotnet-sdk-6.0.423-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c53f9a57-8f7c-4d78-a2a5-32ddcf142cbb/312e8c418f6dd2372dd0e9174b10e6dc/dotnet-sdk-6.0.423-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7985c7ce-12d1-4180-9e95-3cf81790e958/633824a3c4228754b45106040302a5b2/dotnet-sdk-6.0.423-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8e5dec4f-d683-4ffa-9704-f4af023d5383/483bb54f830379d5eedd21c47ccaf47b/dotnet-sdk-6.0.423-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/dc302a1e-2703-423c-83ed-c0b558017c8e/22aa3913cdbb75177c707b9a71a29ec1/dotnet-sdk-6.0.423-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/50b92e6f-930f-43f3-8e81-80e8422b4ea2/f455097aaa991617fb540b557c9c187b/dotnet-sdk-6.0.423-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0814dade-52c0-4f97-83f4-21f784b03a2e/6f0d4b4dc596824a365b63882982031b/dotnet-sdk-6.0.423-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/99a9fa70-dc10-4b3e-8f5e-9e88b322de31/03c298ff8e31897c16ad36618e3042e7/dotnet-sdk-6.0.423-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e7469d78-a5b6-4e8a-8716-2f17fe601cee/098c3c6ce577c1a53f884c8525598e0d/dotnet-sdk-6.0.423-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/53db8d29-aafa-429b-9cbc-fcc0b6bea3cb/5dee51df7fbf01ca1bd17dc8edf83468/dotnet-sdk-6.0.423-win-x86.zip

