# .NET 6.0.32 - July 09, 2024

The .NET 6.0.32, [.NET SDK 6.0.132](6.0.132.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.424
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:d

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```
The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/monitor](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor.md): .NET Monitor
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 6.0 Blog][dotnet-blog]

.NET 6.0.32 release carries the security and non-security fixes.

[CVE-2024-38095 | .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-38095)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0 and .NET 8.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A Vulnerability exists when System.Formats.Asn1 in .NET parses an X.509 certificate or collection of certificates, a malicious certificate can result in excessive CPU consumption on all platforms result in Denial of Service.

[CVE-2024-38081 | .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-38081)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0 . This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A Vulnerability exist in Visual Studio installer on Windows OS where an unprivileged user is allowed to manipulate the Visual Studio installation resulting in elevation of privilege.

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9390](https://github.com/dotnet/core/issues/9390) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.32.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.32-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.32-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/dotnet-and-dotnet-framework-july-2024-servicing-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.32
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.32
Microsoft.WindowsDesktop.App.Ref | 6.0.32
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.32
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.32
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.32
Microsoft.IO.Redist | 6.0.1
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.32
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.32
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.32
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.32
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Composite | 6.0.32
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.32
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.32
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.32
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86 | 6.0.32
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64 | 6.0.32
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400 | 6.0.32
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.32
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.32
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.32
Microsoft.NETCore.App.Host.osx-x64 | 6.0.32
Microsoft.NETCore.App.Host.win-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.32
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.32
Microsoft.NETCore.DotNetHost | 6.0.32
Microsoft.NETCore.DotNetHostPolicy | 6.0.32
Microsoft.NETCore.DotNetHostResolver | 6.0.32
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.32
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.32
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.32
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.32
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.32
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.32
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.32
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.32
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.32
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.32
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.32
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.32
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.32
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.32
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.32
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.32
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.32
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.32
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.32
Microsoft.NETCore.App.Host.win-arm | 6.0.32
Microsoft.NETCore.App.Host.win-arm64 | 6.0.32
Microsoft.NETCore.App.Ref | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.32
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.32
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.32
Microsoft.NETCore.DotNetAppHost | 6.0.32
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.32
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.32
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.32
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.32
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.32
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.32
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.32
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.32
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.32
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.32
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.32
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.32
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.32
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.32
System.Formats.Asn1 | 6.0.1
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.32
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.32
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.32
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.32
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.32
Microsoft.NETCore.App.Host.linux-arm | 6.0.32
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.32
Microsoft.NETCore.App.Host.linux-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.32
Microsoft.NETCore.App.Host.win-x86 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.32
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.win-arm | 6.0.32
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.32
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.32
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.32
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.32
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.32
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.32
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.32
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.32
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.32
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.32
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.32
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.32
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.32
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.32
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.32
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.32
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.32
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.32
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.32
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.32
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.32
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.32
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.32
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.32
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.32
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.32
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300 | 6.0.32
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.32
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.32
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64 | 6.0.32
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86 | 6.0.32
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.32
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.32
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.32
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.32
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.32
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.32
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.32
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.32
Microsoft.AspNetCore.Authentication.Facebook | 6.0.32
Microsoft.AspNetCore.Components | 6.0.32
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.32
Microsoft.AspNetCore.Components.Analyzers | 6.0.32
Microsoft.AspNetCore.Components.WebView | 6.0.32
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.32
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.32
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.32
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.32
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.32
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.32
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.32
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.32
Microsoft.Extensions.Localization | 6.0.32
Microsoft.Extensions.Localization.Abstractions | 6.0.32
Microsoft.Extensions.Logging.AzureAppServices | 6.0.32
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.32
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.32
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.32
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.32
Microsoft.AspNetCore.Authentication.Certificate | 6.0.32
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.32
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.32
Microsoft.AspNetCore.HeaderPropagation | 6.0.32
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.32
Microsoft.AspNetCore.Http.Connections.Common | 6.0.32
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.32
Microsoft.AspNetCore.JsonPatch | 6.0.32
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.32
Microsoft.AspNetCore.TestHost | 6.0.32
Microsoft.Authentication.WebAssembly.Msal | 6.0.32
Microsoft.CodeAnalysis.Razor | 6.0.32
Microsoft.Extensions.ApiDescription.Client | 6.0.32
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.32
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.32
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.32
Microsoft.Extensions.Features | 6.0.32
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.32
Microsoft.Extensions.FileProviders.Embedded | 6.0.32
Microsoft.Extensions.Http.Polly | 6.0.32
Microsoft.Extensions.Identity.Stores | 6.0.32
Microsoft.Extensions.Identity.Core | 6.0.32
Microsoft.Extensions.ObjectPool | 6.0.32
Microsoft.Extensions.WebEncoders | 6.0.32
Microsoft.AspNetCore.Components.Authorization | 6.0.32
Microsoft.AspNetCore.Components.Forms | 6.0.32
Microsoft.AspNetCore.Components.Web | 6.0.32
Microsoft.AspNetCore.Components.WebAssembly | 6.0.32
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.32
Microsoft.AspNetCore.Http.Connections.Client | 6.0.32
Microsoft.AspNetCore.Identity.UI | 6.0.32
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.32
Microsoft.AspNetCore.Mvc.Testing | 6.0.32
Microsoft.AspNetCore.Owin | 6.0.32
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.32
Microsoft.AspNetCore.SignalR.Common | 6.0.32
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.32
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.32
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.32
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.32
Microsoft.AspNetCore.SpaProxy | 6.0.32
Microsoft.Extensions.ApiDescription.Server | 6.0.32
Microsoft.dotnet-openapi | 6.0.32
AspNetCoreRuntime.6.0.x86 | 6.0.32
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.32
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.32
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.32
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.32
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.32
AspNetCoreRuntime.6.0.x64 | 6.0.32
dotnet-sql-cache | 6.0.32
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.32
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.32
Microsoft.AspNetCore.App.Ref | 6.0.32
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.32
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.32
Microsoft.AspNetCore.Authentication.Google | 6.0.32
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.32
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.32
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.32
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.32
Microsoft.AspNetCore.Authentication.Twitter | 6.0.32
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.32
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.32
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.32
Microsoft.AspNetCore.Authorization | 6.0.32
Microsoft.AspNetCore.Connections.Abstractions | 6.0.32
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.32
Microsoft.AspNetCore.Cryptography.Internal | 6.0.32
Microsoft.AspNetCore.DataProtection | 6.0.32
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.32
Microsoft.AspNetCore.Metadata | 6.0.32
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.32
Microsoft.AspNetCore.Razor.Language | 6.0.32
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.32
Microsoft.AspNetCore.SignalR.Client | 6.0.32
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.32
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.32
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.32
Microsoft.Extensions.Caching.SqlServer | 6.0.32
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.32
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.32
Microsoft.JSInterop | 6.0.32
Microsoft.JSInterop.WebAssembly | 6.0.32
Microsoft.TemplateEngine.Utils | 6.0.132
Microsoft.TemplateSearch.Common | 6.0.132
Microsoft.TemplateEngine.Core | 6.0.132
Microsoft.TemplateEngine.Core.Contracts | 6.0.132
Microsoft.TemplateEngine.IDE | 6.0.132
Microsoft.TemplateEngine.Edge | 6.0.132
Microsoft.TemplateEngine.Abstractions | 6.0.132
Microsoft.DotNet.Common.ItemTemplates | 6.0.132
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.132
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.132
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.132
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.132
Microsoft.DotNet.Compatibility | 1.0.0-servicing.24315.1
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.32
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.32
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86 | 6.0.32
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.32
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64 | 6.0.32
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.32
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.32
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300 | 6.0.32
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64 | 6.0.32
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400 | 6.0.32
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64 | 6.0.32
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.32
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.32
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.32
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64 | 6.0.32
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64 | 6.0.32
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64 | 6.0.32
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.32
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.32
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.32
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64 | 6.0.32
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.32
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86 | 6.0.32
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.32
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.32
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.32
Microsoft.EntityFrameworkCore.Analyzers | 6.0.32
Microsoft.EntityFrameworkCore.Cosmos | 6.0.32
Microsoft.EntityFrameworkCore.Design | 6.0.32
Microsoft.EntityFrameworkCore.Proxies | 6.0.32
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.32
Microsoft.Data.Sqlite | 6.0.32
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.32
Microsoft.EntityFrameworkCore.Abstractions | 6.0.32
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.32
Microsoft.EntityFrameworkCore.Sqlite | 6.0.32
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.32
dotnet-ef | 6.0.32
Microsoft.EntityFrameworkCore.Tools | 6.0.32
Microsoft.EntityFrameworkCore | 6.0.32
Microsoft.EntityFrameworkCore.Relational | 6.0.32
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.32
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.32
Microsoft.Data.Sqlite.Core | 6.0.32
Microsoft.EntityFrameworkCore.InMemory | 6.0.32
Microsoft.EntityFrameworkCore.SqlServer | 6.0.32
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.424
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.424
Microsoft.TemplateEngine.Abstractions | 6.0.424
Microsoft.TemplateEngine.Core | 6.0.424
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.424
Microsoft.TemplateEngine.Core.Contracts | 6.0.424
Microsoft.TemplateEngine.Utils | 6.0.424
Microsoft.TemplateEngine.Edge | 6.0.424
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.424
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.424
Microsoft.DotNet.Common.ItemTemplates | 6.0.424
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.424
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.424
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.424
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.424
Microsoft.TemplateEngine.IDE | 6.0.424
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.424
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.424
Microsoft.TemplateSearch.Common | 6.0.424
FSharp.Compiler.Service | 41.0.7
FSharp.Core | 6.0.7
Microsoft.NET.ILLink.Analyzers | 6.0.200-1.24270.5
Microsoft.NET.ILLink | 6.0.200-1.24270.5
Microsoft.NET.ILLink.Tasks | 6.0.200-1.24270.5

[//]: # ( Runtime 6.0.32)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1c69eb5f-1035-4367-b60e-00b55322e871/042836571a606efaaaad0ff46c44a437/dotnet-runtime-6.0.32-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ae57a4e9-a6d3-4532-9061-72cfcbb90e70/89016f6466f00a8e707cd2f12fafe9e4/dotnet-runtime-6.0.32-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eb2787f0-c0be-4b67-ae93-4b981fa5592e/934de7c9a2c528e8fd802e863daf9c7d/dotnet-runtime-6.0.32-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/47224381-7453-4836-aeb1-4dcec9270cd3/798564d0b6cf917a7c0ac8d17077294d/dotnet-runtime-6.0.32-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d192f7bd-bf76-4175-86fe-996e7b716110/7ae2d021a2dc734bb98e331bfe74fece/dotnet-runtime-6.0.32-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/37d9269f-d651-4248-beae-ccfbf4dc34fc/17809ba306015df6406cf4338b5cc576/dotnet-runtime-6.0.32-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3b11bd38-58fd-4783-9d7f-e18e0409fe6a/a3df4c7ebff8fc2c67d7c9f5518fb7fd/dotnet-runtime-6.0.32-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aea2980c-1104-4e20-b608-ff52a1295165/19c1f907bab296a31a1c084776bad885/dotnet-runtime-6.0.32-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/aa0b1f71-8dfc-4b1b-9525-2249cd47cd7d/edd42c3f2bf111067355ae1d4598fa51/dotnet-runtime-6.0.32-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7ff71c2f-9fc9-402a-b88b-e85510530744/4fe521036c2d271ed8247fd5b761af1d/dotnet-runtime-6.0.32-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b6db2261-4288-474f-8762-4ee06bcb1227/e8b1458ea9f82b90e63be8fe8b9f2775/dotnet-runtime-6.0.32-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/5f7e774b-29f0-4289-a8ca-c774739b5642/9002f930381bfde97661c49b7dabb5fd/dotnet-runtime-6.0.32-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4515aaaa-c7d5-40bf-b7fd-f476d6ea3b1a/c545ea92dbd537753aefb937478fd532/dotnet-runtime-6.0.32-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a36df873-9d55-4697-a598-01ccd758365f/1f82e260f2d18ee644768b07f2eee343/dotnet-runtime-6.0.32-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/48edde1e-1e8f-4db6-b4dc-c882556dda4b/084af9e54686f70a8daecea2d2fbe2cb/dotnet-runtime-6.0.32-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/292f1ab0-e7b4-41b7-b9c7-05d7fd68392f/850a09030e9818cee50ae3acf6c038fe/dotnet-runtime-6.0.32-win-x86.zip

[//]: # ( WindowsDesktop 6.0.32)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/7cca2d9f-0006-43b8-b9fe-afd6392e9547/6e41687e10dff5a93d699c0e0d45e6c0/windowsdesktop-runtime-6.0.32-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/209e46b3-9a03-431a-a0c6-3ae7e08898c8/b011f6dc25625d06d2de2d452d31b8ff/windowsdesktop-runtime-6.0.32-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/222a065f-5671-4aed-aba9-46a94f2705e2/2bbcbd8e1c304ed1f7cef2be5afdaf43/windowsdesktop-runtime-6.0.32-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c4920cb7-d5b6-4c67-a2b2-e021777701e2/085054301a471cb675f13495449bdf00/windowsdesktop-runtime-6.0.32-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/11c05bd5-e601-4210-9912-4c0676b0f8ad/6a79dcc4cee0ba6985437d792c2d718e/windowsdesktop-runtime-6.0.32-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7146aff0-f7dd-4dac-a16e-2947c4bbb8fc/0e4b3fbc1ab8f0662b6caaab32f81fc7/windowsdesktop-runtime-6.0.32-win-x86.zip

[//]: # ( ASP 6.0.32)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d5106f1a-d140-4c8c-b480-001824b72768/7e9cf426bf45040eadfcc8bb20227b6d/aspnetcore-runtime-6.0.32-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7b3ead1a-441d-42b9-ac91-1253ed8aee48/044d517eaff9f65e18e3e27f4d825d34/aspnetcore-runtime-6.0.32-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/33b9b0ea-5a96-46a9-8062-3c1ed00a37e9/7a7e182643bc08a8ba9ed43edc07bef0/aspnetcore-runtime-6.0.32-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5538d46b-226f-4c17-978d-60594b82a309/601a23f13805b271012756095535820e/aspnetcore-runtime-6.0.32-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0ad0ece8-449d-4c6d-87d4-8354b2ffcd02/50853571dc0f9092b174cc6c5c7fb579/aspnetcore-runtime-6.0.32-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/99f90118-96b4-4d06-97ad-d779715319f6/aecf393f9b9d362b66b93a47d90cfa8d/aspnetcore-runtime-6.0.32-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/747ff7b4-44cb-4f11-a052-00484643c9ca/60175b793e5b9b472fb53960ee3aabe3/aspnetcore-runtime-6.0.32-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ff01df65-0536-46ad-bd67-95b72251e2cc/a9efc5c00994076c2635d70cac4f94bc/aspnetcore-runtime-6.0.32-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0805e07d-c7bd-4881-8bdf-7a861b195b6c/caf7fd0468542ca8e849b465558be7f8/aspnetcore-runtime-6.0.32-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/cd77851b-80d8-4ef6-87ee-afbaf715cea5/a2e9029cd1d4f0e35641e42852ac911e/aspnetcore-runtime-6.0.32-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/430115d1-18e8-45cc-918f-1ee56e821819/1380876010cb0a75cbbe3e3bd807cd61/aspnetcore-runtime-6.0.32-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4751d311-56b7-4456-a919-592e786d0854/9dabfdcbcd0ed3a8f6dd9ac5971b1848/aspnetcore-runtime-6.0.32-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2142924b-4867-4b7f-982c-b02c2fc7f946/c7b631b553488bda96b534477f2e4233/aspnetcore-runtime-6.0.32-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/67acc6b0-c653-4abf-af31-96edf0f75b24/90a29be6426124af37a70871fe1c0509/dotnet-hosting-6.0.32-win.exe

[//]: # ( SDK 6.0.424)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/500addd2-cfbf-49b4-b09f-e497f93331a4/e096ebc13bba6a9f6890588c5f617cae/dotnet-sdk-6.0.424-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5f4b8e71-b03a-45cb-9a81-3cfcb51ef346/eb9509f0a061be1106689c1fbf5d5169/dotnet-sdk-6.0.424-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2476a148-a7dd-444e-9f9f-afc3f1c6f4bf/50fa21da8d5b095a00970be9d4a7c549/dotnet-sdk-6.0.424-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4925d8f5-663e-4e3f-9c71-8d64f6e443f2/e5b86ec2f28af4192cdb4e77fe01a2dc/dotnet-sdk-6.0.424-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/497f2f70-988b-44c6-a62e-0d725598bebc/08f3b6af01d9d8c0a4c81c8ad0d419df/dotnet-sdk-6.0.424-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e94bb674-1fb1-4966-b2f0-bc9055ea33fc/428b37dee8ffb641fd1e45b401b2994c/dotnet-sdk-6.0.424-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c88c088d-fdf3-46f2-bacb-64ea20d20d65/b751a812209385384ec32a3d84124200/dotnet-sdk-6.0.424-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9692d45e-74d3-49a6-b076-7f1248e92c92/62628ca1d882a0266afb8413a7fbf3ca/dotnet-sdk-6.0.424-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0161ccc5-bb74-4d5f-b153-fb9ed1f31531/a3e393ab61522f4b8050cfd2692ad1d6/dotnet-sdk-6.0.424-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/28142fce-3788-45fb-a84a-1b00493f02b2/bc8df50296819166baa09ad3d372dca2/dotnet-sdk-6.0.424-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/976e9c79-7669-4110-885c-781edf5979fe/916eb14e692997c58b931707b7d81ff4/dotnet-sdk-6.0.424-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/9bfcc69a-301c-4811-aea8-90afedd5df94/150239580afa7cc70e8042e86fb80c10/dotnet-sdk-6.0.424-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/23c7bf0d-e22d-4372-bcb2-292eb36a5238/11af494be409759f46b679ab22e65a58/dotnet-sdk-6.0.424-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b298579b-5779-4a53-bd04-19749f22eb28/5e0f54a5a0de540dba50e8379a4e3ff7/dotnet-sdk-6.0.424-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9e184641-56bb-430b-9297-4316b039b641/3409ae071e0140ce2237f909b4b0ffbb/dotnet-sdk-6.0.424-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/60d5b63c-cccc-4da3-a0ec-da8fdc4be15c/6df910821e7503c9773fa37eeb97a229/dotnet-sdk-6.0.424-win-x86.zip
