# .NET 6.0.33 - August 13, 2024

The .NET 6.0.33, [.NET SDK 6.0.133](6.0.133.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.425
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:d

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```
The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/monitor](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor.md): .NET Monitor
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 6.0 Blog][dotnet-blog]

.NET 6.0.33 release carries the non-security fixes.

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9447](https://github.com/dotnet/core/issues/9447) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.33.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.33-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.33-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/dotnet-and-dotnet-framework-august-2024-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Ref | 6.0.33
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.33
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.33
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.33
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.33
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.33
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.33
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.33
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.33
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.33
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400 | 6.0.33
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.33
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.33
Microsoft.NETCore.App.Host.linux-arm | 6.0.33
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.33
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.33
Microsoft.NETCore.App.Host.linux-x64 | 6.0.33
Microsoft.NETCore.App.Host.win-x64 | 6.0.33
Microsoft.NETCore.App.Ref | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.win-arm | 6.0.33
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.33
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.33
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.33
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.33
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.33
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Composite | 6.0.33
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.33
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.33
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.33
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.33
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.33
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.33
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.33
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.33
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.33
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.33
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.33
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.33
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.33
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.33
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.33
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.33
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.33
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.33
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.33
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.33
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.33
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.33
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.33
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.33
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.33
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.33
Microsoft.NETCore.DotNetHostResolver | 6.0.33
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.33
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.33
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.33
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.33
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.33
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.33
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64 | 6.0.33
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300 | 6.0.33
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.33
Microsoft.NETCore.App.Host.osx-x64 | 6.0.33
Microsoft.NETCore.App.Host.win-arm64 | 6.0.33
Microsoft.NETCore.App.Host.win-arm | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.33
Microsoft.NETCore.DotNetHost | 6.0.33
Microsoft.NETCore.DotNetAppHost | 6.0.33
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.33
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.33
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.33
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.33
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.33
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.33
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.33
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.33
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.33
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.33
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.33
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.33
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.33
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.33
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.33
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.33
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64 | 6.0.33
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64 | 6.0.33
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.33
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.33
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.33
Microsoft.NETCore.App.Host.win-x86 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.33
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.33
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.33
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.33
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.33
Microsoft.NETCore.DotNetHostPolicy | 6.0.33
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.33
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.33
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.33
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.33
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.33
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.33
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.33
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.33
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.33
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.33
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.33
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.33
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.33
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.33
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.33
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.33
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.33
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.33
AspNetCoreRuntime.6.0.x64 | 6.0.33
dotnet-sql-cache | 6.0.33
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.33
Microsoft.AspNetCore.Authentication.Facebook | 6.0.33
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.33
Microsoft.AspNetCore.Authentication.Google | 6.0.33
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.33
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.33
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.33
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.33
Microsoft.AspNetCore.Authentication.Twitter | 6.0.33
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.33
Microsoft.AspNetCore.Components.Web | 6.0.33
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.33
Microsoft.AspNetCore.Owin | 6.0.33
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.33
Microsoft.AspNetCore.SignalR.Common | 6.0.33
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.33
Microsoft.AspNetCore.SpaProxy | 6.0.33
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.33
Microsoft.dotnet-openapi | 6.0.33
Microsoft.Extensions.ApiDescription.Server | 6.0.33
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.33
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.33
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.33
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.33
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.33
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.33
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.33
Microsoft.AspNetCore.Authentication.Certificate | 6.0.33
Microsoft.AspNetCore.Components | 6.0.33
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.33
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.33
Microsoft.AspNetCore.HeaderPropagation | 6.0.33
Microsoft.AspNetCore.Http.Connections.Client | 6.0.33
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.33
Microsoft.AspNetCore.JsonPatch | 6.0.33
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.33
Microsoft.AspNetCore.Metadata | 6.0.33
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.33
Microsoft.AspNetCore.SignalR.Client | 6.0.33
Microsoft.Authentication.WebAssembly.Msal | 6.0.33
Microsoft.CodeAnalysis.Razor | 6.0.33
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.33
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.33
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.33
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.33
Microsoft.AspNetCore.App.Ref | 6.0.33
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.33
Microsoft.AspNetCore.Authorization | 6.0.33
Microsoft.AspNetCore.Components.Analyzers | 6.0.33
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.33
Microsoft.AspNetCore.Components.Forms | 6.0.33
Microsoft.AspNetCore.Components.WebAssembly | 6.0.33
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.33
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.33
Microsoft.AspNetCore.TestHost | 6.0.33
Microsoft.Extensions.ApiDescription.Client | 6.0.33
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.33
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.33
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.33
Microsoft.Extensions.Identity.Stores | 6.0.33
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.33
Microsoft.AspNetCore.Components.Authorization | 6.0.33
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.33
Microsoft.AspNetCore.Components.WebView | 6.0.33
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.33
Microsoft.AspNetCore.Connections.Abstractions | 6.0.33
Microsoft.AspNetCore.Cryptography.Internal | 6.0.33
Microsoft.AspNetCore.DataProtection | 6.0.33
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.33
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.33
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.33
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.33
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.33
Microsoft.AspNetCore.Identity.UI | 6.0.33
Microsoft.AspNetCore.Http.Connections.Common | 6.0.33
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.33
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.33
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.33
Microsoft.AspNetCore.Mvc.Testing | 6.0.33
Microsoft.AspNetCore.Razor.Language | 6.0.33
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.33
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.33
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.33
Microsoft.Extensions.Caching.SqlServer | 6.0.33
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.33
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.33
Microsoft.Extensions.Features | 6.0.33
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.33
Microsoft.Extensions.Identity.Core | 6.0.33
Microsoft.Extensions.Http.Polly | 6.0.33
Microsoft.Extensions.Localization | 6.0.33
Microsoft.Extensions.Localization.Abstractions | 6.0.33
Microsoft.Extensions.Logging.AzureAppServices | 6.0.33
Microsoft.Extensions.ObjectPool | 6.0.33
Microsoft.JSInterop.WebAssembly | 6.0.33
Microsoft.JSInterop | 6.0.33
Microsoft.Extensions.WebEncoders | 6.0.33
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.33
AspNetCoreRuntime.6.0.x86 | 6.0.33
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.33
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.33
Microsoft.Extensions.FileProviders.Embedded | 6.0.33
Microsoft.TemplateEngine.Utils | 6.0.133
Microsoft.TemplateEngine.Core | 6.0.133
Microsoft.TemplateEngine.Core.Contracts | 6.0.133
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.133
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.133
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.133
Microsoft.TemplateEngine.IDE | 6.0.133
Microsoft.TemplateEngine.Edge | 6.0.133
Microsoft.DotNet.Common.ItemTemplates | 6.0.133
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.133
Microsoft.TemplateEngine.Abstractions | 6.0.133
Microsoft.TemplateSearch.Common | 6.0.133
Microsoft.DotNet.Compatibility | 1.0.0-servicing.24379.12
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.33
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.33
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.33
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64 | 6.0.33
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.33
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.33
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.33
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64 | 6.0.33
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400 | 6.0.33
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64 | 6.0.33
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.33
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.33
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.33
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86 | 6.0.33
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.33
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64 | 6.0.33
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300 | 6.0.33
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64 | 6.0.33
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.33
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.33
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.33
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64 | 6.0.33
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.33
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.33
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64 | 6.0.33
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86 | 6.0.33
Microsoft.EntityFrameworkCore | 6.0.33
Microsoft.Data.Sqlite.Core | 6.0.33
Microsoft.Data.Sqlite | 6.0.33
Microsoft.EntityFrameworkCore.Abstractions | 6.0.33
Microsoft.EntityFrameworkCore.Analyzers | 6.0.33
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.33
Microsoft.EntityFrameworkCore.Design | 6.0.33
Microsoft.EntityFrameworkCore.InMemory | 6.0.33
Microsoft.EntityFrameworkCore.Cosmos | 6.0.33
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.33
Microsoft.EntityFrameworkCore.Relational | 6.0.33
Microsoft.EntityFrameworkCore.Sqlite | 6.0.33
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.33
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.33
Microsoft.EntityFrameworkCore.SqlServer | 6.0.33
Microsoft.EntityFrameworkCore.Tools | 6.0.33
dotnet-ef | 6.0.33
Microsoft.EntityFrameworkCore.Proxies | 6.0.33
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.33
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.33
Microsoft.DotNet.Common.ItemTemplates | 6.0.425
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.425
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.425
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.425
Microsoft.TemplateEngine.IDE | 6.0.425
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.425
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.425
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.425
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.425
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.425
Microsoft.TemplateEngine.Abstractions | 6.0.425
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.425
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.425
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.425
Microsoft.TemplateEngine.Core | 6.0.425
Microsoft.TemplateEngine.Core.Contracts | 6.0.425
Microsoft.TemplateEngine.Edge | 6.0.425
Microsoft.TemplateEngine.Utils | 6.0.425
Microsoft.TemplateSearch.Common | 6.0.425
FSharp.Core | 6.0.7
FSharp.Compiler.Service | 41.0.7

[//]: # ( Runtime 6.0.33)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/19a5a6e5-87bf-44b2-b7ed-ac44e9a253b8/00fca686dc0139022528dbe5f6e0f0b3/dotnet-runtime-6.0.33-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/694cd8af-7e9f-4161-8c1d-1c9a7b1d074f/d3a8dc90d971ec4f135f6452c176dc93/dotnet-runtime-6.0.33-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e311cc4b-e2a4-46ef-8f0f-5996ac64e6d2/0a423f3d95284288d08250ce9e34ba06/dotnet-runtime-6.0.33-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6c147b46-cd90-4412-9df3-ca84fe040261/d026454e65fe16a83590bd75f139fbf4/dotnet-runtime-6.0.33-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/28d86acf-06f5-4bff-919b-28a26264591b/452ad01a142981b4ee4fd55b97117cf7/dotnet-runtime-6.0.33-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/250c78ac-a53f-4679-ad2a-cc31fa4c4001/204b39eb9634a8dd9f39cbcaf56030f2/dotnet-runtime-6.0.33-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5f558675-c42d-46ad-904b-66f8e720391b/2e135412543676a0b2f554e6a8fae3ae/dotnet-runtime-6.0.33-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aad5df88-c193-4579-b847-633186659a2f/1688cb1838ae0f0b67d16f3ed808f566/dotnet-runtime-6.0.33-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0140d848-6fb1-4c5c-ab11-dd95822055b9/57907e08f532ec4a76895d1872679dd9/dotnet-runtime-6.0.33-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/82217487-71ef-43cb-8678-d293b802b5a6/cfe49dd7b7e0e3040d4fdc9258c61dde/dotnet-runtime-6.0.33-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/4a783c02-985d-4724-afa8-ba8d4368c8d3/a6a3a2406f1e7e393c2fd3d5b933d0a6/dotnet-runtime-6.0.33-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/e0859868-7d1b-40b1-b254-6f7472650c3f/e8533daf7603a7e847f56426e3317f63/dotnet-runtime-6.0.33-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3c01bbe6-a49d-468f-8335-f195588f582f/b935469e8480e611eae4d79b2e51965e/dotnet-runtime-6.0.33-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1f5fc2af-aa55-4360-9485-3188cd62998e/fd8028bddf0a715ef74f6c8423c5b401/dotnet-runtime-6.0.33-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ef2dbfa6-683e-4ff3-9a17-9f3001d6bdf2/acf6114cce3533200116016b83e76ea7/dotnet-runtime-6.0.33-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/474696e2-79d5-463f-88df-6e874fe19d40/c31007a372025365992e1a0aa047a572/dotnet-runtime-6.0.33-win-x86.zip

[//]: # ( WindowsDesktop 6.0.33)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/9018e445-0559-4dd4-bffb-c772adf808e1/adcf2f02a07e1663ff1a97a8a42e9f96/windowsdesktop-runtime-6.0.33-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0afc5e64-c740-42d5-bd2e-5b7a2a6086e5/ba80390853ed33cb9b491a47d1d4833c/windowsdesktop-runtime-6.0.33-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3ebc1f91-a5ba-477e-9353-198fa4e13371/35f447d6820b078fd18523764a4f0213/windowsdesktop-runtime-6.0.33-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d7d9167d-216f-4d50-95d5-634f550083c7/f2cf30e9ee801dd6d019f11adaa439ef/windowsdesktop-runtime-6.0.33-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8029cdb3-0f5f-4018-bff7-bacd9b9357f8/daf6c8b102a3bdfbbf235cfa0e46f901/windowsdesktop-runtime-6.0.33-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/865cb605-99af-4282-8c68-ea5cea847fec/eeac48ec11ea05db9b6ac1f5152b47f3/windowsdesktop-runtime-6.0.33-win-x86.zip

[//]: # ( ASP 6.0.33)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4ac9397f-3f4a-4cd0-aba2-35e7f1b47396/9823f50c32028899f430bc3ae87251b1/aspnetcore-runtime-6.0.33-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0c5a5f3a-881e-4ceb-a334-c5e3b210eef8/9834ffebacea659cd14d272fb01f81c4/aspnetcore-runtime-6.0.33-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e9b663a7-2199-4111-b18e-5ec1f2f2f87e/1746ce0319914f58806f523c6f6ed24d/aspnetcore-runtime-6.0.33-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a4b5cbf6-85d9-46a0-b698-aaf3cde78d34/e1d46fec4ac226e170ccbacbf111d911/aspnetcore-runtime-6.0.33-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/94348e55-d279-4667-abf6-00a70cfa4773/67a06176a4ac8fbab11013cd728ed823/aspnetcore-runtime-6.0.33-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/91f66f75-bd3e-48f1-acb9-99c0da753f96/42c47999ee4c4d108774536afe5da160/aspnetcore-runtime-6.0.33-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/74fa4afa-a6d6-4c32-8ef7-fe88148f10cd/c887bff014d198532ba942988cba124b/aspnetcore-runtime-6.0.33-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d4641b35-5b85-4250-9913-0f6a2c276888/bd8483d09a767f6c19f9274da2819624/aspnetcore-runtime-6.0.33-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/896a6916-cbdf-446b-b053-bf57d8d6f874/0db72fb2b1b6fe006f634fbbcd2adf72/aspnetcore-runtime-6.0.33-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c4b74fa0-cea3-49f4-8765-ce1dd12d37c8/6f0c2d210864d89743fc7211c2f48edd/aspnetcore-runtime-6.0.33-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/aa3d14d7-f46f-4d7c-bf4a-2f46ddc7da1e/2e5d375269311d6b278df5c7c6b5aaa9/aspnetcore-runtime-6.0.33-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4286a987-b0b8-4fb7-abc6-5422f71387e5/06cc7fa445b8d367ccb37ce1394ff715/aspnetcore-runtime-6.0.33-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a5003e18-1ae9-46ee-a78b-d914d5a8835a/81069abf0c3dee5339c7d13026160630/aspnetcore-runtime-6.0.33-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/a154cee6-ab21-409b-8611-fb6c3b5b7513/b7da806505271536441f05ebd59627b2/dotnet-hosting-6.0.33-win.exe

[//]: # ( SDK 6.0.425)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2ff9a08a-9a84-498d-83e2-82e3e3c3d03d/64b283f30bb7df0260c8a7596dfcdff4/dotnet-sdk-6.0.425-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ec8e29f5-2fbe-47d8-b0c5-81f11434c00f/ba4bd30be448d649e5ddf1991bf76252/dotnet-sdk-6.0.425-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/04bfd229-7d52-40dc-a5eb-d31fe15fbf44/639e3b8aa8616ad25515bfe36faeb2c0/dotnet-sdk-6.0.425-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b5f55496-6494-45bc-9ba3-7aefdefb4518/61f15988a48d429bec81f5c5307f01d9/dotnet-sdk-6.0.425-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c94a92f9-153a-4620-844c-f964dcc7eb8e/ad7baee9c9ed782a5c9ad34509ff47a5/dotnet-sdk-6.0.425-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f57cd7db-7781-4ee0-9285-010a6435ef4f/ebc5bb7e43d2a288a8efcc6401ce3f85/dotnet-sdk-6.0.425-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4bb697a0-9509-4a48-aace-adf5cdd9dae5/db8114ff1a9117627a19ef3b5e709a05/dotnet-sdk-6.0.425-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/24192716-57e3-4e69-9950-7840e05053d1/79398f054d34fb3e424c029e6d41a551/dotnet-sdk-6.0.425-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/8010eb35-b580-4fe3-84a1-323aef5d6947/cd513767c7ece93a71c69703169dd1c5/dotnet-sdk-6.0.425-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ce410b9f-c7f6-4180-a373-bcb6528a0778/448c9df07432b5dc62d08868ccfef62a/dotnet-sdk-6.0.425-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/93733eb5-8222-44bb-8ae4-6be8c0b1fadc/dd7485ef2a6e2e8811480b3507186323/dotnet-sdk-6.0.425-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f06793f9-acc4-4403-8236-ea74cf015832/8072303a25dbd58097965499e801db37/dotnet-sdk-6.0.425-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/61881ecd-a425-4053-a420-7f76586d2f60/6daf1af8c05df332eb1c53261fafc07f/dotnet-sdk-6.0.425-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2cd43980-3abc-47ea-898d-b10116d27890/be9d8a7809b43ce82cf441b6761836a3/dotnet-sdk-6.0.425-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/20e7e1fc-0bfd-4736-bcde-04e64ed5e8f4/52c588d0a5160a30087b2e8c8f5672a2/dotnet-sdk-6.0.425-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4ac7b828-4216-42a7-a309-7c36ed02846d/1655b201203fac5454dcdccd2108ede2/dotnet-sdk-6.0.425-win-x86.zip

