# .NET 6.0.35 - October 08, 2024

The .NET 6.0.35, [.NET SDK 6.0.135](6.0.135.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.427
```
Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:d

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```
The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/monitor](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor.md): .NET Monitor
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 6.0 Blog][dotnet-blog]

.NET 6.0.35 release carries security and non-security fixes.

### Microsoft Security Advisory CVE-2024-43483 | .NET Denial of Service Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in  System.Security.Cryptography.Cose, System.IO.Packaging, System.Runtime.Caching. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

System.Security.Cryptography.Cose, System.IO.Packaging, System.Runtime.Caching may be exposed to a hostile input which may lead them to be susceptible to hash flooding attacks resulting in denial of service.

### Microsoft Security Advisory CVE-2024-43484 | .NET Denial of Service Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in System.IO.Packaging. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

The System.IO.Packaging library may allow untrusted inputs to influence algorithmically complex operations, leading to denial of service.

### Microsoft Security Advisory CVE-2024-43485 | .NET Denial of Service Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in System.Text.Json 6.0.x and 8.0.x. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

In System.Text.Json 6.0.x and 8.0.x, applications which deserialize input to a model with an `[ExtensionData]` property can be vulnerable to an algorithmic complexity attack resulting in Denial of Service.

## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9532](https://github.com/dotnet/core/issues/9532) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.35.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.35-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.35-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/dotnet-and-dotnet-framework-october-2024-servicing-updates/#net-october-2024-updates
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.35
Microsoft.WindowsDesktop.App.Ref | 6.0.35
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.35
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.35
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.35
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.35
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.35
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.35
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.35
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.35
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.35
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Composite | 6.0.35
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86 | 6.0.35
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.35
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.35
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.35
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.35
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.35
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.35
Microsoft.NETCore.App.Ref | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.35
Microsoft.NETCore.DotNetAppHost | 6.0.35
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.35
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.35
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.35
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.35
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.35
Microsoft.NETCore.App.Host.linux-arm | 6.0.35
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.35
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.35
Microsoft.NETCore.App.Host.osx-x64 | 6.0.35
Microsoft.NETCore.App.Host.win-arm | 6.0.35
Microsoft.NETCore.App.Host.win-x86 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 6.0.35
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.35
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.35
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.35
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.35
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.35
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.35
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.35
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.35
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.35
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.35
System.Text.Json | 6.0.10
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.35
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.35
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300 | 6.0.35
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64 | 6.0.35
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400 | 6.0.35
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 6.0.35
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.35
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.35
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.35
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.35
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.35
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.35
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.35
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.35
Microsoft.NETCore.App.Host.win-arm64 | 6.0.35
Microsoft.NETCore.App.Host.win-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.35
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.35
Microsoft.NETCore.DotNetHostResolver | 6.0.35
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.35
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.35
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.35
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.35
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.35
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.35
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.35
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.35
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.35
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.35
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.35
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.35
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.35
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.35
System.IO.Packaging | 6.0.1
Microsoft.Extensions.Caching.Memory | 6.0.2
Microsoft.Extensions.DependencyModel | 6.0.1
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.35
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.35
Microsoft.NETCore.App.Host.linux-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 6.0.35
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.35
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.35
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.35
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.35
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.35
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.35
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.35
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.35
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.35
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.35
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.35
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.35
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.35
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 6.0.35
Microsoft.NETCore.DotNetHost | 6.0.35
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.35
Microsoft.NETCore.DotNetHostPolicy | 6.0.35
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.35
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.35
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.35
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.35
Microsoft.NETCore.App.Runtime.win-arm | 6.0.35
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 6.0.35
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 6.0.35
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 6.0.35
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.35
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.35
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.35
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.35
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.35
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.35
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.35
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 6.0.35
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.35
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.35
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.35
Microsoft.AspNetCore.Components.Analyzers | 6.0.35
Microsoft.AspNetCore.Components.Authorization | 6.0.35
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.35
Microsoft.AspNetCore.Metadata | 6.0.35
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.35
Microsoft.AspNetCore.Mvc.Testing | 6.0.35
Microsoft.AspNetCore.Razor.Language | 6.0.35
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.35
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.35
Microsoft.AspNetCore.SignalR.Client | 6.0.35
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.35
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.35
Microsoft.AspNetCore.SpaProxy | 6.0.35
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.35
Microsoft.AspNetCore.TestHost | 6.0.35
Microsoft.dotnet-openapi | 6.0.35
Microsoft.Authentication.WebAssembly.Msal | 6.0.35
Microsoft.Extensions.Caching.SqlServer | 6.0.35
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.35
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.35
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.35
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.35
Microsoft.Extensions.FileProviders.Embedded | 6.0.35
Microsoft.Extensions.Http.Polly | 6.0.35
Microsoft.Extensions.Localization | 6.0.35
Microsoft.Extensions.Identity.Stores | 6.0.35
Microsoft.JSInterop | 6.0.35
Microsoft.JSInterop.WebAssembly | 6.0.35
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.35
AspNetCoreRuntime.6.0.x86 | 6.0.35
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.35
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.35
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.35
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.35
Microsoft.AspNetCore.Authentication.Certificate | 6.0.35
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.35
Microsoft.AspNetCore.Authentication.Facebook | 6.0.35
Microsoft.AspNetCore.Components.Web | 6.0.35
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.35
Microsoft.AspNetCore.Http.Connections.Common | 6.0.35
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.35
Microsoft.AspNetCore.JsonPatch | 6.0.35
Microsoft.AspNetCore.Owin | 6.0.35
Microsoft.AspNetCore.SignalR.Common | 6.0.35
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.35
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.35
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.35
Microsoft.CodeAnalysis.Razor | 6.0.35
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.35
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.35
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.35
Microsoft.Extensions.Features | 6.0.35
Microsoft.Extensions.Identity.Core | 6.0.35
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.35
AspNetCoreRuntime.6.0.x64 | 6.0.35
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.35
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.35
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.35
dotnet-sql-cache | 6.0.35
Microsoft.AspNetCore.App.Ref | 6.0.35
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.35
Microsoft.AspNetCore.Authentication.Google | 6.0.35
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.35
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.35
Microsoft.AspNetCore.Authentication.Twitter | 6.0.35
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.35
Microsoft.AspNetCore.Authorization | 6.0.35
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.35
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.35
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.35
Microsoft.AspNetCore.Components.Forms | 6.0.35
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.35
Microsoft.AspNetCore.Connections.Abstractions | 6.0.35
Microsoft.AspNetCore.DataProtection | 6.0.35
Microsoft.AspNetCore.Cryptography.Internal | 6.0.35
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.35
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.35
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.35
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.35
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.35
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.35
Microsoft.AspNetCore.Http.Connections.Client | 6.0.35
Microsoft.AspNetCore.HeaderPropagation | 6.0.35
Microsoft.AspNetCore.Identity.UI | 6.0.35
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.35
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.35
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.35
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.35
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.35
Microsoft.AspNetCore.Components | 6.0.35
Microsoft.AspNetCore.Components.WebAssembly | 6.0.35
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.35
Microsoft.AspNetCore.Components.WebView | 6.0.35
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.35
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.35
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.35
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.35
Microsoft.Extensions.ApiDescription.Server | 6.0.35
Microsoft.Extensions.ApiDescription.Client | 6.0.35
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.35
Microsoft.Extensions.Localization.Abstractions | 6.0.35
Microsoft.Extensions.Logging.AzureAppServices | 6.0.35
Microsoft.Extensions.WebEncoders | 6.0.35
Microsoft.Extensions.ObjectPool | 6.0.35
Microsoft.DotNet.Common.ItemTemplates | 6.0.135
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.135
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.135
Microsoft.TemplateEngine.Core | 6.0.135
Microsoft.TemplateEngine.Edge | 6.0.135
Microsoft.TemplateEngine.Core.Contracts | 6.0.135
Microsoft.TemplateEngine.IDE | 6.0.135
Microsoft.TemplateEngine.Utils | 6.0.135
Microsoft.TemplateSearch.Common | 6.0.135
Microsoft.TemplateEngine.Abstractions | 6.0.135
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.135
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.135
Microsoft.DotNet.Compatibility | 1.0.0-servicing.24466.24
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.35
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.35
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.arm64 | 6.0.35
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64 | 6.0.35
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.arm64 | 6.0.35
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.arm64 | 6.0.35
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.35
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.35
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.35
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.35
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.35
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.35
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.35
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.35
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86 | 6.0.35
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400 | 6.0.35
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64 | 6.0.35
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300 | 6.0.35
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64 | 6.0.35
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86 | 6.0.35
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64 | 6.0.35
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.35
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.35
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.35
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.35
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.35
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.35
Microsoft.EntityFrameworkCore | 6.0.35
Microsoft.EntityFrameworkCore.InMemory | 6.0.35
Microsoft.EntityFrameworkCore.Proxies | 6.0.35
Microsoft.EntityFrameworkCore.Sqlite | 6.0.35
dotnet-ef | 6.0.35
Microsoft.Data.Sqlite.Core | 6.0.35
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.35
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.35
Microsoft.EntityFrameworkCore.Cosmos | 6.0.35
Microsoft.EntityFrameworkCore.Design | 6.0.35
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.35
Microsoft.Data.Sqlite | 6.0.35
Microsoft.EntityFrameworkCore.Abstractions | 6.0.35
Microsoft.EntityFrameworkCore.Analyzers | 6.0.35
Microsoft.EntityFrameworkCore.Relational | 6.0.35
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.35
Microsoft.EntityFrameworkCore.SqlServer | 6.0.35
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.35
Microsoft.EntityFrameworkCore.Tools | 6.0.35
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.427
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.427
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.427
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.427
Microsoft.TemplateEngine.Abstractions | 6.0.427
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.427
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.427
Microsoft.TemplateEngine.Core | 6.0.427
Microsoft.TemplateEngine.Core.Contracts | 6.0.427
Microsoft.TemplateEngine.Edge | 6.0.427
Microsoft.TemplateEngine.IDE | 6.0.427
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.427
Microsoft.TemplateEngine.Utils | 6.0.427
Microsoft.TemplateSearch.Common | 6.0.427
Microsoft.DotNet.Common.ItemTemplates | 6.0.427
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.427
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.427
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.427
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.427
FSharp.Core | 6.0.7
FSharp.Compiler.Service | 41.0.7
Microsoft.NET.ILLink | 6.0.200-1.24429.1
Microsoft.NET.ILLink.Tasks | 6.0.200-1.24429.1
Microsoft.NET.ILLink.Analyzers | 6.0.200-1.24429.1

[//]: # ( Runtime 6.0.35)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2c52af07-c968-4edd-acb7-766d81766809/9de0174ec8abfc27498b763c0e1bd370/dotnet-runtime-6.0.35-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8f344652-6b7e-4136-b6ca-c1a46d998835/e00bad479ac747a8ddc90e7d006aaa52/dotnet-runtime-6.0.35-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4355d376-a0b5-4b33-8a80-3171b45100bb/d8ee2b66411370f06b55daaaa8bbac4f/dotnet-runtime-6.0.35-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b737d8bf-ec51-490b-a86d-fd6309965ed4/c2631e668020a1114fd5aa54adabb19f/dotnet-runtime-6.0.35-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/30443c06-a028-4ccc-88b0-8a98691ec823/d0ee93efc931577aa00eabf7cfea98ad/dotnet-runtime-6.0.35-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/79e3d66e-14b8-4c20-9816-37c0c0964c8c/98ed84be388dfa1a7db279e9beefbee8/dotnet-runtime-6.0.35-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/58978ceb-5de3-49e2-b571-972825b08f0a/f1bd9b1bb5b25b8c9cee40ed9a3d8023/dotnet-runtime-6.0.35-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/079437b4-612a-4a5e-be11-decf9fd90666/1932ebb2603542a3b647d958c9412824/dotnet-runtime-6.0.35-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/26920664-d754-4f76-9c99-e69116348e82/a40315371cc607c9f18478c93f2a676a/dotnet-runtime-6.0.35-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/55a4f552-2e06-4ecf-bb99-873cc072646f/0b2a5a90c60e8ceb862aa7f7160cf0e8/dotnet-runtime-6.0.35-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a223c45b-4777-4056-aea2-653c576d8115/bf8af63c6e625be4afa85ec093e81e65/dotnet-runtime-6.0.35-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/1066aa1a-7ef7-479f-b503-e70de2870136/0155525b5873f4f56085b755c476551f/dotnet-runtime-6.0.35-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c4f65621-b36b-46a9-8380-d5b660bef27e/0185fd72055dcdca86166b99add71686/dotnet-runtime-6.0.35-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1c020376-0cd2-47c5-81b6-136c7a12886c/665f124707f1e9373110cf36bec859aa/dotnet-runtime-6.0.35-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a90fb5dc-f488-400e-85ca-843a13640f56/483d24638cc2bedaddab43734aa2e447/dotnet-runtime-6.0.35-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/03918769-c10a-437d-9906-ebf7c5d0e77d/f49b6a1b975056324396d746bf9aea2a/dotnet-runtime-6.0.35-win-x86.zip

[//]: # ( WindowsDesktop 6.0.35)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/59aa44e0-fc7b-49e3-a47b-9b9b186e5716/f819ee6c199b807772b9d313317a0c39/windowsdesktop-runtime-6.0.35-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/86cfce34-0c0c-4b96-b83c-1a3d19a34e92/0980a4955f6b392caa71045be17b5a55/windowsdesktop-runtime-6.0.35-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0bfb4b48-9221-491f-8157-eed2307f13e6/3d7890b36ae32759d141633afd43787e/windowsdesktop-runtime-6.0.35-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/68d58272-acee-4909-a46c-0a5984d52d1a/648e6164e93a6aebf9bdf88438a5155b/windowsdesktop-runtime-6.0.35-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1ae73e99-0083-4dbb-b0c1-438385f1b593/3dadc5bcb35f51e35741ecb4429f51be/windowsdesktop-runtime-6.0.35-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/dee59629-61ec-4ca4-9cf8-e46f58ecb616/5df2e2530116a5b3901c2f7f3eb0d70c/windowsdesktop-runtime-6.0.35-win-x86.zip

[//]: # ( ASP 6.0.35)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/44b0aa96-3ad1-4406-946f-680e9a52897b/8a6b84db7a63924f98b4197ce07313be/aspnetcore-runtime-6.0.35-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5b5b9407-22c3-4ea4-aefe-c958ea78e7d1/1abb142a2ff944d822d133af369dbe21/aspnetcore-runtime-6.0.35-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5d62f7bf-a359-4213-9801-a6e625abcd5f/3d21aef16435231e8dba45d9d97b66f4/aspnetcore-runtime-6.0.35-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fd8b54ab-b3da-4bbc-8cad-e15955a61813/f8afd41bb9cf46a39da72177b56b3a29/aspnetcore-runtime-6.0.35-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/69cd357d-c16c-4578-a109-8fbcdd5f0e30/9c6b46794e4c784fdec1990ffeffb021/aspnetcore-runtime-6.0.35-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ccdb3628-8f55-411b-b0f1-669d42604ad8/81283ab8762aaab1be72772711f07f86/aspnetcore-runtime-6.0.35-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ebda945e-7bb9-4079-b4f2-6a444bbc8d4c/1b7c0b929586db13610d8613329a9fba/aspnetcore-runtime-6.0.35-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/12e0840c-f541-4796-9b7d-7c4568f6af78/41fd0ea7532a0f0e26a6a8755103856e/aspnetcore-runtime-6.0.35-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0de26bd3-0723-4baa-93a0-11a6c5d841bc/9baf020b1066d99d02773d5170829e1f/aspnetcore-runtime-6.0.35-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0f4f225d-77c1-47e4-be10-aece9616dae5/f6dc39b1e9c4885c9ecac992bd159871/aspnetcore-runtime-6.0.35-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/269069a3-74ce-4a22-a86f-68e9ef4d165c/ac7bb38de17413a4a30d616c4c7fba98/aspnetcore-runtime-6.0.35-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/211dee9b-dd5e-48a3-ab5d-7f89464f12d0/768a2d923d1b5ee0cf58890289cda879/aspnetcore-runtime-6.0.35-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6ea5169a-23b0-4635-869c-e409461c1641/5fd48c3623b5346ba3f237636882611e/aspnetcore-runtime-6.0.35-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/59c72253-7750-4f34-8804-4fb326754c4f/b83a6a459d49b6127757b4f873ba459f/dotnet-hosting-6.0.35-win.exe

[//]: # ( SDK 6.0.427)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7ba415c7-4750-44a2-9007-1bdcdee75c34/05c4467df0d7b5de0bc228a25e342ea4/dotnet-sdk-6.0.427-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/30d99992-ae6a-45b8-a8b3-560d2e587ea8/a35304fce1d8a6f5c76a2ccd8da9d431/dotnet-sdk-6.0.427-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/58a54963-a8a8-44fc-bfc2-c2e87e066656/7d0a5a831d123b801c55bd6993c9e69b/dotnet-sdk-6.0.427-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/49bb77df-ebaf-4a77-b6d7-d178c3b1f97f/c87e3f996af3fddd9cb253f0f5720d1c/dotnet-sdk-6.0.427-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8db04a7e-0da2-4064-b17a-c36888961d8a/3919a6cc424dc0dfd581569d02f1db54/dotnet-sdk-6.0.427-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/12ee34e8-640c-400e-a6dc-4892b442df92/81d40fc98a5bbbfbafa4cc1ab86d6288/dotnet-sdk-6.0.427-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/00530a6e-d2da-4c65-aa81-24cd1b8d7012/1213e0922920e0939d81f3d687a49725/dotnet-sdk-6.0.427-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9354e51e-f557-4d99-8b0c-53bb03055201/8267bd56eb17a930408805fc986e8b98/dotnet-sdk-6.0.427-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/82d434e3-1910-40be-bf9e-a4ed5439d336/259a9d70a9bc501a73d167fa473e8fda/dotnet-sdk-6.0.427-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fb30dfb9-b1d0-46a1-a59f-ae1037158de1/83d66d2d78b8ae231c3ded22f1832537/dotnet-sdk-6.0.427-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a9eb3bfc-93cd-45ff-846c-b9782577db8d/9b15e12bb8e4bb253d46688da4556f14/dotnet-sdk-6.0.427-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/289b1083-04b7-4752-bd1e-8166f9987bee/92c021f741718f8b5374f1df09235557/dotnet-sdk-6.0.427-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d28a1003-167b-4223-b7fe-5e4c35d462af/a34a42006700d482816b24224ff3425c/dotnet-sdk-6.0.427-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/493caf1f-df72-4ed8-b011-fd5c0a721dbc/b166ce2a487008737ccecb26d20c2a01/dotnet-sdk-6.0.427-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2be51326-ca0c-4f59-a9d0-e25f83d26619/395afb7637c53c6a3d05fdf60f1a2e23/dotnet-sdk-6.0.427-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/08d6f254-25f6-4b3e-a0da-d73d7f4f4ac8/05986f2326dd16f95c8f6d833bb8d5b8/dotnet-sdk-6.0.427-win-x86.zip
