# .NET 6.0.7 - July 12, 2022

The .NET 6.0.7, .NET SDK 6.0.302, and [.NET SDK 6.0.107](6.0.107.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.302
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```


Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

### Host Error Message Fix

As part of launching an application, the .NET host needs to find the .NET runtime itself. If a runtime (or SDK) cannot be found, the user will not be able to run their application (or run a SDK command). To improve the error experience in such cases, we updated error messages and commands like dotnet --info to provide more information. The more consistent layout and additional information is intended to help end-users self-diagnose their problems and developers support their end-users.

### Additional fixes in this release

* [ASP.NET](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A6.0.7+is%3Aclosed+label%3AServicing-approved+)
* [Efcore](https://github.com/dotnet/efcore/issues?q=milestone%3A6.0.7+is%3Aclosed+label%3AServicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.7+is%3Aclosed+label%3Aservicing-approved+)
* [Winforms](https://github.com/dotnet/winforms/issues?q=milestone%3A6.0.7+is%3Aclosed+label%3AServicing-approved+)
* [WPF](https://github.com/dotnet/wpf/issues?q=milestone%3A6.0.7+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.2](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7596](https://github.com/dotnet/core/issues/7596) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.7.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.7-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.7-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/july-2022-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Ref| 6.0.7.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86| 6.0.7.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64| 6.0.7.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86| 6.0.7.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task| 6.0.7.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64| 6.0.7.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64| 6.0.7.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk| 6.0.7.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64| 6.0.7.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86| 6.0.7.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Composite| 6.0.7.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200.Msi.arm64| 6.0.7.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-arm| 6.0.7.nupkg
Microsoft.NETCore.App.Crossgen2.win-x86| 6.0.7.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Host.win-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Host.win-x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.win-x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-arm| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64| 6.0.7.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.win-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.osx-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64| 6.0.7.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 6.0.7.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.7.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost| 6.0.7.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.7.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-arm64| 6.0.7.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost| 6.0.7.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.7.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.7.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.7.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.7.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 6.0.7.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.7.nupkg
Microsoft.NET.Runtime.wasm.Sample.Mono| 6.0.7.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200| 6.0.7.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100| 6.0.7.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64| 6.0.7.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86| 6.0.7.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64| 6.0.7.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Crossgen2.osx-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Crossgen2.win-arm| 6.0.7.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Host.linux-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Ref| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.linux-arm| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.linux-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.osx-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64| 6.0.7.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.7.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.7.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 6.0.7.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.7.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.7.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 6.0.7.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-x86| 6.0.7.nupkg
Microsoft.NETCore.DotNetHost| 6.0.7.nupkg
Microsoft.NETCore.DotNetHostResolver| 6.0.7.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 6.0.7.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.7.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.7.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHost| 6.0.7.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.7.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.7.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.7.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.7.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 6.0.7.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 6.0.7.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost| 6.0.7.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.7.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.7.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost| 6.0.7.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 6.0.7.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.7.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64| 6.0.7.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Crossgen2.linux-arm| 6.0.7.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Crossgen2.win-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Crossgen2.osx-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64| 6.0.7.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64| 6.0.7.nupkg
Microsoft.NET.Runtime.Android.Sample.Mono| 6.0.7.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64| 6.0.7.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300| 6.0.7.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.DotNetAppHost| 6.0.7.nupkg
Microsoft.NETCore.DotNetHostPolicy| 6.0.7.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 6.0.7.nupkg
Microsoft.NETCore.Platforms| 6.0.5.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.7.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 6.0.7.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 6.0.7.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.7.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 6.0.7.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.7.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 6.0.7.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 6.0.7.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.7.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 6.0.7.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk| 6.0.7.nupkg
Microsoft.NETCore.App.Crossgen2.linux-arm64| 6.0.7.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Host.linux-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Host.osx-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Host.osx-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Host.win-arm| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm| 6.0.7.nupkg
Microsoft.NET.Runtime.iOS.Sample.Mono| 6.0.7.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86| 6.0.7.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64| 6.0.7.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200.Msi.x86| 6.0.7.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm| 6.0.7.nupkg
Microsoft.NETCore.App.Host.linux-arm| 6.0.7.nupkg
Microsoft.NETCore.App.Host.win-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64| 6.0.7.nupkg
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64| 6.0.7.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 6.0.7.nupkg
Microsoft.AspNetCore.Cryptography.Internal| 6.0.7.nupkg
Microsoft.AspNetCore.DataProtection| 6.0.7.nupkg
Microsoft.AspNetCore.Http.Connections.Client| 6.0.7.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates| 6.0.7.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis| 6.0.7.nupkg
Microsoft.Extensions.Caching.SqlServer| 6.0.7.nupkg
Microsoft.Extensions.Configuration.KeyPerFile| 6.0.7.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 6.0.7.nupkg
Microsoft.Extensions.Identity.Core| 6.0.7.nupkg
Microsoft.Extensions.Localization.Abstractions| 6.0.7.nupkg
Microsoft.Extensions.WebEncoders| 6.0.7.nupkg
Microsoft.JSInterop.WebAssembly| 6.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64| 6.0.7.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 6.0.7.nupkg
Microsoft.AspNetCore.Authentication.Facebook| 6.0.7.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer| 6.0.7.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect| 6.0.7.nupkg
Microsoft.AspNetCore.Authorization| 6.0.7.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 6.0.7.nupkg
Microsoft.AspNetCore.Components.WebView| 6.0.7.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 6.0.7.nupkg
Microsoft.AspNetCore.DataProtection.Extensions| 6.0.7.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 6.0.7.nupkg
Microsoft.AspNetCore.Http.Connections.Common| 6.0.7.nupkg
Microsoft.AspNetCore.Metadata| 6.0.7.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 6.0.7.nupkg
Microsoft.AspNetCore.Owin| 6.0.7.nupkg
Microsoft.AspNetCore.SignalR.Client.Core| 6.0.7.nupkg
Microsoft.AspNetCore.SignalR.Common| 6.0.7.nupkg
Microsoft.Authentication.WebAssembly.Msal| 6.0.7.nupkg
Microsoft.DotNet.Web.ItemTemplates.6.0| 6.0.7.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0| 6.0.7.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks| 6.0.7.nupkg
Microsoft.Extensions.Logging.AzureAppServices| 6.0.7.nupkg
Microsoft.Extensions.ObjectPool| 6.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm| 6.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 6.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm| 6.0.7.nupkg
Microsoft.AspNetCore.HeaderPropagation| 6.0.7.nupkg
Microsoft.AspNetCore.Identity.UI| 6.0.7.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions| 6.0.7.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 6.0.7.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 6.0.7.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json| 6.0.7.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests| 6.0.7.nupkg
Microsoft.AspNetCore.SpaProxy| 6.0.7.nupkg
Microsoft.DotNet.Web.ProjectTemplates.6.0| 6.0.7.nupkg
Microsoft.Extensions.ApiDescription.Client| 6.0.7.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 6.0.7.nupkg
Microsoft.Extensions.FileProviders.Embedded| 6.0.7.nupkg
Microsoft.Extensions.Identity.Stores| 6.0.7.nupkg
Microsoft.Extensions.Localization| 6.0.7.nupkg
Microsoft.JSInterop| 6.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64| 6.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64| 6.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.osx-arm64| 6.0.7.nupkg
AspNetCoreRuntime.6.0.x86| 6.0.7.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI| 6.0.7.nupkg
Microsoft.AspNetCore.Authentication.Google| 6.0.7.nupkg
Microsoft.AspNetCore.Authentication.Certificate| 6.0.7.nupkg
Microsoft.AspNetCore.Authentication.Twitter| 6.0.7.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer| 6.0.7.nupkg
Microsoft.AspNetCore.Components.Forms| 6.0.7.nupkg
Microsoft.AspNetCore.Components.Web| 6.0.7.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server| 6.0.7.nupkg
Microsoft.AspNetCore.Components.WebAssembly| 6.0.7.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication| 6.0.7.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 6.0.7.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis| 6.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm| 6.0.7.nupkg
AspNetCoreRuntime.6.0.x64| 6.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64| 6.0.7.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 6.0.7.nupkg
Microsoft.AspNetCore.Authentication.Negotiate| 6.0.7.nupkg
Microsoft.AspNetCore.Authentication.WsFederation| 6.0.7.nupkg
Microsoft.AspNetCore.Components| 6.0.7.nupkg
Microsoft.AspNetCore.Components.Analyzers| 6.0.7.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 6.0.7.nupkg
Microsoft.AspNetCore.SignalR.Client| 6.0.7.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 6.0.7.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 6.0.7.nupkg
Microsoft.AspNetCore.SpaServices.Extensions| 6.0.7.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter| 6.0.7.nupkg
Microsoft.AspNetCore.Connections.Abstractions| 6.0.7.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices| 6.0.7.nupkg
Microsoft.AspNetCore.JsonPatch| 6.0.7.nupkg
Microsoft.AspNetCore.Mvc.Testing| 6.0.7.nupkg
Microsoft.AspNetCore.Razor.Language| 6.0.7.nupkg
Microsoft.dotnet-openapi| 6.0.7.nupkg
Microsoft.AspNetCore.TestHost| 6.0.7.nupkg
Microsoft.Extensions.ApiDescription.Server| 6.0.7.nupkg
Microsoft.CodeAnalysis.Razor| 6.0.7.nupkg
Microsoft.Extensions.Features| 6.0.7.nupkg
Microsoft.Extensions.Http.Polly| 6.0.7.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation| 6.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64| 6.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 6.0.7.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions| 6.0.7.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 6.0.7.nupkg
dotnet-sql-cache| 6.0.7.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86| 6.0.7.nupkg
Microsoft.AspNetCore.App.Ref| 6.0.7.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 6.0.7.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 6.0.7.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration| 6.0.7.nupkg
Microsoft.AspNetCore.Components.Authorization| 6.0.7.nupkg
Microsoft.TemplateEngine.Core| 6.0.302.nupkg
Microsoft.TemplateEngine.Core.Contracts| 6.0.302.nupkg
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.302.nupkg
Microsoft.TemplateEngine.Utils| 6.0.302.nupkg
Microsoft.DotNet.Common.ItemTemplates| 6.0.302.nupkg
Microsoft.TemplateEngine.Abstractions| 6.0.302.nupkg
Microsoft.TemplateEngine.Edge| 6.0.302.nupkg
Microsoft.TemplateEngine.IDE| 6.0.302.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.302.nupkg
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.302.nupkg
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.302.nupkg
Microsoft.TemplateSearch.Common| 6.0.302.nupkg
FSharp.Compiler.Service| 41.0.5.nupkg
FSharp.Core| 6.0.5.nupkg
Microsoft.EntityFrameworkCore| 6.0.7.nupkg
Microsoft.EntityFrameworkCore.InMemory| 6.0.7.nupkg
dotnet-ef| 6.0.7.nupkg
Microsoft.EntityFrameworkCore.Relational| 6.0.7.nupkg
Microsoft.EntityFrameworkCore.Proxies| 6.0.7.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 6.0.7.nupkg
Microsoft.EntityFrameworkCore.Sqlite| 6.0.7.nupkg
Microsoft.EntityFrameworkCore.Abstractions| 6.0.7.nupkg
Microsoft.EntityFrameworkCore.Design| 6.0.7.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core| 6.0.7.nupkg
Microsoft.EntityFrameworkCore.Tools| 6.0.7.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 6.0.7.nupkg
Microsoft.Data.Sqlite| 6.0.7.nupkg
Microsoft.EntityFrameworkCore.Analyzers| 6.0.7.nupkg
Microsoft.Data.Sqlite.Core| 6.0.7.nupkg
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests| 6.0.7.nupkg
Microsoft.EntityFrameworkCore.Cosmos| 6.0.7.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests| 6.0.7.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 6.0.7.nupkg
Microsoft.EntityFrameworkCore.SqlServer| 6.0.7.nupkg
Microsoft.TemplateEngine.Abstractions| 6.0.107.nupkg
Microsoft.TemplateEngine.Core| 6.0.107.nupkg
Microsoft.TemplateEngine.Edge| 6.0.107.nupkg
Microsoft.TemplateEngine.IDE| 6.0.107.nupkg
Microsoft.DotNet.Common.ItemTemplates| 6.0.107.nupkg
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.107.nupkg
Microsoft.TemplateEngine.Core.Contracts| 6.0.107.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.107.nupkg
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.107.nupkg
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.107.nupkg
Microsoft.TemplateSearch.Common| 6.0.107.nupkg
Microsoft.TemplateEngine.Utils| 6.0.107.nupkg
Microsoft.DotNet.Compatibility| 1.0.0-servicing.22323.13.nupkg


[//]: # ( Runtime 6.0.7)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a9be5a0b-5a78-42fe-a387-adb609d115e8/faa10b75513805e36ff7b36044d11507/dotnet-runtime-6.0.7-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f9706e92-c7a1-4dc8-806a-0e95827c5b02/23be52946e4e2425c798208c5f16bb64/dotnet-runtime-6.0.7-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bc3edd96-0350-41e5-9e88-ce1d7895ab8b/abe8c0538a371f105f64d308714f78cf/dotnet-runtime-6.0.7-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/309c5907-8b8c-4fff-96ec-63c28af465ef/1b68392e32d74f011c3b40a17f556717/dotnet-runtime-6.0.7-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b094870b-80a9-43d5-b312-e7bf25dc04a6/acbb927eaea3775bc307161f6300ac9c/dotnet-runtime-6.0.7-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bd828687-1706-4041-a804-5e93631fe256/d4ec75936459a7e8c772c929edcbfeda/dotnet-runtime-6.0.7-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ba8b5982-2d85-4b0f-a933-13b1dcca3e2d/a367458c007ef00bf1544754578cf54c/dotnet-runtime-6.0.7-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/044c6d0f-0ac2-450f-b621-637ca24ab2fb/5cd0c43804f3fde6d09cacbfd8525868/dotnet-runtime-6.0.7-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3da50ef8-7b22-4f08-95e9-3641416fdc08/ee91bcdbbbb117803e315f673c9d19f1/dotnet-runtime-6.0.7-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/97def016-12c7-4e24-b924-772485a41faa/e96d9a0502492efa7de3897467f5972c/dotnet-runtime-6.0.7-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/44834c32-f8c0-4ff9-9d8b-6c097fa4fb23/683c8ef458a0a8870a757180bb41c0e6/dotnet-runtime-6.0.7-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/e9b7052c-3fde-4e8b-8e08-deb60bc16058/98eee9da57eb76a3f035112fb1d87ad4/dotnet-runtime-6.0.7-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/175ea216-cfde-4fab-8184-c19ce4c1e349/05f550b728c9f53e3e14ec54f40f42aa/dotnet-runtime-6.0.7-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5cd66804-64a8-45e5-886e-708788fc8029/0fb15515f1a8661b973ad7222d277d0a/dotnet-runtime-6.0.7-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b26d33ca-ff50-48c0-9f97-cf936e917f82/a145bfd75fef7255df427fcc417c36e5/dotnet-runtime-6.0.7-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a549cf2d-5198-477c-b5ee-afc5fb6f2ddd/a3a43236eb7338685c8d2932db60115b/dotnet-runtime-6.0.7-win-x86.zip

[//]: # ( WindowsDesktop 6.0.7)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/f33cf7ce-bf03-428c-8aa7-e32ef6d7ddc6/e61dc60fce686844c41ec2901ad5b01e/windowsdesktop-runtime-6.0.7-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/92af07e6-3e09-493d-a923-f36f59d1f99e/af0aba8b427c8fc7e76c1ff411c9d9ed/windowsdesktop-runtime-6.0.7-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/dc0e0e83-0115-4518-8b6a-590ed594f38a/65b63e41f6a80decb37fa3c5af79a53d/windowsdesktop-runtime-6.0.7-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/516a8e99-13f9-4b75-bb0b-915474ef697b/f8063599bc9128ca6e64ff7ef9b60383/windowsdesktop-runtime-6.0.7-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f21307ec-9007-48ba-80cb-0b1b7c3c212a/366a3d6b4c092d85d7979c6bb818f1b6/windowsdesktop-runtime-6.0.7-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c4e00967-8611-4e27-9b4b-5b23067265a3/0dea22d1d07fb5a21745bd758ade744d/windowsdesktop-runtime-6.0.7-win-x86.zip

[//]: # ( ASP 6.0.7)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/228e3f86-84fa-4109-9655-2a381acbd6c1/eb174b5083bb639d8b219b7cb11fa50f/aspnetcore-runtime-6.0.7-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b79c5fa9-a08d-4534-9424-4bacfc3cdc3d/449179d6fe8cda05f52b7be0f6828eb0/aspnetcore-runtime-6.0.7-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/451a391e-5a04-47b2-af06-716eef35f583/0d75643777814a60f614d183848ba2d8/aspnetcore-runtime-6.0.7-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2a19f8c9-9381-42a7-bbd4-4c611b1b7ff7/791479159cbe3079b17911e6a687206f/aspnetcore-runtime-6.0.7-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4d0afe6e-9076-494d-bbdb-4e0999613ff5/814f81655f7297e6962875a6cbffb227/aspnetcore-runtime-6.0.7-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/98271725-1784-407c-841a-64d87c674512/b433af33506c816e3b5838f5c65d990a/aspnetcore-runtime-6.0.7-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3d952783-f61f-4399-841a-fa5b5aeffded/15580a465dec6a7c67107e3f96d6da13/aspnetcore-runtime-6.0.7-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5b4d2b0e-607e-4f9a-944f-0acdefd828d9/79a0271038df505617ef800587a92858/aspnetcore-runtime-6.0.7-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/556c57fd-ee7f-42ad-a5ef-f0c1ae30fddd/8dc564bca48badb00a53111922eb19e1/aspnetcore-runtime-6.0.7-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c4c86d02-a47b-4bd4-b73d-ec3be19e5245/76c673e22a120464c95f85bef342a361/aspnetcore-runtime-6.0.7-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1b11ff50-0e82-4a0c-9b1e-99347d218671/0f20eb26cbac962090ca27af88aa2c24/aspnetcore-runtime-6.0.7-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a6f2f0c7-07ff-4255-88e6-707b84990828/db97169bf75388792cb52881dcc6afbc/aspnetcore-runtime-6.0.7-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b3a7c46e-6e53-4aac-bdc3-a8a7f15efefe/37049c002ffd567eab9729a9d0a47e38/aspnetcore-runtime-6.0.7-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/7de08ae2-75e6-49b8-b04a-31526204fa7b/c1cee44a509495e4bb0bba49f52c719a/dotnet-hosting-6.0.7-win.exe

[//]: # ( SDK 6.0.302)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f35557f7-d5e1-43be-93b6-e59ee8bd823c/9dd2c25a4d7351412ff5902c355732ca/dotnet-sdk-6.0.302-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/33389348-a7d7-41ae-850f-ec46d3ca9612/36bad11f948b05a4fa9faac93c35e574/dotnet-sdk-6.0.302-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a16a9795-f335-479e-aad4-0727e163895d/ed1db010fa5458e5ce082590256e9614/dotnet-sdk-6.0.302-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c9fb57ea-0f34-4344-9211-10990010daa5/8c79eae867c9536b8fb8736a0e6c61dd/dotnet-sdk-6.0.302-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/25f15b42-3e95-43b2-bfdf-6c7f20725b82/73af45db61e17748d9f901a71f5c82a2/dotnet-sdk-6.0.302-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0e83f50a-0619-45e6-8f16-dc4f41d1bb16/e0de908b2f070ef9e7e3b6ddea9d268c/dotnet-sdk-6.0.302-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7d98e8ca-e8ec-490b-8ffc-55a458981d86/32c92f3aa0f460119de53477cffa8a0a/dotnet-sdk-6.0.302-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/01a17a2d-6b92-4521-97a2-ad7d845a8064/44aa4e10f71e70a38b5f6f59d211cbab/dotnet-sdk-6.0.302-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7257dada-8ec1-4b5c-9b69-7201a2cf377f/89f452882fb87fbb89d697417cb3f231/dotnet-sdk-6.0.302-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/60719796-b5c5-46dc-a26a-7e8126a292c8/a7b871d6c46136b61c30403d085ef97c/dotnet-sdk-6.0.302-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b1b1b47e-dae9-48e1-80f3-9ff920fa937f/9ca322594becea69bf4b9104fdce6154/dotnet-sdk-6.0.302-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/b1dcdb33-ca37-482b-92c6-6aa7b966305a/c7b6ccfbc028c095c36af1bf682a78e7/dotnet-sdk-6.0.302-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c246f2b8-da39-4b12-b87d-bf89b6b51298/2d43d4ded4b6a0c4d1a0b52f0b9a3b30/dotnet-sdk-6.0.302-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/44d08222-aaa9-4d35-b24b-d0db03432ab7/52a4eb5922afd19e8e0d03e0dbbb41a0/dotnet-sdk-6.0.302-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d238bcf4-7362-4885-b371-e23a269a96bd/838e7e2d43528f9c79001f7737d38e7d/dotnet-sdk-6.0.302-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/28119dbe-f067-42b2-8352-c1de410e10ac/dd10dce1cd17a2d4dbbaa44455bbcb04/dotnet-sdk-6.0.302-win-x86.zip