# System.IO

``` diff
 namespace System.IO {
     public class BinaryReader : IDisposable {
+        public virtual Half ReadHalf();
     }
     public class BinaryWriter : IAsyncDisposable, IDisposable {
+        public virtual void Write(Half value);
     }
     public sealed class BufferedStream : Stream {
-        public override int Read(byte[] array, int offset, int count);
+        public override int Read(byte[] buffer, int offset, int count);
-        public override void Write(byte[] array, int offset, int count);
+        public override void Write(byte[] buffer, int offset, int count);
     }
     public static class Directory {
+        public static FileSystemInfo CreateSymbolicLink(string path, string pathToTarget);
+        public static FileSystemInfo ResolveLinkTarget(string linkPath, bool returnFinalTarget);
     }
     public class EnumerationOptions {
+        public int MaxRecursionDepth { get; set; }
     }
     public static class File {
+        public static FileSystemInfo CreateSymbolicLink(string path, string pathToTarget);
+        public static FileStream Open(string path, FileStreamOptions options);
+        public static SafeFileHandle OpenHandle(string path, FileMode mode = FileMode.Open, FileAccess access = FileAccess.Read, FileShare share = FileShare.Read, FileOptions options = FileOptions.None, long preallocationSize = (long)0);
+        public static FileSystemInfo ResolveLinkTarget(string linkPath, bool returnFinalTarget);
     }
     public sealed class FileInfo : FileSystemInfo {
+        public FileStream Open(FileStreamOptions options);
     }
     public class FileStream : Stream {
+        public FileStream(string path, FileStreamOptions options);
-        public override IAsyncResult BeginRead(byte[] array, int offset, int numBytes, AsyncCallback callback, object state);
+        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
-        public override IAsyncResult BeginWrite(byte[] array, int offset, int numBytes, AsyncCallback callback, object state);
+        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
-        public override int Read(byte[] array, int offset, int count);
+        public override int Read(byte[] buffer, int offset, int count);
-        public override void Write(byte[] array, int offset, int count);
+        public override void Write(byte[] buffer, int offset, int count);
     }
+    public sealed class FileStreamOptions {
+        public FileStreamOptions();
+        public FileAccess Access { get; set; }
+        public int BufferSize { get; set; }
+        public FileMode Mode { get; set; }
+        public FileOptions Options { get; set; }
+        public long PreallocationSize { get; set; }
+        public FileShare Share { get; set; }
+    }
+    public static class FileSystemAclExtensions {
+        public static void Create(this DirectoryInfo directoryInfo, DirectorySecurity directorySecurity);
+        public static FileStream Create(this FileInfo fileInfo, FileMode mode, FileSystemRights rights, FileShare share, int bufferSize, FileOptions options, FileSecurity fileSecurity);
+        public static DirectoryInfo CreateDirectory(this DirectorySecurity directorySecurity, string path);
+        public static DirectorySecurity GetAccessControl(this DirectoryInfo directoryInfo);
+        public static DirectorySecurity GetAccessControl(this DirectoryInfo directoryInfo, AccessControlSections includeSections);
+        public static FileSecurity GetAccessControl(this FileInfo fileInfo);
+        public static FileSecurity GetAccessControl(this FileInfo fileInfo, AccessControlSections includeSections);
+        public static FileSecurity GetAccessControl(this FileStream fileStream);
+        public static void SetAccessControl(this DirectoryInfo directoryInfo, DirectorySecurity directorySecurity);
+        public static void SetAccessControl(this FileInfo fileInfo, FileSecurity fileSecurity);
+        public static void SetAccessControl(this FileStream fileStream, FileSecurity fileSecurity);
+    }
     public abstract class FileSystemInfo : MarshalByRefObject, ISerializable {
+        public string LinkTarget { get; }
+        public void CreateAsSymbolicLink(string pathToTarget);
+        public FileSystemInfo ResolveLinkTarget(bool returnFinalTarget);
     }
     public class MemoryStream : Stream {
-        public override int Read(Span<byte> destination);
+        public override int Read(Span<byte> buffer);
-        public override ValueTask<int> ReadAsync(Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public override ValueTask<int> ReadAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
-        public override void Write(ReadOnlySpan<byte> source);
+        public override void Write(ReadOnlySpan<byte> buffer);
-        public override ValueTask WriteAsync(ReadOnlyMemory<byte> source, CancellationToken cancellationToken = default(CancellationToken));
+        public override ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
+    public static class RandomAccess {
+        public static long GetLength(SafeFileHandle handle);
+        public static long Read(SafeFileHandle handle, IReadOnlyList<Memory<byte>> buffers, long fileOffset);
+        public static int Read(SafeFileHandle handle, Span<byte> buffer, long fileOffset);
+        public static ValueTask<long> ReadAsync(SafeFileHandle handle, IReadOnlyList<Memory<byte>> buffers, long fileOffset, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<int> ReadAsync(SafeFileHandle handle, Memory<byte> buffer, long fileOffset, CancellationToken cancellationToken = default(CancellationToken));
+        public static void Write(SafeFileHandle handle, IReadOnlyList<ReadOnlyMemory<byte>> buffers, long fileOffset);
+        public static void Write(SafeFileHandle handle, ReadOnlySpan<byte> buffer, long fileOffset);
+        public static ValueTask WriteAsync(SafeFileHandle handle, IReadOnlyList<ReadOnlyMemory<byte>> buffers, long fileOffset, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask WriteAsync(SafeFileHandle handle, ReadOnlyMemory<byte> buffer, long fileOffset, CancellationToken cancellationToken = default(CancellationToken));
+    }
     public abstract class Stream : MarshalByRefObject, IAsyncDisposable, IDisposable {
+        protected static void ValidateBufferArguments(byte[] buffer, int offset, int count);
+        protected static void ValidateCopyToArguments(Stream destination, int bufferSize);
     }
     public class StreamReader : TextReader {
+        public StreamReader(string path, FileStreamOptions options);
+        public StreamReader(string path, Encoding encoding, bool detectEncodingFromByteOrderMarks, FileStreamOptions options);
     }
     public class StreamWriter : TextWriter {
+        public StreamWriter(string path, FileStreamOptions options);
+        public StreamWriter(string path, Encoding encoding, FileStreamOptions options);
     }
     public class UnmanagedMemoryStream : Stream {
-        public override int Read(Span<byte> destination);
+        public override int Read(Span<byte> buffer);
-        public override void Write(ReadOnlySpan<byte> source);
+        public override void Write(ReadOnlySpan<byte> buffer);
     }
 }
```

