# System.Linq

``` diff
 namespace System.Linq {
     public static class Enumerable {
+        public static IEnumerable<TSource[]> Chunk<TSource>(this IEnumerable<TSource> source, int size);
+        public static IEnumerable<TSource> DistinctBy<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector);
+        public static IEnumerable<TSource> DistinctBy<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
+        public static TSource ElementAt<TSource>(this IEnumerable<TSource> source, Index index);
+        public static TSource ElementAtOrDefault<TSource>(this IEnumerable<TSource> source, Index index);
+        public static IEnumerable<TSource> ExceptBy<TSource, TKey>(this IEnumerable<TSource> first, IEnumerable<TKey> second, Func<TSource, TKey> keySelector);
+        public static IEnumerable<TSource> ExceptBy<TSource, TKey>(this IEnumerable<TSource> first, IEnumerable<TKey> second, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
+        public static TSource FirstOrDefault<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate, TSource defaultValue);
+        public static TSource FirstOrDefault<TSource>(this IEnumerable<TSource> source, TSource defaultValue);
+        public static IEnumerable<TSource> IntersectBy<TSource, TKey>(this IEnumerable<TSource> first, IEnumerable<TKey> second, Func<TSource, TKey> keySelector);
+        public static IEnumerable<TSource> IntersectBy<TSource, TKey>(this IEnumerable<TSource> first, IEnumerable<TKey> second, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
+        public static TSource LastOrDefault<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate, TSource defaultValue);
+        public static TSource LastOrDefault<TSource>(this IEnumerable<TSource> source, TSource defaultValue);
+        public static TSource Max<TSource>(this IEnumerable<TSource> source, IComparer<TSource> comparer);
+        public static TSource MaxBy<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector);
+        public static TSource MaxBy<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
+        public static TSource Min<TSource>(this IEnumerable<TSource> source, IComparer<TSource> comparer);
+        public static TSource MinBy<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector);
+        public static TSource MinBy<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
+        public static TSource SingleOrDefault<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate, TSource defaultValue);
+        public static TSource SingleOrDefault<TSource>(this IEnumerable<TSource> source, TSource defaultValue);
+        public static IEnumerable<TSource> Take<TSource>(this IEnumerable<TSource> source, Range range);
+        public static bool TryGetNonEnumeratedCount<TSource>(this IEnumerable<TSource> source, out int count);
+        public static IEnumerable<TSource> UnionBy<TSource, TKey>(this IEnumerable<TSource> first, IEnumerable<TSource> second, Func<TSource, TKey> keySelector);
+        public static IEnumerable<TSource> UnionBy<TSource, TKey>(this IEnumerable<TSource> first, IEnumerable<TSource> second, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
+        public static IEnumerable<ValueTuple<TFirst, TSecond, TThird>> Zip<TFirst, TSecond, TThird>(this IEnumerable<TFirst> first, IEnumerable<TSecond> second, IEnumerable<TThird> third);
     }
     public static class Queryable {
+        public static IQueryable<TSource[]> Chunk<TSource>(this IQueryable<TSource> source, int size);
+        public static IQueryable<TSource> DistinctBy<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector);
+        public static IQueryable<TSource> DistinctBy<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, IEqualityComparer<TKey> comparer);
+        public static TSource ElementAt<TSource>(this IQueryable<TSource> source, Index index);
+        public static TSource ElementAtOrDefault<TSource>(this IQueryable<TSource> source, Index index);
+        public static IQueryable<TSource> ExceptBy<TSource, TKey>(this IQueryable<TSource> source1, IEnumerable<TKey> source2, Expression<Func<TSource, TKey>> keySelector);
+        public static IQueryable<TSource> ExceptBy<TSource, TKey>(this IQueryable<TSource> source1, IEnumerable<TKey> source2, Expression<Func<TSource, TKey>> keySelector, IEqualityComparer<TKey> comparer);
+        public static TSource FirstOrDefault<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate, TSource defaultValue);
+        public static TSource FirstOrDefault<TSource>(this IQueryable<TSource> source, TSource defaultValue);
+        public static IQueryable<TSource> IntersectBy<TSource, TKey>(this IQueryable<TSource> source1, IEnumerable<TKey> source2, Expression<Func<TSource, TKey>> keySelector);
+        public static IQueryable<TSource> IntersectBy<TSource, TKey>(this IQueryable<TSource> source1, IEnumerable<TKey> source2, Expression<Func<TSource, TKey>> keySelector, IEqualityComparer<TKey> comparer);
+        public static TSource LastOrDefault<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate, TSource defaultValue);
+        public static TSource LastOrDefault<TSource>(this IQueryable<TSource> source, TSource defaultValue);
+        public static TSource Max<TSource>(this IQueryable<TSource> source, IComparer<TSource> comparer);
+        public static TSource MaxBy<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector);
+        public static TSource MaxBy<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, IComparer<TSource> comparer);
+        public static TSource Min<TSource>(this IQueryable<TSource> source, IComparer<TSource> comparer);
+        public static TSource MinBy<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector);
+        public static TSource MinBy<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, IComparer<TSource> comparer);
+        public static TSource SingleOrDefault<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate, TSource defaultValue);
+        public static TSource SingleOrDefault<TSource>(this IQueryable<TSource> source, TSource defaultValue);
+        public static IQueryable<TSource> Take<TSource>(this IQueryable<TSource> source, Range range);
+        public static IQueryable<TSource> UnionBy<TSource, TKey>(this IQueryable<TSource> source1, IEnumerable<TSource> source2, Expression<Func<TSource, TKey>> keySelector);
+        public static IQueryable<TSource> UnionBy<TSource, TKey>(this IQueryable<TSource> source1, IEnumerable<TSource> source2, Expression<Func<TSource, TKey>> keySelector, IEqualityComparer<TKey> comparer);
+        public static IQueryable<ValueTuple<TFirst, TSecond, TThird>> Zip<TFirst, TSecond, TThird>(this IQueryable<TFirst> source1, IEnumerable<TSecond> source2, IEnumerable<TThird> source3);
     }
 }
```

