# System.Numerics

``` diff
 namespace System.Numerics {
-    public readonly struct BigInteger : IComparable, IComparable<BigInteger>, IEquatable<BigInteger>, IFormattable
+    public readonly struct BigInteger : IComparable, IComparable<BigInteger>, IEquatable<BigInteger>, IFormattable, ISpanFormattable
     public static class BitOperations {
+        public static bool IsPow2(int value);
+        public static bool IsPow2(long value);
+        public static bool IsPow2(uint value);
+        public static bool IsPow2(ulong value);
+        public static uint RoundUpToPowerOf2(uint value);
+        public static ulong RoundUpToPowerOf2(ulong value);
     }
-    public struct Complex : IEquatable<Complex>, IFormattable
+    public readonly struct Complex : IEquatable<Complex>, IFormattable
     public static class Vector {
+        public static Vector<TTo> As<TFrom, TTo>(this Vector<TFrom> vector) where TFrom : struct where TTo : struct;
+        public static Vector<IntPtr> AsVectorNInt<T>(Vector<T> value) where T : struct;
+        public static Vector<UIntPtr> AsVectorNUInt<T>(Vector<T> value) where T : struct;
-        public static Vector<Single> Narrow(Vector<Double> source1, Vector<Double> source2);
+        public static Vector<Single> Narrow(Vector<Double> low, Vector<Double> high);
-        public static Vector<SByte> Narrow(Vector<Int16> source1, Vector<Int16> source2);
+        public static Vector<SByte> Narrow(Vector<Int16> low, Vector<Int16> high);
-        public static Vector<Int16> Narrow(Vector<Int32> source1, Vector<Int32> source2);
+        public static Vector<Int16> Narrow(Vector<Int32> low, Vector<Int32> high);
-        public static Vector<Int32> Narrow(Vector<Int64> source1, Vector<Int64> source2);
+        public static Vector<Int32> Narrow(Vector<Int64> low, Vector<Int64> high);
-        public static Vector<Byte> Narrow(Vector<UInt16> source1, Vector<UInt16> source2);
+        public static Vector<Byte> Narrow(Vector<UInt16> low, Vector<UInt16> high);
-        public static Vector<UInt16> Narrow(Vector<UInt32> source1, Vector<UInt32> source2);
+        public static Vector<UInt16> Narrow(Vector<UInt32> low, Vector<UInt32> high);
-        public static Vector<UInt32> Narrow(Vector<UInt64> source1, Vector<UInt64> source2);
+        public static Vector<UInt32> Narrow(Vector<UInt64> low, Vector<UInt64> high);
+        public static T Sum<T>(Vector<T> value) where T : struct;
-        public static void Widen(Vector<Byte> source, out Vector<UInt16> dest1, out Vector<UInt16> dest2);
+        public static void Widen(Vector<Byte> source, out Vector<UInt16> low, out Vector<UInt16> high);
-        public static void Widen(Vector<Int16> source, out Vector<Int32> dest1, out Vector<Int32> dest2);
+        public static void Widen(Vector<Int16> source, out Vector<Int32> low, out Vector<Int32> high);
-        public static void Widen(Vector<Int32> source, out Vector<Int64> dest1, out Vector<Int64> dest2);
+        public static void Widen(Vector<Int32> source, out Vector<Int64> low, out Vector<Int64> high);
-        public static void Widen(Vector<SByte> source, out Vector<Int16> dest1, out Vector<Int16> dest2);
+        public static void Widen(Vector<SByte> source, out Vector<Int16> low, out Vector<Int16> high);
-        public static void Widen(Vector<Single> source, out Vector<Double> dest1, out Vector<Double> dest2);
+        public static void Widen(Vector<Single> source, out Vector<Double> low, out Vector<Double> high);
-        public static void Widen(Vector<UInt16> source, out Vector<UInt32> dest1, out Vector<UInt32> dest2);
+        public static void Widen(Vector<UInt16> source, out Vector<UInt32> low, out Vector<UInt32> high);
-        public static void Widen(Vector<UInt32> source, out Vector<UInt64> dest1, out Vector<UInt64> dest2);
+        public static void Widen(Vector<UInt32> source, out Vector<UInt64> low, out Vector<UInt64> high);
     }
     public struct Vector<T> : IEquatable<Vector<T>>, IFormattable where T : struct {
+        public static explicit operator Vector<IntPtr> (Vector<T> value);
+        public static explicit operator Vector<UIntPtr> (Vector<T> value);
     }
     public struct Vector2 : IEquatable<Vector2>, IFormattable {
+        public Vector2(ReadOnlySpan<float> values);
+        public void CopyTo(Span<float> destination);
+        public bool TryCopyTo(Span<float> destination);
     }
     public struct Vector3 : IEquatable<Vector3>, IFormattable {
+        public Vector3(ReadOnlySpan<float> values);
+        public void CopyTo(Span<float> destination);
+        public bool TryCopyTo(Span<float> destination);
     }
     public struct Vector4 : IEquatable<Vector4>, IFormattable {
+        public Vector4(ReadOnlySpan<float> values);
+        public void CopyTo(Span<float> destination);
+        public bool TryCopyTo(Span<float> destination);
     }
 }
```

