# System.Runtime.InteropServices

``` diff
 namespace System.Runtime.InteropServices {
     public enum Architecture {
+        S390x = 5,
     }
-    public struct ArrayWithOffset
+    public readonly struct ArrayWithOffset
+    public readonly struct CLong : IEquatable<CLong> {
+        public CLong(int value);
+        public CLong(IntPtr value);
+        public IntPtr Value { get; }
+        public override bool Equals(object o);
+        public bool Equals(CLong other);
+        public override int GetHashCode();
+        public override string ToString();
+    }
     public static class CollectionsMarshal {
+        public static ref TValue GetValueRefOrAddDefault<TKey, TValue>(Dictionary<TKey, TValue> dictionary, TKey key, out bool exists);
+        public static ref TValue GetValueRefOrNullRef<TKey, TValue>(Dictionary<TKey, TValue> dictionary, TKey key);
     }
     public abstract class ComWrappers {
+        public object GetOrRegisterObjectForComInstance(IntPtr externalComObject, CreateObjectFlags flags, object wrapper, IntPtr inner);
     }
     public enum CreateObjectFlags {
+        Aggregation = 4,
+        Unwrap = 8,
     }
+    public readonly struct CULong : IEquatable<CULong> {
+        public CULong(uint value);
+        public CULong(UIntPtr value);
+        public UIntPtr Value { get; }
+        public override bool Equals(object o);
+        public bool Equals(CULong other);
+        public override int GetHashCode();
+        public override string ToString();
+    }
     public static class Marshal {
+        public static int GetLastPInvokeError();
+        public static int GetLastSystemError();
+        public static void InitHandle(SafeHandle safeHandle, IntPtr handle);
+        public static void SetLastPInvokeError(int error);
+        public static void SetLastSystemError(int error);
     }
     public static class MemoryMarshal {
+        public unsafe static ReadOnlySpan<byte> CreateReadOnlySpanFromNullTerminated(byte* value);
+        public unsafe static ReadOnlySpan<char> CreateReadOnlySpanFromNullTerminated(char* value);
+        public static ref byte GetArrayDataReference(Array array);
     }
+    public static class NativeMemory {
+        public unsafe static void* AlignedAlloc(UIntPtr byteCount, UIntPtr alignment);
+        public unsafe static void AlignedFree(void* ptr);
+        public unsafe static void* AlignedRealloc(void* ptr, UIntPtr byteCount, UIntPtr alignment);
+        public unsafe static void* Alloc(UIntPtr byteCount);
+        public unsafe static void* Alloc(UIntPtr elementCount, UIntPtr elementSize);
+        public unsafe static void* AllocZeroed(UIntPtr byteCount);
+        public unsafe static void* AllocZeroed(UIntPtr elementCount, UIntPtr elementSize);
+        public unsafe static void Free(void* ptr);
+        public unsafe static void* Realloc(void* ptr, UIntPtr byteCount);
+    }
+    public readonly struct NFloat : IEquatable<NFloat> {
+        public NFloat(double value);
+        public NFloat(float value);
+        public double Value { get; }
+        public override bool Equals(object o);
+        public bool Equals(NFloat other);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public enum PosixSignal {
+        SIGCHLD = -5,
+        SIGCONT = -6,
+        SIGHUP = -1,
+        SIGINT = -2,
+        SIGQUIT = -3,
+        SIGTERM = -4,
+        SIGTSTP = -10,
+        SIGTTIN = -8,
+        SIGTTOU = -9,
+        SIGWINCH = -7,
+    }
+    public sealed class PosixSignalContext {
+        public PosixSignalContext(PosixSignal signal);
+        public bool Cancel { get; set; }
+        public PosixSignal Signal { get; }
+    }
+    public sealed class PosixSignalRegistration : IDisposable {
+        public static PosixSignalRegistration Create(PosixSignal signal, Action<PosixSignalContext> handler);
+        public void Dispose();
+        ~PosixSignalRegistration();
+    }
     public abstract class SafeBuffer : SafeHandleZeroOrMinusOneIsInvalid {
+        public void ReadSpan<T>(ulong byteOffset, Span<T> buffer) where T : struct;
+        public void WriteSpan<T>(ulong byteOffset, ReadOnlySpan<T> data) where T : struct;
     }
+    public sealed class UnmanagedCallConvAttribute : Attribute {
+        public Type[] CallConvs;
+        public UnmanagedCallConvAttribute();
+    }
 }
```

