# System.Text.Json.Serialization.Metadata

``` diff
+namespace System.Text.Json.Serialization.Metadata {
+    public sealed class JsonCollectionInfoValues<TCollection> {
+        public JsonCollectionInfoValues();
+        public JsonTypeInfo ElementInfo { get; set; }
+        public JsonTypeInfo KeyInfo { get; set; }
+        public JsonNumberHandling NumberHandling { get; set; }
+        public Func<TCollection> ObjectCreator { get; set; }
+        public Action<Utf8JsonWriter, TCollection> SerializeHandler { get; set; }
+    }
+    public static class JsonMetadataServices {
+        public static JsonConverter<bool> BooleanConverter { get; }
+        public static JsonConverter<byte[]> ByteArrayConverter { get; }
+        public static JsonConverter<byte> ByteConverter { get; }
+        public static JsonConverter<char> CharConverter { get; }
+        public static JsonConverter<DateTime> DateTimeConverter { get; }
+        public static JsonConverter<DateTimeOffset> DateTimeOffsetConverter { get; }
+        public static JsonConverter<decimal> DecimalConverter { get; }
+        public static JsonConverter<double> DoubleConverter { get; }
+        public static JsonConverter<Guid> GuidConverter { get; }
+        public static JsonConverter<short> Int16Converter { get; }
+        public static JsonConverter<int> Int32Converter { get; }
+        public static JsonConverter<long> Int64Converter { get; }
+        public static JsonConverter<JsonArray> JsonArrayConverter { get; }
+        public static JsonConverter<JsonElement> JsonElementConverter { get; }
+        public static JsonConverter<JsonNode> JsonNodeConverter { get; }
+        public static JsonConverter<JsonObject> JsonObjectConverter { get; }
+        public static JsonConverter<JsonValue> JsonValueConverter { get; }
+        public static JsonConverter<object> ObjectConverter { get; }
+        public static JsonConverter<sbyte> SByteConverter { get; }
+        public static JsonConverter<float> SingleConverter { get; }
+        public static JsonConverter<string> StringConverter { get; }
+        public static JsonConverter<TimeSpan> TimeSpanConverter { get; }
+        public static JsonConverter<ushort> UInt16Converter { get; }
+        public static JsonConverter<uint> UInt32Converter { get; }
+        public static JsonConverter<ulong> UInt64Converter { get; }
+        public static JsonConverter<Uri> UriConverter { get; }
+        public static JsonConverter<Version> VersionConverter { get; }
+        public static JsonTypeInfo<TElement[]> CreateArrayInfo<TElement>(JsonSerializerOptions options, JsonCollectionInfoValues<TElement[]> collectionInfo);
+        public static JsonTypeInfo<TCollection> CreateConcurrentQueueInfo<TCollection, TElement>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo) where TCollection : ConcurrentQueue<TElement>;
+        public static JsonTypeInfo<TCollection> CreateConcurrentStackInfo<TCollection, TElement>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo) where TCollection : ConcurrentStack<TElement>;
+        public static JsonTypeInfo<TCollection> CreateDictionaryInfo<TCollection, TKey, TValue>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo) where TCollection : Dictionary<TKey, TValue>;
+        public static JsonTypeInfo<TCollection> CreateICollectionInfo<TCollection, TElement>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo) where TCollection : ICollection<TElement>;
+        public static JsonTypeInfo<TCollection> CreateIDictionaryInfo<TCollection, TKey, TValue>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo) where TCollection : IDictionary<TKey, TValue>;
+        public static JsonTypeInfo<TCollection> CreateIDictionaryInfo<TCollection>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo) where TCollection : IDictionary;
+        public static JsonTypeInfo<TCollection> CreateIEnumerableInfo<TCollection, TElement>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo) where TCollection : IEnumerable<TElement>;
+        public static JsonTypeInfo<TCollection> CreateIEnumerableInfo<TCollection>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo) where TCollection : IEnumerable;
+        public static JsonTypeInfo<TCollection> CreateIListInfo<TCollection, TElement>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo) where TCollection : IList<TElement>;
+        public static JsonTypeInfo<TCollection> CreateIListInfo<TCollection>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo) where TCollection : IList;
+        public static JsonTypeInfo<TCollection> CreateImmutableDictionaryInfo<TCollection, TKey, TValue>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo, Func<IEnumerable<KeyValuePair<TKey, TValue>>, TCollection> createRangeFunc) where TCollection : IReadOnlyDictionary<TKey, TValue>;
+        public static JsonTypeInfo<TCollection> CreateImmutableEnumerableInfo<TCollection, TElement>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo, Func<IEnumerable<TElement>, TCollection> createRangeFunc) where TCollection : IEnumerable<TElement>;
+        public static JsonTypeInfo<TCollection> CreateIReadOnlyDictionaryInfo<TCollection, TKey, TValue>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo) where TCollection : IReadOnlyDictionary<TKey, TValue>;
+        public static JsonTypeInfo<TCollection> CreateISetInfo<TCollection, TElement>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo) where TCollection : ISet<TElement>;
+        public static JsonTypeInfo<TCollection> CreateListInfo<TCollection, TElement>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo) where TCollection : List<TElement>;
+        public static JsonTypeInfo<T> CreateObjectInfo<T>(JsonSerializerOptions options, JsonObjectInfoValues<T> objectInfo);
+        public static JsonPropertyInfo CreatePropertyInfo<T>(JsonSerializerOptions options, JsonPropertyInfoValues<T> propertyInfo);
+        public static JsonTypeInfo<TCollection> CreateQueueInfo<TCollection, TElement>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo) where TCollection : Queue<TElement>;
+        public static JsonTypeInfo<TCollection> CreateQueueInfo<TCollection>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo, Action<TCollection, object> addFunc) where TCollection : IEnumerable;
+        public static JsonTypeInfo<TCollection> CreateStackInfo<TCollection, TElement>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo) where TCollection : Stack<TElement>;
+        public static JsonTypeInfo<TCollection> CreateStackInfo<TCollection>(JsonSerializerOptions options, JsonCollectionInfoValues<TCollection> collectionInfo, Action<TCollection, object> addFunc) where TCollection : IEnumerable;
+        public static JsonTypeInfo<T> CreateValueInfo<T>(JsonSerializerOptions options, JsonConverter converter);
+        public static JsonConverter<T> GetEnumConverter<T>(JsonSerializerOptions options) where T : struct;
+        public static JsonConverter<T?> GetNullableConverter<T>(JsonTypeInfo<T> underlyingTypeInfo) where T : struct;
+        public static JsonConverter<T> GetUnsupportedTypeConverter<T>();
+    }
+    public sealed class JsonObjectInfoValues<T> {
+        public JsonObjectInfoValues();
+        public Func<JsonParameterInfoValues[]> ConstructorParameterMetadataInitializer { get; set; }
+        public JsonNumberHandling NumberHandling { get; set; }
+        public Func<T> ObjectCreator { get; set; }
+        public Func<object[], T> ObjectWithParameterizedConstructorCreator { get; set; }
+        public Func<JsonSerializerContext, JsonPropertyInfo[]> PropertyMetadataInitializer { get; set; }
+        public Action<Utf8JsonWriter, T> SerializeHandler { get; set; }
+    }
+    public sealed class JsonParameterInfoValues {
+        public JsonParameterInfoValues();
+        public object DefaultValue { get; set; }
+        public bool HasDefaultValue { get; set; }
+        public string Name { get; set; }
+        public Type ParameterType { get; set; }
+        public int Position { get; set; }
+    }
+    public abstract class JsonPropertyInfo
+    public sealed class JsonPropertyInfoValues<T> {
+        public JsonPropertyInfoValues();
+        public JsonConverter<T> Converter { get; set; }
+        public Type DeclaringType { get; set; }
+        public Func<object, T> Getter { get; set; }
+        public bool HasJsonInclude { get; set; }
+        public JsonIgnoreCondition? IgnoreCondition { get; set; }
+        public bool IsExtensionData { get; set; }
+        public bool IsProperty { get; set; }
+        public bool IsPublic { get; set; }
+        public bool IsVirtual { get; set; }
+        public string JsonPropertyName { get; set; }
+        public JsonNumberHandling? NumberHandling { get; set; }
+        public string PropertyName { get; set; }
+        public JsonTypeInfo PropertyTypeInfo { get; set; }
+        public Action<object, T> Setter { get; set; }
+    }
+    public class JsonTypeInfo
+    public abstract class JsonTypeInfo<T> : JsonTypeInfo {
+        public Action<Utf8JsonWriter, T> SerializeHandler { get; }
+    }
+}
```

