# System.Text.Json.Serialization

``` diff
 namespace System.Text.Json.Serialization {
+    public interface IJsonOnDeserialized {
+        void OnDeserialized();
+    }
+    public interface IJsonOnDeserializing {
+        void OnDeserializing();
+    }
+    public interface IJsonOnSerialized {
+        void OnSerialized();
+    }
+    public interface IJsonOnSerializing {
+        void OnSerializing();
+    }
     public abstract class JsonConverter<T> : JsonConverter {
+        public virtual T ReadAsPropertyName(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options);
+        public virtual void WriteAsPropertyName(Utf8JsonWriter writer, T value, JsonSerializerOptions options);
     }
+    public enum JsonKnownNamingPolicy {
+        CamelCase = 1,
+        Unspecified = 0,
+    }
+    public sealed class JsonPropertyOrderAttribute : JsonAttribute {
+        public JsonPropertyOrderAttribute(int order);
+        public int Order { get; }
+    }
+    public sealed class JsonSerializableAttribute : JsonAttribute {
+        public JsonSerializableAttribute(Type type);
+        public JsonSourceGenerationMode GenerationMode { get; set; }
+        public string TypeInfoPropertyName { get; set; }
+    }
+    public abstract class JsonSerializerContext {
+        protected JsonSerializerContext(JsonSerializerOptions options);
+        protected abstract JsonSerializerOptions GeneratedSerializerOptions { get; }
+        public JsonSerializerOptions Options { get; }
+        public abstract JsonTypeInfo GetTypeInfo(Type type);
+    }
+    public enum JsonSourceGenerationMode {
+        Default = 0,
+        Metadata = 1,
+        Serialization = 2,
+    }
+    public sealed class JsonSourceGenerationOptionsAttribute : JsonAttribute {
+        public JsonSourceGenerationOptionsAttribute();
+        public JsonIgnoreCondition DefaultIgnoreCondition { get; set; }
+        public JsonSourceGenerationMode GenerationMode { get; set; }
+        public bool IgnoreReadOnlyFields { get; set; }
+        public bool IgnoreReadOnlyProperties { get; set; }
+        public bool IncludeFields { get; set; }
+        public JsonKnownNamingPolicy PropertyNamingPolicy { get; set; }
+        public bool WriteIndented { get; set; }
+    }
-    public sealed class JsonStringEnumConverter : JsonConverterFactory {
+    public class JsonStringEnumConverter : JsonConverterFactory {
-        public override bool CanConvert(Type typeToConvert);
+        public sealed override bool CanConvert(Type typeToConvert);
-        public override JsonConverter CreateConverter(Type typeToConvert, JsonSerializerOptions options);
+        public sealed override JsonConverter CreateConverter(Type typeToConvert, JsonSerializerOptions options);
     }
+    public enum JsonUnknownTypeHandling {
+        JsonElement = 0,
+        JsonNode = 1,
+    }
     public abstract class ReferenceHandler {
+        public static ReferenceHandler IgnoreCycles { get; }
     }
 }
```

