# System.Text.Json

``` diff
 namespace System.Text.Json {
     public readonly struct JsonElement {
+        public static JsonElement ParseValue(ref Utf8JsonReader reader);
+        public static bool TryParseValue(ref Utf8JsonReader reader, out JsonElement? element);
     }
     public static class JsonSerializer {
+        public static object Deserialize(Stream utf8Json, Type returnType, JsonSerializerOptions options = null);
+        public static object Deserialize(Stream utf8Json, Type returnType, JsonSerializerContext context);
+        public static object Deserialize(ReadOnlySpan<byte> utf8Json, Type returnType, JsonSerializerContext context);
+        public static object Deserialize(ReadOnlySpan<char> json, Type returnType, JsonSerializerOptions options = null);
+        public static object Deserialize(ReadOnlySpan<char> json, Type returnType, JsonSerializerContext context);
+        public static object Deserialize(string json, Type returnType, JsonSerializerContext context);
+        public static object Deserialize(this JsonDocument document, Type returnType, JsonSerializerOptions options = null);
+        public static object Deserialize(this JsonDocument document, Type returnType, JsonSerializerContext context);
+        public static object Deserialize(this JsonElement element, Type returnType, JsonSerializerOptions options = null);
+        public static object Deserialize(this JsonElement element, Type returnType, JsonSerializerContext context);
+        public static object Deserialize(this JsonNode node, Type returnType, JsonSerializerOptions options = null);
+        public static object Deserialize(this JsonNode node, Type returnType, JsonSerializerContext context);
+        public static object Deserialize(ref Utf8JsonReader reader, Type returnType, JsonSerializerContext context);
+        public static TValue Deserialize<TValue>(Stream utf8Json, JsonSerializerOptions options = null);
+        public static TValue Deserialize<TValue>(Stream utf8Json, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static TValue Deserialize<TValue>(ReadOnlySpan<byte> utf8Json, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static TValue Deserialize<TValue>(ReadOnlySpan<char> json, JsonSerializerOptions options = null);
+        public static TValue Deserialize<TValue>(ReadOnlySpan<char> json, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static TValue Deserialize<TValue>(string json, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static TValue Deserialize<TValue>(this JsonDocument document, JsonSerializerOptions options = null);
+        public static TValue Deserialize<TValue>(this JsonDocument document, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static TValue Deserialize<TValue>(this JsonElement element, JsonSerializerOptions options = null);
+        public static TValue Deserialize<TValue>(this JsonElement element, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static TValue Deserialize<TValue>(this JsonNode node, JsonSerializerOptions options = null);
+        public static TValue Deserialize<TValue>(this JsonNode node, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static TValue Deserialize<TValue>(ref Utf8JsonReader reader, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static ValueTask<object> DeserializeAsync(Stream utf8Json, Type returnType, JsonSerializerContext context, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<TValue> DeserializeAsync<TValue>(Stream utf8Json, JsonTypeInfo<TValue> jsonTypeInfo, CancellationToken cancellationToken = default(CancellationToken));
+        public static IAsyncEnumerable<TValue> DeserializeAsyncEnumerable<TValue>(Stream utf8Json, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static void Serialize(Stream utf8Json, object value, Type inputType, JsonSerializerOptions options = null);
+        public static void Serialize(Stream utf8Json, object value, Type inputType, JsonSerializerContext context);
+        public static string Serialize(object value, Type inputType, JsonSerializerContext context);
+        public static void Serialize(Utf8JsonWriter writer, object value, Type inputType, JsonSerializerContext context);
+        public static void Serialize<TValue>(Stream utf8Json, TValue value, JsonSerializerOptions options = null);
+        public static void Serialize<TValue>(Stream utf8Json, TValue value, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static void Serialize<TValue>(Utf8JsonWriter writer, TValue value, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static string Serialize<TValue>(TValue value, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static Task SerializeAsync(Stream utf8Json, object value, Type inputType, JsonSerializerContext context, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task SerializeAsync<TValue>(Stream utf8Json, TValue value, JsonTypeInfo<TValue> jsonTypeInfo, CancellationToken cancellationToken = default(CancellationToken));
+        public static JsonDocument SerializeToDocument(object value, Type inputType, JsonSerializerOptions options = null);
+        public static JsonDocument SerializeToDocument(object value, Type inputType, JsonSerializerContext context);
+        public static JsonDocument SerializeToDocument<TValue>(TValue value, JsonSerializerOptions options = null);
+        public static JsonDocument SerializeToDocument<TValue>(TValue value, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static JsonElement SerializeToElement(object value, Type inputType, JsonSerializerOptions options = null);
+        public static JsonElement SerializeToElement(object value, Type inputType, JsonSerializerContext context);
+        public static JsonElement SerializeToElement<TValue>(TValue value, JsonSerializerOptions options = null);
+        public static JsonElement SerializeToElement<TValue>(TValue value, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static JsonNode SerializeToNode(object value, Type inputType, JsonSerializerOptions options = null);
+        public static JsonNode SerializeToNode(object value, Type inputType, JsonSerializerContext context);
+        public static JsonNode SerializeToNode<TValue>(TValue value, JsonSerializerOptions options = null);
+        public static JsonNode SerializeToNode<TValue>(TValue value, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static byte[] SerializeToUtf8Bytes(object value, Type inputType, JsonSerializerContext context);
+        public static byte[] SerializeToUtf8Bytes<TValue>(TValue value, JsonTypeInfo<TValue> jsonTypeInfo);
     }
     public sealed class JsonSerializerOptions {
+        public JsonUnknownTypeHandling UnknownTypeHandling { get; set; }
+        public void AddContext<TContext>() where TContext : JsonSerializerContext, new();
     }
     public sealed class Utf8JsonWriter : IAsyncDisposable, IDisposable {
+        public void WriteRawValue(ReadOnlySpan<byte> utf8Json, bool skipInputValidation = false);
+        public void WriteRawValue(ReadOnlySpan<char> json, bool skipInputValidation = false);
+        public void WriteRawValue(string json, bool skipInputValidation = false);
     }
 }
```

