# System.Text

``` diff
 namespace System.Text {
-    public readonly struct Rune : IComparable, IComparable<Rune>, IEquatable<Rune> {
+    public readonly struct Rune : IComparable, IComparable<Rune>, IEquatable<Rune>, IFormattable, ISpanFormattable {
+        string System.IFormattable.ToString(string format, IFormatProvider formatProvider);
+        bool System.ISpanFormattable.TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format, IFormatProvider provider);
     }
+    public ref struct SpanLineEnumerator {
+        public ReadOnlySpan<char> Current { get; }
+        public SpanLineEnumerator GetEnumerator();
+        public bool MoveNext();
+    }
     public sealed class StringBuilder : ISerializable {
+        public StringBuilder Append(ref StringBuilder.AppendInterpolatedStringHandler handler);
+        public StringBuilder Append(IFormatProvider provider, ref StringBuilder.AppendInterpolatedStringHandler handler);
+        public StringBuilder AppendLine(ref StringBuilder.AppendInterpolatedStringHandler handler);
+        public StringBuilder AppendLine(IFormatProvider provider, ref StringBuilder.AppendInterpolatedStringHandler handler);
+        public struct AppendInterpolatedStringHandler {
+            public AppendInterpolatedStringHandler(int literalLength, int formattedCount, StringBuilder stringBuilder);
+            public AppendInterpolatedStringHandler(int literalLength, int formattedCount, StringBuilder stringBuilder, IFormatProvider provider);
+            public void AppendFormatted(object value, int alignment = 0, string format = null);
+            public void AppendFormatted(ReadOnlySpan<char> value);
+            public void AppendFormatted(ReadOnlySpan<char> value, int alignment = 0, string format = null);
+            public void AppendFormatted(string value);
+            public void AppendFormatted(string value, int alignment = 0, string format = null);
+            public void AppendFormatted<T>(T value);
+            public void AppendFormatted<T>(T value, int alignment);
+            public void AppendFormatted<T>(T value, int alignment, string format);
+            public void AppendFormatted<T>(T value, string format);
+            public void AppendLiteral(string value);
+        }
     }
 }
```

