# System.Threading.Tasks

``` diff
 namespace System.Threading.Tasks {
     public static class Parallel {
+        public static Task ForEachAsync<TSource>(IAsyncEnumerable<TSource> source, Func<TSource, CancellationToken, ValueTask> body);
+        public static Task ForEachAsync<TSource>(IAsyncEnumerable<TSource> source, CancellationToken cancellationToken, Func<TSource, CancellationToken, ValueTask> body);
+        public static Task ForEachAsync<TSource>(IAsyncEnumerable<TSource> source, ParallelOptions parallelOptions, Func<TSource, CancellationToken, ValueTask> body);
+        public static Task ForEachAsync<TSource>(IEnumerable<TSource> source, Func<TSource, CancellationToken, ValueTask> body);
+        public static Task ForEachAsync<TSource>(IEnumerable<TSource> source, CancellationToken cancellationToken, Func<TSource, CancellationToken, ValueTask> body);
+        public static Task ForEachAsync<TSource>(IEnumerable<TSource> source, ParallelOptions parallelOptions, Func<TSource, CancellationToken, ValueTask> body);
     }
     public class Task : IAsyncResult, IDisposable {
+        public Task WaitAsync(CancellationToken cancellationToken);
+        public Task WaitAsync(TimeSpan timeout);
+        public Task WaitAsync(TimeSpan timeout, CancellationToken cancellationToken);
     }
     public class Task<TResult> : Task {
+        public new Task<TResult> WaitAsync(CancellationToken cancellationToken);
+        public new Task<TResult> WaitAsync(TimeSpan timeout);
+        public new Task<TResult> WaitAsync(TimeSpan timeout, CancellationToken cancellationToken);
     }
 }
```

