# Microsoft.Extensions.Hosting

``` diff
 namespace Microsoft.Extensions.Hosting {
     public abstract class BackgroundService : IDisposable, IHostedService {
+        public virtual Task ExecuteTask { get; }
     }
+    public enum BackgroundServiceExceptionBehavior {
+        Ignore = 1,
+        StopHost = 0,
+    }
     public static class HostingHostBuilderExtensions {
+        public static IHostBuilder ConfigureDefaults(this IHostBuilder builder, string[] args);
+        public static IHostBuilder ConfigureHostOptions(this IHostBuilder hostBuilder, Action<HostBuilderContext, HostOptions> configureOptions);
+        public static IHostBuilder ConfigureHostOptions(this IHostBuilder hostBuilder, Action<HostOptions> configureOptions);
     }
     public class HostOptions {
+        public BackgroundServiceExceptionBehavior BackgroundServiceExceptionBehavior { get; set; }
     }
 }
```

