# .NET 6 CVEs

The .NET Team releases [monthly updates for .NET 6](https://github.com/dotnet/announcements/labels/.NET%206.0) on [Patch Tuesday](https://en.wikipedia.org/wiki/Patch_Tuesday). These updates often include security fixes.

Your app needs to be on the latest .NET 6 patch version to be secure. The longer you wait to upgrade, the greater the exposure to CVEs.

## Which CVEs apply to my app?

Your app may be vulnerable to the following published security [CVEs](https://www.cve.org/) if you are using an older .NET 6 patch version.

- 6.0.35 (October 2024)
  - [CVE-2024-43483 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/327)
  - [CVE-2024-43484 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/328)
  - [CVE-2024-43485 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/329)
- 6.0.33 (August 2024)
  - No new CVEs.
- 6.0.32 (July 2024)
  - [CVE-2024-38095 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/312)
  - [CVE-2024-38081 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/313)
- 6.0.31 (May 28 2024)
  - No new CVEs.
- 6.0.30 (May 2024)
  - No new CVEs.
- 6.0.29 (April 2024)
  - [CVE-2024-21409 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/303)
- 6.0.27 (February 2024)
  - [CVE-2024-21386 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/295)
  - [CVE-2024-21404 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/296)
- 6.0.26 (January 2024)
  - [CVE-2024-0056 | .NET Information Disclosure Vulnerability](https://github.com/dotnet/announcements/issues/292)
  - [CVE-2024-0057 | .NET Security Feature Bypass Vulnerability](https://github.com/dotnet/announcements/issues/291)
  - [CVE-2024-21319 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/290)
- 6.0.25 (November 2023)
  - [CVE-2023-36049 | .NET Elevation of Privilege Vulnerability](https://github.com/dotnet/announcements/issues/287)
  - [CVE-2023-36558 | .NET Security Feature Bypass Vulnerability](https://github.com/dotnet/announcements/issues/288)
- 6.0.24 (October 2023)
  - [CVE-2023-44487 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/277)
  - [CVE-2023-36799 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/275)
  - [CVE-2023-36796 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/274)
  - [CVE-2023-36793 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/273)
  - [CVE-2023-36794 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/272)
  - [CVE-2023-36792 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/271)
- 6.0.23 (October 2023)
  - [CVE-2023-44487 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/277)
- 6.0.22 (September 2023)
  - [CVE-2023-36799 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/275)
  - [CVE-2023-36796 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/274)
  - [CVE-2023-36793 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/273)
  - [CVE-2023-36794 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/272)
  - [CVE-2023-36792 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/271)
- 6.0.21 (August 2023)
  - [CVE-2023-35390 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/266)
  - [CVE-2023-38180 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/269)
  - [CVE-2023-35391 | .NET Information Disclosure Vulnerability](https://github.com/dotnet/announcements/issues/267)
- 6.0.20 (July 2023)
  - No new CVEs.
- 6.0.19 (June 2023)
  - [CVE-2023-24895 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/261)
  - [CVE-2023-24897 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/260)
  - [CVE-2023-24936 | .NET Elevation of Privilege Vulnerability](https://github.com/dotnet/announcements/issues/259)
  - [CVE-2023-29331 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/257)
  - [CVE-2023-29337 | Nuget Client Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/256)
  - [CVE-2023-32032 | .NET Elevation of Privilege Vulnerability](https://github.com/dotnet/announcements/issues/255)
  - [CVE-2023-33126 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/254)
  - [CVE-2023-33128 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/253)
  - [CVE-2023-33135 | .NET Elevation of Privilege Vulnerability](https://github.com/dotnet/announcements/issues/252)
- 6.0.18 (June 2023)
  - No new CVEs.
- 6.0.17 (May 2023)
  - No new CVEs.
- 6.0.16 (April 2023)
  - [CVE-2023-28260 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/250)
- 6.0.15 (March 2023)
  - No new CVEs.
- 6.0.14 (February 2023)
  - [CVE-2023-21808 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/247)
- 6.0.13 (January 2023)
  - [CVE-2023-21538 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/244)
- 6.0.12 (December 2022)
  - [CVE-2022-41089 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/242)
- 6.0.11 (November 2022)
  - No new CVEs.
- 6.0.10 (October 2022)
  - [CVE-2022-41032 | .NET Core Elevation of Privilege Vulnerability](https://github.com/dotnet/announcements/issues/236)
- 6.0.9 (September 2022)
  - [CVE-2022-38013 | .NET Core Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/234) 
- 6.0.8 (August 2022)
  - [CVE-2022-34716 | .NET Core Information Disclosure Vulnerability](https://github.com/dotnet/announcements/issues/232)
- 6.0.7 (July 2022)
  - No new CVEs.
- 6.0.6 (June 2022)
  - [CVE-2022-30184 | .NET Core Information Disclosure Vulnerability](https://github.com/dotnet/announcements/issues/225)
- 6.0.5 (May 2022)
  - [CVE-2022-29145 | ASP.NET Core Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/222)
  - [CVE-2022-23267 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/221)
  - [CVE-2022-29117 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/220)
- 6.0.4 (April 2022)
  - No new CVEs.
- 6.0.3 (March 2022)
  - [CVE-2022-24512 | .NET Remote Code Execution](https://github.com/dotnet/announcements/issues/213)
  - [CVE-2022-24464 | ASP.NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/212)
- 6.0.2 (February 2022)
  - [CVE-2022-21986 | ASP.NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/207)
- 6.0.1 (December 2021)
  - [CVE-2021-43877 | ASP.NET Core Elevation of privilege Vulnerability](https://github.com/dotnet/announcements/issues/206)
- 6.0.0 (November 2021)
  - No new CVEs.

CVE exposure is cumulative. For example, apps running on the `6.0.0` release may be vulnerable to the CVEs present in `6.0.1` and newer releases. The latest release is not vulnerable to any published CVEs.
