# .NET 6.0.0 Preview 2

.NET 6.0.0 Preview 2 comprises:

* .NET Runtime 6.0.0-preview.2.21154.6
* ASP.NET Core 6.0.0-preview.2.21154.6
* .NET SDK 6.0.100-preview.2.21155.3
* Windowsdesktop 6.0.0-preview.2.21154.2

See the [Release Notes][release-notes] for details about what is included in this update.

## Docker

[.NET container images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. [Staying safe with .NET containers](https://devblogs.microsoft.com/dotnet/staying-safe-with-dotnet-containers/) provides insight and guidance on managing container images, with respect to pedigree, provenance and CVE management.

## Install .NET on Linux

### Install using Snap

Because of the isolated environment, using Snap is the preferred way to install and try .NET Previews on [Linux distributions that support Snap](https://docs.snapcraft.io/installing-snapd/6735).

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --channel=6.0/beta --classic`

When .NET Core is installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it will not conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distributions require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [.NET for Linux Distributions](../../../linux.md) for a possible resolution.

### Install using deb/rpm packages

Preview release installers are not available from the Microsoft package repositories. The steps below provide an easy way to install .NET 6 using your Distro package manager.

**Note:** `curl` must be available on the system before running the following steps. Once you have confirmed that `curl` is available, complete the steps to download and install the latest .NET 6 Preview SDK and Runtime.

1. Create a directory to use for the download location and change into that directory. For example `mkdir $HOME/dotnet_install && cd $HOME/dotnet_install`
2. Run `curl -L https://aka.ms/install-dotnet-preview -o install-dotnet-preview.sh`
3. Run the script with `sudo bash install-dotnet-preview.sh`

Here's what the script does.

* Detects the distribution and version. The script supports platforms and versions listed in [.NET 6.0 - Supported OS versions](https://github.com/dotnet/core/blob/main/release-notes/6.0/supported-os.md).
* Determines if additional system dependencies or utilities are needed to successfully complete and install them. For example `tar` is used to unpack that installer packages.
* Downloads the tar.gz containing the .NET preview installer packages for the detected distribution.
* Downloads the system dependency installer, if needed.
* Expands the tar.gz into ./dotnet_pacakges
* Attempts to install the contents of ./dotnet_packages using `rpm` or `dpkg`, as appropriate, for the detected distribution.

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](../linux-packages.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-6.0` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-6.0` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-6.0.0-preview.2.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

## Install Mobile Workloads

### Downloads

* Android: [[Windows][android-win]] [[Mac][android-mac]]
* iOS: [[Windows][ios-win]] [[Mac][ios-mac]]
* Mac Catalyst: [[Mac][maccatalyst-mac]]

See the [net6-mobile-samples](https://github.com/dotnet/net6-mobile-samples/tree/net6-preview2) repo for sample projects and further details about getting started.

Android, iOS, and Mac Catalyst projects will need to add additional NuGet feeds. An example `NuGet.config` file would be:

```xml
<?xml version="1.0" encoding="utf-8"?>
<configuration>
  <packageSources>
    <clear />
    <!-- ensure only the sources defined below are used -->
    <add key="dotnet6" value="https://pkgs.dev.azure.com/dnceng/public/_packaging/dotnet6/nuget/v3/index.json" />
    <add key="xamarin" value="https://pkgs.dev.azure.com/azure-public/vside/_packaging/xamarin-impl/nuget/v3/index.json" />
  </packageSources>
</configuration>
```

### Android

Prerequisites:

* Install .NET 6.0.0 Preview 2
* You will need the Android SDK installed as well as `Android SDK Platform 30`. One way to acquire this is to install the Xamarin workload in the Visual Studio installer. You can manage Android SDKs from `Tools > Android > Android SDK Manager` from within Visual Studio.

### iOS and Mac Catalyst

Prerequisites:

* Install .NET 6.0.0 Preview 2
* Xcode 12.4

[android-mac]: https://dl.internalx.com/vsts-devdiv/Xamarin.Android/public/net6/4534967/main/f4d8fe238b15eadfc7842749bf13e5fca3e2f2d2/Microsoft.NET.Workload.Android-11.0.200-ci.f4d8fe238b15eadfc7842749bf13e5fca3e2f2d2.148.pkg
[android-win]: https://dl.internalx.com/vsts-devdiv/Xamarin.Android/public/net6/4534967/main/f4d8fe238b15eadfc7842749bf13e5fca3e2f2d2/Microsoft.NET.Workload.Android.11.0.200.148.msi
[ios-mac]: https://bosstoragemirror.azureedge.net/wrench/main/98c8649d0c7d1e3c4c8d8d09e022befa853fb1e7/4541181/package/notarized/Microsoft.iOS.Bundle.14.4.100-ci.main.1192.pkg
[ios-win]: https://bosstoragemirror.azureedge.net/wrench/main/98c8649d0c7d1e3c4c8d8d09e022befa853fb1e7/4541181/package/Microsoft.NET.Workload.iOS.14.4.100-ci.main.1192.msi
[maccatalyst-mac]: https://bosstoragemirror.azureedge.net/wrench/main/98c8649d0c7d1e3c4c8d8d09e022befa853fb1e7/4541181/package/notarized/Microsoft.MacCatalyst.Bundle.14.3.100-ci.main.337.pkg

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.0-preview.2.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-preview.2-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-preview.2-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-core-5-0-preview-2/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-and-blazor-updates-in-net-core-5-0-preview-2/
[ef-blog]: https://devblogs.microsoft.com/dotnet/

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A6.0.0-preview2+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A6.0.0-preview2+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A5.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A5.0+label%3Aenhancement

[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/8f7df454-eea2-4b8c-9194-910fb611679f/8fa8d8415b488668b2d2c6a68e1c63d5/dotnet-hosting-6.0.0-preview.2.21154.6-win.exe
