# .NET 6.0.0 Preview 5 - June 17, 2021

The .NET 6.0.0 Preview 5 and .NET SDK 6.0.100-preview.5.21302.13 releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

## What's new in .NET 6 Preview 5

.NET 6 is the next major release of .NET following .NET 5. You can see some of the new features available with .NET 6 Preview 5 at [dotnet/core #6099](https://github.com/dotnet/core/issues/6099).

See the [.NET][dotnet-blog], [ASP.NET Core][aspnet-blog], [Entity Framework Core][ef-blog] and [.NET MAUI][maui-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in Preview 5.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-Arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [Arm64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz]  \| [Arm64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [Arm64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [Arm64][dotnet-runtime-osx-arm64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [Arm64][aspnetcore-runtime-osx-arm64.tar.gz]  | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install.md) | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz] \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup>  \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.100-preview.5.21302.13
```

### .NET Multi-Platform App UI Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET Multi-platform App UI](https://github.com/dotnet/maui). See [dotnet/maui-samples](https://github.com/dotnet/maui-samples) for additional setup instructions and sample projects you can run today.

After installing the .NET SDK, you can install these platform SDKs using the `dotnet workload install` command:

```console
$ dotnet workload install microsoft-android-sdk-full
$ dotnet workload install microsoft-ios-sdk-full
$ dotnet workload install microsoft-maccatalyst-sdk-full
$ dotnet workload install microsoft-macos-sdk-full
$ dotnet workload install microsoft-tvos-sdk-full
```


Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.


## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples


## Visual Studio Compatibility

You need [Visual Studio 2022 version 17.0](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6389](https://github.com/dotnet/core/issues/6389) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.0-preview.5.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-preview.5-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-preview.5-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-net-6-preview-5/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-6-preview-5
[maui-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-maui-preview-5/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-entity-framework-core-6-0-preview-5-compiled-models/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A6.0.0-preview5+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A6.0.0-preview5+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A6.0.0-preview5+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A6.0.0-preview5+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A6.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A6.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A6.0.1xx
[linux-packages]: ../install-linux.md


[//]: # ( Runtime 6.0.0-preview.5.21301.5)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4c9c57f5-d602-4534-8baf-dcf74e04e691/c852220420dd23603a866565d1fd452f/dotnet-runtime-6.0.0-preview.5.21301.5-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dad1305e-6269-4c6e-bad1-12680ccfd42c/2a903a2cf6eacfaf44d00f27ca3472ff/dotnet-runtime-6.0.0-preview.5.21301.5-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/706413fe-43b7-40af-8fe6-224fe36c9443/bfe4ac59c5a58f1f986a8690af6800ba/dotnet-runtime-6.0.0-preview.5.21301.5-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/68c123d8-6072-410f-97f3-3d9535b3e416/ee5344671f68161b1582c394468f8feb/dotnet-runtime-6.0.0-preview.5.21301.5-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/750940db-184c-419e-9be4-d8330638cc63/6cee68925ca398206cd3092a279de4f5/dotnet-runtime-6.0.0-preview.5.21301.5-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fbf784be-f157-4f40-81bc-508bac32b9d6/273a0d69053e19beb1d048cbd92da627/dotnet-runtime-6.0.0-preview.5.21301.5-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/59b1d539-c76f-493c-9f6e-18c953429084/4c7fafc6ab3f5f4927929b543d62bc81/dotnet-runtime-6.0.0-preview.5.21301.5-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ef2cef88-fdc0-4d42-ad0e-3c4bbc4ab806/fed7ea45282bc20fd38a98b54ea5f2f6/dotnet-runtime-6.0.0-preview.5.21301.5-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c326f2e1-10ee-482e-9871-5fb8de7f7777/dda8203d3b58e56efeca4a7248cdea67/dotnet-runtime-6.0.0-preview.5.21301.5-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8e6155cd-e095-47ac-b642-cfe19c451b17/798abdac364b698400981e8af5471429/dotnet-runtime-6.0.0-preview.5.21301.5-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/195e2dbe-a67a-4882-9d36-43e525b9070b/bad8c506552923441b7ba3efb097ac32/dotnet-runtime-6.0.0-preview.5.21301.5-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/cd854d55-6894-4d19-ae27-cdafffd762c6/fb75c483074a9e9e80324f9138843ef6/dotnet-runtime-6.0.0-preview.5.21301.5-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ef0fa0ce-90d3-4e4d-9573-f15b67ee720f/58a990520b2c53331bcd2a02755eca6d/dotnet-runtime-6.0.0-preview.5.21301.5-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d763969f-3ba9-469a-99ad-d8c09bff879b/5a25bad534f25dafd07fa36036737621/dotnet-runtime-6.0.0-preview.5.21301.5-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1e9c74b3-2535-4420-a268-e510205f4c14/9ed075932877e97ad9b1ecbb60e018c6/dotnet-runtime-6.0.0-preview.5.21301.5-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/58fd0ee6-34fe-43c0-8d60-d343cf00258e/1378d08d2cbfe35a45447b5d29fcacbd/dotnet-runtime-6.0.0-preview.5.21301.5-win-x86.zip

[//]: # ( WindowsDesktop 6.0.0-preview.5.21301.4)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/09301f50-e9d3-47f0-9826-0518e9a81a71/64397a13cd3a47713e5a72f328bd65f2/windowsdesktop-runtime-6.0.0-preview.5.21301.4-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3e0ae708-2bc5-4470-8836-67d64eb24eda/0c4342f2e8c032d461a64c9b72881106/windowsdesktop-runtime-6.0.0-preview.5.21301.4-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/30fbf394-c4e3-4340-aed8-c881e03b27c9/53a2b97e08e9adec809ed21267406a39/windowsdesktop-runtime-6.0.0-preview.5.21301.4-win-x86.exe

[//]: # ( ASP 6.0.0-preview.5.21301.17)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f98b34de-9da4-4911-a974-36f94d684eba/f6245a9a67be46e0c8607c20b275e332/aspnetcore-runtime-6.0.0-preview.5.21301.17-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c61af2b3-c528-4c9d-8499-1dfe3b5fb1c5/429383fe42b5f3f458881c4c074bdf3c/aspnetcore-runtime-6.0.0-preview.5.21301.17-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cd2a65d4-1daa-4e02-80dd-ddac07feb812/bf84355c2d5e09b0328d20035138d8f6/aspnetcore-runtime-6.0.0-preview.5.21301.17-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9c80123f-fadd-463e-8cc7-e649a18e0de1/91f5b4b223fc097a6a025c9c91219a86/aspnetcore-runtime-6.0.0-preview.5.21301.17-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/25845eea-7b65-4fa4-accf-1699842da775/1903f77becff8e6ba34e6c8de0381e3c/aspnetcore-runtime-6.0.0-preview.5.21301.17-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fb25635b-34c4-47bf-9f80-be40f001e33f/968620fe6aebaf300635ebb6cf70685f/aspnetcore-runtime-6.0.0-preview.5.21301.17-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f0d347e9-82ba-4dad-af79-53ca7a9b92f9/f22d2d4ad96576cbea7f0ba98f5f9285/aspnetcore-runtime-6.0.0-preview.5.21301.17-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b4ccd039-1f12-4b40-9198-a992d5131bd0/7ff5e4b828c81eac221ec932e7eb40a8/aspnetcore-runtime-6.0.0-preview.5.21301.17-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/8cac5836-0e83-4f88-beb8-633609f50835/790e099709c0c4fb3ea03c1e1831a236/aspnetcore-runtime-6.0.0-preview.5.21301.17-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c13d1994-bb9b-45c2-a7a5-9a9e98c7e14d/38526aeb5e505dbab37c8c56b245f135/aspnetcore-runtime-6.0.0-preview.5.21301.17-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ba997356-994f-42ed-b4e1-39025c4ccb6a/6e7fdd95c3c9f901a64b4f8eeb407f41/aspnetcore-runtime-6.0.0-preview.5.21301.17-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/03fd9877-39c5-44f4-aae8-a93c1478cd5a/05ee29b94f8eaf3b1cf0bec474312f08/aspnetcore-runtime-6.0.0-preview.5.21301.17-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/85652fb2-811b-44c0-899d-2f9d9a161f6c/67ddec0efbb096a6b169dc2bc3965993/aspnetcore-runtime-6.0.0-preview.5.21301.17-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/c850d922-7954-4e0d-ad31-d581f04e1431/cca5c76bec14321aa4a2dcc9ee17eca8/dotnet-hosting-6.0.0-preview.5.21301.17-win.exe

[//]: # ( SDK 6.0.100-preview.5.21302.13 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b2412ec4-c6b6-4c10-875b-8b1bc2ea2aa4/973ec23de8c7458cebcf01937b813b0f/dotnet-sdk-6.0.100-preview.5.21302.13-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2bea75e0-9a2f-41ed-9336-4dc23076a691/62c191c6fb281850d06f8a1c16c34699/dotnet-sdk-6.0.100-preview.5.21302.13-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3512f898-9ab3-4897-bcca-b25bb91ddb04/24c6504eb73f812bbec3a5790254f73f/dotnet-sdk-6.0.100-preview.5.21302.13-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d90a868f-dee6-418a-a189-bb16f1bd5d00/1d94110380ea2b0ff53b82101718c1bd/dotnet-sdk-6.0.100-preview.5.21302.13-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/68e2a2f9-aab4-40c3-8abc-e22c1e34afef/8c5b1168020496e5f3bc84b7c4ecaf2d/dotnet-sdk-6.0.100-preview.5.21302.13-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/919880af-ab5a-4b58-8058-7baaea4a09d1/4fe186d747cf416cbdc83fd8354e15ea/dotnet-sdk-6.0.100-preview.5.21302.13-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1db1e8d4-0685-4e7a-be25-cb9f016774e1/8f47d46cba3772b130ac0b46615d59fe/dotnet-sdk-6.0.100-preview.5.21302.13-linux-x64.zip
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/b1b77ccc-7428-4ab6-9bd5-dbde5e5fdb56/5a33c488a8bb58eaf1982a2edd2af2a2/dotnet-sdk-6.0.100-preview.5.21302.13-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ec3939d5-4c42-4de5-9f00-23ebc5cc657f/1bb83410899be7c5ac906b0dbf9607e1/dotnet-sdk-6.0.100-preview.5.21302.13-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/134a7c15-69cf-40b3-ba78-a78a666ac2de/996de9580ee6c05b2bcb0e9456fdf877/dotnet-sdk-6.0.100-preview.5.21302.13-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6382ce82-4456-41ca-986e-afa7facdeba1/386af1a9e1d3e0b5affabf01c9ad3af6/dotnet-sdk-6.0.100-preview.5.21302.13-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/4e3a1307-fb38-4a65-b188-eb4d272f76bd/17fcb7eb783e0ebb3901d1b87c9a9215/dotnet-sdk-6.0.100-preview.5.21302.13-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/80e681d8-3438-4825-beec-b7c3dd230745/10b421fbbaef2f94c038d6589305a3fa/dotnet-sdk-6.0.100-preview.5.21302.13-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/df52c798-6143-42f1-98e0-9cc7fc6257cd/cc09da4dcb8a59c1dcf905952f3382a1/dotnet-sdk-6.0.100-preview.5.21302.13-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/74448616-c6d2-40bf-b6da-aa3a6c1009ab/62702150054089e2961aaf32e8ab3ffc/dotnet-sdk-6.0.100-preview.5.21302.13-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/14d26ff2-2168-4782-af08-4f03b1dbc870/f15bf82fa14b08ebfdc18ecc0d38e5d5/dotnet-sdk-6.0.100-preview.5.21302.13-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/20360038-1b6c-4e4c-ab83-d4cc063722e6/817ea1b688c76f90e70deb428830ffbc/dotnet-sdk-6.0.100-preview.5.21302.13-win-x86.zip

[//]: # ( Symbols )
