# .NET 6.0.0 Preview 6 - July 14, 2021

The .NET 6.0.0 Preview 6 and .NET SDK 6.0.100-preview.6.21355.2 releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

## What's new in .NET 6 Preview 6

.NET 6 is the next major release of .NET following .NET 5. You can see some of the new features available with .NET 6 Preview 6 at [dotnet/core #6325](https://github.com/dotnet/core/issues/6325).

See the [.NET][dotnet-blog], [ASP.NET Core][aspnet-blog], [Entity Framework Core][ef-blog] and [.NET MAUI][maui-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in Preview 6.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-Arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [Arm64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz]  \| [Arm64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [Arm64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [Arm64][dotnet-runtime-osx-arm64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [Arm64][aspnetcore-runtime-osx-arm64.tar.gz]  | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install.md) | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz] \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup>  \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.100-preview.6.21355.2
```

### .NET Multi-Platform App UI (MAUI) Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://learn.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install microsoft-android-sdk-full
$ dotnet workload install microsoft-ios-sdk-full
$ dotnet workload install microsoft-maccatalyst-sdk-full
$ dotnet workload install microsoft-macos-sdk-full
$ dotnet workload install microsoft-tvos-sdk-full
```


Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.


## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples


## Visual Studio Compatibility

You need [Visual Studio 2022 version 17.0](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6467](https://github.com/dotnet/core/issues/6467) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 6.0.0-preview.6.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-preview.6-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-preview.6-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-net-6-preview-6/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-6-preview-6
[maui-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-maui-preview-6/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-entity-framework-core-6-0-preview-6-configure-conventions
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A6.0.0-preview6+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A6.0.0-preview6+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A6.0.0-preview6+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A6.0.0-preview6+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A6.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A6.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A6.0.1xx
[linux-packages]: ../install-linux.md


[//]: # ( Runtime 6.0.0-preview.6.21352.12)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8338df6d-f649-447f-8998-e393c63c6645/19f0f84b693fc54222b50870baca4899/dotnet-runtime-6.0.0-preview.6.21352.12-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/28b6d195-c69d-445a-b1c1-821e1a1cd8a1/6c85254b5cd005094a41ebd56774d4e5/dotnet-runtime-6.0.0-preview.6.21352.12-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a5dbb2b9-ee75-4863-9495-a3b725023b0b/97d974fbe72d6c4515a2f93a88244ddf/dotnet-runtime-6.0.0-preview.6.21352.12-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b1434d75-89c3-4b52-9a43-870c0a017897/6c50fdffdc2bd153c809e8dad409c9fe/dotnet-runtime-6.0.0-preview.6.21352.12-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/026cb7b2-fe95-4234-878e-410f678112f9/659fe44ad45762b42a13e66dd2795028/dotnet-runtime-6.0.0-preview.6.21352.12-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/841cf439-e6c6-4164-ae75-e4f1f3aafe0c/fd64b0395f6f0dee9ed184d918e49cd7/dotnet-runtime-6.0.0-preview.6.21352.12-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3e5fcfb9-e470-4989-9677-39dc2fafd154/6b2a23abd069560e975e4c517df7b74c/dotnet-runtime-6.0.0-preview.6.21352.12-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e6e0f9af-9d3a-4a31-b260-666b0b3e4221/51b3052f9c84277b38578c5d7281dc4a/dotnet-runtime-6.0.0-preview.6.21352.12-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/fd4e78c4-eb09-4e98-9a60-0cf796a8af20/1095c137d3801cffaa6ada35eae0c1a3/dotnet-runtime-6.0.0-preview.6.21352.12-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/67ae4f96-a7b5-49e3-809d-50de8e771c0f/ef5e3b6a1ff3abcf881b7ae880253469/dotnet-runtime-6.0.0-preview.6.21352.12-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/e40dee15-1d90-4917-8a41-d5ce3f218407/4b412277f3b9c39e9288bb4020240546/dotnet-runtime-6.0.0-preview.6.21352.12-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/b68e27f8-d382-40f6-adc9-17aa1013925d/7cbd7bb99d2f181c40290b97018071b5/dotnet-runtime-6.0.0-preview.6.21352.12-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d8031c86-e522-40eb-8c5e-edffcd711268/1880257fd9d1cdff0d3d4733c7246376/dotnet-runtime-6.0.0-preview.6.21352.12-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7282c65e-b906-48b7-b8f7-6bf3a6f980f0/ca7af999c52955ffdc45300b1de97a08/dotnet-runtime-6.0.0-preview.6.21352.12-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/547ecbd0-9861-4ad1-beab-cfb256c2d212/f1e11ce269c7e8b8d91139075cde2d59/dotnet-runtime-6.0.0-preview.6.21352.12-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/fa4333d5-b145-4bd1-b86d-101e758ff253/3b813e4a0f98fcc4f9f0930ab43a26df/dotnet-runtime-6.0.0-preview.6.21352.12-win-x86.zip

[//]: # ( WindowsDesktop 6.0.0-preview.6.21353.1)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/7c074ee8-043b-4f50-a135-e198b4a26bb2/fc4e30c8c0a7266cc92fbe7221173fad/windowsdesktop-runtime-6.0.0-preview.6.21353.1-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b6bef7e7-7d36-41fa-a937-119a786bdae3/b8251935ec30137f6d83dab3e6f1f12c/windowsdesktop-runtime-6.0.0-preview.6.21353.1-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/14c95c30-bc3b-43d9-b569-4e388ab7ab19/2e3b68dc6ee53a6aab3f71ad891215d3/windowsdesktop-runtime-6.0.0-preview.6.21353.1-win-x86.exe

[//]: # ( ASP 6.0.0-preview.6.21355.2)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fead33a0-bfa8-4a3c-93c2-fa6dcd7fce47/11681525584ed1a381ecae3536693250/aspnetcore-runtime-6.0.0-preview.6.21355.2-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7535469b-06d6-407d-b751-732ba8ba12d2/9ae4e842565ae3c50e5c2673c06bbe37/aspnetcore-runtime-6.0.0-preview.6.21355.2-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ff9927bd-791b-4d24-9a0c-efb0ed21fef2/655e8c11a83cf865400654fc473b3f8b/aspnetcore-runtime-6.0.0-preview.6.21355.2-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bab174a9-3aef-467a-82d3-3fec5a8e562a/ea80ec9fb413a934e5b8f4d2e60ec5c7/aspnetcore-runtime-6.0.0-preview.6.21355.2-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0678c787-648a-4385-9b33-af728cba9e0b/56171f0269e38da631bf1ed416edb7d9/aspnetcore-runtime-6.0.0-preview.6.21355.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/24e3144f-550d-49a2-bb40-8fb06aaf29a8/300b021763dbff231af63adb28ec6abd/aspnetcore-runtime-6.0.0-preview.6.21355.2-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3830a164-7a1d-43b9-ad38-175f11a3731c/2f9e05c8da288e93154810154616dfa2/aspnetcore-runtime-6.0.0-preview.6.21355.2-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/392fdec4-7fee-4b86-9497-c1f63eb87acb/e5c215160b9e93e43f581e59bff87c9d/aspnetcore-runtime-6.0.0-preview.6.21355.2-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/72a69c8a-e91c-4328-8cb1-699af101fe9f/19354d5c08dadc1812115a21e18655ce/aspnetcore-runtime-6.0.0-preview.6.21355.2-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/02355756-f7fc-43fc-a752-e7dbf3098b1c/4972c4b8b2973b00042a11d39a2d3d10/aspnetcore-runtime-6.0.0-preview.6.21355.2-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/706b6612-e557-432b-88ea-96d13e2af5a3/f00c6537f1a7711138216555797d6833/aspnetcore-runtime-6.0.0-preview.6.21355.2-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1bfa5cd7-d533-4457-90c4-e412610464d0/7b3fc132d204581a9d0f2c809e5b837f/aspnetcore-runtime-6.0.0-preview.6.21355.2-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/5062e035-1f6f-48af-88b1-51ff3a67f7fc/fea719da53e107752b6d1c7e2001f758/aspnetcore-runtime-6.0.0-preview.6.21355.2-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/cf05db87-6052-43ae-8cda-c0aaf1e455d9/a09408560e38c80529d42bbf1bdf552b/dotnet-hosting-6.0.0-preview.6.21355.2-win.exe

[//]: # ( SDK 6.0.100-preview.6.21355.2 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5aed712c-c0bc-43fd-9fca-9483af66c8f1/66093c96a21248ee1ec77110478d13b3/dotnet-sdk-6.0.100-preview.6.21355.2-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8a6a12fc-35bb-47ca-9353-b1e97d569382/61221db91a720e7ae5833460f2ea53d2/dotnet-sdk-6.0.100-preview.6.21355.2-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7f8958ec-0b14-4bc9-9519-41864d501b26/0fd817bc76e6ae0ad5b4a2f3549a3c75/dotnet-sdk-6.0.100-preview.6.21355.2-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0ff6fc52-91f0-4aa5-baa8-e2d4cf46b3e2/40b9c873ac7c37d578a4f3795758651c/dotnet-sdk-6.0.100-preview.6.21355.2-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/41ee1046-a104-4983-82c3-1a33f6b85e31/658fc456b3b8b4435f7556a2c5d5f16d/dotnet-sdk-6.0.100-preview.6.21355.2-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/45f9f84c-dbe6-458e-bea1-c1e931802486/995edcbcd852a07b0a285626f30afb33/dotnet-sdk-6.0.100-preview.6.21355.2-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/494d6cb2-7c5d-4fa6-a1c2-5b76762be9eb/17cd976b4fedc3e2ddeeb0910031ccde/dotnet-sdk-6.0.100-preview.6.21355.2-linux-x64.zip
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/10bb818e-3d14-435c-a76b-40da0a8c561a/616dd2f1d72c8725270530bf67907068/dotnet-sdk-6.0.100-preview.6.21355.2-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fd0b8343-1875-4ffc-aab6-00d57ac223a2/00d7942d7ed9c4333f6f0be9d9678e60/dotnet-sdk-6.0.100-preview.6.21355.2-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/767abef9-9636-47a7-9929-6ac4201b6837/95c3c13e937efb01255843a6d4adf9ed/dotnet-sdk-6.0.100-preview.6.21355.2-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fb01b89f-c07d-4e3f-b9c1-a8d3a074f290/4df3bd673a530e8febcf0089dc698106/dotnet-sdk-6.0.100-preview.6.21355.2-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/af2fcf31-22b3-43c9-b127-d3d2569a4e76/396c947b23cd32f49e2cb12321321d65/dotnet-sdk-6.0.100-preview.6.21355.2-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/96dfe5eb-3837-4541-8878-7258647e8fd7/d90954b202dd3bbb0608fc68080a0bfb/dotnet-sdk-6.0.100-preview.6.21355.2-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9da8718a-a4cf-42dc-a86c-1ea648acf136/73e158f3e4dfb1446595d0dba5b6343a/dotnet-sdk-6.0.100-preview.6.21355.2-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a83c721e-ae81-4d88-9c3e-239e08e664be/ef2e40c18b8f87611477376bc3f6a8e5/dotnet-sdk-6.0.100-preview.6.21355.2-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8598c905-5911-4f50-9e8b-1f4dc53d213c/5f57f06cc04861b2f01ded57de212636/dotnet-sdk-6.0.100-preview.6.21355.2-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6395e8ff-c40e-450b-a663-23aa1b29c19f/516ced1b50fba44e17e5d1cc0bea981d/dotnet-sdk-6.0.100-preview.6.21355.2-win-x86.zip


[//]: # ( Symbols )
