# System.Security.Cryptography.X509Certificates

``` diff
 namespace System.Security.Cryptography.X509Certificates {
     public sealed class PublicKey {
+        public PublicKey(AsymmetricAlgorithm key);
+        public static PublicKey CreateFromSubjectPublicKeyInfo(ReadOnlySpan<byte> source, out int bytesRead);
+        public byte[] ExportSubjectPublicKeyInfo();
+        public bool TryExportSubjectPublicKeyInfo(Span<byte> destination, out int bytesWritten);
     }
     public class X509Certificate2 : X509Certificate {
+        public X509Certificate2 CopyWithPrivateKey(ECDiffieHellman privateKey);
+        public static X509Certificate2 CreateFromPem(ReadOnlySpan<char> certPem);
+        public ECDiffieHellman GetECDiffieHellmanPrivateKey();
+        public ECDiffieHellman GetECDiffieHellmanPublicKey();
     }
 }
```

