# System.Security.Cryptography

``` diff
 namespace System.Security.Cryptography {
     public abstract class ECDiffieHellmanPublicKey : IDisposable {
+        public virtual byte[] ExportSubjectPublicKeyInfo();
+        public virtual bool TryExportSubjectPublicKeyInfo(Span<byte> destination, out int bytesWritten);
     }
     public abstract class RandomNumberGenerator : IDisposable {
+        public static byte[] GetBytes(int count);
     }
     public sealed class RijndaelManaged : Rijndael {
+        public override int FeedbackSize { get; set; }
     }
     public abstract class SymmetricAlgorithm : IDisposable {
+        public int GetCiphertextLengthCbc(int plaintextLength, PaddingMode paddingMode = PaddingMode.PKCS7);
+        public int GetCiphertextLengthCfb(int plaintextLength, PaddingMode paddingMode = PaddingMode.None, int feedbackSizeInBits = 8);
+        public int GetCiphertextLengthEcb(int plaintextLength, PaddingMode paddingMode);
     }
 }
```

