# System.Text.Json

``` diff
 namespace System.Text.Json {
     public static class JsonSerializer {
+        public static object Deserialize(ReadOnlySpan<byte> utf8Json, Type returnType, JsonSerializerContext context);
+        public static object Deserialize(ReadOnlySpan<char> json, Type returnType, JsonSerializerContext context);
+        public static object Deserialize(string json, Type returnType, JsonSerializerContext context);
+        public static object Deserialize(ref Utf8JsonReader reader, Type returnType, JsonSerializerContext context);
+        public static TValue Deserialize<TValue>(ReadOnlySpan<byte> utf8Json, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static TValue Deserialize<TValue>(ReadOnlySpan<char> json, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static TValue Deserialize<TValue>(string json, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static TValue Deserialize<TValue>(ref Utf8JsonReader reader, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static ValueTask<object> DeserializeAsync(Stream utf8Json, Type returnType, JsonSerializerContext context, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<TValue> DeserializeAsync<TValue>(Stream utf8Json, JsonTypeInfo<TValue> jsonTypeInfo, CancellationToken cancellationToken = default(CancellationToken));
+        public static IAsyncEnumerable<TValue> DeserializeAsyncEnumerable<TValue>(Stream utf8Json, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static string Serialize(object value, Type inputType, JsonSerializerContext context);
+        public static void Serialize(Utf8JsonWriter writer, object value, Type inputType, JsonSerializerContext context);
+        public static void Serialize<TValue>(Utf8JsonWriter writer, TValue value, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static string Serialize<TValue>(TValue value, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static Task SerializeAsync(Stream utf8Json, object value, Type inputType, JsonSerializerContext context, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task SerializeAsync<TValue>(Stream utf8Json, TValue value, JsonTypeInfo<TValue> jsonTypeInfo, CancellationToken cancellationToken = default(CancellationToken));
+        public static byte[] SerializeToUtf8Bytes(object value, Type inputType, JsonSerializerContext context);
+        public static byte[] SerializeToUtf8Bytes<TValue>(TValue value, JsonTypeInfo<TValue> jsonTypeInfo);
     }
     public sealed class JsonSerializerOptions {
+        public JsonUnknownTypeHandling UnknownTypeHandling { get; set; }
+        public void AddContext<TContext>() where TContext : JsonSerializerContext, new();
     }
 }
```

