# System

``` diff
 namespace System {
-    public readonly struct Byte : IComparable, IComparable<byte>, IConvertible, IEquatable<byte>, IFormattable
+    public readonly struct Byte : IComparable, IComparable<byte>, IConvertible, IEquatable<byte>, IFormattable, ISpanFormattable
-    public readonly struct Char : IComparable, IComparable<char>, IConvertible, IEquatable<char> {
+    public readonly struct Char : IComparable, IComparable<char>, IConvertible, IEquatable<char>, IFormattable, ISpanFormattable {
+        string System.IFormattable.ToString(string format, IFormatProvider formatProvider);
+        bool System.ISpanFormattable.TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format, IFormatProvider provider);
     }
+    public readonly struct DateOnly : IComparable, IComparable<DateOnly>, IEquatable<DateOnly>, IFormattable, ISpanFormattable {
+        public DateOnly(int year, int month, int day);
+        public DateOnly(int year, int month, int day, Calendar calendar);
+        public int Day { get; }
+        public int DayNumber { get; }
+        public DayOfWeek DayOfWeek { get; }
+        public int DayOfYear { get; }
+        public static DateOnly MaxValue { get; }
+        public static DateOnly MinValue { get; }
+        public int Month { get; }
+        public int Year { get; }
+        public DateOnly AddDays(int value);
+        public DateOnly AddMonths(int value);
+        public DateOnly AddYears(int value);
+        public int CompareTo(DateOnly value);
+        public int CompareTo(object value);
+        public bool Equals(DateOnly value);
+        public override bool Equals(object value);
+        public static DateOnly FromDateTime(DateTime dateTime);
+        public static DateOnly FromDayNumber(int dayNumber);
+        public override int GetHashCode();
+        public static bool operator ==(DateOnly left, DateOnly right);
+        public static bool operator >(DateOnly left, DateOnly right);
+        public static bool operator >=(DateOnly left, DateOnly right);
+        public static bool operator !=(DateOnly left, DateOnly right);
+        public static bool operator <(DateOnly left, DateOnly right);
+        public static bool operator <=(DateOnly left, DateOnly right);
+        public static DateOnly Parse(ReadOnlySpan<char> s, IFormatProvider provider = null, DateTimeStyles style = DateTimeStyles.None);
+        public static DateOnly Parse(string s);
+        public static DateOnly Parse(string s, IFormatProvider provider, DateTimeStyles style = DateTimeStyles.None);
+        public static DateOnly ParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, IFormatProvider provider = null, DateTimeStyles style = DateTimeStyles.None);
+        public static DateOnly ParseExact(ReadOnlySpan<char> s, string[] formats);
+        public static DateOnly ParseExact(ReadOnlySpan<char> s, string[] formats, IFormatProvider provider, DateTimeStyles style = DateTimeStyles.None);
+        public static DateOnly ParseExact(string s, string format);
+        public static DateOnly ParseExact(string s, string format, IFormatProvider provider, DateTimeStyles style = DateTimeStyles.None);
+        public static DateOnly ParseExact(string s, string[] formats);
+        public static DateOnly ParseExact(string s, string[] formats, IFormatProvider provider, DateTimeStyles style = DateTimeStyles.None);
+        public DateTime ToDateTime(TimeOnly time);
+        public DateTime ToDateTime(TimeOnly time, DateTimeKind kind);
+        public string ToLongDateString();
+        public string ToShortDateString();
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, out DateOnly result);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider provider, DateTimeStyles style, out DateOnly result);
+        public static bool TryParse(string s, out DateOnly result);
+        public static bool TryParse(string s, IFormatProvider provider, DateTimeStyles style, out DateOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, out DateOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, IFormatProvider provider, DateTimeStyles style, out DateOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, string[] formats, out DateOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, string[] formats, IFormatProvider provider, DateTimeStyles style, out DateOnly result);
+        public static bool TryParseExact(string s, string format, out DateOnly result);
+        public static bool TryParseExact(string s, string format, IFormatProvider provider, DateTimeStyles style, out DateOnly result);
+        public static bool TryParseExact(string s, string[] formats, out DateOnly result);
+        public static bool TryParseExact(string s, string[] formats, IFormatProvider provider, DateTimeStyles style, out DateOnly result);
+    }
-    public readonly struct DateTime : IComparable, IComparable<DateTime>, IConvertible, IEquatable<DateTime>, IFormattable, ISerializable
+    public readonly struct DateTime : IComparable, IComparable<DateTime>, IConvertible, IEquatable<DateTime>, IFormattable, ISerializable, ISpanFormattable
-    public readonly struct DateTimeOffset : IComparable, IComparable<DateTimeOffset>, IDeserializationCallback, IEquatable<DateTimeOffset>, IFormattable, ISerializable
+    public readonly struct DateTimeOffset : IComparable, IComparable<DateTimeOffset>, IDeserializationCallback, IEquatable<DateTimeOffset>, IFormattable, ISerializable, ISpanFormattable
-    public readonly struct Decimal : IComparable, IComparable<decimal>, IConvertible, IDeserializationCallback, IEquatable<decimal>, IFormattable, ISerializable
+    public readonly struct Decimal : IComparable, IComparable<decimal>, IConvertible, IDeserializationCallback, IEquatable<decimal>, IFormattable, ISerializable, ISpanFormattable
-    public readonly struct Double : IComparable, IComparable<double>, IConvertible, IEquatable<double>, IFormattable
+    public readonly struct Double : IComparable, IComparable<double>, IConvertible, IEquatable<double>, IFormattable, ISpanFormattable
-    public readonly struct Guid : IComparable, IComparable<Guid>, IEquatable<Guid>, IFormattable {
+    public readonly struct Guid : IComparable, IComparable<Guid>, IEquatable<Guid>, IFormattable, ISpanFormattable {
+        bool System.ISpanFormattable.TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format, IFormatProvider provider);
     }
-    public readonly struct Half : IComparable, IComparable<Half>, IEquatable<Half>, IFormattable
+    public readonly struct Half : IComparable, IComparable<Half>, IEquatable<Half>, IFormattable, ISpanFormattable
-    public readonly struct Int16 : IComparable, IComparable<short>, IConvertible, IEquatable<short>, IFormattable
+    public readonly struct Int16 : IComparable, IComparable<short>, IConvertible, IEquatable<short>, IFormattable, ISpanFormattable
-    public readonly struct Int32 : IComparable, IComparable<int>, IConvertible, IEquatable<int>, IFormattable
+    public readonly struct Int32 : IComparable, IComparable<int>, IConvertible, IEquatable<int>, IFormattable, ISpanFormattable
-    public readonly struct Int64 : IComparable, IComparable<long>, IConvertible, IEquatable<long>, IFormattable
+    public readonly struct Int64 : IComparable, IComparable<long>, IConvertible, IEquatable<long>, IFormattable, ISpanFormattable
-    public readonly struct IntPtr : IComparable, IComparable<IntPtr>, IEquatable<IntPtr>, IFormattable, ISerializable
+    public readonly struct IntPtr : IComparable, IComparable<IntPtr>, IEquatable<IntPtr>, IFormattable, ISerializable, ISpanFormattable
+    public interface ISpanFormattable : IFormattable {
+        bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format, IFormatProvider provider);
+    }
     public sealed class OperatingSystem : ICloneable, ISerializable {
+        public static bool IsMacCatalyst();
+        public static bool IsMacCatalystVersionAtLeast(int major, int minor = 0, int build = 0);
     }
     public class Random {
+        public static Random Shared { get; }
     }
-    public readonly struct SByte : IComparable, IComparable<sbyte>, IConvertible, IEquatable<sbyte>, IFormattable
+    public readonly struct SByte : IComparable, IComparable<sbyte>, IConvertible, IEquatable<sbyte>, IFormattable, ISpanFormattable
-    public readonly struct Single : IComparable, IComparable<float>, IConvertible, IEquatable<float>, IFormattable
+    public readonly struct Single : IComparable, IComparable<float>, IConvertible, IEquatable<float>, IFormattable, ISpanFormattable
     public abstract class StringComparer : IComparer, IComparer<string>, IEqualityComparer, IEqualityComparer<string> {
+        public static bool IsWellKnownCultureAwareComparer(IEqualityComparer<string> comparer, out CompareInfo compareInfo, out CompareOptions compareOptions);
+        public static bool IsWellKnownOrdinalComparer(IEqualityComparer<string> comparer, out bool ignoreCase);
     }
+    public readonly struct TimeOnly : IComparable, IComparable<TimeOnly>, IEquatable<TimeOnly>, IFormattable, ISpanFormattable {
+        public TimeOnly(int hour, int minute);
+        public TimeOnly(int hour, int minute, int second);
+        public TimeOnly(int hour, int minute, int second, int millisecond);
+        public TimeOnly(long ticks);
+        public int Hour { get; }
+        public static TimeOnly MaxValue { get; }
+        public int Millisecond { get; }
+        public int Minute { get; }
+        public static TimeOnly MinValue { get; }
+        public int Second { get; }
+        public long Ticks { get; }
+        public TimeOnly Add(TimeSpan value);
+        public TimeOnly Add(TimeSpan value, out int wrappedDays);
+        public TimeOnly AddHours(double value);
+        public TimeOnly AddHours(double value, out int wrappedDays);
+        public TimeOnly AddMinutes(double value);
+        public TimeOnly AddMinutes(double value, out int wrappedDays);
+        public int CompareTo(object value);
+        public int CompareTo(TimeOnly value);
+        public override bool Equals(object value);
+        public bool Equals(TimeOnly value);
+        public static TimeOnly FromDateTime(DateTime dateTime);
+        public static TimeOnly FromTimeSpan(TimeSpan timeSpan);
+        public override int GetHashCode();
+        public bool IsBetween(TimeOnly start, TimeOnly end);
+        public static bool operator ==(TimeOnly left, TimeOnly right);
+        public static bool operator >(TimeOnly left, TimeOnly right);
+        public static bool operator >=(TimeOnly left, TimeOnly right);
+        public static bool operator !=(TimeOnly left, TimeOnly right);
+        public static bool operator <(TimeOnly left, TimeOnly right);
+        public static bool operator <=(TimeOnly left, TimeOnly right);
+        public static TimeSpan operator -(TimeOnly t1, TimeOnly t2);
+        public static TimeOnly Parse(ReadOnlySpan<char> s, IFormatProvider provider = null, DateTimeStyles style = DateTimeStyles.None);
+        public static TimeOnly Parse(string s);
+        public static TimeOnly Parse(string s, IFormatProvider provider, DateTimeStyles style = DateTimeStyles.None);
+        public static TimeOnly ParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, IFormatProvider provider = null, DateTimeStyles style = DateTimeStyles.None);
+        public static TimeOnly ParseExact(ReadOnlySpan<char> s, string[] formats);
+        public static TimeOnly ParseExact(ReadOnlySpan<char> s, string[] formats, IFormatProvider provider, DateTimeStyles style = DateTimeStyles.None);
+        public static TimeOnly ParseExact(string s, string format);
+        public static TimeOnly ParseExact(string s, string format, IFormatProvider provider, DateTimeStyles style = DateTimeStyles.None);
+        public static TimeOnly ParseExact(string s, string[] formats);
+        public static TimeOnly ParseExact(string s, string[] formats, IFormatProvider provider, DateTimeStyles style = DateTimeStyles.None);
+        public string ToLongTimeString();
+        public string ToShortTimeString();
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public TimeSpan ToTimeSpan();
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider provider, DateTimeStyles style, out TimeOnly result);
+        public static bool TryParse(ReadOnlySpan<char> s, out TimeOnly result);
+        public static bool TryParse(string s, IFormatProvider provider, DateTimeStyles style, out TimeOnly result);
+        public static bool TryParse(string s, out TimeOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, IFormatProvider provider, DateTimeStyles style, out TimeOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, out TimeOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, string[] formats, IFormatProvider provider, DateTimeStyles style, out TimeOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, string[] formats, out TimeOnly result);
+        public static bool TryParseExact(string s, string format, IFormatProvider provider, DateTimeStyles style, out TimeOnly result);
+        public static bool TryParseExact(string s, string format, out TimeOnly result);
+        public static bool TryParseExact(string s, string[] formats, IFormatProvider provider, DateTimeStyles style, out TimeOnly result);
+        public static bool TryParseExact(string s, string[] formats, out TimeOnly result);
+    }
-    public readonly struct TimeSpan : IComparable, IComparable<TimeSpan>, IEquatable<TimeSpan>, IFormattable
+    public readonly struct TimeSpan : IComparable, IComparable<TimeSpan>, IEquatable<TimeSpan>, IFormattable, ISpanFormattable
     public sealed class TimeZoneInfo : IDeserializationCallback, IEquatable<TimeZoneInfo>, ISerializable {
+        public bool HasIanaId { get; }
+        public static bool TryConvertIanaIdToWindowsId(string ianaId, out string windowsId);
+        public static bool TryConvertWindowsIdToIanaId(string windowsId, out string ianaId);
+        public static bool TryConvertWindowsIdToIanaId(string windowsId, string region, out string ianaId);
         public sealed class AdjustmentRule : IDeserializationCallback, IEquatable<TimeZoneInfo.AdjustmentRule>, ISerializable {
+            public TimeSpan BaseUtcOffsetDelta { get; }
+            public static TimeZoneInfo.AdjustmentRule CreateAdjustmentRule(DateTime dateStart, DateTime dateEnd, TimeSpan daylightDelta, TimeZoneInfo.TransitionTime daylightTransitionStart, TimeZoneInfo.TransitionTime daylightTransitionEnd, TimeSpan baseUtcOffsetDelta);
         }
     }
-    public readonly struct UInt16 : IComparable, IComparable<ushort>, IConvertible, IEquatable<ushort>, IFormattable
+    public readonly struct UInt16 : IComparable, IComparable<ushort>, IConvertible, IEquatable<ushort>, IFormattable, ISpanFormattable
-    public readonly struct UInt32 : IComparable, IComparable<uint>, IConvertible, IEquatable<uint>, IFormattable
+    public readonly struct UInt32 : IComparable, IComparable<uint>, IConvertible, IEquatable<uint>, IFormattable, ISpanFormattable
-    public readonly struct UInt64 : IComparable, IComparable<ulong>, IConvertible, IEquatable<ulong>, IFormattable
+    public readonly struct UInt64 : IComparable, IComparable<ulong>, IConvertible, IEquatable<ulong>, IFormattable, ISpanFormattable
-    public readonly struct UIntPtr : IComparable, IComparable<UIntPtr>, IEquatable<UIntPtr>, IFormattable, ISerializable
+    public readonly struct UIntPtr : IComparable, IComparable<UIntPtr>, IEquatable<UIntPtr>, IFormattable, ISerializable, ISpanFormattable
-    public sealed class Version : ICloneable, IComparable, IComparable<Version>, IEquatable<Version> {
+    public sealed class Version : ICloneable, IComparable, IComparable<Version>, IEquatable<Version>, IFormattable, ISpanFormattable {
+        string System.IFormattable.ToString(string format, IFormatProvider formatProvider);
+        bool System.ISpanFormattable.TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format, IFormatProvider provider);
     }
 }
```

