# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
     public abstract class ConnectionInfo {
+        public virtual void RequestClose();
     }
     public static class HttpProtocol {
+        public static readonly string Http09;
+        public static bool IsHttp09(string protocol);
     }
     public interface IHeaderDictionary : ICollection<KeyValuePair<string, StringValues>>, IDictionary<string, StringValues>, IEnumerable, IEnumerable<KeyValuePair<string, StringValues>> {
+        StringValues SecWebSocketExtensions { get; set; }
     }
     public static class RequestDelegateFactory {
-        public static RequestDelegate Create(Delegate action);

+        public static RequestDelegate Create(Delegate action, IServiceProvider serviceProvider);
-        public static RequestDelegate Create(MethodInfo methodInfo);

-        public static RequestDelegate Create(MethodInfo methodInfo, Func<HttpContext, object> targetFactory);

+        public static RequestDelegate Create(MethodInfo methodInfo, IServiceProvider serviceProvider);
+        public static RequestDelegate Create(MethodInfo methodInfo, IServiceProvider serviceProvider, Func<HttpContext, object> targetFactory);
     }
     public class WebSocketAcceptContext {
+        public bool DangerousEnableCompression { get; set; }
+        public bool DisableServerContextTakeover { get; set; }
+        public virtual TimeSpan? KeepAliveInterval { get; set; }
+        public int ServerMaxWindowBits { get; set; }
     }
     public abstract class WebSocketManager {
+        public virtual Task<WebSocket> AcceptWebSocketAsync(WebSocketAcceptContext acceptContext);
     }
 }
```

