# System.Diagnostics

``` diff
 namespace System.Diagnostics {
     public static class Debug {
+        public static void Assert(bool condition, Debug.AssertInterpolatedStringHandler message);
+        public static void Assert(bool condition, Debug.AssertInterpolatedStringHandler message, Debug.AssertInterpolatedStringHandler detailMessage);
+        public static void WriteIf(bool condition, Debug.WriteIfInterpolatedStringHandler message);
+        public static void WriteIf(bool condition, Debug.WriteIfInterpolatedStringHandler message, string category);
+        public static void WriteLineIf(bool condition, Debug.WriteIfInterpolatedStringHandler message);
+        public static void WriteLineIf(bool condition, Debug.WriteIfInterpolatedStringHandler message, string category);
+        public struct AssertInterpolatedStringHandler {
+            public AssertInterpolatedStringHandler(int literalLength, int formattedCount, bool condition, out bool shouldAppend);
+            public void AppendFormatted(object value, int alignment = 0, string format = null);
+            public void AppendFormatted(ReadOnlySpan<char> value);
+            public void AppendFormatted(ReadOnlySpan<char> value, int alignment = 0, string format = null);
+            public void AppendFormatted(string value);
+            public void AppendFormatted(string value, int alignment = 0, string format = null);
+            public void AppendFormatted<T>(T value);
+            public void AppendFormatted<T>(T value, int alignment);
+            public void AppendFormatted<T>(T value, int alignment, string format);
+            public void AppendFormatted<T>(T value, string format);
+            public void AppendLiteral(string value);
+        }
+        public struct WriteIfInterpolatedStringHandler {
+            public WriteIfInterpolatedStringHandler(int literalLength, int formattedCount, bool condition, out bool shouldAppend);
+            public void AppendFormatted(object value, int alignment = 0, string format = null);
+            public void AppendFormatted(ReadOnlySpan<char> value);
+            public void AppendFormatted(ReadOnlySpan<char> value, int alignment = 0, string format = null);
+            public void AppendFormatted(string value);
+            public void AppendFormatted(string value, int alignment = 0, string format = null);
+            public void AppendFormatted<T>(T value);
+            public void AppendFormatted<T>(T value, int alignment);
+            public void AppendFormatted<T>(T value, int alignment, string format);
+            public void AppendFormatted<T>(T value, string format);
+            public void AppendLiteral(string value);
+        }
     }
+    public abstract class DistributedContextPropagator {
+        protected DistributedContextPropagator();
+        public static DistributedContextPropagator Current { get; set; }
+        public abstract IReadOnlyCollection<string> Fields { get; }
+        public static DistributedContextPropagator CreateDefaultPropagator();
+        public static DistributedContextPropagator CreateNoOutputPropagator();
+        public static DistributedContextPropagator CreatePassThroughPropagator();
+        public abstract IEnumerable<KeyValuePair<string, string>> ExtractBaggage(object carrier, DistributedContextPropagator.PropagatorGetterCallback getter);
+        public abstract void ExtractTraceIdAndState(object carrier, DistributedContextPropagator.PropagatorGetterCallback getter, out string traceId, out string traceState);
+        public abstract void Inject(Activity activity, object carrier, DistributedContextPropagator.PropagatorSetterCallback setter);
+        public delegate void PropagatorGetterCallback(object carrier, string fieldName, out string fieldValue, out IEnumerable<string> fieldValues);
+        public delegate void PropagatorSetterCallback(object carrier, string fieldName, string fieldValue);
+    }
 }
```

