# System.Text.Json

``` diff
 namespace System.Text.Json {
     public static class JsonSerializer {
+        public static object Deserialize(Stream utf8Json, Type returnType, JsonSerializerOptions options = null);
+        public static object Deserialize(Stream utf8Json, Type returnType, JsonSerializerContext context);
+        public static TValue Deserialize<TValue>(Stream utf8Json, JsonSerializerOptions options = null);
+        public static TValue Deserialize<TValue>(Stream utf8Json, JsonTypeInfo<TValue> jsonTypeInfo);
+        public static void Serialize(Stream utf8Json, object value, Type inputType, JsonSerializerOptions options = null);
+        public static void Serialize(Stream utf8Json, object value, Type inputType, JsonSerializerContext context);
+        public static void Serialize<TValue>(Stream utf8Json, TValue value, JsonSerializerOptions options = null);
+        public static void Serialize<TValue>(Stream utf8Json, TValue value, JsonTypeInfo<TValue> jsonTypeInfo);
     }
     public sealed class Utf8JsonWriter : IAsyncDisposable, IDisposable {
+        public void WriteRawValue(ReadOnlySpan<byte> utf8Json, bool skipInputValidation = false);
+        public void WriteRawValue(ReadOnlySpan<char> json, bool skipInputValidation = false);
+        public void WriteRawValue(string json, bool skipInputValidation = false);
     }
 }
```

