# Microsoft.JSInterop

``` diff
 namespace Microsoft.JSInterop {
+    public interface IJSStreamReference : IAsyncDisposable {
+        long Length { get; }
+        ValueTask<Stream> OpenReadStreamAsync(long maxAllowedSize = (long)512000, CancellationToken cancellationToken = default(CancellationToken));
+    }
     public enum JSCallResultType {
+        JSStreamReference = 2,
     }
     public abstract class JSRuntime : IDisposable, IJSRuntime {
+        protected internal virtual Task<Stream> ReadJSDataAsStreamAsync(IJSStreamReference jsStreamReference, long totalLength, CancellationToken cancellationToken = default(CancellationToken));
     }
 }
```

