# System.Windows.Automation.Peers

``` diff
 namespace System.Windows.Automation.Peers {
     public enum AutomationEvents {
+        ActiveTextPositionChanged = 20,
+        Notification = 19,
     }
     public abstract class AutomationPeer : DispatcherObject {
+        public AutomationHeadingLevel GetHeadingLevel();
+        protected virtual AutomationHeadingLevel GetHeadingLevelCore();
+        public bool IsDialog();
+        protected virtual bool IsDialogCore();
+        public void RaiseNotificationEvent(AutomationNotificationKind notificationKind, AutomationNotificationProcessing notificationProcessing, string displayString, string activityId);
     }
     public class ContentElementAutomationPeer : AutomationPeer {
+        protected override AutomationHeadingLevel GetHeadingLevelCore();
+        protected override bool IsDialogCore();
     }
     public abstract class ContentTextAutomationPeer : FrameworkContentElementAutomationPeer {
+        public virtual void RaiseActiveTextPositionChangedEvent(TextPointer rangeStart, TextPointer rangeEnd);
     }
     public sealed class DataGridCellItemAutomationPeer : AutomationPeer, IGridItemProvider, IInvokeProvider, IScrollItemProvider, ISelectionItemProvider, ITableItemProvider, IValueProvider, IVirtualizedItemProvider {
+        protected override AutomationHeadingLevel GetHeadingLevelCore();
+        protected override bool IsDialogCore();
     }
     public sealed class DateTimeAutomationPeer : AutomationPeer, IGridItemProvider, IInvokeProvider, ISelectionItemProvider, ITableItemProvider, IVirtualizedItemProvider {
+        protected override AutomationHeadingLevel GetHeadingLevelCore();
+        protected override bool IsDialogCore();
     }
     public abstract class ItemAutomationPeer : AutomationPeer, IVirtualizedItemProvider {
+        protected override AutomationHeadingLevel GetHeadingLevelCore();
+        protected override bool IsDialogCore();
     }
     public abstract class TextAutomationPeer : FrameworkElementAutomationPeer {
+        public virtual void RaiseActiveTextPositionChangedEvent(TextPointer rangeStart, TextPointer rangeEnd);
     }
     public class UIElement3DAutomationPeer : AutomationPeer {
+        protected override AutomationHeadingLevel GetHeadingLevelCore();
+        protected override bool IsDialogCore();
     }
     public class UIElementAutomationPeer : AutomationPeer {
+        protected override AutomationHeadingLevel GetHeadingLevelCore();
+        protected override bool IsDialogCore();
     }
 }
```

