# System.Windows.Forms

``` diff
 namespace System.Windows.Forms {
     public sealed class Application {
+        public static void SetDefaultFont(Font font);
     }
     public class ComboBox : ListControl {
+        protected override void OnKeyUp(KeyEventArgs e);
+        protected override void OnMouseDown(MouseEventArgs e);
-        public class ObjectCollection : ICollection, IEnumerable, IList {
+        public class ObjectCollection : ICollection, IComparer<ComboBox.ObjectCollection.Entry>, IEnumerable, IList {
+            int System.Collections.Generic.IComparer<System.Windows.Forms.ComboBox.ObjectCollection.Entry>.Compare(ComboBox.ObjectCollection.Entry entry1, ComboBox.ObjectCollection.Entry entry2);
         }
     }
     public class ContainerControl : ScrollableControl, IContainerControl {
+        protected override void RescaleConstantsForDpi(int deviceDpiOld, int deviceDpiNew);
     }
     public class Control : Component, IArrangedElement, IBindableComponent, IComponent, IDisposable, IDropTarget, IHandle, IKeyboardToolTip, Interop.Ole32.IOleControl, Interop.Ole32.IOleInPlaceActiveObject, Interop.Ole32.IOleInPlaceObject, Interop.Ole32.IOleObject, Interop.Ole32.IOleWindow, Interop.Ole32.IPersist, Interop.Ole32.IPersistStorage, Interop.Ole32.IPersistStreamInit, Interop.Ole32.IQuickActivate, Interop.Ole32.IViewObject, Interop.Ole32.IViewObject2, Interop.Oleaut32.IPersistPropertyBag, ISupportOleDropSource, ISynchronizeInvoke, IWin32Window {
+        public IAsyncResult BeginInvoke(Action method);
+        public void Invoke(Action method);
+        public T Invoke<T>(Func<T> method);
     }
     public class DateTimePicker : Control {
+        protected override void OnEnabledChanged(EventArgs e);
     }
     public enum DialogResult {
+        Continue = 11,
+        TryAgain = 10,
     }
     public sealed class FolderBrowserDialog : CommonDialog {
+        public Guid? ClientGuid { get; set; }
+        public string InitialDirectory { get; set; }
     }
     public class HScrollBar : ScrollBar {
-        protected override AccessibleObject CreateAccessibilityInstance();

     }
     public class LinkClickedEventArgs : EventArgs {
+        public LinkClickedEventArgs(string linkText, int linkStart, int linkLength);
+        public int LinkLength { get; }
+        public int LinkStart { get; }
     }
     public class ListView : Control {
+        protected override void OnGotFocus(EventArgs e);
+        protected override void OnLostFocus(EventArgs e);
     }
     public enum MessageBoxButtons {
+        CancelTryContinue = 6,
     }
     public enum MessageBoxDefaultButton {
+        Button4 = 768,
     }
     public class MonthCalendar : Control {
+        protected override void OnResize(EventArgs e);
     }
     public class PropertyGrid : ContainerControl, IComPropertyBrowser, Interop.Ole32.IPropertyNotifySink {
-        protected override void RescaleConstantsForDpi(int deviceDpiOld, int deviceDpiNew);

     }
     public class RichTextBox : TextBoxBase {
+        protected override void OnGotFocus(EventArgs e);
     }
     public class TabControl : Control {
+        protected override void OnGotFocus(EventArgs e);
+        protected override void OnLostFocus(EventArgs e);
     }
     public class TrackBar : Control, ISupportInitialize {
+        protected override AccessibleObject CreateAccessibilityInstance();
     }
     public class TreeView : Control {
+        protected override void OnGotFocus(EventArgs e);
+        protected override void OnLostFocus(EventArgs e);
     }
     public class VScrollBar : ScrollBar {
-        protected override AccessibleObject CreateAccessibilityInstance();

     }
 }
```

