# Microsoft.AspNetCore.Builder

``` diff
 namespace Microsoft.AspNetCore.Builder {
-    public sealed class ConfigureHostBuilder : IHostBuilder {
+    public sealed class ConfigureHostBuilder : IHostBuilder, ISupportsConfigureWebHost {
+        IHostBuilder Microsoft.AspNetCore.Hosting.Infrastructure.ISupportsConfigureWebHost.ConfigureWebHost(Action<IWebHostBuilder> configure, Action<WebHostBuilderOptions> configureOptions);
     }
-    public sealed class ConfigureWebHostBuilder : IWebHostBuilder {
+    public sealed class ConfigureWebHostBuilder : ISupportsStartup, IWebHostBuilder {
+        IWebHostBuilder Microsoft.AspNetCore.Hosting.Infrastructure.ISupportsStartup.Configure(Action<WebHostBuilderContext, IApplicationBuilder> configure);
+        IWebHostBuilder Microsoft.AspNetCore.Hosting.Infrastructure.ISupportsStartup.UseStartup(Type startupType);
+        IWebHostBuilder Microsoft.AspNetCore.Hosting.Infrastructure.ISupportsStartup.UseStartup<TStartup>(Func<WebHostBuilderContext, TStartup> startupFactory);
     }
+    public sealed class DelegateEndpointConventionBuilder : IEndpointConventionBuilder {
+        public void Add(Action<EndpointBuilder> convention);
+    }
+    public static class DelegateEndpointRouteBuilderExtensions {
+        public static DelegateEndpointConventionBuilder Map(this IEndpointRouteBuilder endpoints, RoutePattern pattern, Delegate handler);
+        public static DelegateEndpointConventionBuilder Map(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        public static DelegateEndpointConventionBuilder MapDelete(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        public static DelegateEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, Delegate handler);
+        public static DelegateEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        public static DelegateEndpointConventionBuilder MapGet(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        public static DelegateEndpointConventionBuilder MapMethods(this IEndpointRouteBuilder endpoints, string pattern, IEnumerable<string> httpMethods, Delegate handler);
+        public static DelegateEndpointConventionBuilder MapPost(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        public static DelegateEndpointConventionBuilder MapPut(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+    }
-    public sealed class MinimalActionEndpointConventionBuilder : IEndpointConventionBuilder {
 {
-        public void Add(Action<EndpointBuilder> convention);

-    }
-    public static class MinimalActionEndpointRouteBuilderExtensions {
 {
-        public static MinimalActionEndpointConventionBuilder Map(this IEndpointRouteBuilder endpoints, RoutePattern pattern, Delegate action);

-        public static MinimalActionEndpointConventionBuilder Map(this IEndpointRouteBuilder endpoints, string pattern, Delegate action);

-        public static MinimalActionEndpointConventionBuilder MapDelete(this IEndpointRouteBuilder endpoints, string pattern, Delegate action);

-        public static MinimalActionEndpointConventionBuilder MapGet(this IEndpointRouteBuilder endpoints, string pattern, Delegate action);

-        public static MinimalActionEndpointConventionBuilder MapMethods(this IEndpointRouteBuilder endpoints, string pattern, IEnumerable<string> httpMethods, Delegate action);

-        public static MinimalActionEndpointConventionBuilder MapPost(this IEndpointRouteBuilder endpoints, string pattern, Delegate action);

-        public static MinimalActionEndpointConventionBuilder MapPut(this IEndpointRouteBuilder endpoints, string pattern, Delegate action);

-    }
     public static class RoutingEndpointConventionBuilderExtensions {
+        public static TBuilder WithGroupName<TBuilder>(this TBuilder builder, string endpointGroupName) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder WithName<TBuilder>(this TBuilder builder, string endpointName) where TBuilder : IEndpointConventionBuilder;
     }
     public sealed class WebApplication : IApplicationBuilder, IAsyncDisposable, IDisposable, IEndpointRouteBuilder, IHost {
+        public static WebApplicationBuilder CreateBuilder();
+        public static WebApplicationBuilder CreateBuilder(WebApplicationOptions options);
-        public static WebApplicationBuilder CreateBuilder(string[] args = null);
+        public static WebApplicationBuilder CreateBuilder(string[] args);
     }
+    public class WebApplicationOptions {
+        public WebApplicationOptions();
+        public string ApplicationName { get; set; }
+        public string[] Args { get; set; }
+        public string ContentRootPath { get; set; }
+        public string EnvironmentName { get; set; }
+    }
 }
```

