# Microsoft.AspNetCore.Components.Web

``` diff
 namespace Microsoft.AspNetCore.Components.Web {
+    public interface IJSComponentConfiguration {
+        JSComponentConfigurationStore JSComponents { get; }
+    }
+    public static class JSComponentConfigurationExtensions {
+        public static void RegisterForJavaScript(this IJSComponentConfiguration configuration, Type componentType, string identifier);
+        public static void RegisterForJavaScript(this IJSComponentConfiguration configuration, Type componentType, string identifier, string javaScriptInitializer);
+        public static void RegisterForJavaScript<TComponent>(this IJSComponentConfiguration configuration, string identifier) where TComponent : IComponent;
+        public static void RegisterForJavaScript<TComponent>(this IJSComponentConfiguration configuration, string identifier, string javaScriptInitializer) where TComponent : IComponent;
+    }
+    public sealed class JSComponentConfigurationStore {
+        public JSComponentConfigurationStore();
+    }
     public class MouseEventArgs : EventArgs {
+        public double PageX { get; set; }
+        public double PageY { get; set; }
     }
 }
```

