# .NET 7.0.0  - November 08, 2022

The .NET 7.0.0 and .NET SDK 7.0.100 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## What's new in .NET 7

.NET 7 is the next major release of .NET following .NET 6.0. You can see [What's new in .NET 7.0](https://learn.microsoft.com/dotnet/core/whats-new/dotnet-7) for more details. You can also find additional details on the following blog posts:

* [Announcing .NET 7][dotnet-blog]
* [EF Core][ef-blog]
* [ASP.NET Core][aspnet-blog]

Here is list of some of the additions and updates we're excited to bring in .NET 7.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.100
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

**_Note: The .NET 7.0 SDK container images contain version 7.3 RC 1 of PowerShell. It is expected that the 7.3 GA release of PowerShell will be included in these images as part of the December servicing release._**

## Notable Changes
.NET 7.0.0 release carries non-security fixes.

## Visual Studio Compatibility

You need [Visual Studio 17.4](https://visualstudio.microsoft.com) or later to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7939](https://github.com/dotnet/core/issues/7939) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.0.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.0-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.0-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-7/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-dotnet-7/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.0+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.0+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.0+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.0+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.1xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
\Microsoft.WindowsDesktop.App.Ref| 7.0.0
\Microsoft.WindowsDesktop.App.Runtime.win-arm64| 7.0.0
\Microsoft.WindowsDesktop.App.Runtime.win-x86| 7.0.0
\Microsoft.WindowsDesktop.App.Runtime.win-x64| 7.0.0
Microsoft.DotNet.ILCompiler| 7.0.0
Microsoft.Bcl.AsyncInterfaces| 7.0.0
Microsoft.Extensions.Caching.Abstractions| 7.0.0
Microsoft.Extensions.Caching.Memory| 7.0.0
Microsoft.Extensions.Configuration| 7.0.0
Microsoft.Extensions.Configuration.Abstractions| 7.0.0
Microsoft.Extensions.Configuration.Ini| 7.0.0
Microsoft.Extensions.Configuration.Binder| 7.0.0
Microsoft.Extensions.Configuration.CommandLine| 7.0.0
Microsoft.Extensions.DependencyInjection.Specification.Tests| 7.0.0
Microsoft.Extensions.Configuration.Xml| 7.0.0
Microsoft.Extensions.Configuration.EnvironmentVariables| 7.0.0
Microsoft.Extensions.Configuration.FileExtensions| 7.0.0
Microsoft.Extensions.Configuration.Json| 7.0.0
Microsoft.Extensions.Configuration.UserSecrets| 7.0.0
Microsoft.Extensions.FileProviders.Physical| 7.0.0
Microsoft.Extensions.FileSystemGlobbing| 7.0.0
Microsoft.Extensions.Logging.Configuration| 7.0.0
Microsoft.Extensions.Primitives| 7.0.0
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64| 7.0.0
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64| 7.0.0
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86| 7.0.0
Microsoft.NET.Runtime.WebAssembly.Sdk| 7.0.0
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64| 7.0.0
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64| 7.0.0
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86| 7.0.0
Microsoft.NET.WebAssembly.Threading| 7.0.0
Microsoft.NET.Sdk.IL| 7.0.0
Microsoft.NETCore.App.Crossgen2.linux-musl-arm| 7.0.0
Microsoft.NETCore.App.Crossgen2.win-arm64| 7.0.0
Microsoft.NETCore.App.Host.linux-arm64| 7.0.0
Microsoft.NETCore.App.Host.linux-musl-arm| 7.0.0
Microsoft.NETCore.App.Host.osx-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.ios-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.win-x86| 7.0.0
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.win-x86| 7.0.0
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 7.0.0
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 7.0.0
runtime.linux-arm.runtime.native.System.IO.Ports| 7.0.0
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler| 7.0.0
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 7.0.0
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 7.0.0
runtime.linux-musl-arm64.Microsoft.NETCore.ILAsm| 7.0.0
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 7.0.0
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 7.0.0
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost| 7.0.0
runtime.osx-x64.Microsoft.DotNet.ILCompiler| 7.0.0
runtime.osx-arm64.Microsoft.NETCore.ILAsm| 7.0.0
System.Numerics.Tensors| 7.0.0-rtm.22518.5
System.Reflection.MetadataLoadContext| 7.0.0
System.Reflection.Context| 7.0.0
System.Resources.Extensions| 7.0.0
System.Runtime.Caching| 7.0.0
System.Runtime.Serialization.Schema| 7.0.0
Microsoft.NETCore.App.Crossgen2.osx-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.android-arm| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.android-x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.browser-wasm| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.win-x64| 7.0.0
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.win-x64| 7.0.0
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86| 7.0.0
Microsoft.Windows.Compatibility| 7.0.0
Microsoft.Win32.SystemEvents| 7.0.0
runtime.linux-arm.Microsoft.NETCore.ILAsm| 7.0.0
runtime.linux-arm64.Microsoft.DotNet.ILCompiler| 7.0.0
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 7.0.0
runtime.linux-musl-arm64.Microsoft.NETCore.ILDAsm| 7.0.0
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler| 7.0.0
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 7.0.0
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver| 7.0.0
runtime.osx-arm64.Microsoft.NETCore.ILDAsm| 7.0.0
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 7.0.0
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 7.0.0
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 7.0.0
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 7.0.0
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 7.0.0
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 7.0.0
runtime.win-x86.Microsoft.NETCore.ILDAsm| 7.0.0
System.CodeDom| 7.0.0
System.ComponentModel.Composition.Registration| 7.0.0
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100| 7.0.0
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.arm64| 7.0.0
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.arm64| 7.0.0
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x86| 7.0.0
Microsoft.NETCore.App.Crossgen2.osx-x64| 7.0.0
Microsoft.NETCore.App.Crossgen2.win-x64| 7.0.0
Microsoft.NETCore.App.Host.linux-musl-x64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64| 7.0.0
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.android-x86| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64| 7.0.0
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 7.0.0
Microsoft.XmlSerializer.Generator| 7.0.0
runtime.linux-arm.Microsoft.NETCore.ILDAsm| 7.0.0
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost| 7.0.0
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver| 7.0.0
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy| 7.0.0
runtime.linux-musl-arm.Microsoft.NETCore.ILAsm| 7.0.0
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver| 7.0.0
runtime.linux-musl-arm.Microsoft.NETCore.ILDAsm| 7.0.0
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 7.0.0
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 7.0.0
runtime.native.System.IO.Ports| 7.0.0
runtime.linux-x64.runtime.native.System.IO.Ports| 7.0.0
runtime.osx-arm64.Microsoft.NETCore.DotNetHost| 7.0.0
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy| 7.0.0
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 7.0.0
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 7.0.0
runtime.win-arm64.Microsoft.NETCore.ILDAsm| 7.0.0
System.Composition| 7.0.0
System.Composition.AttributedModel| 7.0.0
System.Formats.Cbor| 7.0.0
System.ServiceProcess.ServiceController| 7.0.0
System.Windows.Extensions| 7.0.0
dotnet-ilverify| 7.0.0
Microsoft.Extensions.Options.DataAnnotations| 7.0.0
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64| 7.0.0
Microsoft.NET.Runtime.WebAssembly.Templates| 7.0.0
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64| 7.0.0
Microsoft.NETCore.App.Composite| 7.0.0
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100| 7.0.0
Microsoft.NETCore.App.Crossgen2.win-arm| 7.0.0
Microsoft.NETCore.App.Host.linux-bionic-x64| 7.0.0
Microsoft.NETCore.App.Host.linux-bionic-arm64| 7.0.0
Microsoft.NETCore.App.Host.linux-musl-arm64| 7.0.0
Microsoft.NETCore.App.Host.win-x86| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.linux-arm| 7.0.0
Microsoft.NETCore.App.Runtime.linux-musl-arm| 7.0.0
Microsoft.NETCore.App.Runtime.linux-musl-x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.ios-arm| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.linux-arm| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64| 7.0.0
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 7.0.0
runtime.linux-arm64.Microsoft.NETCore.ILAsm| 7.0.0
runtime.osx-arm64.runtime.native.System.IO.Ports| 7.0.0
runtime.win-arm.Microsoft.NETCore.DotNetHost| 7.0.0
runtime.win-arm.Microsoft.NETCore.ILAsm| 7.0.0
runtime.win-arm.Microsoft.NETCore.ILDAsm| 7.0.0
runtime.win-x64.Microsoft.DotNet.ILCompiler| 7.0.0
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 7.0.0
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 7.0.0
runtime.win-x64.Microsoft.NETCore.DotNetHost| 7.0.0
System.Collections.Immutable| 7.0.0
System.ComponentModel.Composition| 7.0.0
System.Composition.Convention| 7.0.0
System.Composition.Hosting| 7.0.0
System.Composition.TypedParts| 7.0.0
System.Composition.Runtime| 7.0.0
System.Configuration.ConfigurationManager| 7.0.0
System.Data.Odbc| 7.0.0
System.Management| 7.0.0
System.IO.Packaging| 7.0.0
System.Reflection.Metadata| 7.0.0
System.Security.Cryptography.Cose| 7.0.0
System.Security.Cryptography.Pkcs| 7.0.0
System.Security.Cryptography.ProtectedData| 7.0.0
Microsoft.Extensions.FileProviders.Composite| 7.0.0
Microsoft.Extensions.DependencyInjection| 7.0.0
Microsoft.Extensions.DependencyInjection.Abstractions| 7.0.0
Microsoft.Extensions.FileProviders.Abstractions| 7.0.0
Microsoft.NET.Runtime.Android.Sample.Mono| 7.0.0
Microsoft.NET.Runtime.iOS.Sample.Mono| 7.0.0
Microsoft.NET.Runtime.MonoAOTCompiler.Task| 7.0.0
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64| 7.0.0
Microsoft.NET.Runtime.wasm.Sample.Mono| 7.0.0
Microsoft.NET.Runtime.MonoTargets.Sdk| 7.0.0
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86| 7.0.0
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64| 7.0.0
Microsoft.NETCore.App.Crossgen2.linux-arm| 7.0.0
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x64| 7.0.0
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x86| 7.0.0
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x64| 7.0.0
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64| 7.0.0
Microsoft.NETCore.App.Crossgen2.linux-x64| 7.0.0
Microsoft.NETCore.App.Crossgen2.win-x86| 7.0.0
Microsoft.NETCore.App.Host.linux-arm| 7.0.0
Microsoft.NETCore.App.Host.win-arm| 7.0.0
Microsoft.NETCore.App.Host.win-arm64| 7.0.0
Microsoft.NETCore.App.Host.osx-x64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.linux-bionic-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.linux-bionic-x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.linux-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.osx-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.osx-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86| 7.0.0
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 7.0.0
runtime.linux-arm64.runtime.native.System.IO.Ports| 7.0.0
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost| 7.0.0
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy| 7.0.0
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 7.0.0
runtime.osx-x64.Microsoft.NETCore.ILAsm| 7.0.0
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 7.0.0
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 7.0.0
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 7.0.0
runtime.win-arm64.Microsoft.DotNet.ILCompiler| 7.0.0
runtime.win-x64.Microsoft.NETCore.ILDAsm| 7.0.0
System.Diagnostics.PerformanceCounter| 7.0.0
System.DirectoryServices| 7.0.0
System.DirectoryServices.AccountManagement| 7.0.0
System.Diagnostics.EventLog| 7.0.0
System.IO.Hashing| 7.0.0
System.IO.Ports| 7.0.0
System.Threading.AccessControl| 7.0.0
System.Threading.Channels| 7.0.0
System.Text.Encodings.Web| 7.0.0
System.Text.Json| 7.0.0
System.Threading.RateLimiting| 7.0.0
System.Threading.Tasks.Dataflow| 7.0.0
Microsoft.NETCore.App.Ref| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86| 7.0.0
Microsoft.NETCore.App.Runtime.linux-x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.linux-x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.osx-x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.osx-x64| 7.0.0
Microsoft.NETCore.App.Runtime.win-arm| 7.0.0
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64| 7.0.0
Microsoft.NETCore.DotNetAppHost| 7.0.0
Microsoft.NETCore.DotNetHost| 7.0.0
Microsoft.NETCore.DotNetHostPolicy| 7.0.0
Microsoft.NETCore.DotNetHostResolver| 7.0.0
Microsoft.NETCore.ILAsm| 7.0.0
Microsoft.NETCore.Platforms| 7.0.0
Microsoft.NETCore.ILDAsm| 7.0.0
Microsoft.Win32.Registry.AccessControl| 7.0.0
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 7.0.0
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy| 7.0.0
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver| 7.0.0
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost| 7.0.0
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 7.0.0
runtime.linux-musl-x64.Microsoft.NETCore.ILAsm| 7.0.0
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 7.0.0
Microsoft.Extensions.DependencyModel| 7.0.0
Microsoft.Extensions.Hosting.Systemd| 7.0.0
Microsoft.Extensions.Hosting.WindowsServices| 7.0.0
Microsoft.Extensions.Hosting| 7.0.0
Microsoft.Extensions.Http| 7.0.0
Microsoft.Extensions.Hosting.Abstractions| 7.0.0
Microsoft.Extensions.Logging.Debug| 7.0.0
Microsoft.Extensions.Logging| 7.0.0
Microsoft.Extensions.Logging.Abstractions| 7.0.0
Microsoft.Extensions.Logging.TraceSource| 7.0.0
Microsoft.Extensions.Logging.Console| 7.0.0
Microsoft.Extensions.Logging.EventLog| 7.0.0
Microsoft.Extensions.Logging.EventSource| 7.0.0
Microsoft.Extensions.Options| 7.0.0
Microsoft.Extensions.Options.ConfigurationExtensions| 7.0.0
Microsoft.ILVerification| 7.0.0
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86| 7.0.0
Microsoft.NETCore.App.Crossgen2.linux-arm64| 7.0.0
Microsoft.NETCore.App.Crossgen2.linux-musl-x64| 7.0.0
Microsoft.NETCore.App.Host.linux-x64| 7.0.0
Microsoft.NETCore.App.Host.win-x64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.linux-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.android-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64| 7.0.0
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86| 7.0.0
Microsoft.NETCore.App.Runtime.win-arm64| 7.0.0
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 7.0.0
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 7.0.0
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost| 7.0.0
runtime.linux-arm64.Microsoft.NETCore.ILDAsm| 7.0.0
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost| 7.0.0
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost| 7.0.0
runtime.linux-x64.Microsoft.DotNet.ILCompiler| 7.0.0
runtime.linux-musl-x64.Microsoft.NETCore.ILDAsm| 7.0.0
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 7.0.0
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 7.0.0
runtime.linux-x64.Microsoft.NETCore.ILAsm| 7.0.0
runtime.linux-x64.Microsoft.NETCore.ILDAsm| 7.0.0
runtime.osx-x64.Microsoft.NETCore.ILDAsm| 7.0.0
runtime.osx-x64.runtime.native.System.IO.Ports| 7.0.0
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 7.0.0
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 7.0.0
runtime.win-arm64.Microsoft.NETCore.ILAsm| 7.0.0
runtime.win-x64.Microsoft.NETCore.ILAsm| 7.0.0
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 7.0.0
runtime.win-x86.Microsoft.NETCore.ILAsm| 7.0.0
runtime.win-x86.Microsoft.NETCore.DotNetHost| 7.0.0
System.Data.OleDb| 7.0.0
System.Diagnostics.DiagnosticSource| 7.0.0
System.DirectoryServices.Protocols| 7.0.0
System.Drawing.Common| 7.0.0
System.Formats.Asn1| 7.0.0
System.IO.Pipelines| 7.0.0
System.Net.Http.WinHttpHandler| 7.0.0
System.Net.Http.Json| 7.0.0
System.Memory.Data| 7.0.0
System.Security.Cryptography.Xml| 7.0.0
System.Security.Permissions| 7.0.0
System.Text.Encoding.CodePages| 7.0.0
System.Speech| 7.0.0
System.ServiceModel.Syndication| 7.0.0
Microsoft.AspNetCore.Authentication.JwtBearer| 7.0.0
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 7.0.0
Microsoft.AspNetCore.Authentication.WsFederation| 7.0.0
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 7.0.0
Microsoft.AspNetCore.AzureAppServicesIntegration| 7.0.0
Microsoft.AspNetCore.Authorization| 7.0.0
Microsoft.AspNetCore.Components| 7.0.0
Microsoft.AspNetCore.Components.CustomElements| 7.0.0
Microsoft.AspNetCore.Components.Analyzers| 7.0.0
Microsoft.AspNetCore.Components.WebAssembly.Server| 7.0.0
Microsoft.AspNetCore.Components.WebView| 7.0.0
Microsoft.AspNetCore.DataProtection.Abstractions| 7.0.0
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 7.0.0
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 7.0.0
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 7.0.0
Microsoft.AspNetCore.App.Runtime.win-x64| 7.0.0
Microsoft.AspNetCore.App.Runtime.linux-arm64| 7.0.0
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 7.0.0
Microsoft.AspNetCore.App.Runtime.linux-x64| 7.0.0
AspNetCoreRuntime.7.0.x64| 7.0.0
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 7.0.0
Microsoft.AspNetCore.Metadata| 7.0.0
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 7.0.0
Microsoft.AspNetCore.Mvc.Testing| 7.0.0
Microsoft.AspNetCore.OpenApi| 7.0.0
Microsoft.AspNetCore.SignalR.Client.Core| 7.0.0
Microsoft.AspNetCore.SignalR.Client| 7.0.0
Microsoft.AspNetCore.SpaProxy| 7.0.0
Microsoft.dotnet-openapi| 7.0.0
Microsoft.Extensions.ApiDescription.Server| 7.0.0
Microsoft.Authentication.WebAssembly.Msal| 7.0.0
Microsoft.Extensions.ApiDescription.Client| 7.0.0
Microsoft.DotNet.Web.Client.ItemTemplates| 7.0.0
Microsoft.DotNet.Web.ProjectTemplates.7.0| 7.0.0
Microsoft.DotNet.Web.ItemTemplates.7.0| 7.0.0
Microsoft.Extensions.Features| 7.0.0
Microsoft.AspNetCore.App.Runtime.linux-arm| 7.0.0
Microsoft.AspNetCore.App.Runtime.linux-musl-arm| 7.0.0
Microsoft.AspNetCore.App.Runtime.osx-x64| 7.0.0
Microsoft.AspNetCore.App.Runtime.win-arm| 7.0.0
Microsoft.AspNetCore.App.Ref| 7.0.0
Microsoft.AspNetCore.Components.Authorization| 7.0.0
AspNetCoreRuntime.7.0.x86| 7.0.0
Microsoft.AspNetCore.Authentication.Certificate| 7.0.0
Microsoft.AspNetCore.Authentication.Facebook| 7.0.0
Microsoft.AspNetCore.Authentication.Google| 7.0.0
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 7.0.0
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 7.0.0
Microsoft.Extensions.FileProviders.Embedded| 7.0.0
Microsoft.Extensions.Identity.Core| 7.0.0
Microsoft.Extensions.Localization.Abstractions| 7.0.0
Microsoft.AspNetCore.Components.Forms| 7.0.0
Microsoft.AspNetCore.ConcurrencyLimiter| 7.0.0
Microsoft.AspNetCore.Cryptography.KeyDerivation| 7.0.0
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 7.0.0
Microsoft.AspNetCore.DataProtection.Extensions| 7.0.0
Microsoft.AspNetCore.Grpc.JsonTranscoding| 7.0.0
Microsoft.AspNetCore.Grpc.Swagger| 0.3.0
Microsoft.AspNetCore.Owin| 7.0.0
Microsoft.AspNetCore.SignalR.Common| 7.0.0
Microsoft.Extensions.Caching.SqlServer| 7.0.0
Microsoft.Extensions.Caching.StackExchangeRedis| 7.0.0
Microsoft.Extensions.Configuration.KeyPerFile| 7.0.0
Microsoft.Extensions.Diagnostics.HealthChecks| 7.0.0
Microsoft.Extensions.Http.Polly| 7.0.0
Microsoft.Extensions.Identity.Stores| 7.0.0
Microsoft.Extensions.Localization| 7.0.0
Microsoft.Extensions.Logging.AzureAppServices| 7.0.0
Microsoft.Extensions.ObjectPool| 7.0.0
Microsoft.Extensions.WebEncoders| 7.0.0
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 7.0.0
Microsoft.AspNetCore.App.Runtime.osx-arm64| 7.0.0
dotnet-sql-cache| 7.0.0
Microsoft.AspNetCore.App.Runtime.win-x86| 7.0.0
Microsoft.AspNetCore.App.Runtime.win-arm64| 7.0.0
Microsoft.AspNetCore.Authentication.Negotiate| 7.0.0
Microsoft.AspNetCore.Authentication.OpenIdConnect| 7.0.0
Microsoft.AspNetCore.Authentication.Twitter| 7.0.0
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 7.0.0
Microsoft.AspNetCore.Components.WebAssembly.Authentication| 7.0.0
Microsoft.AspNetCore.Components.Web| 7.0.0
Microsoft.AspNetCore.Components.WebAssembly| 7.0.0
Microsoft.AspNetCore.Components.WebAssembly.DevServer| 7.0.0
Microsoft.AspNetCore.Connections.Abstractions| 7.0.0
Microsoft.AspNetCore.DataProtection| 7.0.0
Microsoft.AspNetCore.Cryptography.Internal| 7.0.0
Microsoft.AspNetCore.HeaderPropagation| 7.0.0
Microsoft.AspNetCore.Hosting.WindowsServices| 7.0.0
Microsoft.AspNetCore.Identity.UI| 7.0.0
Microsoft.AspNetCore.Http.Connections.Client| 7.0.0
Microsoft.AspNetCore.Http.Connections.Common| 7.0.0
Microsoft.AspNetCore.JsonPatch| 7.0.0
Microsoft.AspNetCore.MiddlewareAnalysis| 7.0.0
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 7.0.0
Microsoft.AspNetCore.SignalR.Protocols.Json| 7.0.0
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 7.0.0
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 7.0.0
Microsoft.AspNetCore.SpaServices.Extensions| 7.0.0
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 7.0.0
Microsoft.AspNetCore.SignalR.Specification.Tests| 7.0.0
Microsoft.AspNetCore.TestHost| 7.0.0
Microsoft.DotNet.Web.Spa.ProjectTemplates.7.0| 7.0.0
Microsoft.JSInterop.WebAssembly| 7.0.0
Microsoft.JSInterop| 7.0.0
FSharp.Core| 7.0.0
FSharp.Compiler.Service| 42.7.100
Microsoft.DotNet.Common.ItemTemplates| 7.0.100
Microsoft.DotNet.Common.ProjectTemplates.7.0| 7.0.100
Microsoft.DotNet.ApiCompat.Tool| 7.0.100
Microsoft.DotNet.ApiCompat.Task| 7.0.100
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64| 7.0.0
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.osx-x64| 7.0.0
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64| 7.0.0
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.osx-x64| 7.0.0
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.x64| 7.0.0
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.arm64| 7.0.0
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x64| 7.0.0
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.x64| 7.0.0
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x86| 7.0.0
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.linux-x64| 7.0.0
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.linux-x64| 7.0.0
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.x64| 7.0.0
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100| 7.0.0
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x86| 7.0.0
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.linux-x64| 7.0.0
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.osx-x64| 7.0.0
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64| 7.0.0
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64| 7.0.0
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.osx-x64| 7.0.0
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.x64| 7.0.0
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100| 7.0.0
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.arm64| 7.0.0
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x64| 7.0.0
dotnet-ef| 7.0.0
Microsoft.EntityFrameworkCore| 7.0.0
Microsoft.EntityFrameworkCore.Cosmos| 7.0.0
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests| 7.0.0
Microsoft.Data.Sqlite.Core| 7.0.0
Microsoft.EntityFrameworkCore.Design| 7.0.0
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 7.0.0
Microsoft.EntityFrameworkCore.Sqlite| 7.0.0
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 7.0.0
Microsoft.EntityFrameworkCore.Proxies| 7.0.0
Microsoft.EntityFrameworkCore.Sqlite.Core| 7.0.0
Microsoft.EntityFrameworkCore.SqlServer| 7.0.0
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 7.0.0
Microsoft.Data.Sqlite| 7.0.0
Microsoft.EntityFrameworkCore.Abstractions| 7.0.0
Microsoft.EntityFrameworkCore.Analyzers| 7.0.0
Microsoft.EntityFrameworkCore.InMemory| 7.0.0
Microsoft.EntityFrameworkCore.Specification.Tests| 7.0.0
Microsoft.EntityFrameworkCore.Relational| 7.0.0
Microsoft.EntityFrameworkCore.Templates| 7.0.0
Microsoft.EntityFrameworkCore.Tools| 7.0.0
Microsoft.TemplateEngine.Core.Contracts| 7.0.100
Microsoft.TemplateEngine.TemplateLocalizer.Core| 7.0.100
Microsoft.TemplateEngine.Utils| 7.0.100
Microsoft.TemplateSearch.Common| 7.0.100
Microsoft.TemplateEngine.Abstractions| 7.0.100
Microsoft.TemplateEngine.Core| 7.0.100
Microsoft.TemplateEngine.Edge| 7.0.100
Microsoft.TemplateEngine.IDE| 7.0.100
Microsoft.TemplateEngine.TemplateLocalizer| 7.0.100
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 7.0.100
Microsoft.TemplateEngine.Tasks| 7.0.100
Microsoft.CodeAnalysis.Analyzers| 3.3.4-beta1.22518.1
Microsoft.CodeAnalysis.Metrics| 3.3.4-beta1.22518.1
Microsoft.CodeAnalysis.NetAnalyzers| 7.0.0-preview1.22518.1
Roslyn.Diagnostics.Analyzers| 3.3.4-beta1.22518.1
Microsoft.CodeAnalysis.BannedApiAnalyzers| 3.3.4-beta1.22518.1
Microsoft.CodeAnalysis.AnalyzerUtilities| 3.3.4-beta1.22518.1
Microsoft.CodeAnalysis.RulesetToEditorconfigConverter| 3.3.4-beta1.22518.1
Microsoft.CodeAnalysis.PublicApiAnalyzers| 3.3.4-beta1.22518.1
Text.Analyzers| 3.3.4-beta1.22518.1
Microsoft.CodeAnalysis.RulesetToEditorconfigConverter| 3.3.4-beta1.22514.1
Roslyn.Diagnostics.Analyzers| 3.3.4-beta1.22514.1
Microsoft.CodeAnalysis.Metrics| 3.3.4-beta1.22514.1
Microsoft.CodeAnalysis.NetAnalyzers| 7.0.0-preview1.22514.1
Microsoft.CodeAnalysis.AnalyzerUtilities| 3.3.4-beta1.22514.1
Microsoft.CodeAnalysis.BannedApiAnalyzers| 3.3.4-beta1.22514.1
Microsoft.CodeAnalysis.PublicApiAnalyzers| 3.3.4-beta1.22514.1
Microsoft.CodeAnalysis.Analyzers| 3.3.4-beta1.22514.1
Text.Analyzers| 3.3.4-beta1.22514.1

[//]: # ( Runtime 7.0.0)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9ba81ab4-6e22-45bd-9c0b-c4ad46918e97/3b5a3d47243f3fb1bcc4ebbf1b08b08c/dotnet-runtime-7.0.0-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/edc62d2f-5c2e-4085-a6d8-11ba9abb18f4/6ca82f155ed65e4c1335214d2d948c78/dotnet-runtime-7.0.0-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/627b669c-807b-4d21-8711-2e0c5c5fb22c/3a46f7ac5f9218ed3e4b08fd46821362/dotnet-runtime-7.0.0-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/de6327fe-c9a6-4efc-90ff-fb148519415f/30e99e1622183f6483b68a5e3181cd19/dotnet-runtime-7.0.0-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7e09d632-ee66-4bb7-b441-74acddeeaa6f/98cbf635f6fb3c5be55223b1bc4299f7/dotnet-runtime-7.0.0-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d4b0a69b-29cd-40ef-9e95-a8d16f0ff346/5844add76ae3917af9efd59d95e3cbd4/dotnet-runtime-7.0.0-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e5e32c3c-995c-4ca3-ac93-c4f3a3ebf9ad/9c098971b58b58236eac14a1afe14214/dotnet-runtime-7.0.0-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fa0f8c59-92d6-46eb-a35b-2063a888f26e/0dcd341b1bde64bd1a8ae91097dfca7f/dotnet-runtime-7.0.0-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/79e87fe7-1e4d-4128-b655-2af302df2d3f/30f2bbf3f79f6b790cd918c425b9e1ea/dotnet-runtime-7.0.0-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/93aca2a1-570c-4db7-90a1-de89a3a53f27/2d443a62676d498918def9188859f900/dotnet-runtime-7.0.0-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/3089e685-b4bf-4712-bedd-54e88f6c3c7b/42e9722f291b6867a08bf5707c58b4d6/dotnet-runtime-7.0.0-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/9c158fb5-1e42-4008-bcb0-f7c2bf308624/d3843b3d758477ba653ff7350bf17ab8/dotnet-runtime-7.0.0-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/87bc5966-97cc-498c-8381-bff4c43aafc6/baca88b989e7d2871e989d33a667d8e9/dotnet-runtime-7.0.0-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/243bac9c-0559-4d5e-9ab3-60aa92ef51bd/1bb509033e17301021a458b4214f0931/dotnet-runtime-7.0.0-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/75c0d7c7-9f30-46fd-9675-a301f0e051f4/ec04d5cc40aa6537a4af21fad6bf8ba9/dotnet-runtime-7.0.0-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/84b1923c-4b65-49c1-9a2a-34d5648b3d28/4bbef4a1b2aa8c4e73f300ce362a1108/dotnet-runtime-7.0.0-win-x86.zip

[//]: # ( WindowsDesktop 7.0.0)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/bce1b608-3a2a-45e6-ab7b-8c414b9e2c56/74703a44afc5f7550eba824143fc20a7/windowsdesktop-runtime-7.0.0-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/8b81b276-cfb9-454c-aec5-f7dac60bfc36/6e736f4c7ddcfb84f742f252e9718d0d/windowsdesktop-runtime-7.0.0-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5b2fbe00-507e-450e-8b52-43ab052aadf2/79d54c3a19ce3fce314f2367cf4e3b21/windowsdesktop-runtime-7.0.0-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/27bbcb40-cda2-442f-987a-713fa7af8b5d/cc7a34a2b7e9154560d3594b8563473f/windowsdesktop-runtime-7.0.0-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d05a833c-2cf9-4d06-89ae-a0f3e10c5c91/c668ff42e23c2f67aa3d80227860585f/windowsdesktop-runtime-7.0.0-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ba55d53e-eab9-44e6-888c-f846181815ab/bc55dedc4952feb2eb6036a1cf71574f/windowsdesktop-runtime-7.0.0-win-x86.zip

[//]: # ( ASP 7.0.0)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/61cb6649-f41f-4966-84ae-9ff673528054/9bbd07607c5a1af87354e1fa93c36a00/aspnetcore-runtime-7.0.0-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2d6d851a-4eea-4a7a-9d5e-f1d6cdccda29/366a3dd90251ce11d8c5191ae9633efc/aspnetcore-runtime-7.0.0-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9b35f4cd-a743-40b8-8056-f55027395ebb/09ceb52d68e4aec0b3fb5593c0d45625/aspnetcore-runtime-7.0.0-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5c96860b-97bd-4ff6-b639-40730bd84571/9564aee4622448a5713e151b3288f51d/aspnetcore-runtime-7.0.0-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5d9c71c5-929f-4307-9150-0be20991efed/61fd3999701e7aaa236499c9c7521b2d/aspnetcore-runtime-7.0.0-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4bbb4d31-70ba-4def-b747-4358be873982/3dbca5b64c2ffb88641c0e42bdeb297a/aspnetcore-runtime-7.0.0-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e8576603-3b51-43ac-8ec1-fa96517e9149/7de992056c89e164f60908d9912f3a81/aspnetcore-runtime-7.0.0-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5ea36935-090e-4ca4-841f-49371b408d9d/6e0c2c4721dabbb9a237d6b6ed17df75/aspnetcore-runtime-7.0.0-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/df1f26fd-9be2-4864-9ba3-bec826570f15/2e600dd754fbda4281a52cd97c2c2ba3/aspnetcore-runtime-7.0.0-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/388543cf-e110-4425-be62-2dfa1635586c/fab629ebe2c7b2edfa0f2ee9171de26b/aspnetcore-runtime-7.0.0-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e3c77b40-cb02-4f1a-845f-c8040de58a83/be6bba4cac270a11c2b9dbdeec0a3040/aspnetcore-runtime-7.0.0-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/aa4da7f2-fa27-47b1-9ad0-ac07dcecb730/00101e955bae403e5a2a424b3c29fb78/aspnetcore-runtime-7.0.0-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1aff84af-e84a-4168-b025-8242fa1a7bb6/5f0f967857d5b72bc2ec34f1bb71569f/aspnetcore-runtime-7.0.0-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/8de163f5-5d91-4dc3-9d01-e0b031a03dd9/0170b328d569a49f6f6a080064309161/dotnet-hosting-7.0.0-win.exe

[//]: # ( SDK 7.0.100)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fd193b5b-f171-436e-8783-5eb77a7ad5ee/2a0af2a874f3c4f7da0199dc64996829/dotnet-sdk-7.0.100-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/47337472-c910-4815-9d9b-80e1a30fcf16/14847f6a51a6a7e53a859d4a17edc311/dotnet-sdk-7.0.100-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/14c9ff00-b457-4bf3-ba1e-b54634827e8e/1292a52a53115da28ce17b19a2a0cd45/dotnet-sdk-7.0.100-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a620c089-f7f2-4b54-9c29-1e123e346c40/52bf752a693f9139133a041009d27ae4/dotnet-sdk-7.0.100-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/302a8de6-66a1-418f-b349-638d4b88dcd4/248ad4dfcbbf931009fa736ced0518e0/dotnet-sdk-7.0.100-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/253e5af8-41aa-48c6-86f1-39a51b44afdc/5bb2cb9380c5b1a7f0153e0a2775727b/dotnet-sdk-7.0.100-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4f0bd204-39be-492a-be5e-4bda7f569963/b245763ad54175dd87e260e394ec9c0d/dotnet-sdk-7.0.100-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1a0e0146-3401-4c2b-9369-4cb5e72785b7/8548e8f2c619330ea7282e15d1116155/dotnet-sdk-7.0.100-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/11810c49-a615-40ec-b869-2eb2eae30f7b/4b0b7700fa0e8307b5f99c1d372d95bb/dotnet-sdk-7.0.100-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/09e4b839-c809-49b5-b424-86d8ca67b42e/54be2d3868ae49fa00b1cc59065d5e2e/dotnet-sdk-7.0.100-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c780825d-b202-407e-b3ab-7854249c8328/76c4a311bbda0004deb3f4f212595828/dotnet-sdk-7.0.100-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/2586d573-4d02-43b9-bf4a-452d4170daaa/0f25ae6ea4381187688ddde932655343/dotnet-sdk-7.0.100-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5b9d1f0d-9c56-4bef-b950-c1b439489b27/b4aa387715207faa618a99e9b2dd4e35/dotnet-sdk-7.0.100-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1fb808dc-d017-4460-94f8-bf1ac83e6cd8/756b301e714755e411b84684b885a516/dotnet-sdk-7.0.100-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d2c590d2-1f87-4228-bf6c-6c07cd9e4477/245e9d13322edf2cfdc5225a8ea0842a/dotnet-sdk-7.0.100-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c45d50f1-c3f6-47cd-b9c9-861d095f8cb7/5a5ed9fb5e4b40fa4d4131cbe79d6a36/dotnet-sdk-7.0.100-win-x86.zip
